/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.ui.swing.FileFilterEx;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.excontrols.CreadorButton;
import gdtel.ui.swing.excontrols.JCheckBoxEx;
import gdtel.ui.swing.excontrols.JFiltroTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import modela.bd.obj.TrCabeceraSistema;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.graf.LectorXMLDES;
import modela.graf.LectorXMLDefProc;
import modela.ui.ModelaUI;
import modela.ui.swing.PropFaseJPanel;

public class PropEntidadesSistemaJPanel
extends JPanel {
    private static final long serialVersionUID = 5958745524490579106L;
    private XYLayout xYLayout1 = new XYLayout();
    private JLabel jLabel1 = new JLabel();
    private JLabel jLabel2 = new JLabel();
    private JFiltroTextField archivoTextField = new JFiltroTextField();
    private JLabel jLabel3 = new JLabel();
    private JLabel entidadSelLabel = new JLabel();
    private JCheckBox actualizarEntidadesCheckBox = new JCheckBoxEx();
    private JCheckBox importarCheckBox = new JCheckBox();
    private JCheckBox actualizarOtroCheckBox = new JCheckBox();
    private JTextField otroSistemaTextField = new JTextField();
    ImageIcon seleccionarIconN = new ImageIcon(PropEntidadesSistemaJPanel.class.getResource(ModelaUI.IMG_SMALL_SELECCION));
    ImageIcon seleccionarIconS = new ImageIcon(PropEntidadesSistemaJPanel.class.getResource(ModelaUI.IMG_SMALL_SELECCION_SOBRE));
    ImageIcon seleccionarIconD = new ImageIcon(PropEntidadesSistemaJPanel.class.getResource(ModelaUI.IMG_SMALL_SELECCION_NO_ENABLED));
    ImageIcon asignarIconN = new ImageIcon(PropEntidadesSistemaJPanel.class.getResource(ModelaUI.IMG_SMALL_ASIGNAR));
    ImageIcon asignarIconS = new ImageIcon(PropEntidadesSistemaJPanel.class.getResource(ModelaUI.IMG_SMALL_ASIGNAR_SOBRE));
    ImageIcon asignarIconD = new ImageIcon(PropEntidadesSistemaJPanel.class.getResource(ModelaUI.IMG_SMALL_ASIGNAR_NO_ENABLED));
    ImageIcon eliminarIconN = new ImageIcon(PropFaseJPanel.class.getResource(ModelaUI.IMG_SMALL_ELIMINAR));
    ImageIcon eliminarIconS = new ImageIcon(PropFaseJPanel.class.getResource(ModelaUI.IMG_SMALL_ELIMINAR_SOBRE));
    ImageIcon eliminarIconD = new ImageIcon(PropFaseJPanel.class.getResource(ModelaUI.IMG_SMALL_ELIMINAR_NO_ENABLED));
    private JButton actualizarButton = (JButton)CreadorButton.crearBoton(1, false, this.asignarIconN, this.asignarIconD, this.asignarIconS, this.asignarIconS);
    private JButton seleccionarButton = (JButton)CreadorButton.crearBoton(1, false, this.seleccionarIconN, this.seleccionarIconD, this.seleccionarIconS, this.seleccionarIconS);
    private JButton seleccionarOtroButton = (JButton)CreadorButton.crearBoton(1, false, this.seleccionarIconN, this.seleccionarIconD, this.seleccionarIconS, this.seleccionarIconS);
    private JButton eliminarOtroBtn = (JButton)CreadorButton.crearBoton(1, false, this.eliminarIconN, this.eliminarIconD, this.eliminarIconS, this.eliminarIconS);
    private DDPGrafico graficoActual;
    private LectorXMLDES lectorDES;
    File ficheroAImportar;

    public PropEntidadesSistemaJPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.xYLayout1);
        this.xYLayout1.setWidth(606);
        this.xYLayout1.setHeight(300);
        this.graficoActual = null;
        this.ficheroAImportar = null;
        this.lectorDES = new LectorXMLDES();
        this.jLabel1.setText("Selecci\u00f3n de la definici\u00f3n de entidades del sistema");
        this.jLabel1.setFont(ModelaUI.fuentePrincipalNegrita);
        this.jLabel1.setForeground(ModelaUI.colorSeleccion);
        this.jLabel2.setText("Archivo:");
        this.jLabel2.setFont(ModelaUI.fuentePrincipalNegrita);
        this.archivoTextField.setEnabled(true);
        this.archivoTextField.setEditable(false);
        this.otroSistemaTextField.setEnabled(true);
        this.otroSistemaTextField.setEditable(false);
        this.jLabel3.setText("Informaci\u00f3n del sistema");
        this.jLabel3.setFont(ModelaUI.fuentePrincipalNegrita);
        this.jLabel3.setForeground(ModelaUI.colorSeleccion);
        this.entidadSelLabel.setText("Entidades del procedimiento del sistema");
        this.entidadSelLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.actualizarEntidadesCheckBox.setEnabled(false);
        this.actualizarEntidadesCheckBox.setText("Actualizar entidades ya existentes con los valores recibidos");
        this.actualizarEntidadesCheckBox.setFocusPainted(false);
        this.importarCheckBox.setText("Importar s\u00f3lo la informaci\u00f3n general");
        this.actualizarOtroCheckBox.setText("Actualizar sobre otro sistema");
        this.seleccionarOtroButton.setSize(new Dimension(140, 25));
        this.actualizarButton.setEnabled(false);
        this.actualizarButton.setFocusPainted(false);
        this.eliminarOtroBtn.setFocusPainted(false);
        this.seleccionarButton.setFocusPainted(false);
        this.seleccionarOtroButton.setFocusPainted(false);
        this.add((Component)this.jLabel1, new XYConstraints(20, 20, 430, 25));
        this.add((Component)this.jLabel2, new XYConstraints(20, 50, 70, 25));
        this.add((Component)this.archivoTextField, new XYConstraints(20, 75, 460, 25));
        this.add((Component)this.seleccionarButton, new XYConstraints(495, 75, 85, 25));
        this.add((Component)this.jLabel3, new XYConstraints(20, 115, 320, 25));
        this.add((Component)this.entidadSelLabel, new XYConstraints(20, 148, 550, 25));
        this.add((Component)this.actualizarEntidadesCheckBox, new XYConstraints(15, 190, 380, 20));
        this.seleccionarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropEntidadesSistemaJPanel.this.seleccArchivo_actionPerformed(e);
            }
        });
        this.seleccionarOtroButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropEntidadesSistemaJPanel.this.seleccOtro_actionPerformed(e);
            }
        });
        this.eliminarOtroBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropEntidadesSistemaJPanel.this.eliminarOtro_actionPerformed(e);
            }
        });
        this.limpiarCampos();
    }

    void seleccArchivo_actionPerformed(ActionEvent e) {
        String strRuta = ModelaConf.getRutaArchivo();
        this.ficheroAImportar = null;
        JFileChooser fileDlg = strRuta != null ? new JFileChooser(strRuta) : new JFileChooser();
        fileDlg.setFileSelectionMode(0);
        FileFilterEx filter = new FileFilterEx("xml");
        filter.setDescription("Archivos xml");
        fileDlg.addChoosableFileFilter(filter);
        int nRet = fileDlg.showOpenDialog(null);
        if (nRet == 0) {
            this.limpiarCampos();
            this.ficheroAImportar = fileDlg.getSelectedFile();
            String strPath = this.ficheroAImportar.getPath();
            if (!strPath.endsWith(".xml")) {
                strPath = strPath + ".xml";
            }
            if (!strPath.equals("")) {
                this.archivoTextField.setText(strPath);
                TrCabeceraSistema cabecera = null;
                cabecera = this.lectorDES.obtenerSistema(this.ficheroAImportar);
                if (cabecera != null) {
                    this.entidadSelLabel.setText(cabecera.getSistema());
                    this.actualizarButton.setEnabled(true);
                    this.actualizarEntidadesCheckBox.setEnabled(true);
                } else {
                    JOptionPane.showMessageDialog(null, "El fichero seleccionado no es v\u00e1lido:\nLa definici\u00f3n de entidades del sistema no est\u00e1 bien formada.", "Fichero no v\u00e1lido", 2);
                    this.limpiarCampos();
                }
            }
        }
    }

    public void limpiarCampos() {
        this.archivoTextField.setText("");
        this.otroSistemaTextField.setText("");
        this.entidadSelLabel.setText("");
        this.actualizarEntidadesCheckBox.setSelected(false);
        this.importarCheckBox.setSelected(false);
        this.actualizarOtroCheckBox.setSelected(false);
        this.ficheroAImportar = null;
    }

    void seleccOtro_actionPerformed(ActionEvent e) {
        String strRuta = ModelaConf.getRutaArchivo();
        JFileChooser fileDlg = strRuta != null ? new JFileChooser(strRuta) : new JFileChooser();
        fileDlg.setFileSelectionMode(0);
        FileFilterEx filter = new FileFilterEx("xml");
        filter.setDescription("Archivos xml");
        fileDlg.addChoosableFileFilter(filter);
        int nRet = fileDlg.showOpenDialog(null);
        if (nRet == 0) {
            File fich = fileDlg.getSelectedFile();
            String strPath = fich.getPath();
            if (!strPath.endsWith(".xml")) {
                strPath = strPath + ".xml";
            }
            if (!strPath.equals("")) {
                this.otroSistemaTextField.setText(strPath);
            }
        }
    }

    void eliminarOtro_actionPerformed(ActionEvent e) {
        this.otroSistemaTextField.setText("");
    }

    public void setGrafico(DDPGrafico pGrafico) {
        this.graficoActual = pGrafico;
    }

    public File getFicheroAImportar() {
        return this.ficheroAImportar;
    }

    public void comenzarProcesoDeImportacion() {
        if (this.graficoActual == null) {
            return;
        }
        if (this.lectorDES == null) {
            return;
        }
        if (this.ficheroAImportar == null) {
            return;
        }
        Object[] options = new Object[]{"S\u00ed", "No"};
        int n = JOptionPane.showOptionDialog(this, "Un error en este proceso podr\u00eda da\u00f1ar su DDP actual.\n\u00bfDesea salvar su trabajo antes de continuar?", "Atenci\u00f3n", 0, 3, null, options, options[0]);
        if (n == -1) {
            n = 0;
        }
        if (n == 0 && (this.graficoActual.getDDPPadre() == null ? !this.graficoActual.salvar(false) : !this.graficoActual.getDDPPadre().salvar(false))) {
            return;
        }
        this.lectorDES.setActualizarEntidades(this.actualizarEntidadesCheckBox.isSelected());
        this.lectorDES.setTipoLectura(LectorXMLDefProc.LECTURA_IMPORTACION_DES);
        this.lectorDES.setGrafico(this.graficoActual);
        if (!this.lectorDES.leerArchivo(this.ficheroAImportar) && this.lectorDES.isFicheroValido()) {
            JOptionPane.showMessageDialog(this, "Proceso de importaci\u00f3n con fallos.\nEl DDP actual puede haber sufrido da\u00f1os.", "Atenci\u00f3n", 2);
        }
    }
}

