/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import gdtel.ui.swing.calendario.DatePicker;
import gdtel.ui.swing.calendario.ObservingTextField;
import gdtel.ui.swing.excontrols.CreadorButton;
import gdtel.ui.swing.excontrols.JFiltroTextArea;
import gdtel.ui.swing.excontrols.JFiltroTextField;
import gdtel.ui.swing.excontrols.JPanelAtributable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import modela.bd.obj.TrOrganismo;
import modela.bd.obj.TrOrganismoProc;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.MantenimientoOrganismoJDialog;

public class PropOrganismoProcedimientoJPanel
extends JPanelAtributable {
    private static final long serialVersionUID = -2249465641244552904L;
    ImageIcon seleccionarIconN = new ImageIcon(PropOrganismoProcedimientoJPanel.class.getResource(ModelaUI.IMG_SMALL_SELECCION));
    ImageIcon seleccionarIconS = new ImageIcon(PropOrganismoProcedimientoJPanel.class.getResource(ModelaUI.IMG_SMALL_SELECCION_SOBRE));
    ImageIcon seleccionarIconD = new ImageIcon(PropOrganismoProcedimientoJPanel.class.getResource(ModelaUI.IMG_SMALL_SELECCION_NO_ENABLED));
    ImageIcon calendarioIconN = new ImageIcon(PropOrganismoProcedimientoJPanel.class.getResource(ModelaUI.IMG_CALENDARIO));
    ImageIcon calendarioIconS = new ImageIcon(PropOrganismoProcedimientoJPanel.class.getResource(ModelaUI.IMG_CALENDARIO_SOBRE));
    ImageIcon calendarioIconD = new ImageIcon(PropOrganismoProcedimientoJPanel.class.getResource(ModelaUI.IMG_CALENDARIO_NO_ENABLED));
    private Color colorFuenteCodigoOrganismoAsociado = null;
    private Color colorFuenteNombreOrganismoAsociado = null;
    private Color colorFondoTipoAsociacion = null;
    private Color colorFondoFechaInicio = null;
    private Color colorFondoFechaFin = null;
    private Color colorFondoObservOrganismoProc = null;
    JLabel labelTituloPanel;
    TitledBorder bordeOrganismo;
    JPanel panelOrganismoAsociado;
    JLabel labelCodigoOrganismoAsociado;
    JFiltroTextField codigoOrganismoAsociadoField;
    JLabel labelNombreOrganismoAsociado;
    JFiltroTextField nombreOrganismoAsociadoField;
    JButton btnSelOrganismoAsociado = (JButton)CreadorButton.crearBoton(1, false, this.seleccionarIconN, this.seleccionarIconD, this.seleccionarIconS, this.seleccionarIconS);
    JLabel labelObservOrganismoProc;
    JFiltroTextArea observOrganismoProcArea;
    JLabel labelTipoAsociacionOrganismoProc;
    JFiltroTextField tipoAsociacion;
    JLabel labelFechaIni;
    ObservingTextField fechaIniField;
    JButton btnSelFechaIni = (JButton)CreadorButton.crearBoton(1, false, this.calendarioIconN, this.calendarioIconD, this.calendarioIconS, this.calendarioIconS);
    JLabel labelFechaFin;
    ObservingTextField fechaFinField;
    JButton btnSelFechaFin = (JButton)CreadorButton.crearBoton(1, false, this.calendarioIconN, this.calendarioIconD, this.calendarioIconS, this.calendarioIconS);
    private DDPGrafico grafico;
    TrOrganismo trOrganismoAsociado;
    SimpleDateFormat formatoDeFecha = new SimpleDateFormat("dd/MM/yyyy");

    public PropOrganismoProcedimientoJPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() {
        this.setLayout(new XYLayout());
        this.labelTituloPanel = new JLabel();
        this.labelTituloPanel.setText("Propiedades del organismo asociado");
        this.labelTituloPanel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.labelTituloPanel.setForeground(ModelaUI.colorSeleccion);
        this.panelOrganismoAsociado = new JPanel();
        this.panelOrganismoAsociado.setLayout(new XYLayout());
        this.panelOrganismoAsociado.setBounds(new Rectangle(130, 50, 160, 100));
        this.bordeOrganismo = new TitledBorder("Organismo asociado");
        this.bordeOrganismo.setTitleFont(ModelaUI.fuentePrincipalNegrita);
        this.panelOrganismoAsociado.setBorder(this.bordeOrganismo);
        this.panelOrganismoAsociado.setOpaque(false);
        this.labelCodigoOrganismoAsociado = new JLabel();
        this.labelCodigoOrganismoAsociado.setText("C\u00f3digo:");
        this.labelCodigoOrganismoAsociado.setFont(ModelaUI.fuentePrincipalNegrita);
        this.codigoOrganismoAsociadoField = new JFiltroTextField();
        this.codigoOrganismoAsociadoField.setNumItems(50);
        this.codigoOrganismoAsociadoField.establecerTipografia(1);
        this.codigoOrganismoAsociadoField.setTipoFiltro(1);
        this.codigoOrganismoAsociadoField.setEnabled(true);
        this.codigoOrganismoAsociadoField.setEditable(false);
        this.btnSelOrganismoAsociado.setBorderPainted(false);
        this.btnSelOrganismoAsociado.setFocusPainted(false);
        this.labelNombreOrganismoAsociado = new JLabel();
        this.labelNombreOrganismoAsociado.setText("Nombre:");
        this.labelNombreOrganismoAsociado.setFont(ModelaUI.fuentePrincipalNegrita);
        this.nombreOrganismoAsociadoField = new JFiltroTextField();
        this.nombreOrganismoAsociadoField.setNumItems(10);
        this.nombreOrganismoAsociadoField.establecerTipografia(1);
        this.nombreOrganismoAsociadoField.setTipoFiltro(1);
        this.nombreOrganismoAsociadoField.setEnabled(true);
        this.nombreOrganismoAsociadoField.setEditable(false);
        this.panelOrganismoAsociado.add((Component)this.labelCodigoOrganismoAsociado, new XYConstraints(5, 5, 60, 25));
        this.panelOrganismoAsociado.add((Component)this.codigoOrganismoAsociadoField, new XYConstraints(65, 5, 265, 25));
        this.panelOrganismoAsociado.add((Component)this.btnSelOrganismoAsociado, new XYConstraints(337, 5, 85, 25));
        this.panelOrganismoAsociado.add((Component)this.labelNombreOrganismoAsociado, new XYConstraints(5, 35, 60, 25));
        this.panelOrganismoAsociado.add((Component)this.nombreOrganismoAsociadoField, new XYConstraints(65, 35, 355, 25));
        this.labelObservOrganismoProc = new JLabel();
        this.labelObservOrganismoProc.setText("Observaciones:");
        this.labelObservOrganismoProc.setFont(ModelaUI.fuentePrincipal);
        this.observOrganismoProcArea = new JFiltroTextArea();
        this.observOrganismoProcArea.setBorder(BorderFactory.createBevelBorder(1));
        this.observOrganismoProcArea.establecerTipografia(1);
        this.observOrganismoProcArea.setNumItems(2500);
        this.observOrganismoProcArea.setTipoFiltro(1);
        this.observOrganismoProcArea.setEnabled(true);
        this.observOrganismoProcArea.setEditable(false);
        this.labelTipoAsociacionOrganismoProc = new JLabel();
        this.labelTipoAsociacionOrganismoProc.setText("Tipo de asociaci\u00f3n:");
        this.labelTipoAsociacionOrganismoProc.setFont(ModelaUI.fuentePrincipalNegrita);
        this.tipoAsociacion = new JFiltroTextField();
        this.tipoAsociacion.establecerTipografia(1);
        this.tipoAsociacion.setNumItems(50);
        this.tipoAsociacion.setTipoFiltro(1);
        this.tipoAsociacion.setEnabled(true);
        this.tipoAsociacion.setEditable(false);
        this.labelFechaIni = new JLabel();
        this.labelFechaIni.setText("Inicio vigencia:");
        this.labelFechaIni.setFont(ModelaUI.fuentePrincipalNegrita);
        this.fechaIniField = new ObservingTextField();
        this.fechaIniField.setNumItems(10);
        this.fechaIniField.establecerTipografia(1);
        this.fechaIniField.setTipoFiltro(3);
        this.fechaIniField.setHorizontalAlignment(4);
        this.labelFechaFin = new JLabel();
        this.labelFechaFin.setText("Fin vigencia:");
        this.labelFechaFin.setFont(ModelaUI.fuentePrincipal);
        this.fechaFinField = new ObservingTextField();
        this.fechaFinField.setNumItems(10);
        this.fechaFinField.establecerTipografia(1);
        this.fechaFinField.setTipoFiltro(3);
        this.fechaFinField.setHorizontalAlignment(4);
        this.add((Component)this.labelTituloPanel, new XYConstraints(0, 0, 285, 15));
        this.add((Component)this.panelOrganismoAsociado, new XYConstraints(0, 50, 436, 100));
        this.add((Component)this.labelFechaIni, new XYConstraints(0, 165, 120, 25));
        this.add((Component)this.fechaIniField, new XYConstraints(105, 165, 90, 25));
        this.add((Component)this.btnSelFechaIni, new XYConstraints(200, 165, 25, 25));
        this.add((Component)this.labelFechaFin, new XYConstraints(235, 165, 120, 25));
        this.add((Component)this.fechaFinField, new XYConstraints(316, 165, 90, 25));
        this.add((Component)this.btnSelFechaFin, new XYConstraints(411, 165, 25, 25));
        this.add((Component)this.labelTipoAsociacionOrganismoProc, new XYConstraints(0, 200, 130, 25));
        this.add((Component)this.tipoAsociacion, new XYConstraints(0, 235, 436, 25));
        this.add((Component)this.labelObservOrganismoProc, new XYConstraints(0, 270, 120, 20));
        this.add((Component)this.observOrganismoProcArea.getScrollableArea(), new XYConstraints(0, 290, 436, 85));
        this.addListeners();
    }

    private void addListeners() {
        this.btnSelOrganismoAsociado.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropOrganismoProcedimientoJPanel.this.btnSelOrganismoAsociado_actionPerformed(e);
            }
        });
        this.btnSelFechaIni.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropOrganismoProcedimientoJPanel.this.btnSelFechaIni_actionPerformed(e);
            }
        });
        this.btnSelFechaFin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropOrganismoProcedimientoJPanel.this.btnSelFechaFin_actionPerformed(e);
            }
        });
    }

    public void limpiarCampos() {
        this.trOrganismoAsociado = null;
        this.codigoOrganismoAsociadoField.setText("");
        this.nombreOrganismoAsociadoField.setText("");
        this.observOrganismoProcArea.setText("");
        this.tipoAsociacion.setText("");
        this.fechaIniField.setText("");
        this.fechaFinField.setText("");
    }

    public void inicializarCampos(int nTipo) {
        this.nModoActualDeTrabajo = nTipo;
        boolean activo = false;
        boolean bReiniciarColoresLabel = true;
        switch (nTipo) {
            case 4: {
                this.conservarColoresDeFondo();
                bReiniciarColoresLabel = false;
                break;
            }
            case 2: {
                activo = false;
                bReiniciarColoresLabel = false;
                break;
            }
            case 3: {
                activo = true;
                break;
            }
            case 1: {
                this.iDatoAsignable = new TrOrganismoProc();
                this.limpiarCampos();
                activo = true;
            }
        }
        this.codigoOrganismoAsociadoField.setEditable(false);
        this.nombreOrganismoAsociadoField.setEditable(false);
        this.btnSelOrganismoAsociado.setEnabled(activo);
        this.observOrganismoProcArea.setEditable(activo);
        this.tipoAsociacion.setEditable(activo);
        this.btnSelFechaIni.setEnabled(activo);
        this.fechaIniField.setEditable(activo);
        this.btnSelFechaFin.setEnabled(activo);
        this.fechaFinField.setEditable(activo);
        if (bReiniciarColoresLabel) {
            this.labelCodigoOrganismoAsociado.setForeground(Color.BLACK);
            this.labelNombreOrganismoAsociado.setForeground(Color.BLACK);
        }
    }

    public void conservarColoresDeFondo() {
        this.colorFondoObservOrganismoProc = this.observOrganismoProcArea.getBackground();
        this.colorFondoTipoAsociacion = this.tipoAsociacion.getBackground();
        this.colorFuenteCodigoOrganismoAsociado = this.labelCodigoOrganismoAsociado.getForeground();
        this.colorFuenteNombreOrganismoAsociado = this.labelNombreOrganismoAsociado.getForeground();
        this.colorFondoFechaInicio = this.fechaIniField.getBackground();
        this.colorFondoFechaFin = this.fechaFinField.getBackground();
    }

    public void restaurarColoresDeFondo() {
        if (this.colorFondoObservOrganismoProc != null) {
            this.observOrganismoProcArea.setBackground(this.colorFondoObservOrganismoProc);
            this.colorFondoObservOrganismoProc = null;
        }
        if (this.colorFondoTipoAsociacion != null) {
            this.tipoAsociacion.setBackground(this.colorFondoTipoAsociacion);
            this.colorFondoTipoAsociacion = null;
        }
        if (this.colorFuenteCodigoOrganismoAsociado != null) {
            this.labelCodigoOrganismoAsociado.setForeground(this.colorFuenteCodigoOrganismoAsociado);
            this.colorFuenteCodigoOrganismoAsociado = null;
        }
        if (this.colorFuenteNombreOrganismoAsociado != null) {
            this.labelCodigoOrganismoAsociado.setForeground(this.colorFuenteNombreOrganismoAsociado);
            this.colorFuenteNombreOrganismoAsociado = null;
        }
        if (this.colorFondoFechaInicio != null) {
            this.fechaIniField.setBackground(this.colorFondoFechaInicio);
            this.colorFondoFechaInicio = null;
        }
        if (this.colorFondoFechaFin != null) {
            this.fechaFinField.setBackground(this.colorFondoFechaFin);
            this.colorFondoFechaFin = null;
        }
    }

    public IAsignable getValoresAsignables() {
        return this.iDatoAsignable;
    }

    public void setValoresAsignables(IAsignable datosAsignables) {
        if (datosAsignables != null && datosAsignables instanceof TrOrganismoProc) {
            this.iDatoAsignable = datosAsignables;
            TrOrganismoProc organismoProc = (TrOrganismoProc)datosAsignables;
            this.observOrganismoProcArea.setText(organismoProc.getObservaciones());
            this.tipoAsociacion.setText(organismoProc.getTipoAsociacion());
            if (organismoProc.getFechaInicioVigencia() != null) {
                this.fechaIniField.setText(this.formatoDeFecha.format(organismoProc.getFechaInicioVigencia()));
            } else {
                this.fechaIniField.setText("");
            }
            if (organismoProc.getFechaFinVigencia() != null) {
                this.fechaFinField.setText(this.formatoDeFecha.format(organismoProc.getFechaFinVigencia()));
            } else {
                this.fechaFinField.setText("");
            }
            this.trOrganismoAsociado = organismoProc.getOrganismoAsociado();
            if (this.trOrganismoAsociado != null) {
                this.codigoOrganismoAsociadoField.setText(this.trOrganismoAsociado.getCodigo());
                this.nombreOrganismoAsociadoField.setText(this.trOrganismoAsociado.getNombre());
            }
        }
    }

    public String getTitulo(int tipo) {
        return "Mantenimiento de Organismos del Procedimiento";
    }

    public boolean obtenerValoresCampos() {
        boolean ok = true;
        TrOrganismoProc organismoProc = new TrOrganismoProc();
        organismoProc = (TrOrganismoProc)this.iDatoAsignable;
        if (organismoProc == null || this.trOrganismoAsociado == null || this.tipoAsociacion.getText() == null || this.tipoAsociacion.getText().equals("") || this.fechaIniField.getText() == null || this.fechaIniField.getText().equals("")) {
            ok = false;
        }
        if (!ok) {
            JOptionPane.showMessageDialog(null, MantenimientoJDialog.TEXTO_FALTAN_ATRIBUTOS_OBLIGATORIOS, MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            return ok;
        }
        Date fechaIniAux = null;
        Date fechaFinAux = null;
        try {
            fechaIniAux = this.formatoDeFecha.parse(this.fechaIniField.getText());
        }
        catch (ParseException e) {
            JOptionPane.showMessageDialog(null, "El formato de la fecha de inicio de vigencia no es v\u00e1lido:\nFormato requerido: DD/MM/AAAA", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            return false;
        }
        try {
            if (this.fechaFinField.getText() != null && !this.fechaFinField.getText().equals("")) {
                fechaFinAux = this.formatoDeFecha.parse(this.fechaFinField.getText());
            }
        }
        catch (ParseException e) {
            JOptionPane.showMessageDialog(null, "El formato de la fecha de finalizaci\u00f3n de vigencia no es v\u00e1lido:\nFormato requerido: DD/MM/AAAA", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            return false;
        }
        if (fechaIniAux != null && fechaFinAux != null && fechaIniAux.after(fechaFinAux)) {
            JOptionPane.showMessageDialog(null, "La fecha de inicio de vigencia no puede ser posterior a la de finalizaci\u00f3n", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            return false;
        }
        organismoProc.setObservaciones(this.observOrganismoProcArea.getText());
        organismoProc.setFechaInicioVigencia(fechaIniAux);
        organismoProc.setFechaFinVigencia(fechaFinAux);
        organismoProc.setTipoAsociacion(this.tipoAsociacion.getText());
        organismoProc.setOrganismoAsociado(this.trOrganismoAsociado);
        return ok;
    }

    void btnSelOrganismoAsociado_actionPerformed(ActionEvent e) {
        MantenimientoOrganismoJDialog mttoOrganismos = new MantenimientoOrganismoJDialog();
        if (this.grafico != null) {
            if (this.nModoActualDeTrabajo != 1) {
                mttoOrganismos.inicializarListaElementos(this.grafico.getOrganismosInvolucrados(), this.trOrganismoAsociado);
            } else {
                mttoOrganismos.inicializarListaElementos(this.grafico.getOrganismosInvolucrados());
            }
        }
        mttoOrganismos.setLocationRelativeTo(null);
        mttoOrganismos.activarSeleccion(true);
        mttoOrganismos.setVisible(true);
        if (mttoOrganismos.obtenerElementoSeleccionado() != null) {
            TrOrganismo organismoSeleccionado = null;
            this.trOrganismoAsociado = organismoSeleccionado = (TrOrganismo)mttoOrganismos.obtenerElementoSeleccionado();
            if (this.trOrganismoAsociado != null) {
                this.codigoOrganismoAsociadoField.setText(this.trOrganismoAsociado.getCodigo());
                this.nombreOrganismoAsociadoField.setText(this.trOrganismoAsociado.getNombre());
                this.labelCodigoOrganismoAsociado.setForeground(ModelaUI.colorFuenteEtiquetaModificandose);
                this.labelNombreOrganismoAsociado.setForeground(ModelaUI.colorFuenteEtiquetaModificandose);
            }
        }
    }

    void btnSelFechaIni_actionPerformed(ActionEvent e) {
        DatePicker dp = new DatePicker((Observer)this.fechaIniField, new Locale("es", "", ""));
        dp.getScreen().setTitle("Fecha inicio vigencia");
        dp.start(this.fechaIniField);
    }

    void btnSelFechaFin_actionPerformed(ActionEvent e) {
        DatePicker dp = new DatePicker((Observer)this.fechaFinField, new Locale("es", "", ""));
        dp.getScreen().setTitle("Fecha finaliza vigencia");
        dp.start(this.fechaFinField);
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        this.grafico = nuevoGrafico;
    }

    public void inicializarFoco() {
        this.observOrganismoProcArea.requestFocus();
    }
}

