/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import gdtel.ui.swing.excontrols.CreadorButton;
import gdtel.ui.swing.excontrols.JComboBoxEx;
import gdtel.ui.swing.excontrols.JFiltroTextField;
import gdtel.ui.swing.excontrols.JPanelAtributable;
import gdtel.ui.swing.excontrols.JTextFieldAsignable;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.obj.TrFase;
import modela.bd.obj.TrPlazoSimple;
import modela.bd.obj.TrTransicion;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.MantenimientoTransicionJDialog;
import modela.ui.swing.PlazoSimpleJDialog;
import modela.ui.swing.PropBloqueJPanel;
import modela.ui.swing.PropEntidadesSistemaJPanel;
import modela.ui.swing.PropFaseJPanel;

public class PropPlazoSimpleJPanel
extends JPanelAtributable {
    private static final long serialVersionUID = 7581679291878088678L;
    private JLabel faseLabel = new JLabel();
    private JTextFieldAsignable faseTextField = new JTextFieldAsignable();
    private JLabel unidadesLabel = new JLabel();
    private JFiltroTextField unidadesTextField = new JFiltroTextField();
    private JLabel unidadLabel = new JLabel();
    private JComboBoxEx unidadComboBox = new JComboBoxEx();
    private XYLayout xYLayout1 = new XYLayout();
    private JLabel descripcionLabel = new JLabel();
    private JFiltroTextField descripcionTextField = new JFiltroTextField();
    private JLabel transicionLabel = new JLabel();
    private JTextFieldAsignable transTextField = new JTextFieldAsignable();
    private JLabel plazoLabel = new JLabel();
    ImageIcon seleccionarIconN = new ImageIcon(PropEntidadesSistemaJPanel.class.getResource(ModelaUI.IMG_SMALL_SELECCION));
    ImageIcon seleccionarIconS = new ImageIcon(PropEntidadesSistemaJPanel.class.getResource(ModelaUI.IMG_SMALL_SELECCION_SOBRE));
    ImageIcon seleccionarIconD = new ImageIcon(PropEntidadesSistemaJPanel.class.getResource(ModelaUI.IMG_SMALL_SELECCION_NO_ENABLED));
    ImageIcon eliminarIconN = new ImageIcon(PropFaseJPanel.class.getResource(ModelaUI.IMG_SMALL_ELIMINAR));
    ImageIcon eliminarIconS = new ImageIcon(PropFaseJPanel.class.getResource(ModelaUI.IMG_SMALL_ELIMINAR_SOBRE));
    ImageIcon eliminarIconD = new ImageIcon(PropFaseJPanel.class.getResource(ModelaUI.IMG_SMALL_ELIMINAR_NO_ENABLED));
    ImageIcon cancelarIconN = new ImageIcon(PlazoSimpleJDialog.class.getResource(ModelaUI.IMG_SMALL_CANCELAR));
    ImageIcon cancelarIconD = new ImageIcon(PlazoSimpleJDialog.class.getResource(ModelaUI.IMG_SMALL_CANCELAR_NO_ENABLED));
    ImageIcon cancelarIconS = new ImageIcon(PlazoSimpleJDialog.class.getResource(ModelaUI.IMG_SMALL_CANCELAR_SOBRE));
    ImageIcon aplicarIconN = new ImageIcon(PlazoSimpleJDialog.class.getResource(ModelaUI.IMG_SMALL_APLICAR));
    ImageIcon aplicarIconD = new ImageIcon(PlazoSimpleJDialog.class.getResource(ModelaUI.IMG_SMALL_APLICAR_NO_ENABLED));
    ImageIcon aplicarIconS = new ImageIcon(PlazoSimpleJDialog.class.getResource(ModelaUI.IMG_SMALL_APLICAR_SOBRE));
    ImageIcon quitarIconN = new ImageIcon(PropBloqueJPanel.class.getResource(ModelaUI.IMG_SMALL_QUITAR));
    ImageIcon quitarIconS = new ImageIcon(PropBloqueJPanel.class.getResource(ModelaUI.IMG_SMALL_QUITAR_SOBRE));
    ImageIcon quitarIconD = new ImageIcon(PropBloqueJPanel.class.getResource(ModelaUI.IMG_SMALL_QUITAR_NO_ENABLED));
    private JButton seleccionarButton = (JButton)CreadorButton.crearBoton(1, false, this.seleccionarIconN, this.seleccionarIconD, this.seleccionarIconS, this.seleccionarIconS);
    private JButton eliminarButton = (JButton)CreadorButton.crearBoton(1, false, this.quitarIconN, this.quitarIconD, this.quitarIconS, this.quitarIconS);
    private TrFase m_faseActiva = null;
    private TrPlazoSimple m_plazoSimple = null;
    DDPGrafico grafico = null;

    public PropPlazoSimpleJPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.xYLayout1);
        this.plazoLabel.setText("Propiedades del plazo simple");
        this.plazoLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.plazoLabel.setForeground(ModelaUI.colorSeleccion);
        this.faseLabel.setText("Fase:");
        this.faseLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.faseLabel.setVisible(false);
        this.faseLabel.setToolTipText("null");
        this.faseLabel.setHorizontalTextPosition(2);
        this.faseLabel.setHorizontalAlignment(2);
        this.faseTextField.setText("");
        this.faseTextField.setVisible(false);
        this.faseTextField.setEnabled(true);
        this.faseTextField.setEditable(false);
        this.faseTextField.establecerTipografia(1);
        this.unidadesLabel.setText("Unidades:");
        this.unidadesLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.unidadesTextField.setText("");
        this.unidadesTextField.setTipoFiltro(2);
        this.unidadesTextField.setNumItems(2);
        this.unidadLabel.setText("Unidad:");
        this.unidadLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.descripcionLabel.setText("Descripci\u00f3n:");
        this.descripcionLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.descripcionTextField.setText("");
        this.descripcionTextField.setNumItems(100);
        this.descripcionTextField.establecerTipografia(1);
        this.descripcionTextField.setTipoFiltro(1);
        this.transicionLabel.setText("Transici\u00f3n que se provoca:");
        this.transTextField.setText("");
        this.transTextField.setEnabled(false);
        this.seleccionarButton.setFocusPainted(false);
        this.eliminarButton.setFocusPainted(false);
        this.seleccionarButton.setEnabled(true);
        this.eliminarButton.setEnabled(true);
        this.add((Component)this.plazoLabel, new XYConstraints(0, 0, 190, 20));
        this.add((Component)this.unidadesLabel, new XYConstraints(15, 47, 65, 10));
        this.add((Component)this.unidadesTextField, new XYConstraints(80, 40, 45, 25));
        this.add((Component)this.unidadLabel, new XYConstraints(135, 47, 50, 10));
        this.add((Component)this.unidadComboBox, new XYConstraints(185, 40, 100, 25));
        this.add((Component)this.descripcionLabel, new XYConstraints(0, 75, 80, 20));
        this.add((Component)this.descripcionTextField, new XYConstraints(80, 75, 450, 25));
        this.add((Component)this.transTextField, new XYConstraints(160, 110, 240, 25));
        this.add((Component)this.transicionLabel, new XYConstraints(0, 110, 160, 20));
        this.add((Component)this.seleccionarButton, new XYConstraints(415, 111, 80, 25));
        this.add((Component)this.eliminarButton, new XYConstraints(500, 113, 30, 21));
        this.add((Component)this.faseLabel, new XYConstraints(0, 15, 40, 10));
        this.add((Component)this.faseTextField, new XYConstraints(80, 10, 100, 25));
        this.cargarCmbUnidad();
        this.limpiarCampos();
        this.seleccionarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropPlazoSimpleJPanel.this.seleccionarButton_actionPerformed(e);
            }
        });
        this.eliminarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropPlazoSimpleJPanel.this.eliminarButton_actionPerformed(e);
            }
        });
    }

    public void setFaseActiva(TrFase fase) {
        if (fase != null) {
            this.m_faseActiva = fase;
            this.faseTextField.setObjetoAsignable(this.m_faseActiva);
        } else {
            this.faseTextField.setText("");
        }
    }

    public void cargarCmbUnidad() {
        this.unidadComboBox.removeAllItems();
        this.unidadComboBox.addItem("DIAS");
        this.unidadComboBox.addItem("MESES");
        this.unidadComboBox.addItem("A\u00d1OS");
        this.unidadComboBox.setSelectedItem("DIAS");
    }

    public void setPlazoSimple(TrPlazoSimple plazoSimple) {
        if (plazoSimple != null) {
            this.m_plazoSimple = plazoSimple;
            int nNumUnidades = plazoSimple.getNumUnidades();
            this.unidadesTextField.setText(String.valueOf(nNumUnidades));
            this.descripcionTextField.setText(plazoSimple.getDescripcion());
            if (!plazoSimple.getUnidad().equals("")) {
                if (plazoSimple.getUnidad().equals("D")) {
                    this.unidadComboBox.setSelectedItem("DIAS");
                }
                if (plazoSimple.getUnidad().equals("M")) {
                    this.unidadComboBox.setSelectedItem("MESES");
                }
                if (plazoSimple.getUnidad().equals("A")) {
                    this.unidadComboBox.setSelectedItem("A\u00d1OS");
                }
                this.transTextField.setObjetoAsignable(plazoSimple.getTransicionQueProvoca());
            }
        } else {
            this.limpiarCampos();
            this.m_plazoSimple = null;
        }
    }

    public TrPlazoSimple getPlazoSimple() {
        return this.m_plazoSimple;
    }

    public boolean obtenerValoresCampos() {
        boolean ok = true;
        if (this.m_plazoSimple == null) {
            this.m_plazoSimple = new TrPlazoSimple();
        }
        if (this.unidadesTextField.getText().equals("") || this.descripcionTextField.getText().equals("")) {
            ok = false;
        }
        if (this.unidadComboBox.getSelectedIndex() < 0) {
            ok = false;
        }
        if (!ok) {
            JOptionPane.showMessageDialog(null, MantenimientoJDialog.TEXTO_FALTAN_ATRIBUTOS_OBLIGATORIOS, MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
        } else {
            this.m_plazoSimple.setNumUnidades(Integer.parseInt(this.unidadesTextField.getText()));
            this.m_plazoSimple.setDESCRIPCION(this.descripcionTextField.getText());
            this.m_plazoSimple.setFaseAsociada(this.m_faseActiva);
            int nSelectedItem = this.unidadComboBox.getSelectedIndex();
            if (this.unidadComboBox.getItemAt(nSelectedItem).toString().equals("DIAS")) {
                this.m_plazoSimple.setUnidad("D");
            }
            if (this.unidadComboBox.getItemAt(nSelectedItem).toString().equals("MESES")) {
                this.m_plazoSimple.setUnidad("M");
            }
            if (this.unidadComboBox.getItemAt(nSelectedItem).toString().equals("A\u00d1OS")) {
                this.m_plazoSimple.setUnidad("A");
            }
            this.m_plazoSimple.setTransicionQueProvoca((TrTransicion)this.transTextField.getObjetoAsignable());
        }
        return ok;
    }

    public void limpiarCampos() {
        this.unidadesTextField.setText("");
        this.descripcionTextField.setText("");
        this.transTextField.setObjetoAsignable(null);
        this.unidadComboBox.setSelectedItem("DIAS");
    }

    public void eliminarPlazoSimple() {
        this.limpiarCampos();
        this.m_plazoSimple = null;
    }

    public void inicializarCampos(int nTipo) {
    }

    public String getTitulo(int nTipo) {
        return "";
    }

    public void setValoresAsignables(IAsignable datosAsignables) {
    }

    public IAsignable getValoresAsignables() {
        return null;
    }

    public void seleccionarButton_actionPerformed(ActionEvent e) {
        if (this.m_faseActiva == null) {
            return;
        }
        MantenimientoTransicionJDialog mmttTransicion = new MantenimientoTransicionJDialog(true);
        mmttTransicion.setDesdeUtilidadGrf(true);
        if (this.grafico != null) {
            mmttTransicion.setGrafico(this.grafico);
            ConjuntoDatos conjuntoTransiciones = this.grafico.getTransicionesPlazoSimple(this.m_faseActiva);
            if (conjuntoTransiciones == null || conjuntoTransiciones.getListaDatos().size() == 0) {
                JOptionPane.showMessageDialog(null, "No existen transiciones que se puedan provocar desde esta fase.", "Atenci\u00f3n", 2);
                return;
            }
            mmttTransicion.inicializarListaElementos(conjuntoTransiciones);
        }
        mmttTransicion.setLocationRelativeTo(null);
        mmttTransicion.setVisible(true);
        TrTransicion trSeleccionada = (TrTransicion)mmttTransicion.obtenerElementoSeleccionado();
        if (trSeleccionada != null) {
            this.transTextField.setObjetoAsignable(trSeleccionada);
            this.transicionLabel.setForeground(ModelaUI.colorFuenteEtiquetaModificandose);
        }
    }

    public void eliminarButton_actionPerformed(ActionEvent e) {
        if (!this.transTextField.getText().equals("")) {
            this.transicionLabel.setForeground(ModelaUI.colorFuenteEtiquetaModificandose);
        }
        this.transTextField.setObjetoAsignable(null);
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        this.grafico = nuevoGrafico;
    }

    public void reiniciarColores() {
        this.unidadComboBox.setEnabled(true);
        this.unidadesTextField.setEditable(true);
        this.transicionLabel.setForeground(Color.BLACK);
        this.descripcionTextField.setEditable(true);
    }
}

