/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import gdtel.ui.swing.excontrols.JComboBoxAsignable;
import gdtel.ui.swing.excontrols.JFiltroTextArea;
import gdtel.ui.swing.excontrols.JFiltroTextField;
import gdtel.ui.swing.excontrols.JPanelAtributable;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import modela.bd.obj.TrBloquePermitido;
import modela.bd.obj.TrDocumentoPermitido;
import modela.bd.obj.TrTarea;
import modela.bd.obj.TrTipoTarea;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.AgregarTipoTareaJDialog;
import modela.ui.swing.PropBloquePermitidoJPanel;
import modela.ui.swing.PropDocumentoPermitidoJPanel;

public class PropTareaJPanel
extends JPanelAtributable {
    private static final long serialVersionUID = 3430448413396001067L;
    private XYLayout xYLayout1 = new XYLayout();
    private JLabel jLabel1 = new JLabel();
    private JFiltroTextField nombreField = new JFiltroTextField();
    private JLabel jLabel2 = new JLabel();
    private JFiltroTextArea descripArea = new JFiltroTextArea();
    private JLabel jLabel3 = new JLabel();
    private JLabel jLabel4 = new JLabel();
    JComboBoxAsignable comboTipoTarea = new JComboBoxAsignable();
    private JButton nuevoTipoButton = new JButton();
    private JPanel proAdicionalesPanel;
    private PropBloquePermitidoJPanel bloquePanel;
    private PropDocumentoPermitidoJPanel documentoPanel;
    private TrTipoTarea m_tipoTarea = TrTipoTarea.MANIPULAR_DATOS;
    private long m_nTipoUtilidad;
    private DDPGrafico grafico = null;
    boolean m_bCambioTipo;

    public PropTareaJPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void jbInit() {
        this.setLayout(this.xYLayout1);
        this.jLabel1.setText("Nombre:");
        this.jLabel1.setFont(ModelaUI.fuentePrincipalNegrita);
        this.m_bCambioTipo = false;
        this.nombreField.setTipoFiltro(1);
        this.nombreField.setNumItems(50);
        this.nombreField.setEnabled(true);
        this.nombreField.setEditable(false);
        this.nombreField.setFocusable(false);
        this.jLabel2.setText("Descripci\u00f3n:");
        this.jLabel2.setFont(ModelaUI.fuentePrincipalNegrita);
        this.descripArea.setBorder(BorderFactory.createBevelBorder(1));
        this.descripArea.establecerTipografia(1);
        this.descripArea.setTipoFiltro(1);
        this.descripArea.setNumItems(250);
        this.descripArea.setEnabled(true);
        this.descripArea.setEditable(false);
        this.descripArea.setFocusable(false);
        this.jLabel3.setText("Propiedades de la tarea");
        this.jLabel3.setFont(ModelaUI.fuentePrincipalNegrita);
        this.jLabel3.setForeground(ModelaUI.colorSeleccion);
        this.jLabel4.setText("Tipo:");
        this.jLabel4.setFont(ModelaUI.fuentePrincipalNegrita);
        this.nuevoTipoButton.setText("Nuevo");
        this.add((Component)this.jLabel3, new XYConstraints(0, 0, 215, 25));
        this.add((Component)this.jLabel4, new XYConstraints(0, 50, 40, 20));
        this.add((Component)this.comboTipoTarea, new XYConstraints(0, 70, 345, 25));
        this.add((Component)this.jLabel1, new XYConstraints(0, 100, 65, 20));
        this.add((Component)this.nombreField, new XYConstraints(0, 120, 345, 25));
        this.add((Component)this.jLabel2, new XYConstraints(0, 150, 120, 20));
        this.add((Component)this.descripArea.getScrollableArea(), new XYConstraints(0, 170, 345, 120));
        this.documentoPanel = new PropDocumentoPermitidoJPanel(this);
        this.bloquePanel = new PropBloquePermitidoJPanel(this);
        this.proAdicionalesPanel = new JPanel(new CardLayout());
        this.proAdicionalesPanel.add((Component)this.bloquePanel, "Bloque");
        this.proAdicionalesPanel.add((Component)this.documentoPanel, "Documento");
        this.add((Component)this.proAdicionalesPanel, new XYConstraints(0, 280, 500, 70));
        this.comboTipoTarea.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropTareaJPanel.this.visualizarPanel();
            }
        });
        this.nuevoTipoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                AgregarTipoTareaJDialog nuevoTipoJDialog = new AgregarTipoTareaJDialog();
                nuevoTipoJDialog.setModal(true);
                nuevoTipoJDialog.setLocationRelativeTo(null);
                nuevoTipoJDialog.setVisible(true);
                if (nuevoTipoJDialog.isAcepta()) {
                    TrTipoTarea tipoTarea = new TrTipoTarea();
                    tipoTarea.setTipo(nuevoTipoJDialog.getNombreTipo());
                    tipoTarea.setDescripTipoActual(nuevoTipoJDialog.getDescripTipo());
                    PropTareaJPanel.this.comboTipoTarea.addItem(tipoTarea);
                    Object var3_3 = null;
                }
                nuevoTipoJDialog = null;
            }
        });
        this.descripArea.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                if (evt.getKeyChar() == '\t') {
                    // empty if block
                }
            }
        });
        this.cargarCmbTiposTarea();
    }

    public void limpiarCampos() {
        this.nombreField.setText("");
        this.descripArea.setText("");
        this.comboTipoTarea.setSelectedIndex(0);
        if (this.bloquePanel != null) {
            this.bloquePanel.limpiarCampos();
        }
        if (this.documentoPanel != null) {
            this.documentoPanel.limpiarCampos();
        }
    }

    public IAsignable getValoresAsignables() {
        if (this.iDatoAsignable instanceof TrBloquePermitido) {
            return this.bloquePanel.getValoresAsignables();
        }
        if (this.iDatoAsignable instanceof TrDocumentoPermitido) {
            return this.documentoPanel.getValoresAsignables();
        }
        return this.iDatoAsignable;
    }

    public void setValoresAsignables(IAsignable datosAsignables) {
        TrTarea tarea = null;
        this.iDatoAsignable = datosAsignables;
        if (datosAsignables != null && datosAsignables instanceof TrTarea) {
            if (datosAsignables instanceof TrBloquePermitido) {
                tarea = (TrBloquePermitido)datosAsignables;
            }
            if (datosAsignables instanceof TrDocumentoPermitido) {
                tarea = (TrDocumentoPermitido)datosAsignables;
            }
            if (!(datosAsignables instanceof TrBloquePermitido) && !(datosAsignables instanceof TrDocumentoPermitido)) {
                tarea = (TrTarea)datosAsignables;
            }
        } else {
            return;
        }
        if (tarea != null && tarea.getNOMBRE() != null) {
            this.nombreField.setText(tarea.getNombre());
        }
        if (tarea != null && tarea.getDESCRIPCION() != null) {
            this.descripArea.setText(tarea.getDescripcion());
        }
        if (tarea != null && tarea.getTrTipoTarea() != null) {
            this.comboTipoTarea.setSelectedItem(tarea.getTrTipoTarea());
        }
        if (tarea instanceof TrBloquePermitido) {
            this.proAdicionalesPanel.setVisible(true);
            this.bloquePanel.setValoresAsignables(datosAsignables);
        }
        if (tarea instanceof TrDocumentoPermitido) {
            this.proAdicionalesPanel.setVisible(true);
            this.documentoPanel.setValoresAsignables(datosAsignables);
        }
        if (!(tarea instanceof TrBloquePermitido) && !(tarea instanceof TrDocumentoPermitido)) {
            this.proAdicionalesPanel.setVisible(false);
        }
    }

    public String getTitulo(int n) {
        String titulo = "Mantenimiento de tareas";
        return titulo;
    }

    public boolean obtenerValoresCampos() {
        String strTipo = "";
        this.m_bCambioTipo = false;
        boolean ok = true;
        if (this.nombreField.getText() == null || this.descripArea.getText() == null || this.comboTipoTarea.getSelectedItem() == null) {
            ok = false;
        }
        if (this.nombreField.getText().equals("") || this.descripArea.getText().equals("")) {
            ok = false;
        }
        if (!ok) {
            JOptionPane.showMessageDialog(null, MantenimientoJDialog.TEXTO_FALTAN_ATRIBUTOS_OBLIGATORIOS, MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            this.inicializarCampos(3);
        } else {
            TrTarea tarea;
            if (this.iDatoAsignable instanceof TrBloquePermitido) {
                if (!this.bloquePanel.obtenerValoresCampos()) {
                    return false;
                }
                tarea = (TrBloquePermitido)this.bloquePanel.getValoresAsignables();
                TrBloquePermitido bloqueAux = (TrBloquePermitido)this.bloquePanel.getValoresAsignables();
                strTipo = bloqueAux.getBloqueFin().getTipoBloque().toString();
            } else if (this.iDatoAsignable instanceof TrDocumentoPermitido) {
                if (!this.documentoPanel.obtenerValoresCampos()) {
                    return false;
                }
                tarea = (TrDocumentoPermitido)this.documentoPanel.getValoresAsignables();
                TrDocumentoPermitido docAux = (TrDocumentoPermitido)this.documentoPanel.getValoresAsignables();
                strTipo = docAux.getTipoDocumento().getIncGen();
            } else {
                tarea = (TrTarea)this.iDatoAsignable;
            }
            tarea.setNOMBRE(this.nombreField.getText());
            tarea.setDESCRIPCION(this.descripArea.getText());
            int nSelectedItem = this.comboTipoTarea.getSelectedIndex();
            tarea.setTrTipoTarea((TrTipoTarea)this.comboTipoTarea.getItemAt(nSelectedItem));
            if (tarea instanceof TrDocumentoPermitido) {
                int n;
                Object[] options;
                String strTipoTarea;
                if (strTipo.equals("G") && !(strTipoTarea = tarea.getTrTipoTarea().getNombre()).equals("GENERAR_DOCUMENTO")) {
                    options = new Object[]{"S\u00ed", "No"};
                    n = JOptionPane.showOptionDialog(this, "Se est\u00e1 intentando guardar un tipo de documento GENERADO para un tipo de tarea INCORPORAR_DOCUMENTO.\n \u00bfDesea actualizar el tipo de tarea?", "Atenci\u00f3n", 0, 3, null, options, options[1]);
                    if (n == 0) {
                        tarea.setTrTipoTarea((TrTipoTarea)this.comboTipoTarea.getItemAt(1));
                        this.m_bCambioTipo = true;
                        this.comboTipoTarea.setSelectedItem(TrTipoTarea.GENERAR_DOCUMENTO);
                        this.m_bCambioTipo = false;
                    } else {
                        ok = false;
                    }
                }
                if (strTipo.equals("I") && !(strTipoTarea = tarea.getTrTipoTarea().getNombre()).equals("INCORPORAR_DOCUMENTO")) {
                    options = new Object[]{"S\u00ed", "No"};
                    n = JOptionPane.showOptionDialog(this, "Se est\u00e1 intentando guardar un tipo de documento INCORPORADO para un tipo de tarea GENERAR_DOCUMENTO.\n \u00bfDesea actualizar el tipo de tarea?", "Atenci\u00f3n", 0, 3, null, options, options[1]);
                    if (n == 0) {
                        tarea.setTrTipoTarea((TrTipoTarea)this.comboTipoTarea.getItemAt(2));
                        this.m_bCambioTipo = true;
                        this.comboTipoTarea.setSelectedItem(TrTipoTarea.INCORPORAR_DOCUMENTO);
                        this.m_bCambioTipo = false;
                    } else {
                        ok = false;
                    }
                }
            } else if (tarea instanceof TrBloquePermitido) {
                if (strTipo.equals("OTROS")) {
                    String strTipoTarea = tarea.getTrTipoTarea().getNombre();
                    if (!strTipoTarea.equals("OTROS")) {
                        Object[] options = new Object[]{"S\u00ed", "No"};
                        int n = JOptionPane.showOptionDialog(this, "Se est\u00e1 intentando guardar un bloque del tipo OTROS para un tipo de tarea MANIPULAR_DATOS.\n \u00bfDesea actualizar el tipo de tarea?", "Atenci\u00f3n", 0, 3, null, options, options[1]);
                        if (n == 0) {
                            tarea.setTrTipoTarea((TrTipoTarea)this.comboTipoTarea.getItemAt(3));
                            this.m_bCambioTipo = true;
                            this.comboTipoTarea.setSelectedItem(TrTipoTarea.OTROS);
                            this.m_bCambioTipo = false;
                        } else {
                            ok = false;
                        }
                    }
                } else {
                    String strTipoTarea = tarea.getTrTipoTarea().getNombre();
                    if (!strTipoTarea.equals("MANIPULAR_DATOS")) {
                        Object[] options = new Object[]{"S\u00ed", "No"};
                        int n = JOptionPane.showOptionDialog(this, "Se est\u00e1 intentando guardar un bloque del tipo " + strTipo + " para un tipo de tarea OTROS.\n \u00bfDesea actualizar el tipo de tarea?", "Atenci\u00f3n", 0, 3, null, options, options[1]);
                        if (n == 0) {
                            tarea.setTrTipoTarea((TrTipoTarea)this.comboTipoTarea.getItemAt(0));
                            this.m_bCambioTipo = true;
                            this.comboTipoTarea.setSelectedItem(TrTipoTarea.MANIPULAR_DATOS);
                            this.m_bCambioTipo = false;
                        } else {
                            ok = false;
                        }
                    }
                }
            }
        }
        return ok;
    }

    public void inicializarCampos(int nTipo) {
        this.comboTipoTarea.setEnabled(false);
        this.m_nTipoUtilidad = nTipo;
        switch (nTipo) {
            case 4: {
                this.conservarColoresDeFondo();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 1: {
                this.comboTipoTarea.setEnabled(true);
                this.iDatoAsignable = new TrBloquePermitido();
                this.limpiarCampos();
            }
        }
        if (this.iDatoAsignable instanceof TrBloquePermitido) {
            this.proAdicionalesPanel.setVisible(true);
            this.bloquePanel.inicializarCampos(nTipo);
        }
        if (this.iDatoAsignable instanceof TrDocumentoPermitido) {
            this.proAdicionalesPanel.setVisible(true);
            this.documentoPanel.inicializarCampos(nTipo);
        }
    }

    public void setGrafico(DDPGrafico g) {
        this.grafico = g;
        this.documentoPanel.setGrafico(this.grafico);
        this.bloquePanel.setGrafico(this.grafico);
    }

    private void cargarCmbTiposTarea() {
        this.comboTipoTarea.removeAllItems();
        this.comboTipoTarea.addItem(TrTipoTarea.MANIPULAR_DATOS);
        this.comboTipoTarea.addItem(TrTipoTarea.GENERAR_DOCUMENTO);
        this.comboTipoTarea.addItem(TrTipoTarea.INCORPORAR_DOCUMENTO);
        this.comboTipoTarea.addItem(TrTipoTarea.OTROS);
        this.comboTipoTarea.setSelectedIndex(0);
    }

    void visualizarPanel() {
        int nSelectedItem = this.comboTipoTarea.getSelectedIndex();
        if (nSelectedItem == -1) {
            return;
        }
        CardLayout cl = (CardLayout)this.proAdicionalesPanel.getLayout();
        if (this.comboTipoTarea.getItemAt(nSelectedItem).toString().equals("MANIPULAR_DATOS") || this.comboTipoTarea.getItemAt(nSelectedItem).toString().equals("OTROS")) {
            cl.show(this.proAdicionalesPanel, "Bloque");
        } else {
            cl.show(this.proAdicionalesPanel, "Documento");
        }
        if (this.m_nTipoUtilidad == 1L && !this.m_bCambioTipo) {
            this.crearDatoAsignable();
        }
        this.repaint();
    }

    private void crearDatoAsignable() {
        int nSelectedItem = this.comboTipoTarea.getSelectedIndex();
        TrTipoTarea tipoTarea = (TrTipoTarea)this.comboTipoTarea.getItemAt(nSelectedItem);
        if (tipoTarea.equals(this.m_tipoTarea)) {
            return;
        }
        this.m_tipoTarea = tipoTarea;
        this.iDatoAsignable = null;
        if (tipoTarea == TrTipoTarea.MANIPULAR_DATOS || tipoTarea == TrTipoTarea.OTROS) {
            this.iDatoAsignable = new TrBloquePermitido();
            this.bloquePanel.inicializarCampos(1);
        } else if (tipoTarea == TrTipoTarea.GENERAR_DOCUMENTO || tipoTarea == TrTipoTarea.INCORPORAR_DOCUMENTO) {
            this.iDatoAsignable = new TrDocumentoPermitido();
            this.documentoPanel.inicializarCampos(1);
        } else {
            this.iDatoAsignable = new TrTarea();
        }
    }

    public void setNombre(String strNombre) {
        this.nombreField.setText(strNombre);
    }

    public void setDescripcion(String strDescripcion) {
        this.descripArea.setText(strDescripcion);
    }

    public void setTipoTarea(TrTipoTarea tipoTarea) {
        if (tipoTarea != null) {
            this.comboTipoTarea.setSelectedItem(tipoTarea);
        }
    }

    public IAsignable getValoresAsignablesTemporales() {
        int nSelectedItem = this.comboTipoTarea.getSelectedIndex();
        if (nSelectedItem < 0) {
            return null;
        }
        TrTipoTarea tipoTarea = (TrTipoTarea)this.comboTipoTarea.getItemAt(nSelectedItem);
        if (tipoTarea == TrTipoTarea.MANIPULAR_DATOS || tipoTarea == TrTipoTarea.OTROS) {
            TrBloquePermitido tareaTemp = new TrBloquePermitido();
            tareaTemp.setBloqueFin(this.bloquePanel.getBloqueSeleccionado());
            return tareaTemp;
        }
        if (tipoTarea == TrTipoTarea.GENERAR_DOCUMENTO || tipoTarea == TrTipoTarea.INCORPORAR_DOCUMENTO) {
            TrDocumentoPermitido tareaTemp = new TrDocumentoPermitido();
            tareaTemp.setTipoDocumento(this.documentoPanel.getTipoDocumentoSeleccioando());
            return tareaTemp;
        }
        return null;
    }

    public void setCambioTipo(boolean bCambioTipo) {
        this.m_bCambioTipo = bCambioTipo;
    }

    public void inicializarFoco() {
    }

    public void restaurarColoresDeFondo() {
        if (this.documentoPanel != null) {
            this.documentoPanel.restaurarColoresDeFondo();
        }
        if (this.bloquePanel != null) {
            this.bloquePanel.restaurarColoresDeFondo();
        }
    }

    public void conservarColoresDeFondo() {
        if (this.documentoPanel != null) {
            this.documentoPanel.conservarColoresDeFondo();
        }
        if (this.bloquePanel != null) {
            this.bloquePanel.conservarColoresDeFondo();
        }
    }
}

