/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import gdtel.ui.swing.excontrols.JFiltroTextArea;
import gdtel.ui.swing.excontrols.JFiltroTextField;
import gdtel.ui.swing.excontrols.JPanelAtributable;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.obj.TrTipoActo;
import modela.ui.ModelaUI;

public class PropTipoActoJPanel
extends JPanelAtributable {
    private static final long serialVersionUID = 7618361055928774092L;
    private final JLabel abreviaturaLabel = new JLabel();
    JFiltroTextField abreviaturaField = new JFiltroTextField();
    private final JFiltroTextArea descripcionArea = new JFiltroTextArea();
    private final JLabel jLabel1 = new JLabel();
    private final JLabel jLabel2 = new JLabel();
    private final XYLayout xYLayout1 = new XYLayout();
    private Color colorFondoAbreviatura = null;
    private Color colorFondoDescripcion = null;

    public PropTipoActoJPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.xYLayout1);
        this.jLabel2.setText("Propiedades de tipo de acto");
        this.jLabel2.setFont(ModelaUI.fuentePrincipalNegrita);
        this.jLabel2.setForeground(ModelaUI.colorSeleccion);
        this.abreviaturaLabel.setText("Abreviatura:");
        this.abreviaturaLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.jLabel1.setText("Descripci\u00f3n:");
        this.jLabel1.setFont(ModelaUI.fuentePrincipalNegrita);
        this.abreviaturaField.setNumItems(10);
        this.abreviaturaField.establecerTipografia(1);
        this.abreviaturaField.setTipoFiltro(1);
        this.abreviaturaField.setEnabled(true);
        this.abreviaturaField.setEditable(false);
        this.descripcionArea.setBorder(BorderFactory.createBevelBorder(1));
        this.descripcionArea.setTipoFiltro(1);
        this.descripcionArea.setNumItems(200);
        this.descripcionArea.establecerTipografia(1);
        this.descripcionArea.setEnabled(true);
        this.descripcionArea.setEditable(false);
        this.descripcionArea.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                if (evt.getKeyChar() == '\t') {
                    PropTipoActoJPanel.this.abreviaturaField.requestFocus();
                }
            }
        });
        this.add((Component)this.jLabel2, new XYConstraints(0, 0, 200, 20));
        this.add((Component)this.abreviaturaLabel, new XYConstraints(0, 50, 100, 25));
        this.add((Component)this.abreviaturaField, new XYConstraints(0, 70, 345, 25));
        this.add((Component)this.jLabel1, new XYConstraints(0, 100, 100, 25));
        this.add((Component)this.descripcionArea.getScrollableArea(), new XYConstraints(0, 120, 345, 210));
    }

    public void inicializarCampos(int nTipo) {
        boolean activo = false;
        switch (nTipo) {
            case 4: {
                this.conservarColoresDeFondo();
                break;
            }
            case 2: {
                activo = false;
                break;
            }
            case 3: {
                activo = true;
                break;
            }
            case 1: {
                this.iDatoAsignable = new TrTipoActo();
                this.abreviaturaField.setText("");
                this.descripcionArea.setText("");
                activo = true;
            }
        }
        this.abreviaturaField.setEditable(activo);
        this.descripcionArea.setEditable(activo);
    }

    public boolean obtenerValoresCampos() {
        TrTipoActo tipoActo = null;
        boolean ok = true;
        tipoActo = (TrTipoActo)this.iDatoAsignable;
        if (tipoActo == null) {
            return false;
        }
        if (this.abreviaturaField.getText() == null || this.descripcionArea.getText() == null) {
            ok = false;
        }
        if (this.abreviaturaField.getText().equals("") || this.descripcionArea.getText().equals("")) {
            ok = false;
        }
        if (!ok) {
            JOptionPane.showMessageDialog(null, MantenimientoJDialog.TEXTO_FALTAN_ATRIBUTOS_OBLIGATORIOS, MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
        } else {
            tipoActo.setABREVIATURA(this.abreviaturaField.getText());
            tipoActo.setDESCRIPCION(this.descripcionArea.getText());
        }
        return ok;
    }

    public String getTitulo(int nTipo) {
        String strTitulo = "Mantenimiento de tipos de acto";
        return strTitulo;
    }

    public void setValoresAsignables(IAsignable datosAsignables) {
        TrTipoActo trTipoActo = null;
        if (datosAsignables == null) {
            return;
        }
        if (!(datosAsignables instanceof TrTipoActo)) {
            return;
        }
        this.iDatoAsignable = datosAsignables;
        trTipoActo = (TrTipoActo)datosAsignables;
        if (trTipoActo.getNombre() != null) {
            this.abreviaturaField.setText(trTipoActo.getNombre());
        }
        if (trTipoActo.getDescripcion() != null) {
            this.descripcionArea.setText(trTipoActo.getDescripcion());
        }
    }

    public IAsignable getValoresAsignables() {
        return this.iDatoAsignable;
    }

    public void limpiarCampos() {
        this.abreviaturaField.setText("");
        this.descripcionArea.setText("");
    }

    public String getAbreviaturaTmp() {
        return this.abreviaturaField.getText();
    }

    public void inicializarFoco() {
        this.abreviaturaField.requestFocus();
    }

    public void conservarColoresDeFondo() {
        this.colorFondoAbreviatura = this.abreviaturaField.getBackground();
        this.colorFondoDescripcion = this.descripcionArea.getBackground();
    }

    public void restaurarColoresDeFondo() {
        if (this.colorFondoAbreviatura != null) {
            this.abreviaturaField.setBackground(this.colorFondoAbreviatura);
            this.colorFondoAbreviatura = null;
        }
        if (this.colorFondoDescripcion != null) {
            this.descripcionArea.setBackground(this.colorFondoDescripcion);
            this.colorFondoDescripcion = null;
        }
    }
}

