/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.bd.BotonesMantenimientoJPanel;
import gdtel.ui.swing.excontrols.CreadorButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.graf.ValidadorDefProcedimiento;
import modela.ui.ModelaUI;
import modela.ui.event.InfoResultado;
import modela.ui.event.InfoResultadoEvent;
import modela.ui.event.InfoResultadoListener;
import modela.ui.swing.excontrols.JTableResultados;
import modela.ui.swing.renderers.ResultadosTableCellRenderer;

public class ValidarDefProcJDialog
extends JDialog
implements ContainerListener,
KeyListener {
    private static final long serialVersionUID = -109683484298731350L;
    private JPanel pPanelPrincipal;
    private JTableResultados tablaResultados;
    ImageIcon cerrarIconN = new ImageIcon(BotonesMantenimientoJPanel.class.getResource(ModelaUI.IMG_MTTO_CERRAR));
    ImageIcon cerrarIconS = new ImageIcon(BotonesMantenimientoJPanel.class.getResource(ModelaUI.IMG_MTTO_CERRAR_SOBRE));
    private final JButton bttCerrar = (JButton)CreadorButton.crearBoton(1, false, this.cerrarIconN, this.cerrarIconN, this.cerrarIconS, this.cerrarIconS);
    DDPGrafico DDPGrNuevo = null;
    ButtonGroup grupoOpciones;
    JRadioButton opcionVarTodas;
    JRadioButton opcionVarWarning;
    JRadioButton opcionVarErrores;

    public ValidarDefProcJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void jbInit() {
        this.setModal(true);
        this.setTitle("Validar definici\u00f3n del procedimiento");
        this.setSize(750, 515);
        this.setResizable(true);
        this.tablaResultados = new JTableResultados();
        this.tablaResultados.setDefaultRenderer(this.tablaResultados.getColumnClass(0), new ResultadosTableCellRenderer());
        this.tablaResultados.setAutoscrolls(true);
        this.tablaResultados.setAutoscrolls(true);
        JPanel panelAuxSouth = new JPanel();
        panelAuxSouth.setLayout(new BorderLayout());
        panelAuxSouth.add((Component)this.bttCerrar, "East");
        this.bttCerrar.setFocusPainted(false);
        this.bttCerrar.setBorderPainted(false);
        JPanel panelAuxNorth = new JPanel();
        panelAuxNorth = new JPanel();
        panelAuxNorth.setLayout(new XYLayout());
        this.grupoOpciones = new ButtonGroup();
        this.opcionVarTodas = new JRadioButton("Todos");
        this.opcionVarWarning = new JRadioButton("Avisos");
        this.opcionVarErrores = new JRadioButton("Errores");
        this.opcionVarTodas.setSelected(true);
        this.opcionVarTodas.setFont(ModelaUI.fuenteMenu);
        this.opcionVarWarning.setFont(ModelaUI.fuenteMenu);
        this.opcionVarErrores.setFont(ModelaUI.fuenteMenu);
        this.grupoOpciones.add(this.opcionVarTodas);
        this.grupoOpciones.add(this.opcionVarWarning);
        this.grupoOpciones.add(this.opcionVarErrores);
        panelAuxNorth.add((Component)this.opcionVarTodas, new XYConstraints(5, 5, 80, 25));
        panelAuxNorth.add((Component)this.opcionVarWarning, new XYConstraints(90, 5, 80, 25));
        panelAuxNorth.add((Component)this.opcionVarErrores, new XYConstraints(175, 5, 80, 25));
        this.pPanelPrincipal = new JPanel();
        this.pPanelPrincipal.setLayout(new BorderLayout());
        this.pPanelPrincipal.setVisible(true);
        this.pPanelPrincipal.add((Component)panelAuxNorth, "North");
        this.pPanelPrincipal.add((Component)this.tablaResultados.getScroll(), "Center");
        this.pPanelPrincipal.add((Component)panelAuxSouth, "South");
        TitledBorder bordePanel = new TitledBorder("");
        bordePanel.setTitleFont(ModelaUI.fuentePrincipal);
        this.pPanelPrincipal.setBorder(bordePanel);
        this.getContentPane().add((Component)this.pPanelPrincipal, "Center");
        this.bttCerrar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ValidarDefProcJDialog.this.dispose();
            }
        });
        this.opcionVarTodas.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ValidarDefProcJDialog.this.tablaResultados.aplicarFiltro(1);
            }
        });
        this.opcionVarWarning.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ValidarDefProcJDialog.this.tablaResultados.aplicarFiltro(2);
            }
        });
        this.opcionVarErrores.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ValidarDefProcJDialog.this.tablaResultados.aplicarFiltro(3);
            }
        });
        this.addKeyAndContainerListenerRecursively(this);
        ModelaConf.setVentanaActiva(this);
    }

    public void setDiagrama(DDPGrafico DDPGr) {
        this.DDPGrNuevo = DDPGr;
    }

    public void validarProcedimiento() {
        if (this.DDPGrNuevo == null) {
            return;
        }
        ValidadorDefProcedimiento validadorDefProc = null;
        this.tablaResultados.removeAllRows();
        this.tablaResultados.updateUI();
        validadorDefProc = new ValidadorDefProcedimiento();
        validadorDefProc.addInfoResultadoListener(new InfoResultadoListener(){

            public void obtenerResultado(InfoResultadoEvent evt) {
                ValidarDefProcJDialog.this.nuevoResultado(evt);
            }
        });
        if (this.DDPGrNuevo.getDDPPadre() == null) {
            validadorDefProc.validarDefProdedimiento(this.DDPGrNuevo);
        } else {
            validadorDefProc.validarDefProdedimiento(this.DDPGrNuevo.getDDPPadre());
        }
        this.tablaResultados.updateUI();
    }

    public void nuevoResultado(InfoResultadoEvent evt) {
        if (evt == null) {
            return;
        }
        InfoResultado info = evt.getResultado();
        if (info == null) {
            return;
        }
        this.tablaResultados.addFila(info);
    }

    private void addKeyAndContainerListenerRecursively(Component c) {
        c.removeKeyListener(this);
        c.addKeyListener(this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            cont.addContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.addKeyAndContainerListenerRecursively(children[i]);
            }
        }
    }

    private void removeKeyAndContainerListenerRecursively(Component c) {
        c.removeKeyListener(this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.removeKeyAndContainerListenerRecursively(children[i]);
            }
        }
    }

    public void componentAdded(ContainerEvent e) {
        this.addKeyAndContainerListenerRecursively(e.getChild());
    }

    public void componentRemoved(ContainerEvent e) {
        this.removeKeyAndContainerListenerRecursively(e.getChild());
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 27) {
            this.dispose();
        } else if (code == 10) {
            this.performEnterAction(e);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    void performEnterAction(KeyEvent e) {
    }
}

