/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing.excontrols;

import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.excontrols.CreadorButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import modela.ui.ModelaUI;
import modela.ui.swing.PropGraficoJPanel;

public class JFontChooser
extends JDialog
implements ListSelectionListener,
ContainerListener,
KeyListener {
    private static final long serialVersionUID = 7959686071901927312L;
    private Font fuenteActual = null;
    private ArrayList arrFuentes = new ArrayList();
    private XYLayout xYLayout = new XYLayout();
    private JList listaFuentesDisponibles = new JList();
    private JList listaEstilosDisponibles = new JList();
    private JList listaTamaniosDisponibles = new JList();
    private JLabel labelMuestra;
    ImageIcon aceptarIconN = new ImageIcon(PropGraficoJPanel.class.getResource(ModelaUI.IMG_ACEPTAR_SIMPLE));
    ImageIcon aceptarIconS = new ImageIcon(PropGraficoJPanel.class.getResource(ModelaUI.IMG_ACEPTAR_SIMPLE_SOBRE));
    ImageIcon cancelarIconN = new ImageIcon(PropGraficoJPanel.class.getResource(ModelaUI.IMG_MTTO_CANCELAR));
    ImageIcon cancelarIconS = new ImageIcon(PropGraficoJPanel.class.getResource(ModelaUI.IMG_MTTO_CANCELAR_SOBRE));
    private JButton buttonAceptar = (JButton)CreadorButton.crearBoton(1, false, this.aceptarIconN, this.aceptarIconN, this.aceptarIconS, this.aceptarIconS);
    private JButton buttonCancelar = (JButton)CreadorButton.crearBoton(1, false, this.cancelarIconN, this.cancelarIconN, this.cancelarIconS, this.cancelarIconS);
    private int returnValue = 2;
    public static final int ACCEPT_OPTION = 1;
    public static final int CANCEL_OPTION = 2;

    public JFontChooser(Font fuente) {
        this.fuenteActual = fuente;
        this.jbInit();
    }

    private void jbInit() {
        this.setTitle("Selecci\u00f3n de fuente");
        this.setSize(430, 360);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.getContentPane().setLayout(this.xYLayout);
        this.setResizable(false);
        this.setEnabled(true);
        this.setModal(true);
        Font[] arrTodasLasFuentes = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        ArrayList<String> arrNombreFuentes = new ArrayList<String>();
        for (int i = 0; i < arrTodasLasFuentes.length; ++i) {
            String strNombreFuente = arrTodasLasFuentes[i].getFamily();
            if (arrNombreFuentes.contains(strNombreFuente)) continue;
            arrNombreFuentes.add(strNombreFuente);
            this.arrFuentes.add(arrTodasLasFuentes[i]);
        }
        this.listaFuentesDisponibles.setListData(arrNombreFuentes.toArray());
        this.listaFuentesDisponibles.addListSelectionListener(this);
        Object[] arrEstilosAux = new Object[]{"Normal", "Negrita", "Cursiva", "NegritaCursiva"};
        this.listaEstilosDisponibles.setListData(arrEstilosAux);
        this.listaEstilosDisponibles.addListSelectionListener(this);
        String[] arrTamaniosAux = new String[30];
        for (int i = 3; i < 33; ++i) {
            arrTamaniosAux[i - 3] = new Integer(i + 1).toString();
        }
        this.listaTamaniosDisponibles.setListData(arrTamaniosAux);
        this.listaTamaniosDisponibles.addListSelectionListener(this);
        this.labelMuestra = new JLabel(" Texto de muestra previa");
        this.labelMuestra.setBorder(BorderFactory.createEtchedBorder());
        this.buttonAceptar.setBorderPainted(false);
        this.buttonAceptar.setFocusPainted(false);
        this.buttonCancelar.setBorderPainted(false);
        this.buttonCancelar.setFocusPainted(false);
        this.addListeners();
        this.getContentPane().add((Component)new JScrollPane(this.listaFuentesDisponibles), new XYConstraints(10, 10, 240, 180));
        this.getContentPane().add((Component)new JScrollPane(this.listaEstilosDisponibles), new XYConstraints(260, 10, 100, 180));
        this.getContentPane().add((Component)new JScrollPane(this.listaTamaniosDisponibles), new XYConstraints(370, 10, 50, 180));
        this.getContentPane().add((Component)this.labelMuestra, new XYConstraints(10, 200, 410, 70));
        this.getContentPane().add((Component)this.buttonAceptar, new XYConstraints(252, 280, 80, 50));
        this.getContentPane().add((Component)this.buttonCancelar, new XYConstraints(340, 280, 80, 50));
        this.actualizarSeleccionListas();
    }

    private void addListeners() {
        this.buttonAceptar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFontChooser.this.buttonAceptar_actionPerformed();
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFontChooser.this.buttonCancelar_actionPerformed();
            }
        });
        this.addKeyAndContainerListenerRecursively(this);
    }

    private void actualizarSeleccionListas() {
        if (this.fuenteActual == null) {
            this.listaFuentesDisponibles.setSelectedIndex(-1);
            this.listaEstilosDisponibles.setSelectedIndex(-1);
            this.listaTamaniosDisponibles.setSelectedIndex(-1);
            return;
        }
        this.listaFuentesDisponibles.setSelectedValue(this.fuenteActual.getFamily(), true);
        if (this.fuenteActual.getStyle() == 0) {
            this.listaEstilosDisponibles.setSelectedValue("Normal", true);
        } else if (this.fuenteActual.getStyle() == 2) {
            this.listaEstilosDisponibles.setSelectedValue("Cursiva", true);
        } else if (this.fuenteActual.getStyle() == 1) {
            this.listaEstilosDisponibles.setSelectedValue("Negrita", true);
        } else if (this.fuenteActual.getStyle() == 3) {
            this.listaEstilosDisponibles.setSelectedValue("NegritaCursiva", true);
        }
        this.listaTamaniosDisponibles.setSelectedValue(new Integer(this.fuenteActual.getSize()).toString(), true);
        this.listaFuentesDisponibles.ensureIndexIsVisible(this.listaFuentesDisponibles.getSelectedIndex());
        this.listaEstilosDisponibles.ensureIndexIsVisible(this.listaEstilosDisponibles.getSelectedIndex());
        this.listaTamaniosDisponibles.ensureIndexIsVisible(this.listaTamaniosDisponibles.getSelectedIndex());
        this.updateFont(this.fuenteActual);
    }

    private void updateFont(Font f) {
        this.fuenteActual = f;
        this.labelMuestra.setFont(this.fuenteActual);
    }

    private void updateFontSize(int size) {
        this.updateFont(this.fuenteActual.deriveFont(new Integer(size).floatValue()));
    }

    private void updateFontStyle(int style) {
        this.updateFont(this.fuenteActual.deriveFont(style));
    }

    public Font getSelectedFont() {
        return this.fuenteActual;
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.listaFuentesDisponibles) {
            Font f = (Font)this.arrFuentes.get(this.listaFuentesDisponibles.getSelectedIndex());
            f = new Font(f.getFontName(), this.fuenteActual.getStyle(), this.fuenteActual.getSize());
            this.updateFont(f);
        }
        if (e.getSource() == this.listaTamaniosDisponibles) {
            this.updateFontSize(new Integer((String)this.listaTamaniosDisponibles.getSelectedValue()));
        }
        if (e.getSource() == this.listaEstilosDisponibles) {
            int style = 0;
            String selection = (String)this.listaEstilosDisponibles.getSelectedValue();
            if (selection.equals("Normal")) {
                style = 0;
            }
            if (selection.equals("Negrita")) {
                style = 1;
            }
            if (selection.equals("Cursiva")) {
                style = 2;
            }
            if (selection.equals("NegritaCursiva")) {
                style = 3;
            }
            this.updateFontStyle(style);
        }
    }

    public void buttonAceptar_actionPerformed() {
        this.returnValue = 1;
        this.dispose();
    }

    public void buttonCancelar_actionPerformed() {
        this.returnValue = 2;
        this.dispose();
    }

    public int getOpcion() {
        return this.returnValue;
    }

    private void addKeyAndContainerListenerRecursively(Component c) {
        c.removeKeyListener(this);
        c.addKeyListener(this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            cont.addContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.addKeyAndContainerListenerRecursively(children[i]);
            }
        }
    }

    private void removeKeyAndContainerListenerRecursively(Component c) {
        c.removeKeyListener(this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.removeKeyAndContainerListenerRecursively(children[i]);
            }
        }
    }

    public void componentAdded(ContainerEvent e) {
        this.addKeyAndContainerListenerRecursively(e.getChild());
    }

    public void componentRemoved(ContainerEvent e) {
        this.removeKeyAndContainerListenerRecursively(e.getChild());
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 27) {
            this.buttonCancelar_actionPerformed();
        } else if (code == 10) {
            this.performEnterAction(e);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    void performEnterAction(KeyEvent e) {
    }
}

