/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing.graficas;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import modela.bd.obj.TrMetafase;
import modela.conf.ModelaConf;
import modela.ui.swing.graficas.JPanelGrafica;
import org.jfree.chart.ChartPanel;

public class JPanelGraficaFasesXMetafase
extends JPanelGrafica {
    private static final long serialVersionUID = 6177745172213231667L;

    public JPanelGraficaFasesXMetafase() {
        this.jbInit();
    }

    private void jbInit() {
        this.setTituloPanel("Fases X Metafase");
        this.comboTipo.addItem("Barras");
        this.comboTipo.addItem("Barras 3D");
        this.comboTipo.addItem("Tarta");
        this.comboTipo.addItem("Tarta 3D");
        this.add((Component)this.panelOpcionesGraficas, "South");
        this.setNElementosVista(ModelaConf.getItemsPorPagina());
    }

    public boolean loadGrafica(int nTipoGraf, boolean bLimitarAmbito) {
        this.setTipoGrafica(nTipoGraf);
        if (this.diagramaAsociado == null || this.diagramaAsociado.getDDP() == null) {
            return false;
        }
        try {
            String tituloGrafica;
            ArrayList arrMetafases;
            if (!bLimitarAmbito) {
                arrMetafases = this.diagramaAsociado.getMetafasesInvolucradas().getListaDatos();
                tituloGrafica = "Todo el procedimiento (Reutilizables inclusive)";
            } else {
                arrMetafases = this.diagramaAsociado.getMetafasesInvolucradasGr().getListaDatos();
                tituloGrafica = this.diagramaAsociado.getDDP().getTITULO();
                if (tituloGrafica == null) {
                    tituloGrafica = this.diagramaAsociado.getDDP().getNOMBRE();
                }
            }
            Collections.sort(arrMetafases);
            for (int n = 0; arrMetafases != null && n < arrMetafases.size(); ++n) {
                TrMetafase metaAux = (TrMetafase)arrMetafases.get(n);
                ArrayList arrFasesAux = !bLimitarAmbito ? this.diagramaAsociado.obtenerFasesDeMetafase(metaAux) : this.diagramaAsociado.obtenerFasesDeMetafaseEnEsteDDP(metaAux);
                if (arrFasesAux == null) {
                    arrFasesAux = new ArrayList();
                }
                this.addValor(metaAux.getNombre(), new Double(arrFasesAux.size()));
            }
            super.createChart(tituloGrafica);
            if (this.getComponentCount() > 1 && this.getComponent(1) instanceof ChartPanel) {
                this.remove(1);
            }
            this.add((Component)super.createPanel(), "Center");
            this.validate();
            this.repaint();
            return true;
        }
        catch (Exception e) {
            System.out.println("\u00b7 [ Error ] No se pudo cargar la gr\u00e1fica de Fases X Metafase");
            e.printStackTrace();
            return false;
        }
    }
}

