/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing.graficas;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import modela.bd.obj.TrTarea;
import modela.bd.obj.TrTareaEnFaseDefProcedimiento;
import modela.bd.obj.TrTipoTarea;
import modela.ui.swing.graficas.JPanelGrafica;
import org.jfree.chart.ChartPanel;

public class JPanelGraficaTiposTarea
extends JPanelGrafica {
    private static final long serialVersionUID = 8485888416330085132L;

    public JPanelGraficaTiposTarea() {
        this.jbInit();
    }

    private void jbInit() {
        this.setTituloPanel("Tipos de Tarea:");
        this.comboTipo.addItem("Barras");
        this.comboTipo.addItem("Barras 3D");
        this.comboTipo.addItem("Tarta");
        this.comboTipo.addItem("Tarta 3D");
        this.add((Component)this.panelOpcionesGraficas, "South");
        this.setNElementosVista(0);
        this.panelOpcionesGraficasAux2.setVisible(false);
    }

    public boolean loadGrafica(int nTipoGraf, boolean bLimitarAmbito) {
        this.setTipoGrafica(nTipoGraf);
        if (this.diagramaAsociado == null || this.diagramaAsociado.getDDP() == null) {
            return false;
        }
        try {
            String tituloGrafica;
            ArrayList arrTareas = new ArrayList();
            if (!bLimitarAmbito) {
                arrTareas = this.diagramaAsociado.getTareasInvolucradas().getListaDatos();
                tituloGrafica = "Todo el procedimiento (Reutilizables inclusive)";
            } else {
                ArrayList arrAux = this.diagramaAsociado.getTareaFaseDefProcInvolucradas().getListaDatos();
                for (int n = 0; arrAux != null && n < arrAux.size(); ++n) {
                    TrTareaEnFaseDefProcedimiento trTareaAux = (TrTareaEnFaseDefProcedimiento)arrAux.get(n);
                    if (trTareaAux.getTareaEnFase() == null || trTareaAux.getTareaEnFase().getTarea() == null) continue;
                    arrTareas.add(trTareaAux.getTareaEnFase().getTarea());
                }
                tituloGrafica = this.diagramaAsociado.getDDP().getTITULO();
                if (tituloGrafica == null) {
                    tituloGrafica = this.diagramaAsociado.getDDP().getNOMBRE();
                }
            }
            Collections.sort(arrTareas);
            int nBloques = 0;
            int nIncorporarDoc = 0;
            int nGenerarDoc = 0;
            int nOtras = 0;
            for (int n = 0; arrTareas != null && n < arrTareas.size(); ++n) {
                TrTarea tareaAux = (TrTarea)arrTareas.get(n);
                if (tareaAux.getTrTipoTarea().equals(TrTipoTarea.MANIPULAR_DATOS)) {
                    ++nBloques;
                    continue;
                }
                if (tareaAux.getTrTipoTarea().equals(TrTipoTarea.INCORPORAR_DOCUMENTO)) {
                    ++nIncorporarDoc;
                    continue;
                }
                if (tareaAux.getTrTipoTarea().equals(TrTipoTarea.GENERAR_DOCUMENTO)) {
                    ++nGenerarDoc;
                    continue;
                }
                ++nOtras;
            }
            super.addValor("Incorporar Documentos", new Double(nIncorporarDoc));
            super.addValor("Generar Documentos", new Double(nGenerarDoc));
            super.addValor("Bloques", new Double(nBloques));
            super.addValor("Otras", new Double(nOtras));
            super.createChart(tituloGrafica);
            if (this.getComponentCount() > 1 && this.getComponent(1) instanceof ChartPanel) {
                this.remove(1);
            }
            this.add((Component)super.createPanel(), "Center");
            this.validate();
            this.repaint();
            return true;
        }
        catch (Exception e) {
            System.out.println("\u00b7 [ Error ] No se pudo cargar la gr\u00e1fica de Tipos de Tarea");
            e.printStackTrace();
            return false;
        }
    }
}

