/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing.renderers;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import modela.bd.obj.TrFase;
import modela.bd.obj.TrMetafase;
import modela.bd.obj.TrTransicion;
import modela.ui.ModelaUI;
import modela.ui.piccolo.nodes.PNodoGrafico;

public class LocalizadorTreeRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -2369297055516438157L;
    ImageIcon metafaseAbierta = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_METAFASE_OPEN));
    ImageIcon metafaseCerrada = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_METAFASE_CLOSED));
    ImageIcon faseAbierta = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_FASE_OPEN));
    ImageIcon faseCerrada = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_FASE_CLOSED));
    ImageIcon grafico = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_GR_FASE));
    ImageIcon transicionAbierta = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TRANSICION_OPEN));
    ImageIcon transicionCerrada = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TRANSICION_CLOSED));
    ImageIcon eventoAbierto = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_EVENTO_OPEN));
    ImageIcon eventoCerrado = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_EVENTO_CLOSED));
    ImageIcon graficoTransi = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_NORMAL));
    ImageIcon graficoTransiIni = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_INICIO));
    ImageIcon graficoTransiFin = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_FIN));
    ImageIcon graficoTransiDiv = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_DIVISION));
    ImageIcon graficoTransiUni = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_UNION));
    ImageIcon graficoTransiEs = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_ES));
    ImageIcon graficoTransiEn = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_EN));

    public Component getTreeCellRendererComponent(JTree arbol, Object valor, boolean seleccionado, boolean expandido, boolean rama, int fila, boolean conFoco) {
        JLabel label = (JLabel)super.getTreeCellRendererComponent(arbol, valor, seleccionado, expandido, rama, fila, conFoco);
        DefaultMutableTreeNode nodo = (DefaultMutableTreeNode)valor;
        Object clase = nodo.getUserObject();
        if (clase instanceof TrMetafase) {
            if (!expandido) {
                label.setIcon(this.metafaseCerrada);
            } else {
                label.setIcon(this.metafaseAbierta);
            }
        } else if (clase instanceof TrFase) {
            if (!expandido) {
                label.setIcon(this.faseCerrada);
            } else {
                label.setIcon(this.faseAbierta);
            }
        } else if (clase instanceof PNodoGrafico) {
            label.setIcon(this.grafico);
        } else if (clase instanceof TrTransicion) {
            label.setText(((TrTransicion)clase).getETIQUETA() + " - " + ((TrTransicion)clase).getDESCRIPCION());
            if (((TrTransicion)clase).getTIPO().equals("N")) {
                label.setIcon(this.graficoTransi);
            } else if (((TrTransicion)clase).getTIPO().equals("I")) {
                label.setIcon(this.graficoTransiIni);
            } else if (((TrTransicion)clase).getTIPO().equals("F")) {
                label.setIcon(this.graficoTransiFin);
            } else if (((TrTransicion)clase).getTIPO().equals("D")) {
                label.setIcon(this.graficoTransiDiv);
            } else if (((TrTransicion)clase).getTIPO().equals("U")) {
                label.setIcon(this.graficoTransiUni);
            } else if (((TrTransicion)clase).getTIPO().equals("EN")) {
                label.setIcon(this.graficoTransiEn);
            } else if (((TrTransicion)clase).getTIPO().equals("ES")) {
                label.setIcon(this.graficoTransiEs);
            }
        } else if (clase.equals("Eventos")) {
            if (!expandido) {
                label.setIcon(this.eventoCerrado);
            } else {
                label.setIcon(this.eventoAbierto);
            }
        } else if (clase.equals("Transiciones")) {
            if (!expandido) {
                label.setIcon(this.transicionCerrada);
            } else {
                label.setIcon(this.transicionAbierta);
            }
        }
        return label;
    }
}

