/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing.renderers;

import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import modela.bd.obj.TrTransicion;
import modela.ui.ModelaUI;

public class TransicionesListCellRenderer
extends JLabel
implements ListCellRenderer {
    private static final long serialVersionUID = 8051640100906743555L;
    ImageIcon DIVISION;
    ImageIcon EVENTO_EN;
    ImageIcon EVENTO_ES;
    ImageIcon FIN_PROCEDIMIENTO;
    ImageIcon INICIO_PROCEDIMIENTO;
    ImageIcon NORMAL;
    ImageIcon UNION;
    private Color colorDeFondo;
    private Color colorDeLetra;

    public TransicionesListCellRenderer() {
        this.setOpaque(true);
        this.NORMAL = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_NORMAL));
        this.INICIO_PROCEDIMIENTO = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_INICIO));
        this.FIN_PROCEDIMIENTO = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_FIN));
        this.EVENTO_EN = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_EN));
        this.EVENTO_ES = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_ES));
        this.DIVISION = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_DIVISION));
        this.UNION = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_UNION));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        TrTransicion transicion = null;
        if (value == null) {
            return null;
        }
        transicion = (TrTransicion)value;
        if (transicion.getTIPO().equals("D")) {
            this.setIcon(this.DIVISION);
        } else if (transicion.getTIPO().equals("EN")) {
            this.setIcon(this.EVENTO_EN);
        } else if (transicion.getTIPO().equals("ES")) {
            this.setIcon(this.EVENTO_ES);
        } else if (transicion.getTIPO().equals("F")) {
            this.setIcon(this.FIN_PROCEDIMIENTO);
        } else if (transicion.getTIPO().equals("I")) {
            this.setIcon(this.INICIO_PROCEDIMIENTO);
        } else if (transicion.getTIPO().equals("N")) {
            this.setIcon(this.NORMAL);
        } else if (transicion.getTIPO().equals("U")) {
            this.setIcon(this.UNION);
        }
        this.setText(transicion.toString());
        if (isSelected) {
            this.colorDeFondo = list.getSelectionBackground();
            this.colorDeLetra = list.getSelectionForeground();
        } else {
            this.colorDeFondo = list.getBackground();
            this.colorDeLetra = list.getForeground();
        }
        if (!transicion.isValida()) {
            this.colorDeLetra = ModelaUI.colorElementoInvalido;
        }
        this.setBackground(this.colorDeFondo);
        this.setForeground(this.colorDeLetra);
        return this;
    }
}

