/*
 * Decompiled with CFR 0.152.
 */
package modela.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;

public class TrOpenDocumentService {
    private final String FILE_CONTENT_XML = "content.xml";
    private final String MARK_VARIABLES_DEFAULT = "$$";

    public void copyDataStream(InputStream input, OutputStream output) throws IOException {
        int count;
        int BUFFER = 2048;
        byte[] data = new byte[2048];
        while ((count = input.read(data, 0, 2048)) != -1) {
            output.write(data, 0, count);
        }
    }

    public List getVariables(InputStream openDocument) throws Exception {
        return this.getVariables(openDocument, this.MARK_VARIABLES_DEFAULT);
    }

    public List getVariables(InputStream openDocument, String markVariables) throws Exception {
        ZipEntry entry;
        ZipInputStream zipFile = new ZipInputStream(openDocument);
        LinkedList vars = new LinkedList();
        while ((entry = zipFile.getNextEntry()) != null) {
            if (!entry.getName().equals(this.FILE_CONTENT_XML)) continue;
            ByteArrayOutputStream baOut = new ByteArrayOutputStream();
            this.copyDataStream(zipFile, baOut);
            SAXBuilder sax = new SAXBuilder();
            Document doc = sax.build((InputStream)new ByteArrayInputStream(baOut.toByteArray()));
            Element rootElement = doc.getRootElement();
            this.processElementGetVariables(rootElement, vars, markVariables);
            break;
        }
        return vars;
    }

    private void processElementGetVariables(Object o, List vars, String markVariables) {
        block7: {
            if (!(o instanceof Element)) break block7;
            Element e = (Element)o;
            String elementName = e.getQualifiedName();
            if (elementName.startsWith("text")) {
                List children = e.getContent();
                Iterator iterator = children.iterator();
                while (iterator.hasNext()) {
                    Object child = iterator.next();
                    if (child instanceof Text) {
                        Text t = (Text)child;
                        String text = t.getValue();
                        int nIni = text.indexOf(markVariables);
                        int nFin = 0;
                        while (nIni >= 0) {
                            nFin = text.indexOf(markVariables, nIni + 2);
                            if (nFin != -1) {
                                String var = text.substring(nIni + 2, nFin);
                                nIni = text.indexOf(markVariables, nFin + 2);
                                vars.add(var);
                                continue;
                            }
                            nIni = -1;
                        }
                        continue;
                    }
                    this.processElementGetVariables(child, vars, markVariables);
                }
            } else {
                List non_text_list = e.getContent();
                Iterator it = non_text_list.iterator();
                while (it.hasNext()) {
                    Object non_text_child = it.next();
                    this.processElementGetVariables(non_text_child, vars, markVariables);
                }
            }
        }
    }
}

