/*
 * Decompiled with CFR 0.152.
 */
package gdtel.ui.swing.excontrols;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.excontrols.JListEx;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import modela.ui.Portapapeles;
import modela.ui.swing.filtros.AbstractListModelFilter;

public class JListAsignable
extends JListEx
implements MouseMotionListener {
    private static final long serialVersionUID = -6075708301926552843L;
    private final DefaultListModel model = new DefaultListModel();
    private AbstractListModelFilter modelFiltro = null;
    public JPopupMenu popup = null;
    private JMenuItem menuCopiar = null;
    private JMenuItem menuPegar = null;
    private int TIPO_ALMACENADO = 0;
    private boolean bListaPrincipal = true;

    public JListAsignable() {
        this.setModel(this.model);
        try {
            this.addMouseMotionListener(this);
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFiltro(AbstractListModelFilter model) {
        try {
            super.setModel(model);
            this.modelFiltro = model;
        }
        catch (Exception e) {
            this.modelFiltro = null;
        }
    }

    public void quitarFiltro() {
        this.modelFiltro = null;
        super.setModel(this.model);
    }

    public Vector toVector() {
        Vector v = new Vector();
        for (int i = 0; i < this.model.getSize(); ++i) {
            v.addElement(this.model.getElementAt(i));
        }
        return v;
    }

    public ArrayList toArrayList() {
        ArrayList arr = new ArrayList();
        for (int i = 0; i < this.model.getSize(); ++i) {
            arr.add(this.model.getElementAt(i));
        }
        return arr;
    }

    public ArrayList toArrayListFiltro() {
        ArrayList<Object> arr = new ArrayList<Object>();
        for (int i = 0; i < this.modelFiltro.getSize(); ++i) {
            arr.add(this.modelFiltro.getElementAt(i));
        }
        return arr;
    }

    public boolean addItem(IAsignable datoAsignable) {
        if (datoAsignable == null) {
            return false;
        }
        this.model.addElement(datoAsignable);
        return true;
    }

    public boolean removeItem(int index) {
        if (this.modelFiltro == null) {
            if (index < 0 || index >= this.model.size()) {
                return false;
            }
            this.model.removeElementAt(index);
            return true;
        }
        if (index < 0 || index >= this.modelFiltro.getSize()) {
            return false;
        }
        int nElemento = this.modelFiltro.removeElementAt(index);
        this.model.removeElementAt(nElemento);
        return true;
    }

    public boolean removeItem(IAsignable datoAsignable) {
        if (datoAsignable == null || this.model.contains(datoAsignable)) {
            return false;
        }
        this.model.removeElement(datoAsignable);
        return true;
    }

    public void removeAllItems() {
        if (this.getModel().getSize() > 0) {
            this.model.removeAllElements();
        }
    }

    public boolean addConjuntoDatos(ConjuntoDatos c) {
        if (c == null) {
            return false;
        }
        for (int j = 0; j < c.getListaDatos().size(); ++j) {
            this.model.addElement(c.getListaDatos().get(j));
        }
        return true;
    }

    public boolean hasAnyObject() {
        if (this.modelFiltro == null) {
            return !this.model.isEmpty();
        }
        return this.modelFiltro.isEmpty();
    }

    public IAsignable getElementAt(int i) {
        IAsignable elem = null;
        elem = this.modelFiltro == null ? (IAsignable)this.model.elementAt(i) : (IAsignable)this.modelFiltro.getElementAt(i);
        return elem;
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(128, 155));
        this.bListaPrincipal = true;
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                JListAsignable.this.ensureIndexIsVisible(JListAsignable.this.getSelectedIndex());
            }

            public void keyTyped(KeyEvent e) {
            }
        });
    }

    public int getNumItems() {
        if (this.modelFiltro == null) {
            return this.model.size();
        }
        return this.modelFiltro.getSize();
    }

    public void mouseMoved(MouseEvent evt) {
        this.lista_MouseMoved(evt);
    }

    public void mouseDragged(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void lista_MouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        int index = this.locationToIndex(p);
        if (index >= 0 && index <= this.getModel().getSize()) {
            String toolTip = this.getElementAt(index).getDescripcion();
            this.setToolTipText(toolTip);
        }
    }

    public JScrollPane getScrollableArea() {
        JScrollPane scroll = new JScrollPane(this);
        return scroll;
    }

    public boolean crearPopupMenu() {
        this.eliminarPopupMenu();
        this.popup = new JPopupMenu();
        if (this.popup == null) {
            return false;
        }
        this.menuCopiar = new JMenuItem("Copiar");
        if (this.menuCopiar == null) {
            return false;
        }
        this.menuPegar = new JMenuItem("Pegar");
        if (this.menuPegar == null) {
            return false;
        }
        this.menuCopiar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JListAsignable.this.copiarAlPortapapeles();
            }
        });
        if (this.popup.add(this.menuCopiar) == null) {
            return false;
        }
        this.menuPegar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JListAsignable.this.pegarDesdeElPortapapeles();
            }
        });
        if (this.popup.add(this.menuPegar) == null) {
            return false;
        }
        if (this.getSelectedValues() == null || this.getSelectedValues().length <= 0) {
            this.menuCopiar.setEnabled(false);
        }
        if (Portapapeles.getListaEnPortapapeles().size() > 0) {
            if (Portapapeles.getTipoAlmacenado() != this.getTipoAlmacenado()) {
                this.menuPegar.setEnabled(false);
            }
        } else {
            this.menuPegar.setEnabled(false);
        }
        return true;
    }

    public void eliminarPopupMenu() {
        ActionListener[] actionListener = null;
        int nActions = 0;
        int i = 0;
        this.popup = null;
        if (this.menuCopiar != null) {
            actionListener = this.menuCopiar.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuCopiar.removeActionListener(actionListener[i]);
            }
            this.menuCopiar = null;
        }
        if (this.menuPegar != null) {
            actionListener = this.menuPegar.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuPegar.removeActionListener(actionListener[i]);
            }
            this.menuPegar = null;
        }
    }

    public void copiarAlPortapapeles() {
        if (this.getSelectedValues() == null || this.getSelectedValues().length <= 0) {
            return;
        }
        Portapapeles.setListaEnPortapapeles(this.getSelectedValues());
    }

    public void pegarDesdeElPortapapeles() {
        Portapapeles.pegarEn(this);
    }

    public void setTipoAlmacenado(int nTipoElementoCopyPaste) {
        this.TIPO_ALMACENADO = nTipoElementoCopyPaste;
    }

    public int getTipoAlmacenado() {
        return this.TIPO_ALMACENADO;
    }

    public AbstractListModelFilter getModelFiltro() {
        return this.modelFiltro;
    }

    public boolean isListaPrincipal() {
        return this.bListaPrincipal;
    }

    public void setListaPrincipal(boolean bValor) {
        this.bListaPrincipal = bValor;
    }
}

