/*
 * Decompiled with CFR 0.152.
 */
package gdtel.ui.swing.excontrols;

import gdtel.ui.swing.excontrols.PlainDocumentEx;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import modela.ui.ModelaUI;

public class JTextAreaEx
extends JTextArea
implements KeyListener {
    private static final long serialVersionUID = -6830744782883849851L;
    private JScrollPane scrollableArea;
    private int nNumItems = -1;
    public static final int LOWER = 0;
    public static final int UPPER = 1;
    public static final int NORMAL = 2;
    protected boolean bCambiarColorAlModificar = true;
    protected boolean bControlPulsado = false;
    protected boolean bTabulando = false;
    protected boolean bTeclaVDePegado = false;
    protected boolean bTeclaXDeCortado = false;

    public JTextAreaEx(int filas, int columnas) {
        super(filas, columnas);
        this.jbInit();
    }

    public JTextAreaEx() {
        this.jbInit();
    }

    private void jbInit() {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.scrollableArea = new JScrollPane(this);
        this.scrollableArea.setVerticalScrollBarPolicy(20);
        this.bCambiarColorAlModificar = true;
        this.bControlPulsado = false;
        this.bTabulando = false;
        this.bTeclaVDePegado = false;
        this.bTeclaXDeCortado = false;
        this.disablePaste_Shift_Insert();
    }

    public JScrollPane getScrollableArea() {
        return this.scrollableArea;
    }

    public void setNumItems(int nNum) {
        this.nNumItems = nNum;
        if (this.nNumItems < 1) {
            this.removeKeyListener(this);
        } else {
            this.addKeyListener(this);
        }
    }

    public int getNumItems() {
        return this.nNumItems;
    }

    private void controlarNumItems(KeyEvent anEvent) {
        if (this.nNumItems < 1) {
            return;
        }
        if (anEvent.getKeyChar() == '\b') {
            return;
        }
        String strSel = this.getSelectedText();
        if (strSel != null) {
            return;
        }
        int nItemsActuales = this.getText().length();
        if (nItemsActuales >= this.getNumItems()) {
            anEvent.consume();
        }
        if (this.getText() != null && this.getText().length() > this.nNumItems) {
            this.setText(this.getText().substring(0, this.nNumItems));
        }
    }

    public void disableCopyNormal() {
        KeyStroke copy = KeyStroke.getKeyStroke(67, 2);
        String actionKey = "none";
        InputMap map = super.getInputMap();
        map.put(copy, actionKey);
    }

    public void disablePasteNormal() {
        KeyStroke paste = KeyStroke.getKeyStroke(86, 2);
        String actionKey = "none";
        InputMap map = super.getInputMap();
        map.put(paste, actionKey);
    }

    public void disablePaste_Shift_Insert() {
        KeyStroke paste = KeyStroke.getKeyStroke(155, 1);
        String actionKey = "none";
        InputMap map = super.getInputMap();
        map.put(paste, actionKey);
    }

    public void keyPressed(KeyEvent anEvent) {
        if (anEvent.getKeyCode() == 17) {
            this.bControlPulsado = true;
        }
        if (anEvent.getKeyCode() == 9) {
            this.bTabulando = true;
        }
        if (anEvent.getKeyCode() == 86) {
            this.bTeclaVDePegado = true;
        }
        if (anEvent.getKeyCode() == 88) {
            this.bTeclaXDeCortado = true;
        }
    }

    public void keyTyped(KeyEvent anEvent) {
        this.controlarNumItems(anEvent);
        if (this.bCambiarColorAlModificar && this.isEditable() && !this.bTabulando && (!this.bControlPulsado || this.bControlPulsado && this.bTeclaVDePegado || this.bControlPulsado && this.bTeclaXDeCortado)) {
            this.setBackground(ModelaUI.colorFondoTextoModificandose);
        }
        if (this.bTabulando) {
            this.bTabulando = false;
        }
    }

    public void keyReleased(KeyEvent anEvent) {
        if (anEvent.getKeyCode() == 17) {
            this.bControlPulsado = false;
        }
        if (anEvent.getKeyCode() == 9) {
            this.bTabulando = false;
        }
        if (anEvent.getKeyCode() == 86) {
            this.bTeclaVDePegado = false;
        }
        if (anEvent.getKeyCode() == 88) {
            this.bTeclaXDeCortado = false;
        }
    }

    public void establecerTipografia(int nTipo) {
        switch (nTipo) {
            case 0: {
                PlainDocumentEx lowerFilter = new PlainDocumentEx(" abcdefghijklmn\u00f1opqrstuvwxyz1234567890\u00e1\u00e9\u00ed\u00f3\u00fa!\u00a1\"$%&/()=?\u00bf'|@#~><{}[]*/+-.:,;._\\\u00aa\u00ba\n\u00e0\u00e7\u00e8\u00ec\u00ef\u00f2\u00f9\u00fc\u00b7");
                this.setDocument(lowerFilter);
                break;
            }
            case 1: {
                PlainDocumentEx upperFilter = new PlainDocumentEx(" ABCDEFGHIJKLMN\u00d1OPQRSTUVWXYZ1234567890\u00c1\u00c9\u00cd\u00d3\u00da\u00a1!\"$%&/()=?\u00bf'|@#~><{}[]*/-+.:,;._\\\u00aa\u00ba\n\u00c0\u00c8\u00c7\u00cc\u00cf\u00d2\u00d9\u00dc\u00b7");
                this.setDocument(upperFilter);
                break;
            }
            case 2: {
                PlainDocumentEx normalFilter = new PlainDocumentEx(" abcdefghijklmn\u00f1opqrstuvwxyz1234567890\u00e1\u00e9\u00ed\u00f3\u00fa!\u00a1\"$%&/()=?\u00bf'|@#~><{}[]*/+-.:,;._\\\u00aa\u00ba\n\u00e0\u00e7\u00e8\u00ec\u00ef\u00f2\u00f9\u00fc\u00b7 ABCDEFGHIJKLMN\u00d1OPQRSTUVWXYZ1234567890\u00c1\u00c9\u00cd\u00d3\u00da\u00a1!\"$%&/()=?\u00bf'|@#~><{}[]*/-+.:,;._\\\u00aa\u00ba\n\u00c0\u00c8\u00c7\u00cc\u00cf\u00d2\u00d9\u00dc\u00b70123456789");
                normalFilter.setNegativeAccepted(true);
            }
        }
    }

    public void setEditable(boolean enabled) {
        super.setEditable(enabled);
        if (this.isEditable()) {
            this.setBackground(ModelaUI.colorFondoTextoHabilitado);
        } else {
            this.setBackground(ModelaUI.colorFondoTextoDeshabilitado);
        }
    }

    public void setCambiarColorAlModificar(boolean pValor) {
        this.bCambiarColorAlModificar = pValor;
    }

    public boolean getCambiarColorAlModificar() {
        return this.bCambiarColorAlModificar;
    }
}

