/*
 * Decompiled with CFR 0.152.
 */
package gdtel.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class CopiadorArchivos {
    public static void copia(String nombreFuente, String nombreDestino) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        StringBuffer fich = null;
        File entrada = new File(nombreFuente);
        File destino = new File(nombreDestino);
        if (!destino.exists()) {
            throw new IOException("El directorio destino no existe");
        }
        System.out.println("- [ Info ] Copiando... " + entrada.toURL());
        fich = CopiadorArchivos.obtenerFichero(entrada.getAbsolutePath(), File.separatorChar);
        System.out.println("- A destino: " + nombreDestino + File.separatorChar + fich);
        File bscDestino = new File(nombreDestino + File.separatorChar + fich);
        if (!entrada.isFile() && !bscDestino.exists()) {
            throw new IOException("El origen no es un archivo");
        }
        if (entrada.exists()) {
            fis = new FileInputStream(nombreFuente);
            fos = new FileOutputStream(nombreDestino + File.separatorChar + fich);
            FileChannel canalFuente = fis.getChannel();
            FileChannel canalDestino = fos.getChannel();
            canalFuente.transferTo(0L, canalFuente.size(), canalDestino);
            fis.close();
            fos.close();
            System.out.println("- Copia realizada con \u00e9xito.");
        } else if (bscDestino.exists()) {
            System.out.println("- El fichero de origen no existe pero s\u00ed el de destino. Rev\u00edselo.");
        } else {
            throw new IOException("el origen no existe");
        }
    }

    public static StringBuffer obtenerFichero(String ruta, char sepa) {
        char separador = sepa;
        int posicion = 0;
        StringBuffer nombre = new StringBuffer(2000);
        for (int i = 0; i < ruta.length(); ++i) {
            char s = ruta.charAt(i);
            if (separador != s) continue;
            posicion = i;
        }
        for (int j = posicion + 1; j < ruta.length(); ++j) {
            nombre.append(ruta.charAt(j));
        }
        return nombre;
    }

    public static boolean existeArchivo(String strRutaArchivo) {
        if (strRutaArchivo == null) {
            return false;
        }
        File entrada = new File(strRutaArchivo);
        return entrada.exists() && entrada.isFile();
    }
}

