/*
 * Decompiled with CFR 0.152.
 */
package modela.bd.obj;

import gdtel.ui.IAsignable;
import gdtel.util.GeneradorID;
import gdtel.util.UtilObj;
import java.math.BigDecimal;
import modela.bd.obj.TrCondicion;
import modela.graf.CodificadorAtributosXML;
import modela.graf.CreadorXMLDefProc;
import modela.graf.Referencia;

public class TrCondicionTransicion
extends Referencia
implements Cloneable,
IAsignable,
Comparable {
    private BigDecimal xID = BigDecimal.valueOf(GeneradorID.getID());
    private TrCondicion m_trCondicion = null;
    private String m_strMenajeOk = null;
    private String m_strMenajeNoOk = null;
    private boolean m_bObligatoria = false;
    private boolean m_bValida = true;
    private String m_strComprobar = null;
    private String m_strMostrarMsj = null;
    private String strTextoLibre = null;
    public static final String COMPROBAR_TRAMITAR = "TRAMITAR";
    public static final String COMPROBAR_DESHACER = "DESHACER";
    public static final String COMPROBAR_TRAMITAR_DESHACER = "TRAMITAR Y DESHACER";
    public static final String COMPROBAR_VISUALIZAR = "VISUALIZAR";
    public static final String MOSTRAR_MSJ_OK = "OK";
    public static final String MOSTRAR_MSJ_NO_OK = "NO OK";
    public static final String MOSTRAR_MSJ_AMBOS = "AMBOS";
    public static final String MOSTRAR_MSJ_NINGUNO = "NINGUNO";

    public BigDecimal getXID() {
        return this.xID;
    }

    public void setXID(BigDecimal _X_ID) {
        this.xID = _X_ID;
    }

    public double getID() {
        if (this.getXID() == null) {
            return 0.0;
        }
        return this.getXID().doubleValue();
    }

    public String getClave() {
        if (this.getXID() == null) {
            return "";
        }
        return this.getXID().toString();
    }

    public TrCondicion getCondicion() {
        return this.m_trCondicion;
    }

    public void setCondicion(TrCondicion trCondicion) {
        this.m_trCondicion = trCondicion;
    }

    public String getMensajeOk() {
        return this.m_strMenajeOk;
    }

    public void setMensajeOk(String strMensajeOk) {
        this.m_strMenajeOk = strMensajeOk;
    }

    public String getMensajeNoOk() {
        return this.m_strMenajeNoOk;
    }

    public void setMensajeNoOk(String strMensajeNoOk) {
        this.m_strMenajeNoOk = strMensajeNoOk;
    }

    public void setObligatoria(boolean bObligatoria) {
        this.m_bObligatoria = bObligatoria;
    }

    public boolean isObligatoria() {
        return this.m_bObligatoria;
    }

    public String isObligatoriaToString() {
        if (this.isObligatoria()) {
            return "S";
        }
        return "N";
    }

    public void setValida(boolean bValida) {
        this.m_bValida = bValida;
    }

    public boolean isValida() {
        return this.m_bValida;
    }

    public String isValidaToString() {
        if (this.isValida()) {
            return "S";
        }
        return "N";
    }

    public String getComprobar() {
        return this.m_strComprobar;
    }

    public void setComprobar(String strComprobar) {
        this.m_strComprobar = strComprobar;
    }

    public String getMostrarMsj() {
        return this.m_strMostrarMsj;
    }

    public void setMostrarMsj(String strMostrarMsj) {
        this.m_strMostrarMsj = strMostrarMsj;
    }

    public String getNombre() {
        if (this.m_trCondicion == null) {
            return "";
        }
        return this.m_trCondicion.getNombre();
    }

    public String getDescripcion() {
        if (this.m_trCondicion == null) {
            return "";
        }
        return this.m_trCondicion.getDescripcion();
    }

    public void setTextoLibre(String pNuevoTexto) {
        this.strTextoLibre = pNuevoTexto;
    }

    public String getTextoLibre() {
        return this.strTextoLibre;
    }

    public void toPrintln() {
        if (this.m_trCondicion == null) {
            return;
        }
        String strID = this.xID == null ? "null" : this.xID.toString();
        String strDescr = this.m_trCondicion.getDescripcion() == null ? "null" : this.m_trCondicion.getDescripcion();
        String strNombre = this.m_trCondicion.getNombre() == null ? "null" : this.m_trCondicion.getNombre();
        System.out.println(strID + " - " + strNombre + " - " + strDescr);
    }

    public Object clone() {
        Object obj = null;
        try {
            obj = super.clone();
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        super.finalize();
    }

    public String toXML(BigDecimal TransicionID) {
        String strXML = null;
        if (this.m_trCondicion == null || this.xID == null || TransicionID == null) {
            return null;
        }
        strXML = "<CONDICION_TRANSICION id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(String.valueOf(this.xID.longValue())) + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + " obligatoria=" + CreadorXMLDefProc.COMILLAS_DOBLES + this.isObligatoriaToString() + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + " condicion_id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(String.valueOf(this.m_trCondicion.getXID().longValue())) + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + " transicion_id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(String.valueOf(TransicionID.longValue())) + CreadorXMLDefProc.COMILLAS_DOBLES;
        if (this.m_strMenajeOk != null && !this.m_strMenajeOk.equals("")) {
            strXML = strXML + " mensaje_ok=" + CreadorXMLDefProc.COMILLAS_DOBLES + CodificadorAtributosXML.codificar(this.m_strMenajeOk) + CreadorXMLDefProc.COMILLAS_DOBLES;
        }
        if (this.m_strMenajeNoOk != null && !this.m_strMenajeNoOk.equals("")) {
            strXML = strXML + " mensaje_no_ok=" + CreadorXMLDefProc.COMILLAS_DOBLES + CodificadorAtributosXML.codificar(this.m_strMenajeNoOk) + CreadorXMLDefProc.COMILLAS_DOBLES;
        }
        if (this.m_strComprobar != null && !this.m_strComprobar.equals("")) {
            strXML = strXML + " comprobar=" + CreadorXMLDefProc.COMILLAS_DOBLES + this.m_strComprobar + CreadorXMLDefProc.COMILLAS_DOBLES;
        }
        if (this.m_strMostrarMsj != null && !this.m_strMostrarMsj.equals("")) {
            strXML = strXML + " mostrar_msj=" + CreadorXMLDefProc.COMILLAS_DOBLES + this.m_strMostrarMsj + CreadorXMLDefProc.COMILLAS_DOBLES;
        }
        strXML = strXML + " valida=" + CreadorXMLDefProc.COMILLAS_DOBLES + this.isValidaToString() + CreadorXMLDefProc.COMILLAS_DOBLES;
        if (this.getTextoLibre() != null && !this.getTextoLibre().equals("")) {
            strXML = strXML + " texto_libre=" + CreadorXMLDefProc.COMILLAS_DOBLES + CodificadorAtributosXML.codificar(this.getTextoLibre()) + CreadorXMLDefProc.COMILLAS_DOBLES;
        }
        strXML = strXML + "/>";
        return strXML;
    }

    public boolean equals(TrCondicionTransicion c) {
        if (c == null) {
            return false;
        }
        if (UtilObj.isAnyNull(this.getXID(), c.getXID())) {
            return false;
        }
        if (!UtilObj.areBothNull(this.getXID(), c.getXID()) && c.getXID().compareTo(this.getXID()) != 0) {
            return false;
        }
        if (UtilObj.isAnyNull(c.getCondicion(), this.getCondicion())) {
            return false;
        }
        if (!UtilObj.areBothNull(c.getCondicion(), this.getCondicion()) && !c.getCondicion().equals(this.getCondicion())) {
            return false;
        }
        if (UtilObj.isAnyNull(c.getMensajeOk(), this.getMensajeOk())) {
            return false;
        }
        if (!UtilObj.areBothNull(c.getMensajeOk(), this.getMensajeOk()) && !c.getMensajeOk().equals(this.getMensajeOk())) {
            return false;
        }
        if (UtilObj.isAnyNull(c.getMensajeNoOk(), this.getMensajeNoOk())) {
            return false;
        }
        if (!UtilObj.areBothNull(c.getMensajeNoOk(), this.getMensajeNoOk()) && !c.getMensajeOk().equals(this.getMensajeNoOk())) {
            return false;
        }
        if (c.isObligatoria() != this.isObligatoria()) {
            return false;
        }
        if (c.isValida() != this.isValida()) {
            return false;
        }
        if (UtilObj.isAnyNull(c.getComprobar(), this.getComprobar())) {
            return false;
        }
        if (!UtilObj.areBothNull(c.getComprobar(), this.getComprobar()) && !c.getComprobar().equals(this.getComprobar())) {
            return false;
        }
        if (UtilObj.isAnyNull(c.getMostrarMsj(), this.getMostrarMsj())) {
            return false;
        }
        return UtilObj.areBothNull(c.getMostrarMsj(), this.getMostrarMsj()) || c.getMostrarMsj().equals(this.getMostrarMsj());
    }

    public String toString() {
        if (this.m_trCondicion == null) {
            return "";
        }
        return this.m_trCondicion.getNombre();
    }

    public String getValidaToString() {
        if (this.isValida()) {
            return "S\u00cd";
        }
        return "NO";
    }

    public String getObligatoriaToString() {
        if (this.isObligatoria()) {
            return "S\u00cd";
        }
        return "NO";
    }

    public String getComprobarToString() {
        if (this.m_strComprobar == null) {
            return "";
        }
        if (this.m_strComprobar.equals("T")) {
            return COMPROBAR_TRAMITAR;
        }
        if (this.m_strComprobar.equals("D")) {
            return COMPROBAR_DESHACER;
        }
        if (this.m_strComprobar.equals("A")) {
            return COMPROBAR_TRAMITAR_DESHACER;
        }
        if (this.m_strComprobar.equals("V")) {
            return COMPROBAR_VISUALIZAR;
        }
        return "";
    }

    public int compareTo(Object o) {
        TrCondicionTransicion condicionTran = (TrCondicionTransicion)o;
        int cmp = this.getNombre().compareTo(condicionTran.getNombre());
        return cmp;
    }
}

