/*
 * Decompiled with CFR 0.152.
 */
package modela.bd.obj;

import gdtel.ui.IAsignable;
import gdtel.util.GeneradorID;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import modela.bd.obj.TrOrganismo;
import modela.graf.CodificadorAtributosXML;
import modela.graf.CreadorXMLDefProc;
import modela.graf.Referencia;

public class TrOrganismoProc
extends Referencia
implements Cloneable,
IAsignable,
Comparable {
    private BigDecimal xOrganismoProc = BigDecimal.valueOf(GeneradorID.getID());
    private String observaciones = null;
    private TrOrganismo trOrganismoAsociado = null;
    private String tipoAsociacion = null;
    private Date fechaInicioVigencia = null;
    private Date fechaFinVigencia = null;
    public static final String TIPO_ASOCIACION_PERTENECE = "PERTENECE";
    public static final String TIPO_ASOCIACION_COMPETE = "COMPETENTE";
    public static final String TIPO_ASOCIACION_RESUELVE = "RESUELVE";
    public static final String TIPO_ASOCIACION_TRAMITA = "TRAMITA";

    public BigDecimal getXOrganismoProc() {
        return this.xOrganismoProc;
    }

    public void setXOrganismoProc(BigDecimal pId) {
        this.xOrganismoProc = pId;
    }

    public String getObservaciones() {
        return this.observaciones;
    }

    public void setObservaciones(String pObserva) {
        this.observaciones = pObserva;
    }

    public String getTipoAsociacion() {
        return this.tipoAsociacion;
    }

    public void setTipoAsociacion(String strTipo) {
        this.tipoAsociacion = strTipo;
    }

    public TrOrganismo getOrganismoAsociado() {
        return this.trOrganismoAsociado;
    }

    public void setOrganismoAsociado(TrOrganismo pOrganismo) {
        this.trOrganismoAsociado = pOrganismo;
    }

    public Date getFechaInicioVigencia() {
        return this.fechaInicioVigencia;
    }

    public void setFechaInicioVigencia(Date pFechaIni) {
        this.fechaInicioVigencia = pFechaIni;
    }

    public Date getFechaFinVigencia() {
        return this.fechaFinVigencia;
    }

    public void setFechaFinVigencia(Date pFechaFin) {
        this.fechaFinVigencia = pFechaFin;
    }

    public double getID() {
        if (this.getXOrganismoProc() == null) {
            return 0.0;
        }
        return this.getXOrganismoProc().doubleValue();
    }

    public String getClave() {
        if (this.getXOrganismoProc() == null) {
            return "";
        }
        return this.getXOrganismoProc().toString();
    }

    public String getDescripcion() {
        return this.getObservaciones();
    }

    public String getNombre() {
        if (this.getOrganismoAsociado() != null) {
            return this.getOrganismoAsociado().getNombre();
        }
        return "";
    }

    public String toString() {
        return this.getNombre();
    }

    public Object clone() {
        Object obj = null;
        try {
            obj = super.clone();
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
        }
        return obj;
    }

    public boolean equals(TrOrganismoProc trOrganismoComparar) {
        if (trOrganismoComparar == null) {
            return false;
        }
        if (this.getDescripcion() == null ? trOrganismoComparar.getDescripcion() != null : !this.getDescripcion().equals(trOrganismoComparar.getDescripcion())) {
            return false;
        }
        if (this.getFechaInicioVigencia() == null ? trOrganismoComparar.getFechaInicioVigencia() != null : !this.getFechaInicioVigencia().equals(trOrganismoComparar.getFechaInicioVigencia())) {
            return false;
        }
        if (this.getFechaFinVigencia() == null ? trOrganismoComparar.getFechaFinVigencia() != null : !this.getFechaFinVigencia().equals(trOrganismoComparar.getFechaFinVigencia())) {
            return false;
        }
        if (this.getXOrganismoProc() == null ? trOrganismoComparar.getXOrganismoProc() != null : this.getXOrganismoProc().compareTo(trOrganismoComparar.getXOrganismoProc()) != 0) {
            return false;
        }
        return !(this.getOrganismoAsociado() == null ? trOrganismoComparar.getOrganismoAsociado() != null : !this.getOrganismoAsociado().equals(trOrganismoComparar.getOrganismoAsociado()));
    }

    public boolean esDuplicidadAtributos(TrOrganismoProc trOrganismoComparar) {
        if (trOrganismoComparar == null) {
            return false;
        }
        if (this.getOrganismoAsociado() == null ? trOrganismoComparar.getOrganismoAsociado() != null : !this.getOrganismoAsociado().equals(trOrganismoComparar.getOrganismoAsociado())) {
            return false;
        }
        return !(this.getTipoAsociacion() == null ? trOrganismoComparar.getTipoAsociacion() != null : !this.getTipoAsociacion().equals(trOrganismoComparar.getTipoAsociacion()));
    }

    public int compareTo(Object o) {
        TrOrganismoProc indN = (TrOrganismoProc)o;
        int cmp = this.getNombre().compareTo(indN.getNombre());
        return cmp;
    }

    public String toXML() {
        String strXML = null;
        if (this.xOrganismoProc == null || this.getOrganismoAsociado() == null) {
            return null;
        }
        SimpleDateFormat formatoDeFecha = new SimpleDateFormat("dd/MM/yyyy");
        strXML = "<ORGANISMO_PROC id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(this.xOrganismoProc.longValue()) + CreadorXMLDefProc.COMILLAS_DOBLES + " organismo_id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(this.trOrganismoAsociado.getUORGID().longValue()) + CreadorXMLDefProc.COMILLAS_DOBLES;
        if (this.observaciones != null && !this.observaciones.equals("")) {
            strXML = strXML + " observaciones=" + CreadorXMLDefProc.COMILLAS_DOBLES + CodificadorAtributosXML.codificar(this.observaciones) + CreadorXMLDefProc.COMILLAS_DOBLES;
        }
        if (this.tipoAsociacion != null && !this.tipoAsociacion.equals("")) {
            strXML = strXML + " tipo_asociacion=" + CreadorXMLDefProc.COMILLAS_DOBLES + CodificadorAtributosXML.codificar(this.tipoAsociacion) + CreadorXMLDefProc.COMILLAS_DOBLES;
        }
        if (this.fechaInicioVigencia != null && !this.fechaInicioVigencia.equals("")) {
            strXML = strXML + " fecha_ini_vigencia=" + CreadorXMLDefProc.COMILLAS_DOBLES + CodificadorAtributosXML.codificar(formatoDeFecha.format(this.fechaInicioVigencia)) + CreadorXMLDefProc.COMILLAS_DOBLES;
        }
        if (this.fechaFinVigencia != null && !this.fechaFinVigencia.equals("")) {
            strXML = strXML + " fecha_fin_vigencia=" + CreadorXMLDefProc.COMILLAS_DOBLES + CodificadorAtributosXML.codificar(formatoDeFecha.format(this.fechaFinVigencia)) + CreadorXMLDefProc.COMILLAS_DOBLES;
        }
        strXML = strXML + "/>";
        return strXML;
    }
}

