/*
 * Decompiled with CFR 0.152.
 */
package modela.bd.obj;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.PropiedadesJDialog;
import gdtel.util.GeneradorID;
import gdtel.util.UtilObj;
import java.math.BigDecimal;
import modela.bd.obj.ConjuntoDatosFase;
import modela.bd.obj.ConjuntoDatosTransicionDefProcedimiento;
import modela.bd.obj.TrAccionTransicion;
import modela.bd.obj.TrAvisoTransicion;
import modela.bd.obj.TrCondicionTransicion;
import modela.bd.obj.TrFase;
import modela.bd.obj.TrPerfilTransEvol;
import modela.bd.obj.TrTipoActo;
import modela.bd.obj.TrTransicionDefProcedimiento;
import modela.graf.CodificadorAtributosXML;
import modela.graf.CreadorXMLDefProc;
import modela.graf.Referencia;
import modela.ui.swing.PropTransicionJPanel;

public class TrTransicion
extends Referencia
implements Cloneable,
IAsignable,
Comparable {
    public static final String TIPO_NORMAL = "N";
    public static final String TIPO_DIVISION = "D";
    public static final String TIPO_UNION = "U";
    public static final String TIPO_EVENTO_ES = "ES";
    public static final String TIPO_EVENTO_EN = "EN";
    public static final String TIPO_INICIO_PROCEDIMIENTO = "I";
    public static final String TIPO_FIN_PROCEDIMIENTO = "F";
    public static final String DESCR_TIPO_NORMAL = "NORMAL";
    public static final String DESCR_TIPO_DIVISION = "DIVISI\u00d3N";
    public static final String DESCR_TIPO_UNION = "UNI\u00d3N";
    public static final String DESCR_TIPO_EVENTO_ES = "EVENTO QUE HACE SALIR";
    public static final String DESCR_TIPO_EVENTO_EN = "EVENTO QUE NO HACE SALIR";
    public static final String DESCR_TIPO_INICIO_PROCEDIMIENTO = "INICIO DE PROCEDIMIENTO";
    public static final String DESCR_TIPO_FIN_PROCEDIMIENTO = "FIN DE PROCEDIMIENTO";
    public static final int ORDEN_TIPO_INICIO_PROCEDIMIENTO = 0;
    public static final int ORDEN_TIPO_NORMAL = 1;
    public static final int ORDEN_TIPO_DIVISION = 2;
    public static final int ORDEN_TIPO_UNION = 3;
    public static final int ORDEN_TIPO_EVENTO_ES = 4;
    public static final int ORDEN_TIPO_EVENTO_EN = 5;
    public static final int ORDEN_TIPO_FIN_PROCEDIMIENTO = 6;
    private String T_ETIQUETA = null;
    private String D_TRANSICION;
    private String V_TIPO = "N";
    private BigDecimal X_TRAN = BigDecimal.valueOf(GeneradorID.getID());
    private Integer N_ORDEN = null;
    private String D_FECHA = null;
    private String L_VALIDA = "S";
    private String L_INFORMAR = "N";
    private String T_ETIQUETA_LARGA = null;
    protected TrFase faseFin = null;
    protected TrFase faseIni = null;
    protected TrTipoActo tipoActo = null;
    protected TrTransicion trTransicion_1 = null;
    private final ConjuntoDatosFase cdFasesFin = new ConjuntoDatosFase();
    private final ConjuntoDatos cdAccionTransicion = new ConjuntoDatos();
    private final ConjuntoDatos cdCondicionTransicion = new ConjuntoDatos();
    private final ConjuntoDatos cdAvisoTransicion = new ConjuntoDatos();

    public String getETIQUETA() {
        return this.T_ETIQUETA;
    }

    public void setETIQUETA(String _T_ETIQUETA) {
        this.T_ETIQUETA = _T_ETIQUETA;
    }

    public BigDecimal getTRANID() {
        return this.X_TRAN;
    }

    public void setTRANID(BigDecimal _X_TRAN) {
        this.X_TRAN = _X_TRAN;
    }

    public String getDESCRIPCION() {
        return this.D_TRANSICION;
    }

    public void setDESCRIPCION(String _D_TRANSICION) {
        this.D_TRANSICION = _D_TRANSICION;
    }

    public String getTIPO() {
        return this.V_TIPO;
    }

    public String obtenerDescrpcionTipo() {
        if (this.V_TIPO == null) {
            return "";
        }
        if (this.V_TIPO.equals(TIPO_NORMAL)) {
            return DESCR_TIPO_NORMAL;
        }
        if (this.V_TIPO.equals(TIPO_DIVISION)) {
            return DESCR_TIPO_DIVISION;
        }
        if (this.V_TIPO.equals(TIPO_UNION)) {
            return DESCR_TIPO_UNION;
        }
        if (this.V_TIPO.equals(TIPO_EVENTO_ES)) {
            return DESCR_TIPO_EVENTO_ES;
        }
        if (this.V_TIPO.equals(TIPO_EVENTO_EN)) {
            return DESCR_TIPO_EVENTO_EN;
        }
        if (this.V_TIPO.equals(TIPO_INICIO_PROCEDIMIENTO)) {
            return DESCR_TIPO_INICIO_PROCEDIMIENTO;
        }
        if (this.V_TIPO.equals(TIPO_FIN_PROCEDIMIENTO)) {
            return DESCR_TIPO_FIN_PROCEDIMIENTO;
        }
        return "";
    }

    public void setTIPO(String _V_TIPO) {
        this.V_TIPO = _V_TIPO;
    }

    public Integer getORDEN() {
        return this.N_ORDEN;
    }

    public void setORDEN(Integer _N_ORDEN) {
        this.N_ORDEN = _N_ORDEN;
    }

    public String getDESCRIPCIONFECHA() {
        return this.D_FECHA;
    }

    public void setDESCRIPCIONFECHA(String _D_FECHA) {
        this.D_FECHA = _D_FECHA;
    }

    public String getVALIDA() {
        return this.L_VALIDA;
    }

    public boolean isValida() {
        return this.L_VALIDA.compareTo("S") == 0;
    }

    public void setVALIDA(String _L_VALIDA) {
        this.L_VALIDA = _L_VALIDA;
    }

    public void setValida(boolean bValida) {
        this.L_VALIDA = bValida ? "S" : TIPO_NORMAL;
    }

    public String getValidaToString() {
        if (this.L_VALIDA.equals("S")) {
            return "S\u00cd";
        }
        if (this.L_VALIDA.equals(TIPO_NORMAL)) {
            return "NO";
        }
        return "NO";
    }

    public void setTrFaseIni(TrFase nuevaFase) {
        this.faseIni = nuevaFase;
    }

    public TrFase getTrFaseIni() {
        return this.faseIni;
    }

    public void setTipoActo(TrTipoActo nuevoTipoActo) {
        this.tipoActo = nuevoTipoActo;
    }

    public TrTipoActo getTipoActo() {
        return this.tipoActo;
    }

    public void setTrFaseFin(TrFase nuevaFase) {
        this.faseFin = nuevaFase;
    }

    public TrFase getFaseFin() {
        return this.faseFin;
    }

    public String getINFORMAR() {
        return this.L_INFORMAR;
    }

    public boolean isInformar() {
        return this.L_INFORMAR.compareTo("S") == 0;
    }

    public void setINFORMAR(String _L_INFORMAR) {
        this.L_INFORMAR = _L_INFORMAR;
    }

    public void setINFORMAR(boolean bInformar) {
        this.L_INFORMAR = bInformar ? "S" : TIPO_NORMAL;
    }

    public String getETIQUETA_LARGA() {
        return this.T_ETIQUETA_LARGA;
    }

    public void setETIQUETA_LARGA(String _T_ETIQUETA_LARGA) {
        this.T_ETIQUETA_LARGA = _T_ETIQUETA_LARGA;
    }

    public double getID() {
        return this.getTRANID().doubleValue();
    }

    public String getClave() {
        return String.valueOf(this.getTRANID().longValue());
    }

    public String getNombre() {
        return this.getETIQUETA();
    }

    public String getDescripcion() {
        return this.getDESCRIPCION();
    }

    public String toString() {
        return this.getETIQUETA() + " - " + this.getDESCRIPCION();
    }

    public void addFaseFin(TrFase fFin) {
        this.cdFasesFin.add(fFin);
    }

    public void removeFaseFin(TrFase fFin) {
        this.cdFasesFin.remove(fFin);
    }

    public ConjuntoDatosFase getConjuntoFasesFin() {
        return this.cdFasesFin;
    }

    public Object clone() {
        Object obj = null;
        try {
            obj = super.clone();
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        super.finalize();
    }

    public void mostrarPropiedades() {
        PropiedadesJDialog p = new PropiedadesJDialog(new PropTransicionJPanel(true), 1);
        p.setTitle("Propiedades de la transici\u00f3n");
        p.setValoresAsignables(this);
        p.setSize(590, 425);
        p.setVisible(true);
    }

    public String toXMLCabecera(ConjuntoDatosTransicionDefProcedimiento transicionesProcedimiento) {
        String strXML = null;
        if (this.T_ETIQUETA == null || this.X_TRAN == null || this.V_TIPO == null || this.D_TRANSICION == null || this.L_VALIDA == null) {
            return null;
        }
        strXML = "<TRANSICION id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(String.valueOf(this.X_TRAN.longValue())) + CreadorXMLDefProc.COMILLAS_DOBLES + " etiqueta=" + CreadorXMLDefProc.COMILLAS_DOBLES + CodificadorAtributosXML.codificar(this.T_ETIQUETA) + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + " descripcion=" + CreadorXMLDefProc.COMILLAS_DOBLES + CodificadorAtributosXML.codificar(this.D_TRANSICION) + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + " tipo=" + CreadorXMLDefProc.COMILLAS_DOBLES + CodificadorAtributosXML.codificar(this.V_TIPO) + CreadorXMLDefProc.COMILLAS_DOBLES;
        if (this.getTipoActo() != null) {
            strXML = strXML + " actoadm_id =" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(String.valueOf(this.getTipoActo().getTIPOID().longValue())) + CreadorXMLDefProc.COMILLAS_DOBLES;
        }
        if (this.D_FECHA != null && !this.D_FECHA.equals("")) {
            strXML = strXML + " desc_fecha=" + CreadorXMLDefProc.COMILLAS_DOBLES + CodificadorAtributosXML.codificar(this.D_FECHA) + CreadorXMLDefProc.COMILLAS_DOBLES;
        }
        if (this.N_ORDEN != null) {
            strXML = strXML + " orden=" + CreadorXMLDefProc.COMILLAS_DOBLES + this.N_ORDEN + CreadorXMLDefProc.COMILLAS_DOBLES;
        }
        strXML = strXML + " valida=" + CreadorXMLDefProc.COMILLAS_DOBLES + this.L_VALIDA + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + " informar=" + CreadorXMLDefProc.COMILLAS_DOBLES + this.L_INFORMAR + CreadorXMLDefProc.COMILLAS_DOBLES;
        if (this.T_ETIQUETA_LARGA != null && !this.T_ETIQUETA_LARGA.equals("")) {
            strXML = strXML + " etiq_larga=" + CreadorXMLDefProc.COMILLAS_DOBLES + CodificadorAtributosXML.codificar(this.T_ETIQUETA_LARGA) + CreadorXMLDefProc.COMILLAS_DOBLES;
        }
        TrTransicionDefProcedimiento transiProcedimiento = null;
        transiProcedimiento = transicionesProcedimiento.getTransicionDefProcedimiento(this.getTRANID().doubleValue());
        if (transiProcedimiento != null && transiProcedimiento.getMaxOcurrencias() != null) {
            strXML = strXML + " max_ocurrencias=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(transiProcedimiento.getMaxOcurrencias()) + CreadorXMLDefProc.COMILLAS_DOBLES;
        }
        strXML = strXML + ">";
        if (this.getTrFaseIni() != null) {
            strXML = strXML + "\n<FASE_INI>";
            strXML = strXML + "\n<FASE_ID id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(String.valueOf(this.getTrFaseIni().getFASEID().longValue())) + CreadorXMLDefProc.COMILLAS_DOBLES + "/>";
            strXML = strXML + "\n</FASE_INI>";
        }
        if (this.getTIPO().equals(TIPO_DIVISION)) {
            if (this.cdFasesFin != null) {
                strXML = strXML + "\n<FASES_FIN>";
                for (int n = 0; n < this.cdFasesFin.obtenerNumRegistros(); ++n) {
                    strXML = strXML + "\n<FASE_ID id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(String.valueOf(((TrFase)this.cdFasesFin.obtenerDato(n)).getFASEID().longValue())) + CreadorXMLDefProc.COMILLAS_DOBLES + "/>";
                }
                strXML = strXML + "\n</FASES_FIN>";
            }
        } else if (this.getFaseFin() != null) {
            strXML = strXML + "\n<FASES_FIN>";
            strXML = strXML + "\n<FASE_ID id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(String.valueOf(this.getFaseFin().getFASEID().longValue())) + CreadorXMLDefProc.COMILLAS_DOBLES + "/>";
            strXML = strXML + "\n</FASES_FIN>";
        }
        strXML = strXML + "\n<PERMISOS_TRAMITACION>";
        if (transicionesProcedimiento.getListaDatos() != null) {
            TrTransicionDefProcedimiento transiProcAux = null;
            transiProcAux = transicionesProcedimiento.getTransicionDefProcedimiento(this.getTRANID().doubleValue());
            if (transiProcAux != null && transiProcAux.getConjuntoPerfilTransEvol() != null) {
                String strPermiso = null;
                for (int p = 0; p < transiProcAux.getConjuntoPerfilTransEvol().obtenerNumRegistros(); ++p) {
                    strXML = strXML + "\n<PERFIL_TRANSICION perfil_id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(String.valueOf(((TrPerfilTransEvol)transiProcAux.getConjuntoPerfilTransEvol().obtenerDato(p)).getPERFIL().getX_PEUS().longValue())) + CreadorXMLDefProc.COMILLAS_DOBLES;
                    strPermiso = String.valueOf(String.valueOf(((TrPerfilTransEvol)transiProcAux.getConjuntoPerfilTransEvol().obtenerDato(p)).getPERMISO()));
                    if (strPermiso.equals("TRAMITAR")) {
                        strPermiso = "T";
                    }
                    if (strPermiso.equals("DESHACER")) {
                        strPermiso = TIPO_DIVISION;
                    }
                    if (strPermiso.equals("AMBOS")) {
                        strPermiso = "A";
                    }
                    strXML = strXML + " permiso=" + CreadorXMLDefProc.COMILLAS_DOBLES + strPermiso + CreadorXMLDefProc.COMILLAS_DOBLES + "/>";
                }
            }
        }
        strXML = strXML + "\n</PERMISOS_TRAMITACION>";
        return strXML;
    }

    public String toXMLFinTransicion(ConjuntoDatosTransicionDefProcedimiento transicionesProcedimiento) {
        if (this.toXMLCabecera(transicionesProcedimiento) != null) {
            return "</TRANSICION>";
        }
        return "";
    }

    public boolean equals(TrTransicion t) {
        if (t == null) {
            return false;
        }
        if (!t.getVALIDA().equals(this.getVALIDA())) {
            return false;
        }
        if (t.getDESCRIPCIONFECHA() != null || this.getDESCRIPCIONFECHA() != null) {
            if (t.getDESCRIPCIONFECHA() == null) {
                return false;
            }
            if (this.getDESCRIPCIONFECHA() == null) {
                return false;
            }
            if (!t.getDESCRIPCIONFECHA().equals(this.getDESCRIPCIONFECHA())) {
                return false;
            }
        }
        if (UtilObj.isAnyNull(t.getTRANID(), this.getTRANID())) {
            return false;
        }
        if (!UtilObj.areBothNull(t.getTRANID(), this.getTRANID()) && t.getTRANID().compareTo(this.getTRANID()) != 0) {
            return false;
        }
        if (UtilObj.isAnyNull(t.getTIPO(), this.getTIPO())) {
            return false;
        }
        if (!UtilObj.areBothNull(t.getTIPO(), this.getTIPO()) && !t.getTIPO().equals(this.getTIPO())) {
            return false;
        }
        if (UtilObj.isAnyNull(t.getORDEN(), this.getORDEN())) {
            return false;
        }
        if (!UtilObj.areBothNull(t.getORDEN(), this.getORDEN()) && t.getORDEN().compareTo(this.getORDEN()) != 0) {
            return false;
        }
        if (UtilObj.isAnyNull(t.getNombre(), this.getNombre())) {
            return false;
        }
        if (!UtilObj.areBothNull(t.getNombre(), this.getNombre()) && !t.getNombre().equals(this.getNombre())) {
            return false;
        }
        if (UtilObj.isAnyNull(t.getTrFaseIni(), this.getTrFaseIni())) {
            return false;
        }
        if (!UtilObj.areBothNull(t.getTrFaseIni(), this.getTrFaseIni()) && !t.getTrFaseIni().equals(this.getTrFaseIni())) {
            return false;
        }
        if (UtilObj.isAnyNull(t.getFaseFin(), this.getFaseFin())) {
            return false;
        }
        if (!UtilObj.areBothNull(t.getFaseFin(), this.getFaseFin()) && !t.getFaseFin().equals(this.getFaseFin())) {
            return false;
        }
        if (UtilObj.isAnyNull(t.getETIQUETA(), this.getETIQUETA())) {
            return false;
        }
        if (!UtilObj.areBothNull(t.getETIQUETA(), this.getETIQUETA()) && !t.getETIQUETA().equals(this.getETIQUETA())) {
            return false;
        }
        if (UtilObj.isAnyNull(t.getETIQUETA_LARGA(), this.getETIQUETA_LARGA())) {
            return false;
        }
        if (!UtilObj.areBothNull(t.getETIQUETA_LARGA(), this.getETIQUETA_LARGA()) && !t.getETIQUETA_LARGA().equals(this.getETIQUETA_LARGA())) {
            return false;
        }
        if (UtilObj.isAnyNull(t.getDescripcion(), this.getDescripcion())) {
            return false;
        }
        return UtilObj.areBothNull(t.getDescripcion(), this.getDescripcion()) || t.getDescripcion().equals(this.getDescripcion());
    }

    public void addAccionTransicion(TrAccionTransicion accionTransicion) {
        this.cdAccionTransicion.add(accionTransicion);
    }

    public void removeAccionTransicion(TrAccionTransicion accionTransicion) {
        this.cdAccionTransicion.remove(accionTransicion);
    }

    public ConjuntoDatos getConjuntoAccionTransicion() {
        return this.cdAccionTransicion;
    }

    public void addCondicionTransicion(TrCondicionTransicion condicionTransicion) {
        this.cdCondicionTransicion.add(condicionTransicion);
    }

    public void removeCondicionTransicion(TrCondicionTransicion condicionTransicion) {
        this.cdCondicionTransicion.remove(condicionTransicion);
    }

    public ConjuntoDatos getConjuntoCondicionTransicion() {
        return this.cdCondicionTransicion;
    }

    public void addAvisoTransicion(TrAvisoTransicion avisoTransicion) {
        this.cdAvisoTransicion.add(avisoTransicion);
    }

    public void removeAvisoTransicion(TrCondicionTransicion avisoTransicion) {
        this.cdAvisoTransicion.remove(avisoTransicion);
    }

    public ConjuntoDatos getConjuntoAvisoTransicion() {
        return this.cdAvisoTransicion;
    }

    public int compareTo(Object o) {
        TrTransicion transicionN = (TrTransicion)o;
        int cmp = this.getNombre().compareTo(transicionN.getNombre());
        return cmp;
    }

    public String toStringArbol() {
        return this.getETIQUETA() + " - " + this.getDESCRIPCION();
    }
}

