/*
 * Decompiled with CFR 0.152.
 */
package modela.bean.ui.swing;

import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.excontrols.CreadorButton;
import gdtel.ui.swing.excontrols.JTreePanelEx;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import modela.bd.obj.TrCaducidadExpediente;
import modela.bd.obj.TrExpediente;
import modela.bd.obj.TrExpedienteRelacionado;
import modela.bd.obj.TrInteresado;
import modela.bd.obj.TrUsuarioAsignado;
import modela.bean.ui.swing.renderers.ExpedienteTreeRenderer;
import modela.ui.ModelaUI;
import modela.ui.swing.ModificacionesCaducidadJPanel;
import modela.ui.swing.VisorEtiquetaValorJPanel;

public class FichaExpedienteJDialog
extends JDialog
implements ContainerListener,
KeyListener {
    private static final long serialVersionUID = 1987497944847929041L;
    ImageIcon cerrarIconN = new ImageIcon(FichaExpedienteJDialog.class.getResource(ModelaUI.IMG_MTTO_CERRAR));
    ImageIcon cerrarIconS = new ImageIcon(FichaExpedienteJDialog.class.getResource(ModelaUI.IMG_MTTO_CERRAR_SOBRE));
    JButton cerrarButton = (JButton)CreadorButton.crearBoton(1, false, this.cerrarIconN, this.cerrarIconN, this.cerrarIconS, this.cerrarIconS);
    JLabel tituloLabel = new JLabel();
    JTreePanelEx treeExpediente = null;
    VisorEtiquetaValorJPanel panelValores = null;
    ModificacionesCaducidadJPanel panelModificaciones = null;

    public FichaExpedienteJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.prepararDisenio();
        this.addListeners();
        this.limpiarListaElementos();
        this.treeExpediente.getTree().setCellRenderer(new ExpedienteTreeRenderer());
    }

    private void prepararDisenio() {
        this.setSize(new Dimension(650, 580));
        this.setModal(true);
        this.setResizable(false);
        this.setTitle("Ficha del expediente");
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new XYLayout());
        this.tituloLabel.setText("Expediente");
        this.tituloLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.tituloLabel.setForeground(ModelaUI.colorSeleccion);
        this.treeExpediente = new JTreePanelEx();
        this.treeExpediente.getTree().setRootVisible(false);
        this.panelValores = new VisorEtiquetaValorJPanel();
        this.panelModificaciones = new ModificacionesCaducidadJPanel();
        this.panelModificaciones.setVisible(false);
        this.getContentPane().add((Component)this.tituloLabel, new XYConstraints(20, 10, 650, 25));
        this.getContentPane().add((Component)this.treeExpediente, new XYConstraints(20, 30, 610, 130));
        this.getContentPane().add((Component)this.panelValores, new XYConstraints(20, 170, 610, 195));
        this.getContentPane().add((Component)this.panelModificaciones, new XYConstraints(20, 370, 610, 130));
        this.getContentPane().add((Component)this.cerrarButton, new XYConstraints(515, 515, 120, 30));
    }

    private void addListeners() {
        this.cerrarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FichaExpedienteJDialog.this.cerrar();
            }
        });
        this.treeExpediente.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                FichaExpedienteJDialog.this.mostrarAtributosElemento(e);
            }
        });
        this.addKeyAndContainerListenerRecursively(this);
    }

    public void limpiarListaElementos() {
        this.treeExpediente.clear();
    }

    protected void cerrar() {
        this.dispose();
    }

    public void contraerArbol() {
        for (int r = 0; r < this.treeExpediente.getTree().getRowCount(); ++r) {
            this.treeExpediente.getTree().collapseRow(r);
        }
        if (this.treeExpediente.getTree().getRowCount() > 0) {
            this.treeExpediente.getTree().setSelectionRow(0);
        }
    }

    public void cargarEstructuraExpediente(TrExpediente expediente) {
        int n;
        if (expediente == null) {
            return;
        }
        this.limpiarListaElementos();
        this.tituloLabel.setText("Expediente " + expediente.toString());
        DefaultMutableTreeNode rootExpediente = null;
        DefaultMutableTreeNode rootInteresados = null;
        DefaultMutableTreeNode rootUsuarios = null;
        DefaultMutableTreeNode rootRelaciones = null;
        DefaultMutableTreeNode rootCaducidades = null;
        rootExpediente = new DefaultMutableTreeNode();
        rootExpediente = this.treeExpediente.addObject(null, expediente, true);
        if (expediente.getInteresadosExpediente().size() > 0) {
            rootInteresados = new DefaultMutableTreeNode();
            rootInteresados = this.treeExpediente.addObject(rootExpediente, "Interesados", true);
            for (n = 0; n < expediente.getInteresadosExpediente().size(); ++n) {
                this.treeExpediente.addObject(rootInteresados, expediente.getInteresadosExpediente().get(n), true);
            }
        }
        if (expediente.getUsuariosAsignados().size() > 0) {
            rootUsuarios = new DefaultMutableTreeNode();
            rootUsuarios = this.treeExpediente.addObject(rootExpediente, "Usuarios asignados", true);
            for (n = 0; n < expediente.getUsuariosAsignados().size(); ++n) {
                this.treeExpediente.addObject(rootUsuarios, expediente.getUsuariosAsignados().get(n), true);
            }
        }
        if (expediente.getRelacionesExpediente().size() > 0) {
            rootRelaciones = new DefaultMutableTreeNode();
            rootRelaciones = this.treeExpediente.addObject(rootExpediente, "Relaciones", true);
            for (n = 0; n < expediente.getRelacionesExpediente().size(); ++n) {
                this.treeExpediente.addObject(rootRelaciones, expediente.getRelacionesExpediente().get(n), true);
            }
        }
        if (expediente.getCaducidadesExpediente().size() > 0) {
            rootCaducidades = new DefaultMutableTreeNode();
            rootCaducidades = this.treeExpediente.addObject(rootExpediente, "Caducidades", true);
            for (n = 0; n < expediente.getCaducidadesExpediente().size(); ++n) {
                this.treeExpediente.addObject(rootCaducidades, expediente.getCaducidadesExpediente().get(n), true);
            }
        }
        this.contraerArbol();
    }

    void mostrarAtributosElemento(TreeSelectionEvent e) {
        TreePath pathActual = e.getPath();
        this.panelValores.limpiarAtributos();
        this.panelValores.setTitulo("Ficha");
        this.panelModificaciones.limpiar();
        this.panelModificaciones.setVisible(false);
        if (((DefaultMutableTreeNode)pathActual.getLastPathComponent()).getUserObject() instanceof TrExpediente) {
            this.panelValores.setTitulo("Ficha del expediente");
            TrExpediente elementoSeleccionado = (TrExpediente)((DefaultMutableTreeNode)pathActual.getLastPathComponent()).getUserObject();
            this.panelValores.mostrarAtributos(elementoSeleccionado);
        } else if (((DefaultMutableTreeNode)pathActual.getLastPathComponent()).getUserObject() instanceof TrInteresado) {
            this.panelValores.setTitulo("Ficha de interesado");
            TrInteresado elementoSeleccionado = (TrInteresado)((DefaultMutableTreeNode)pathActual.getLastPathComponent()).getUserObject();
            this.panelValores.mostrarAtributos(elementoSeleccionado);
        } else if (((DefaultMutableTreeNode)pathActual.getLastPathComponent()).getUserObject() instanceof TrUsuarioAsignado) {
            this.panelValores.setTitulo("Ficha de usuario asignado");
            TrUsuarioAsignado elementoSeleccionado = (TrUsuarioAsignado)((DefaultMutableTreeNode)pathActual.getLastPathComponent()).getUserObject();
            this.panelValores.mostrarAtributos(elementoSeleccionado);
        } else if (((DefaultMutableTreeNode)pathActual.getLastPathComponent()).getUserObject() instanceof TrExpedienteRelacionado) {
            this.panelValores.setTitulo("Ficha de expediente relacionado");
            TrExpedienteRelacionado elementoSeleccionado = (TrExpedienteRelacionado)((DefaultMutableTreeNode)pathActual.getLastPathComponent()).getUserObject();
            this.panelValores.mostrarAtributos(elementoSeleccionado);
        } else if (((DefaultMutableTreeNode)pathActual.getLastPathComponent()).getUserObject() instanceof TrCaducidadExpediente) {
            this.panelValores.setTitulo("Ficha de caducidad en el expediente");
            TrCaducidadExpediente elementoSeleccionado = (TrCaducidadExpediente)((DefaultMutableTreeNode)pathActual.getLastPathComponent()).getUserObject();
            this.panelValores.mostrarAtributos(elementoSeleccionado);
            this.panelModificaciones.setVisible(true);
            this.panelModificaciones.mostrarModificaciones(elementoSeleccionado);
        }
    }

    private void addKeyAndContainerListenerRecursively(Component c) {
        c.removeKeyListener(this);
        c.addKeyListener(this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            cont.addContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.addKeyAndContainerListenerRecursively(children[i]);
            }
        }
    }

    private void removeKeyAndContainerListenerRecursively(Component c) {
        c.removeKeyListener(this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.removeKeyAndContainerListenerRecursively(children[i]);
            }
        }
    }

    public void componentAdded(ContainerEvent e) {
        this.addKeyAndContainerListenerRecursively(e.getChild());
    }

    public void componentRemoved(ContainerEvent e) {
        this.removeKeyAndContainerListenerRecursively(e.getChild());
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 27) {
            this.dispose();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

