/*
 * Decompiled with CFR 0.152.
 */
package modela.graf;

import edu.umd.cs.piccolo.PLayer;
import gdtel.bd.ConjuntoDatos;
import gdtel.util.file.CreadorArchivo;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import modela.bd.ConjuntoDatosModela;
import modela.bd.obj.ConjuntoDatosAccion;
import modela.bd.obj.ConjuntoDatosAmbitosLey;
import modela.bd.obj.ConjuntoDatosCondicion;
import modela.bd.obj.ConjuntoDatosOrganismo;
import modela.bd.obj.ConjuntoDatosTarea;
import modela.bd.obj.ConjuntoDatosTareaEnFase;
import modela.bd.obj.ConjuntoDatosTareaFaseDefProcedimiento;
import modela.bd.obj.ConjuntoDatosTipoActo;
import modela.bd.obj.ConjuntoDatosTiposIndicacion;
import modela.bd.obj.ConjuntoDatosTiposNormativa;
import modela.bd.obj.ConjuntoDatosTiposOrganismo;
import modela.bd.obj.ConjuntoDatosTiposPublicacion;
import modela.bd.obj.ConjuntoDatosTransicion;
import modela.bd.obj.ConjuntoDatosTransicionDefProcedimiento;
import modela.bd.obj.TrAccionTareaFase;
import modela.bd.obj.TrAccionTransicion;
import modela.bd.obj.TrAmbitoLey;
import modela.bd.obj.TrAviso;
import modela.bd.obj.TrAvisoTareaFase;
import modela.bd.obj.TrAvisoTransicion;
import modela.bd.obj.TrBloque;
import modela.bd.obj.TrCondicionTareaFase;
import modela.bd.obj.TrCondicionTransicion;
import modela.bd.obj.TrFase;
import modela.bd.obj.TrIndicacionFicha;
import modela.bd.obj.TrMetafase;
import modela.bd.obj.TrMetafaseGr;
import modela.bd.obj.TrNormativa;
import modela.bd.obj.TrOrganismo;
import modela.bd.obj.TrOrganismoProc;
import modela.bd.obj.TrParametro;
import modela.bd.obj.TrParrafoTipDoc;
import modela.bd.obj.TrPlantilla;
import modela.bd.obj.TrPlantillaProcedimiento;
import modela.bd.obj.TrPlazoCompuestoDefProc;
import modela.bd.obj.TrPlazoSimple;
import modela.bd.obj.TrTareaEnFase;
import modela.bd.obj.TrTareaEnFaseDefProcedimiento;
import modela.bd.obj.TrTipoActo;
import modela.bd.obj.TrTipoDocumento;
import modela.bd.obj.TrTipoIndicacionFicha;
import modela.bd.obj.TrTipoNormativa;
import modela.bd.obj.TrTipoOrganismo;
import modela.bd.obj.TrTipoParrafo;
import modela.bd.obj.TrTipoPublicacion;
import modela.bd.obj.TrTransicion;
import modela.bd.obj.TrTransicionDefProcedimiento;
import modela.bd.obj.TrVariable;
import modela.conf.ModelaConf;
import modela.graf.CodificadorAtributosXML;
import modela.graf.DDPGrafico;
import modela.graf.ValidadorDefProcedimiento;
import modela.ui.event.InfoResultado;
import modela.ui.event.InfoResultadoEvent;
import modela.ui.event.InfoResultadoListener;
import modela.ui.piccolo.nodes.FasePNode;
import modela.ui.piccolo.nodes.PNodoGrafico;
import modela.ui.piccolo.nodes.PostItPNode;
import modela.ui.piccolo.nodes.TransicionPNode;

public class CreadorXMLDefProc
extends CreadorArchivo {
    protected String rutaSalida = "";
    protected DDPGrafico graficoDDP;
    boolean bGenerarInformacionGrafica = true;
    BigDecimal idEnProceso = null;
    int nEtiquetas = 0;
    boolean bCerrandoDefinicion;
    private final String strVersionActual = "1.0.0";
    String strCabeceraDEF_PROC = "DEF_PROCEDIMIENTO_MODELA";
    String strOrigenXML = null;
    public static char COMILLAS_DOBLES = (char)34;
    ValidadorDefProcedimiento m_ValidadorDefProc = null;
    private final int BASE_GENERADORA_CONTROL = 201081;

    public CreadorXMLDefProc() {
        this.m_ValidadorDefProc = new ValidadorDefProcedimiento();
    }

    public CreadorXMLDefProc(String strArchivo) {
        super(strArchivo);
    }

    public void setGenerarInfoGrafica(boolean bGenerar) {
        this.bGenerarInformacionGrafica = bGenerar;
    }

    public void setRutaSalida(String strRutaNueva) {
        this.rutaSalida = strRutaNueva;
    }

    public boolean generarArchivo(String strArchivo, DDPGrafico grafico, boolean pCerrar) {
        if (this.m_ValidadorDefProc == null) {
            return false;
        }
        if (grafico == null) {
            return false;
        }
        if (strArchivo == null) {
            return false;
        }
        if (grafico.getDDP() == null) {
            return false;
        }
        if (grafico.getDDP().getDDPGID() == null) {
            return false;
        }
        if (grafico.getDDP().getTIPOEVOL() == null) {
            return false;
        }
        if (!this.crearArchivoSalida(strArchivo, ModelaConf.getEncoding())) {
            return false;
        }
        this.m_ValidadorDefProc.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_INICIO, "Iniciando proceso de generaci\u00f3n", "", "", "")));
        if (!this.generarCabecera()) {
            return false;
        }
        this.nEtiquetas = 0;
        this.bCerrandoDefinicion = pCerrar;
        this.generarXML(grafico);
        if (!this.cerrarArchivoSalida()) {
            return false;
        }
        if (!this.m_ValidadorDefProc.getComprimir()) {
            this.m_ValidadorDefProc.fireFinal();
        }
        return true;
    }

    public boolean generarXML(DDPGrafico grafico) {
        String strInicio;
        if (this.m_ValidadorDefProc == null) {
            return false;
        }
        if (grafico.getDDP() == null) {
            return false;
        }
        if (grafico.getDDP().getTIPOEVOL() == null) {
            return false;
        }
        if (grafico.getDDPPadre() == null) {
            this.m_ValidadorDefProc.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_CORRECTO, "Exportando definici\u00f3n del procedimiento", "Definici\u00f3n de procedimiento", grafico.getDDP().getTIPOEVOL().getABREVIATURA(), "")));
        } else {
            this.m_ValidadorDefProc.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_CORRECTO, "Exportando m\u00f3dulo reutilizable", "M\u00f3dulo reutilizable", grafico.getDDP().getTIPOEVOL().getABREVIATURA(), "")));
        }
        this.idEnProceso = grafico.getDDP().getTIPOEVOL().getTIEVID();
        if (String.valueOf(grafico.getDDP().getDDPGID().longValue()) == null || grafico.getDDP().getTIPOEVOL().getABREVIATURA() == null || grafico.getDDP().getTIPOEVOL().getSISTEMA() == null) {
            return false;
        }
        if (grafico.getDDPPadre() == null) {
            this.strOrigenXML = grafico.getPathSimple();
            if (this.bCerrandoDefinicion) {
                this.strCabeceraDEF_PROC = "DEF_PROCEDIMIENTO";
            } else if (!this.bCerrandoDefinicion) {
                this.strCabeceraDEF_PROC = "DEF_PROCEDIMIENTO_MODELA";
            }
            strInicio = "<" + this.strCabeceraDEF_PROC + " id=" + COMILLAS_DOBLES + String.valueOf(grafico.getDDP().getTIPOEVOL().getTIEVID());
        } else {
            strInicio = ModelaConf.isCompatibleTrewa0() ? "<DEF_PROCEDIMIENTO_R id=" + COMILLAS_DOBLES + String.valueOf(grafico.getDDP().getTIPOEVOL().getTIEVID()) : "<DEF_PROCEDIMIENTO id=" + COMILLAS_DOBLES + String.valueOf(grafico.getDDP().getTIPOEVOL().getTIEVID());
        }
        strInicio = strInicio + COMILLAS_DOBLES + " nombre=" + COMILLAS_DOBLES + CodificadorAtributosXML.codificar(grafico.getDDP().getTIPOEVOL().getABREVIATURA());
        strInicio = strInicio + COMILLAS_DOBLES + " descripcion=" + COMILLAS_DOBLES + CodificadorAtributosXML.codificar(grafico.getDDP().getTIPOEVOL().getDESCRIPCION());
        strInicio = strInicio + COMILLAS_DOBLES + " sistema=" + COMILLAS_DOBLES + CodificadorAtributosXML.codificar(grafico.getDDP().getTIPOEVOL().getSISTEMA());
        strInicio = strInicio + COMILLAS_DOBLES + " version=" + COMILLAS_DOBLES + this.strVersionActual;
        if (grafico.getDDP().getTIPOEVOL().getUORG_X_UROG() != null) {
            strInicio = strInicio + COMILLAS_DOBLES + " organo=" + COMILLAS_DOBLES + String.valueOf(grafico.getDDP().getTIPOEVOL().getUORG_X_UROG().getUORGID());
        }
        if (grafico.getDDP().getTIPOEVOL().getUORG_X_UROG_COMP() != null) {
            strInicio = strInicio + COMILLAS_DOBLES + " organo_competente=" + COMILLAS_DOBLES + String.valueOf(grafico.getDDP().getTIPOEVOL().getUORG_X_UROG_COMP().getUORGID());
        }
        if (grafico.getDDP().getTIPOEVOL().getUORG_X_UROG_RES() != null) {
            strInicio = strInicio + COMILLAS_DOBLES + " organo_resuelve=" + COMILLAS_DOBLES + String.valueOf(grafico.getDDP().getTIPOEVOL().getUORG_X_UROG_RES().getUORGID());
        }
        if (grafico.getDDP().getTIPOEVOL().getUORG_X_UROG_TRAM() != null) {
            strInicio = strInicio + COMILLAS_DOBLES + " organo_tramita=" + COMILLAS_DOBLES + String.valueOf(grafico.getDDP().getTIPOEVOL().getUORG_X_UROG_TRAM().getUORGID());
        }
        if (grafico.getDDP().getTIPOEVOL().getMotorTramita() != null && !grafico.getDDP().getTIPOEVOL().getMotorTramita().equals("")) {
            strInicio = strInicio + COMILLAS_DOBLES + " motor_tramita=" + COMILLAS_DOBLES + CodificadorAtributosXML.codificar(grafico.getDDP().getTIPOEVOL().getMotorTramita());
        }
        strInicio = strInicio + COMILLAS_DOBLES + " informar=" + COMILLAS_DOBLES + grafico.getDDP().getTIPOEVOL().getINFORMAR();
        if (grafico.getDDP().getTIPOEVOL().getDESCRIPCION_AMP() != null && !grafico.getDDP().getTIPOEVOL().getDESCRIPCION_AMP().equals("")) {
            strInicio = strInicio + COMILLAS_DOBLES + " descrip_ampliada=" + COMILLAS_DOBLES + CodificadorAtributosXML.codificar(grafico.getDDP().getTIPOEVOL().getDESCRIPCION_AMP());
        }
        strInicio = strInicio + COMILLAS_DOBLES + " vigente=" + COMILLAS_DOBLES + grafico.getDDP().getTIPOEVOL().getVIGENTE();
        if (grafico.getDDP().getTIPOEVOL().getCATEGORIA() != null && grafico.getDDP().getTIPOEVOL().getCATEGORIA().getTipoCategoria() != null && !grafico.getDDP().getTIPOEVOL().getCATEGORIA().getTipoCategoria().equals("")) {
            strInicio = strInicio + COMILLAS_DOBLES + " categoria=" + COMILLAS_DOBLES + CodificadorAtributosXML.codificar(grafico.getDDP().getTIPOEVOL().getCATEGORIA().getTipoCategoria());
        }
        if (grafico.getDDP().getTIPOEVOL().getFamilia() != null && !grafico.getDDP().getTIPOEVOL().getFamilia().equals("")) {
            strInicio = strInicio + COMILLAS_DOBLES + " familia=" + COMILLAS_DOBLES + CodificadorAtributosXML.codificar(grafico.getDDP().getTIPOEVOL().getFamilia());
        }
        if (grafico.getDDP().getTIPOEVOL().getDescripcionFamilia() != null && !grafico.getDDP().getTIPOEVOL().getDescripcionFamilia().equals("")) {
            strInicio = strInicio + COMILLAS_DOBLES + " desc_familia=" + COMILLAS_DOBLES + CodificadorAtributosXML.codificar(grafico.getDDP().getTIPOEVOL().getDescripcionFamilia());
        }
        if (grafico.getDDP().getTIPOEVOL().getSubfamilia() != null && !grafico.getDDP().getTIPOEVOL().getSubfamilia().equals("")) {
            strInicio = strInicio + COMILLAS_DOBLES + " subfamilia=" + COMILLAS_DOBLES + CodificadorAtributosXML.codificar(grafico.getDDP().getTIPOEVOL().getSubfamilia());
        }
        if (grafico.getDDP().getTIPOEVOL().getDescripcionSubfamilia() != null && !grafico.getDDP().getTIPOEVOL().getDescripcionSubfamilia().equals("")) {
            strInicio = strInicio + COMILLAS_DOBLES + " desc_subfamilia=" + COMILLAS_DOBLES + CodificadorAtributosXML.codificar(grafico.getDDP().getTIPOEVOL().getDescripcionSubfamilia());
        }
        if (grafico.getDDP().getTIPOEVOL().getComentarios() != null && !grafico.getDDP().getTIPOEVOL().getComentarios().equals("")) {
            strInicio = strInicio + COMILLAS_DOBLES + " comentarios=" + COMILLAS_DOBLES + CodificadorAtributosXML.codificar(grafico.getDDP().getTIPOEVOL().getComentarios());
        }
        if (!this.bCerrandoDefinicion) {
            strInicio = strInicio + COMILLAS_DOBLES + " editable=" + COMILLAS_DOBLES + grafico.isEditableToString();
        }
        if (!this.escribir(strInicio = strInicio + COMILLAS_DOBLES + ">")) {
            return false;
        }
        if (!this.generarCuerpoXML(grafico)) {
            return false;
        }
        this.bGenerarInformacionGrafica = grafico.existeInfoGraf();
        if (this.bGenerarInformacionGrafica) {
            this.m_ValidadorDefProc.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_CORRECTO, "Exportando informaci\u00f3n gr\u00e1fica", "", "", "")));
            if (!this.generarCuerpoGraficoXML(grafico)) {
                return false;
            }
        }
        return !(grafico.getDDPPadre() == null ? !this.escribir("</" + this.strCabeceraDEF_PROC + ">") : (ModelaConf.isCompatibleTrewa0() ? !this.escribir("</DEF_PROCEDIMIENTO_R>") : !this.escribir("</DEF_PROCEDIMIENTO>")));
    }

    public boolean generarCabecera() {
        if (this.archivoSalida == null) {
            return false;
        }
        try {
            Timestamp horaControl = new Timestamp(System.currentTimeMillis());
            String strHoraControl = String.valueOf(horaControl.getSeconds() * this.BASE_GENERADORA_CONTROL) + "\u00b7";
            strHoraControl = strHoraControl + String.valueOf(horaControl.getMinutes() * this.BASE_GENERADORA_CONTROL) + "\u00b7";
            strHoraControl = strHoraControl + String.valueOf(horaControl.getHours() * this.BASE_GENERADORA_CONTROL);
            this.archivoSalida.println("<?xml version='1.0' encoding='" + ModelaConf.getEncoding() + "' ?>");
            this.archivoSalida.println("<!--Generado desde Model@ v" + ModelaConf.obtenerVersion() + " [" + strHoraControl + "]-->");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean generarCuerpoXML(DDPGrafico grafico) {
        ConjuntoDatosTransicion cdTransicionAux;
        ConjuntoDatosModela cdMetafasesAux;
        String strXML;
        String strXML2;
        ConjuntoDatosModela cdBloquesAux;
        String strXML3;
        if (grafico == null) {
            return false;
        }
        if (grafico.getDDP() == null) {
            return false;
        }
        if (grafico.getDDP().getDDPGID() == null) {
            return false;
        }
        if (grafico.getDDP().getTIPOEVOL() == null) {
            return false;
        }
        ConjuntoDatosModela cdPerfilesAux = this.getPerfilesUsuarioInvolucrados(grafico);
        if (cdPerfilesAux != null && cdPerfilesAux.obtenerNumRegistros() > 0 && !this.escribir(strXML3 = cdPerfilesAux.toXML())) {
            return false;
        }
        ConjuntoDatosModela cdParametrosAux = this.getParametrosInvolucrados(grafico);
        if (cdParametrosAux != null && cdParametrosAux.obtenerNumRegistros() > 0) {
            if (!this.escribir("<PARAMETROS>")) {
                return false;
            }
            String strXML4 = null;
            String strAuxXML = null;
            if (cdParametrosAux.getListaDatos() == null) {
                return false;
            }
            ArrayList vDatos = cdParametrosAux.getListaDatos();
            TrParametro trParametro = null;
            for (int j = 0; j < vDatos.size(); ++j) {
                strXML4 = "";
                trParametro = (TrParametro)vDatos.get(j);
                strAuxXML = trParametro.toXML();
                if (strAuxXML == null || this.escribir(strXML4 = strXML4 + strAuxXML)) continue;
                return false;
            }
            if (!this.escribir("</PARAMETROS>")) {
                return false;
            }
        }
        if ((cdBloquesAux = this.getBloquesInvolucrados(grafico)) != null && cdBloquesAux.obtenerNumRegistros() > 0) {
            if (!this.escribir("<BLOQUES>")) {
                return false;
            }
            String strXML5 = null;
            String strAuxXML = null;
            if (cdBloquesAux.getListaDatos() == null) {
                return false;
            }
            ArrayList vDatos = cdBloquesAux.getListaDatos();
            TrBloque trBloque = null;
            for (int j = 0; j < vDatos.size(); ++j) {
                strXML5 = "";
                trBloque = (TrBloque)vDatos.get(j);
                strAuxXML = trBloque.toXML();
                if (strAuxXML == null || this.escribir(strXML5 = strXML5 + strAuxXML)) continue;
                return false;
            }
            if (!this.escribir("</BLOQUES>")) {
                return false;
            }
        }
        this.generarCuerpoTipoParrafosXML(grafico);
        this.generarCuerpoPlantillasXML(grafico);
        ConjuntoDatosTipoActo cdTiposActoAux = this.getTiposActoInvolucrados(grafico);
        if (cdTiposActoAux != null && cdTiposActoAux.obtenerNumRegistros() > 0) {
            if (!this.escribir("<TIPOS_ACTO>")) {
                return false;
            }
            ArrayList listaTiposActo = cdTiposActoAux.getListaDatos();
            for (int i = 0; i < listaTiposActo.size(); ++i) {
                if (this.escribir(((TrTipoActo)listaTiposActo.get(i)).toXML())) continue;
                return false;
            }
            if (!this.escribir("</TIPOS_ACTO>")) {
                return false;
            }
        }
        this.generarCuerpoVariablesXML(grafico);
        this.generarCuerpoTipoDocumentosXML(grafico);
        this.generarCuerpoTareasXML(grafico);
        ConjuntoDatosModela cdCondicionesAux = this.getCondicionesInvolucradas(grafico);
        if (cdCondicionesAux != null && cdCondicionesAux.obtenerNumRegistros() > 0 && !this.escribir(strXML2 = ((ConjuntoDatosCondicion)cdCondicionesAux).toXML())) {
            return false;
        }
        ConjuntoDatosModela cdAccionesAux = this.getAccionesInvolucradas(grafico);
        if (cdAccionesAux != null && cdAccionesAux.obtenerNumRegistros() > 0 && !this.escribir(strXML = ((ConjuntoDatosAccion)cdAccionesAux).toXML())) {
            return false;
        }
        this.generarCuerpoAvisosXML(grafico);
        ArrayList arrReutilizables = new ArrayList();
        DDPGrafico ddpReutilizable = null;
        arrReutilizables = grafico.obtenerReutilizablesAsociados(this.bCerrandoDefinicion);
        if (arrReutilizables.size() > 0 && !ModelaConf.isCompatibleTrewa0()) {
            if (!this.escribir("<DEF_PROCEDIMIENTOS_R>")) {
                return false;
            }
            ++this.nEtiquetas;
        }
        for (int r = 0; r < arrReutilizables.size(); ++r) {
            ddpReutilizable = (DDPGrafico)arrReutilizables.get(r);
            this.generarXML(ddpReutilizable);
        }
        if (arrReutilizables.size() > 0 && !ModelaConf.isCompatibleTrewa0() && this.nEtiquetas > 0) {
            if (!this.escribir("</DEF_PROCEDIMIENTOS_R>")) {
                return false;
            }
            --this.nEtiquetas;
        }
        if ((cdMetafasesAux = this.getMetafasesInvolucradas(grafico)) != null && cdMetafasesAux.obtenerNumRegistros() > 0) {
            if (!this.escribir("<METAFASES>")) {
                return false;
            }
            if (cdMetafasesAux.obtenerNumRegistros() > 0) {
                ArrayList listaMetafases = cdMetafasesAux.getListaDatos();
                for (int i = 0; i < listaMetafases.size(); ++i) {
                    this.generarCuerpoXMLFasesEnMetafase((TrMetafase)listaMetafases.get(i), grafico);
                }
            }
            if (!this.escribir("</METAFASES>")) {
                return false;
            }
        }
        if ((cdTransicionAux = this.getTransicionesInvolucradas(grafico)) != null) {
            if (cdTransicionAux.obtenerNumRegistros() > 0) {
                String strXML6 = cdTransicionAux.toXML(grafico.getTransicionesDelProcInvolucradas());
                if (!this.escribir(strXML6)) {
                    return false;
                }
                if (this.bCerrandoDefinicion && grafico.getTransicionesDelProcInvolucradas() != null) {
                    ConjuntoDatosTransicionDefProcedimiento cdValidar = grafico.getTransicionesDelProcInvolucradas();
                    TrTransicionDefProcedimiento trAux = null;
                    for (int t = 0; t < cdValidar.obtenerNumRegistros(); ++t) {
                        int ac;
                        trAux = (TrTransicionDefProcedimiento)cdValidar.getListaDatos().get(t);
                        if ((trAux.getConjuntoPerfilTransEvol() == null || trAux.getConjuntoPerfilTransEvol().getListaDatos() == null || trAux.getConjuntoPerfilTransEvol().getListaDatos().size() < 1) && trAux.getTransicion() != null) {
                            this.m_ValidadorDefProc.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Transici\u00f3n sin perfiles asociados", "Transici\u00f3n", trAux.getTransicion().getETIQUETA(), "Compruebe que no ha olvidado asociar perfiles a esta transici\u00f3n")));
                        }
                        if (trAux.getTransicion() == null) continue;
                        if (grafico.getCanvas() != null && grafico.getCanvas().localizarGraficosTransicion(trAux.getTransicion()).size() < 1) {
                            this.m_ValidadorDefProc.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Transici\u00f3n sin dibujar en el procedimiento", "Transici\u00f3n", trAux.getTransicion().getETIQUETA(), "Compruebe que no ha olvidado representar gr\u00e1ficamente esta transici\u00f3n en su procedimiento")));
                        }
                        if (!trAux.getTransicion().isValida()) {
                            this.m_ValidadorDefProc.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Transici\u00f3n marcada como no v\u00e1lida", "Transici\u00f3n", trAux.getTransicion().getETIQUETA(), "Compruebe que no ha olvidado eliminar esta transici\u00f3n. Los elementos no v\u00e1lidos pueden crear conflictos al importar el procedimiento en las HAT")));
                        }
                        if (trAux.getConjuntoAccionTransicion() != null && trAux.getConjuntoAccionTransicion().getListaDatos() != null) {
                            for (ac = 0; ac < trAux.getConjuntoAccionTransicion().getListaDatos().size(); ++ac) {
                                TrAccionTransicion accionTransiAux = (TrAccionTransicion)trAux.getConjuntoAccionTransicion().getListaDatos().get(ac);
                                if (accionTransiAux == null || accionTransiAux.isValida()) continue;
                                this.m_ValidadorDefProc.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Acci\u00f3n marcada como no v\u00e1lida", "Acci\u00f3n en Transici\u00f3n", accionTransiAux.getNombre() + " [ en " + trAux.getNombre() + " ]", "Compruebe que no ha olvidado eliminar esta acci\u00f3n. Los elementos no v\u00e1lidos pueden crear conflictos al importar el procedimiento en las HAT")));
                            }
                        }
                        if (trAux.getConjuntoCondicionTransicion() != null && trAux.getConjuntoCondicionTransicion().getListaDatos() != null) {
                            for (ac = 0; ac < trAux.getConjuntoCondicionTransicion().getListaDatos().size(); ++ac) {
                                TrCondicionTransicion condicionTransiAux = (TrCondicionTransicion)trAux.getConjuntoCondicionTransicion().getListaDatos().get(ac);
                                if (condicionTransiAux == null || condicionTransiAux.isValida()) continue;
                                this.m_ValidadorDefProc.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Condici\u00f3n marcada como no v\u00e1lida", "Condici\u00f3n en Transici\u00f3n", condicionTransiAux.getNombre() + " [ en " + trAux.getNombre() + " ]", "Compruebe que no ha olvidado eliminar esta acci\u00f3n. Los elementos no v\u00e1lidos pueden crear conflictos al importar el procedimiento en las HAT")));
                            }
                        }
                        if (trAux.getConjuntoAvisoTransicion() == null || trAux.getConjuntoAvisoTransicion().getListaDatos() == null) continue;
                        for (ac = 0; ac < trAux.getConjuntoAvisoTransicion().getListaDatos().size(); ++ac) {
                            TrAvisoTransicion avisoTransiAux = (TrAvisoTransicion)trAux.getConjuntoAvisoTransicion().getListaDatos().get(ac);
                            if (avisoTransiAux == null || avisoTransiAux.isValida()) continue;
                            this.m_ValidadorDefProc.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Aviso marcado como no v\u00e1lido", "Aviso en Transici\u00f3n", avisoTransiAux.getNombre() + " [ en " + trAux.getNombre() + " ]", "Compruebe que no ha olvidado eliminar este aviso. Los elementos no v\u00e1lidos pueden crear conflictos al importar el procedimiento en las HAT")));
                        }
                    }
                }
            }
            this.validarTransiciones(grafico);
        }
        this.generarCuerpoTareasEnFaseXML(grafico);
        boolean bExistenCondicionesTransicion = false;
        boolean bExistenCondicionesTareaEnFase = false;
        bExistenCondicionesTransicion = grafico.existenCondicionesTransicion();
        bExistenCondicionesTareaEnFase = grafico.existenCondicionesTareaEnFase();
        if ((bExistenCondicionesTransicion || bExistenCondicionesTareaEnFase) && !this.escribir("<CONDICIONES_TRAMITACION>")) {
            return false;
        }
        if (bExistenCondicionesTransicion) {
            this.generarCuerpoCondicionesTransicionXML(grafico);
        }
        if (bExistenCondicionesTareaEnFase) {
            this.generarCuerpoCondicionesTareaEnFaseXML(grafico);
        }
        if ((bExistenCondicionesTransicion || bExistenCondicionesTareaEnFase) && !this.escribir("</CONDICIONES_TRAMITACION>")) {
            return false;
        }
        boolean bExistenAccionesTransicion = false;
        boolean bExistenAccionesTareaEnFase = false;
        bExistenAccionesTransicion = grafico.existenAccionesTransicion();
        bExistenAccionesTareaEnFase = grafico.existenAccionesTareaEnFase();
        if ((bExistenAccionesTransicion || bExistenAccionesTareaEnFase) && !this.escribir("<ACCIONES_TRAMITACION>")) {
            return false;
        }
        if (bExistenAccionesTransicion) {
            this.generarCuerpoAccionesTransicionXML(grafico);
        }
        if (bExistenAccionesTareaEnFase) {
            this.generarCuerpoAccionesTareaEnFaseXML(grafico);
        }
        if ((bExistenAccionesTransicion || bExistenAccionesTareaEnFase) && !this.escribir("</ACCIONES_TRAMITACION>")) {
            return false;
        }
        boolean bExistenAvisosTransicion = false;
        boolean bExistenAvisosTareaEnFase = false;
        bExistenAvisosTransicion = grafico.existenAvisosTransicion();
        bExistenAvisosTareaEnFase = grafico.existenAvisosTareaEnFase();
        if ((bExistenAvisosTransicion || bExistenAvisosTareaEnFase) && !this.escribir("<AVISOS_TRAMITACION>")) {
            return false;
        }
        if (bExistenAvisosTransicion) {
            this.generarCuerpoAvisosTransicionXML(grafico);
        }
        if (bExistenAvisosTareaEnFase) {
            this.generarCuerpoAvisosTareaEnFaseXML(grafico);
        }
        if ((bExistenAvisosTransicion || bExistenAvisosTareaEnFase) && !this.escribir("</AVISOS_TRAMITACION>")) {
            return false;
        }
        this.generarCuerpoControlPlazosXML(grafico);
        this.generarCuerpoTiposOrganismoXML(grafico);
        this.generarCuerpoOrganismosXML(grafico);
        this.generarCuerpoOrganismosProcXML(grafico);
        this.generarCuerpoTiposIndicacionXML(grafico);
        this.generarCuerpoFichasXML(grafico);
        this.generarCuerpoTiposNormativaXML(grafico);
        this.generarCuerpoTiposPublicacionXML(grafico);
        this.generarCuerpoAmbitosLeyXML(grafico);
        this.generarCuerpoNormativasXML(grafico);
        this.generarCuerpoNormativasDefProcXML(grafico);
        this.generarCuerpoPlantillasProcXML(grafico);
        return true;
    }

    public boolean generarCuerpoXMLFasesEnMetafase(TrMetafase metafase, DDPGrafico grafico) {
        if (metafase == null) {
            return false;
        }
        boolean bExistenFases = false;
        if (!this.escribir(metafase.toXMLCabecera())) {
            return false;
        }
        if (this.getFasesInvolucradas(grafico) != null && this.getFasesInvolucradas(grafico).obtenerNumRegistros() > 0) {
            ArrayList listaFases = this.getFasesInvolucradas(grafico).getListaDatos();
            for (int i = 0; i < listaFases.size(); ++i) {
                TrFase fase = (TrFase)listaFases.get(i);
                if (fase.getMETAFASE() == null || !fase.getMETAFASE().getNOMBRE().equals(metafase.getNOMBRE())) continue;
                if (!bExistenFases) {
                    if (!this.escribir("<FASES>")) {
                        return false;
                    }
                    bExistenFases = true;
                }
                if (this.escribir(fase.toXML())) continue;
                return false;
            }
            if (bExistenFases && !this.escribir("</FASES>")) {
                return false;
            }
        }
        if (ModelaConf.isCompatibleTrewa0() && !bExistenFases) {
            if (!this.escribir("<FASES>")) {
                return false;
            }
            if (!this.escribir("</FASES>")) {
                return false;
            }
        }
        return this.escribir(metafase.toXMLFinMetafase());
    }

    public boolean generarCuerpoGraficoXML(DDPGrafico grafico) {
        String strInicio = "<DEFPROC_GR id=" + COMILLAS_DOBLES + String.valueOf(grafico.getDDP().getDDPGID().longValue());
        String strTituloReu = "DDP Reutilizable";
        strTituloReu = grafico.getDDP().getTITULO() != null ? grafico.getDDP().getTITULO() : grafico.getDDP().getTIPOEVOL().getDESCRIPCION();
        if (!this.escribir(strInicio = strInicio + COMILLAS_DOBLES + " titulo=" + COMILLAS_DOBLES + CodificadorAtributosXML.codificar(strTituloReu) + COMILLAS_DOBLES + ">")) {
            return false;
        }
        if (!this.generarCuerpoMetafasesGrXML(grafico)) {
            return false;
        }
        if (!this.generarCuerpoExtremosTransicionXML(grafico)) {
            return false;
        }
        if (!this.generarCuerpoTransicionXML(grafico)) {
            return false;
        }
        if (!this.generarCuerpoPostItXML(grafico)) {
            return false;
        }
        return this.escribir("</DEFPROC_GR>");
    }

    public boolean generarCuerpoMetafasesGrXML(DDPGrafico grafico) {
        if (this.getMetafasesInvolucradas(grafico) == null) {
            return false;
        }
        if (this.getMetafasesInvolucradas(grafico).getListaDatos() == null) {
            return false;
        }
        if (this.getMetafasesInvolucradas(grafico).getListaDatos().size() < 1) {
            return false;
        }
        String strEtiquetaIni = new String("<GRAFICOS_METAFASE>");
        String strEtiquetaFin = new String("</GRAFICOS_METAFASE>");
        if (!this.escribir(strEtiquetaIni)) {
            return false;
        }
        for (int n = 0; n < this.getMetafasesInvolucradas(grafico).getListaDatos().size(); ++n) {
            TrMetafase metafaseAux = new TrMetafase();
            TrMetafaseGr metafaseGrAux = new TrMetafaseGr();
            metafaseAux = (TrMetafase)this.getMetafasesInvolucradas(grafico).getListaDatos().get(n);
            if (metafaseAux == null) {
                return false;
            }
            metafaseGrAux = metafaseAux.getPropiedadesGraficas();
            if (metafaseGrAux == null) {
                return false;
            }
            if (this.escribir(metafaseGrAux.toXML(metafaseAux.getMETAID()))) continue;
            return false;
        }
        return this.escribir(strEtiquetaFin);
    }

    public boolean generarCuerpoExtremosTransicionXML(DDPGrafico grafico) {
        if (grafico.getCanvas() == null) {
            return false;
        }
        String strInicio = "<GRAFICOS_EXTREMOS_TRANSICION>";
        if (!this.escribir(strInicio)) {
            return false;
        }
        PLayer lyr = grafico.getCanvas().getLayer();
        if (lyr != null) {
            ArrayList<PNodoGrafico> nodosErroneos = new ArrayList<PNodoGrafico>();
            int nNum = lyr.getChildrenCount();
            for (int i = 0; i < nNum; ++i) {
                if (lyr.getChild(i) instanceof PLayer || !(lyr.getChild(i) instanceof PNodoGrafico) || lyr.getChild(i) instanceof PostItPNode) continue;
                PNodoGrafico pNodo = (PNodoGrafico)lyr.getChild(i);
                if (!pNodo.getTipo().equals("FA")) {
                    if (this.comprobarExistExtremoTransGr(grafico, pNodo.getTrFaseGrAsociada().getID().longValue()) == null) {
                        nodosErroneos.add(pNodo);
                        continue;
                    }
                    this.escribir(pNodo.toXMLCabecera());
                    continue;
                }
                if (pNodo.getTrFaseGrAsociada() != null) {
                    if (pNodo.getTrFaseGrAsociada().getTrFase() != null) {
                        if (!this.comprobarExisteFase(grafico, pNodo.getTrFaseGrAsociada().getTrFase().getFASEID().longValue())) {
                            nodosErroneos.add(pNodo);
                            continue;
                        }
                        this.escribir(pNodo.toXMLCabecera());
                        continue;
                    }
                    nodosErroneos.add(pNodo);
                    continue;
                }
                nodosErroneos.add(pNodo);
            }
            this.eliminarNodosErroneos(grafico, nodosErroneos);
        }
        return this.escribir("</GRAFICOS_EXTREMOS_TRANSICION>");
    }

    public boolean generarCuerpoTransicionXML(DDPGrafico grafico) {
        String strInicio = "<GRAFICOS_TRANSICION>";
        if (grafico.getCanvas() == null) {
            return false;
        }
        if (!this.escribir(strInicio)) {
            return false;
        }
        PLayer lyr = grafico.getCanvas().getLayer();
        if (lyr != null) {
            int nNum = lyr.getChildrenCount();
            for (int i = 0; i < nNum; ++i) {
                if (lyr.getChild(i) instanceof PLayer || !(lyr.getChild(i) instanceof TransicionPNode)) continue;
                TransicionPNode pNodo = (TransicionPNode)lyr.getChild(i);
                this.escribir(pNodo.toXMLCabecera());
            }
        }
        return this.escribir("</GRAFICOS_TRANSICION>");
    }

    public void run() {
    }

    public boolean generarCuerpoTareasXML(DDPGrafico grafico) {
        ConjuntoDatosTarea cdTareasAux = this.getTareasInvolucradas(grafico);
        if (cdTareasAux != null && cdTareasAux.obtenerNumRegistros() > 0) {
            String strXML = cdTareasAux.toXML();
            return this.escribir(strXML);
        }
        return false;
    }

    public boolean generarCuerpoAvisosXML(DDPGrafico grafico) {
        ConjuntoDatosModela cdAvisosAux = this.getAvisosInvolucrados(grafico);
        if (cdAvisosAux != null && cdAvisosAux.obtenerNumRegistros() > 0) {
            ArrayList vDatos = cdAvisosAux.getListaDatos();
            TrAviso aviso = null;
            if (!this.escribir("<AVISOS>")) {
                return false;
            }
            for (int j = 0; j < vDatos.size(); ++j) {
                String strXML = "";
                aviso = (TrAviso)vDatos.get(j);
                String strAuxXML = aviso.toXML();
                if (strAuxXML != null) {
                    if (this.escribir(strXML = strXML + strAuxXML)) continue;
                    return false;
                }
                return false;
            }
            return this.escribir("</AVISOS>");
        }
        return false;
    }

    public boolean generarCuerpoPlantillasXML(DDPGrafico grafico) {
        ConjuntoDatosModela cdPlantillasAux = this.getPlantillasInvolucradas(grafico);
        if (cdPlantillasAux != null && cdPlantillasAux.obtenerNumRegistros() > 0) {
            ArrayList vDatos = cdPlantillasAux.getListaDatos();
            TrPlantilla plantilla = null;
            if (!this.escribir("<PLANTILLAS>")) {
                return false;
            }
            for (int j = 0; j < vDatos.size(); ++j) {
                String strXML = "";
                plantilla = (TrPlantilla)vDatos.get(j);
                String strAuxXML = plantilla.toXML();
                if (strAuxXML != null) {
                    if (this.escribir(strXML = strXML + strAuxXML)) continue;
                    return false;
                }
                return false;
            }
            return this.escribir("</PLANTILLAS>");
        }
        return false;
    }

    public boolean generarCuerpoTipoParrafosXML(DDPGrafico grafico) {
        if (this.m_ValidadorDefProc == null) {
            return false;
        }
        ConjuntoDatosModela cdTiposParrafoAux = this.getTipoParrafosInvolucrados(grafico);
        if (cdTiposParrafoAux != null && cdTiposParrafoAux.obtenerNumRegistros() > 0) {
            ArrayList vDatos = cdTiposParrafoAux.getListaDatos();
            TrTipoParrafo tipoParrafo = null;
            if (!this.escribir("<TIPOS_PARRAFOS>")) {
                return false;
            }
            for (int j = 0; j < vDatos.size(); ++j) {
                String strXML = "";
                tipoParrafo = (TrTipoParrafo)vDatos.get(j);
                String strAuxXML = tipoParrafo.toXML(this.bCerrandoDefinicion);
                if (strAuxXML != null) {
                    if (!this.escribir(strXML = strXML + strAuxXML)) {
                        return false;
                    }
                } else {
                    return false;
                }
                if (tipoParrafo.getNombreFichero() == null || tipoParrafo.getNombreFichero().equals("")) continue;
                this.m_ValidadorDefProc.copiarArchivo(tipoParrafo.getRutaCompleta(), this.strOrigenXML, ModelaConf.getRutaArchivo(), tipoParrafo.getNombreFichero(), "Tipo de p\u00e1rrafo", tipoParrafo.getNombre(), false);
            }
            return this.escribir("</TIPOS_PARRAFOS>");
        }
        return false;
    }

    public boolean generarCuerpoTipoDocumentosXML(DDPGrafico grafico) {
        if (this.m_ValidadorDefProc == null) {
            return false;
        }
        ConjuntoDatosModela cdTiposDocumentoAux = this.getTipoDocumentosInvolucrados(grafico);
        if (cdTiposDocumentoAux != null && cdTiposDocumentoAux.obtenerNumRegistros() > 0) {
            ArrayList vDatos = cdTiposDocumentoAux.getListaDatos();
            TrTipoDocumento tipoDocumento = null;
            if (!this.escribir("<TIPOS_DOCUMENTOS>")) {
                return false;
            }
            for (int j = 0; j < vDatos.size(); ++j) {
                String strXML = "";
                tipoDocumento = (TrTipoDocumento)vDatos.get(j);
                String strAuxXML = tipoDocumento.toXML(this.bCerrandoDefinicion);
                if (strAuxXML != null) {
                    if (!this.escribir(strXML = strXML + strAuxXML)) {
                        return false;
                    }
                } else {
                    return false;
                }
                if (tipoDocumento.getT_Nom_Fichero() != null && !tipoDocumento.getT_Nom_Fichero().equals("")) {
                    this.m_ValidadorDefProc.copiarArchivo(tipoDocumento.getRuta(), this.strOrigenXML, ModelaConf.getRutaArchivo(), tipoDocumento.getT_Nom_Fichero(), "Tipo de documento - Plantilla Office", tipoDocumento.getNombre(), true);
                } else if (tipoDocumento.getVariables() != null && tipoDocumento.getVariables().size() > 0) {
                    this.m_ValidadorDefProc.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Tipo de documento con variables pero sin plantilla binaria Open Office asociada", "Tipo documento", tipoDocumento.getNombre(), "Compruebe que no ha olvidado asociar una plantilla binaria Open Office")));
                }
                if (tipoDocumento.getParrafoTipoDoc() == null) continue;
                for (int i = 0; i < tipoDocumento.getParrafoTipoDoc().size(); ++i) {
                    TrParrafoTipDoc parrafo = (TrParrafoTipDoc)tipoDocumento.getParrafoTipoDoc().get(i);
                    if (parrafo.getNOMB_FICHERO() == null || parrafo.getNOMB_FICHERO().equals("")) continue;
                    this.m_ValidadorDefProc.copiarArchivo(parrafo.getRutaCompleta(), this.strOrigenXML, ModelaConf.getRutaArchivo(), parrafo.getNOMB_FICHERO(), "P\u00e1rrafo del tipo de documento", parrafo.getNombre(), false);
                }
            }
            return this.escribir("</TIPOS_DOCUMENTOS>");
        }
        return false;
    }

    public boolean generarCuerpoVariablesXML(DDPGrafico grafico) {
        ConjuntoDatosModela cdVariablesAux = this.getVariablesInvolucradas(grafico);
        if (cdVariablesAux != null && cdVariablesAux.obtenerNumRegistros() > 0) {
            ArrayList vDatos = cdVariablesAux.getListaDatos();
            TrVariable variable = null;
            if (!this.escribir("<VARIABLES>")) {
                return false;
            }
            for (int j = 0; j < vDatos.size(); ++j) {
                String strXML = "";
                variable = (TrVariable)vDatos.get(j);
                String strAuxXML = variable.toXML();
                if (strAuxXML != null) {
                    if (this.escribir(strXML = strXML + strAuxXML)) continue;
                    return false;
                }
                return false;
            }
            return this.escribir("</VARIABLES>");
        }
        return false;
    }

    public boolean generarCuerpoTareasEnFaseXML(DDPGrafico grafico) {
        boolean bProcesarTareasFase = true;
        if (this.m_ValidadorDefProc == null) {
            return false;
        }
        if (grafico.getTareaFaseDefProcInvolucradas() == null) {
            bProcesarTareasFase = false;
        }
        if (grafico.getTareaFaseDefProcInvolucradas().getListaDatos() == null) {
            bProcesarTareasFase = false;
        }
        if (grafico.getTareaFaseDefProcInvolucradas().getListaDatos().size() < 1) {
            bProcesarTareasFase = false;
        }
        if (bProcesarTareasFase) {
            ArrayList listaTareasFaseProc = grafico.getTareaFaseDefProcInvolucradas().getListaDatos();
            TrTareaEnFaseDefProcedimiento tareaFase = null;
            String strXML = "";
            ConjuntoDatosTareaEnFase cdTareasEnFase = new ConjuntoDatosTareaEnFase();
            ArrayList<TrTareaEnFase> listaTareasEnFaseFinal = new ArrayList<TrTareaEnFase>();
            cdTareasEnFase.setListaDatos(listaTareasEnFaseFinal);
            for (int n = 0; n < listaTareasFaseProc.size(); ++n) {
                tareaFase = (TrTareaEnFaseDefProcedimiento)listaTareasFaseProc.get(n);
                if (tareaFase.getTareaEnFase() == null || listaTareasEnFaseFinal.contains(tareaFase.getTareaEnFase())) continue;
                listaTareasEnFaseFinal.add(tareaFase.getTareaEnFase());
            }
            if (listaTareasEnFaseFinal.size() > 0) {
                strXML = "<TAREAS_FASE>";
                if (!this.escribir(strXML)) {
                    return false;
                }
                strXML = cdTareasEnFase.toXML(grafico.getTareaFaseDefProcInvolucradas());
                if (!this.escribir(strXML)) {
                    return false;
                }
                strXML = "</TAREAS_FASE>";
                if (!this.escribir(strXML)) {
                    return false;
                }
                if (this.bCerrandoDefinicion && grafico.getTareaFaseDefProcInvolucradas() != null) {
                    ConjuntoDatosTareaFaseDefProcedimiento cdValidar = grafico.getTareaFaseDefProcInvolucradas();
                    TrTareaEnFaseDefProcedimiento tareaAux = null;
                    String strAuxiliar = "";
                    for (int t = 0; t < cdValidar.obtenerNumRegistros(); ++t) {
                        int ac;
                        tareaAux = (TrTareaEnFaseDefProcedimiento)cdValidar.getListaDatos().get(t);
                        if (tareaAux.getConjuntoPerfilesTareaFase() != null && tareaAux.getConjuntoPerfilesTareaFase().getListaDatos() != null && tareaAux.getConjuntoPerfilesTareaFase().getListaDatos().size() >= 1) continue;
                        if (tareaAux.getTareaEnFase() != null) {
                            strAuxiliar = "";
                            if (tareaAux.getTareaEnFase().getFase() != null) {
                                strAuxiliar = " [ en " + tareaAux.getTareaEnFase().getFase() + " ]";
                            }
                            this.m_ValidadorDefProc.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Tarea en fase sin perfiles asociados", "Tarea en fase", tareaAux.getTareaEnFase().getETIQUETA() + strAuxiliar, "Compruebe que no ha olvidado asociar perfiles a esta tarea en fase")));
                        }
                        if (!tareaAux.getTareaEnFase().isValida()) {
                            this.m_ValidadorDefProc.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Tarea en fase marcada como no v\u00e1lida", "Tarea en fase", tareaAux.getTareaEnFase().getETIQUETA() + strAuxiliar, "Compruebe que no ha olvidado eliminar esta tarea en fase. Los elementos no v\u00e1lidos pueden crear conflictos al importar el procedimiento en las HAT")));
                        }
                        if (tareaAux.getConjuntoAccionTareaFase() != null && tareaAux.getConjuntoAccionTareaFase().getListaDatos() != null) {
                            for (ac = 0; ac < tareaAux.getConjuntoAccionTareaFase().getListaDatos().size(); ++ac) {
                                TrAccionTareaFase accionTareaAux = (TrAccionTareaFase)tareaAux.getConjuntoAccionTareaFase().getListaDatos().get(ac);
                                if (accionTareaAux == null || accionTareaAux.isValida()) continue;
                                this.m_ValidadorDefProc.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Acci\u00f3n marcada como no v\u00e1lida", "Acci\u00f3n en Tarea en Fase", accionTareaAux.getNombre() + " [ en " + tareaAux.getNombre() + " ]", "Compruebe que no ha olvidado eliminar esta acci\u00f3n. Los elementos no v\u00e1lidos pueden crear conflictos al importar el procedimiento en las HAT")));
                            }
                        }
                        if (tareaAux.getConjuntoCondicionTareaFase() != null && tareaAux.getConjuntoCondicionTareaFase().getListaDatos() != null) {
                            for (ac = 0; ac < tareaAux.getConjuntoCondicionTareaFase().getListaDatos().size(); ++ac) {
                                TrCondicionTareaFase condicionTareaAux = (TrCondicionTareaFase)tareaAux.getConjuntoCondicionTareaFase().getListaDatos().get(ac);
                                if (condicionTareaAux == null || condicionTareaAux.isValida()) continue;
                                this.m_ValidadorDefProc.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Condici\u00f3n marcada como no v\u00e1lida", "Condici\u00f3n en Tarea en Fase", condicionTareaAux.getNombre() + " [ en " + tareaAux.getNombre() + " ]", "Compruebe que no ha olvidado eliminar esta condici\u00f3n. Los elementos no v\u00e1lidos pueden crear conflictos al importar el procedimiento en las HAT")));
                            }
                        }
                        if (tareaAux.getConjuntoAvisoTareaFase() == null || tareaAux.getConjuntoAvisoTareaFase().getListaDatos() == null) continue;
                        for (ac = 0; ac < tareaAux.getConjuntoAvisoTareaFase().getListaDatos().size(); ++ac) {
                            TrAvisoTareaFase avisoTareaAux = (TrAvisoTareaFase)tareaAux.getConjuntoAvisoTareaFase().getListaDatos().get(ac);
                            if (avisoTareaAux == null || avisoTareaAux.isValida()) continue;
                            this.m_ValidadorDefProc.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Acci\u00f3n marcada como no v\u00e1lida", "Aviso en Tarea en Fase", avisoTareaAux.getNombre() + " [ en " + tareaAux.getNombre() + " ]", "Compruebe que no ha olvidado eliminar esta acci\u00f3n. Los elementos no v\u00e1lidos pueden crear conflictos al importar el procedimiento en las HAT")));
                        }
                    }
                }
            }
        }
        return true;
    }

    public boolean generarCuerpoCondicionesTransicionXML(DDPGrafico grafico) {
        if (grafico.getTransicionesDelProcInvolucradas() != null && grafico.getTransicionesDelProcInvolucradas().obtenerNumRegistros() > 0) {
            ArrayList vDatos = grafico.getTransicionesDelProcInvolucradas().getListaDatos();
            TrTransicionDefProcedimiento transicion = null;
            if (!this.escribir("<CONDICIONES_TRANSICION>")) {
                return false;
            }
            for (int j = 0; j < vDatos.size(); ++j) {
                String strXML = "";
                transicion = (TrTransicionDefProcedimiento)vDatos.get(j);
                if (transicion.getConjuntoCondicionTransicion() == null || transicion.getConjuntoCondicionTransicion().obtenerNumRegistros() <= 0) continue;
                ArrayList vDatosCondicion = transicion.getConjuntoCondicionTransicion().getListaDatos();
                TrCondicionTransicion condicion = null;
                for (int i = 0; i < vDatosCondicion.size(); ++i) {
                    strXML = "";
                    condicion = (TrCondicionTransicion)vDatosCondicion.get(i);
                    String strAuxXML = condicion.toXML(transicion.getTransicion().getTRANID());
                    if (strAuxXML != null) {
                        if (this.escribir(strXML = strXML + strAuxXML)) continue;
                        return false;
                    }
                    return false;
                }
            }
            return this.escribir("</CONDICIONES_TRANSICION>");
        }
        return false;
    }

    public boolean generarCuerpoCondicionesTareaEnFaseXML(DDPGrafico grafico) {
        if (grafico.getTareaFaseDefProcInvolucradas() != null && grafico.getTareaFaseDefProcInvolucradas().obtenerNumRegistros() > 0) {
            ArrayList vDatos = grafico.getTareaFaseDefProcInvolucradas().getListaDatos();
            TrTareaEnFaseDefProcedimiento tareaFase = null;
            if (!this.escribir("<CONDICIONES_TAREA>")) {
                return false;
            }
            for (int j = 0; j < vDatos.size(); ++j) {
                String strXML = "";
                tareaFase = (TrTareaEnFaseDefProcedimiento)vDatos.get(j);
                if (tareaFase.getConjuntoCondicionTareaFase() == null || tareaFase.getConjuntoCondicionTareaFase().obtenerNumRegistros() <= 0) continue;
                ArrayList vDatosCondicion = tareaFase.getConjuntoCondicionTareaFase().getListaDatos();
                TrCondicionTareaFase condicion = null;
                for (int i = 0; i < vDatosCondicion.size(); ++i) {
                    strXML = "";
                    condicion = (TrCondicionTareaFase)vDatosCondicion.get(i);
                    String strAuxXML = condicion.toXML(tareaFase.getTareaEnFase().getX_ID());
                    if (strAuxXML != null) {
                        if (this.escribir(strXML = strXML + strAuxXML)) continue;
                        return false;
                    }
                    return false;
                }
            }
            return this.escribir("</CONDICIONES_TAREA>");
        }
        return false;
    }

    public boolean generarCuerpoAccionesTransicionXML(DDPGrafico grafico) {
        if (grafico.getTransicionesDelProcInvolucradas() != null && grafico.getTransicionesDelProcInvolucradas().obtenerNumRegistros() > 0) {
            ArrayList vDatos = grafico.getTransicionesDelProcInvolucradas().getListaDatos();
            TrTransicionDefProcedimiento transicion = null;
            if (!this.escribir("<ACCIONES_TRANSICION>")) {
                return false;
            }
            for (int j = 0; j < vDatos.size(); ++j) {
                String strXML = "";
                transicion = (TrTransicionDefProcedimiento)vDatos.get(j);
                if (transicion.getConjuntoAccionTransicion() == null || transicion.getConjuntoAccionTransicion().obtenerNumRegistros() <= 0) continue;
                ArrayList vDatosAccion = transicion.getConjuntoAccionTransicion().getListaDatos();
                TrAccionTransicion accion = null;
                for (int i = 0; i < vDatosAccion.size(); ++i) {
                    strXML = "";
                    accion = (TrAccionTransicion)vDatosAccion.get(i);
                    String strAuxXML = accion.toXML(transicion.getTransicion().getTRANID());
                    if (strAuxXML != null) {
                        if (this.escribir(strXML = strXML + strAuxXML)) continue;
                        return false;
                    }
                    return false;
                }
            }
            return this.escribir("</ACCIONES_TRANSICION>");
        }
        return false;
    }

    public boolean generarCuerpoAccionesTareaEnFaseXML(DDPGrafico grafico) {
        if (grafico.getTareaFaseDefProcInvolucradas() != null && grafico.getTareaFaseDefProcInvolucradas().obtenerNumRegistros() > 0) {
            ArrayList vDatos = grafico.getTareaFaseDefProcInvolucradas().getListaDatos();
            TrTareaEnFaseDefProcedimiento tareaFase = null;
            if (!this.escribir("<ACCIONES_TAREA>")) {
                return false;
            }
            for (int j = 0; j < vDatos.size(); ++j) {
                String strXML = "";
                tareaFase = (TrTareaEnFaseDefProcedimiento)vDatos.get(j);
                if (tareaFase.getConjuntoAccionTareaFase() == null || tareaFase.getConjuntoAccionTareaFase().obtenerNumRegistros() <= 0) continue;
                ArrayList vDatosAccion = tareaFase.getConjuntoAccionTareaFase().getListaDatos();
                TrAccionTareaFase accion = null;
                for (int i = 0; i < vDatosAccion.size(); ++i) {
                    strXML = "";
                    accion = (TrAccionTareaFase)vDatosAccion.get(i);
                    String strAuxXML = accion.toXML(tareaFase.getTareaEnFase().getX_ID());
                    if (strAuxXML != null) {
                        if (this.escribir(strXML = strXML + strAuxXML)) continue;
                        return false;
                    }
                    return false;
                }
            }
            return this.escribir("</ACCIONES_TAREA>");
        }
        return false;
    }

    public boolean generarCuerpoAvisosTransicionXML(DDPGrafico grafico) {
        if (grafico.getTransicionesDelProcInvolucradas() != null && grafico.getTransicionesDelProcInvolucradas().obtenerNumRegistros() > 0) {
            ArrayList vDatos = grafico.getTransicionesDelProcInvolucradas().getListaDatos();
            TrTransicionDefProcedimiento transicion = null;
            if (!this.escribir("<AVISOS_TRANSICION>")) {
                return false;
            }
            for (int j = 0; j < vDatos.size(); ++j) {
                String strXML = "";
                transicion = (TrTransicionDefProcedimiento)vDatos.get(j);
                if (transicion.getConjuntoAvisoTransicion() == null || transicion.getConjuntoAvisoTransicion().obtenerNumRegistros() <= 0) continue;
                ArrayList vDatosAviso = transicion.getConjuntoAvisoTransicion().getListaDatos();
                TrAvisoTransicion aviso = null;
                for (int i = 0; i < vDatosAviso.size(); ++i) {
                    strXML = "";
                    aviso = (TrAvisoTransicion)vDatosAviso.get(i);
                    String strAuxXML = aviso.toXML(transicion.getTransicion().getTRANID());
                    if (strAuxXML != null) {
                        if (this.escribir(strXML = strXML + strAuxXML)) continue;
                        return false;
                    }
                    return false;
                }
            }
            return this.escribir("</AVISOS_TRANSICION>");
        }
        return false;
    }

    public boolean generarCuerpoAvisosTareaEnFaseXML(DDPGrafico grafico) {
        if (grafico.getTareaFaseDefProcInvolucradas() != null && grafico.getTareaFaseDefProcInvolucradas().obtenerNumRegistros() > 0) {
            ArrayList vDatos = grafico.getTareaFaseDefProcInvolucradas().getListaDatos();
            TrTareaEnFaseDefProcedimiento tareaFase = null;
            if (!this.escribir("<AVISOS_TAREA>")) {
                return false;
            }
            for (int j = 0; j < vDatos.size(); ++j) {
                String strXML = "";
                tareaFase = (TrTareaEnFaseDefProcedimiento)vDatos.get(j);
                if (tareaFase.getConjuntoAvisoTareaFase() == null || tareaFase.getConjuntoAvisoTareaFase().obtenerNumRegistros() <= 0) continue;
                ArrayList vDatosAviso = tareaFase.getConjuntoAvisoTareaFase().getListaDatos();
                TrAvisoTareaFase aviso = null;
                for (int i = 0; i < vDatosAviso.size(); ++i) {
                    strXML = "";
                    aviso = (TrAvisoTareaFase)vDatosAviso.get(i);
                    String strAuxXML = aviso.toXML(tareaFase.getTareaEnFase().getX_ID());
                    if (strAuxXML != null) {
                        if (this.escribir(strXML = strXML + strAuxXML)) continue;
                        return false;
                    }
                    return false;
                }
            }
            return this.escribir("</AVISOS_TAREA>");
        }
        return false;
    }

    public boolean generarCuerpoControlPlazosXML(DDPGrafico grafico) {
        ConjuntoDatos cdPlazosCompuestos;
        int j;
        boolean bRecorrerPlazosSimplesEnTransicion = false;
        boolean bRecorrerPlazosSimplesEnTarea = false;
        boolean bRecorrerPlazosCompuestos = false;
        TrTransicionDefProcedimiento transicion = null;
        TrTareaEnFaseDefProcedimiento tareaEnFase = null;
        if (grafico.getTransicionesDelProcInvolucradas() != null && grafico.getTransicionesDelProcInvolucradas().getListaDatos() != null) {
            ArrayList vDatos = grafico.getTransicionesDelProcInvolucradas().getListaDatos();
            for (j = 0; j < vDatos.size(); ++j) {
                transicion = (TrTransicionDefProcedimiento)vDatos.get(j);
                if (transicion.getPlazosSimple() != null && transicion.getPlazosSimple().size() > 0) {
                    bRecorrerPlazosSimplesEnTransicion = true;
                }
                if (transicion.getPlazoSimple() == null) continue;
                bRecorrerPlazosSimplesEnTransicion = true;
            }
        }
        if (grafico.getTareaFaseDefProcInvolucradas() != null && grafico.getTareaFaseDefProcInvolucradas().getListaDatos() != null) {
            ArrayList vDatosTareas = grafico.getTareaFaseDefProcInvolucradas().getListaDatos();
            for (j = 0; j < vDatosTareas.size(); ++j) {
                tareaEnFase = (TrTareaEnFaseDefProcedimiento)vDatosTareas.get(j);
                if (tareaEnFase.getPlazoSimple() == null) continue;
                bRecorrerPlazosSimplesEnTarea = true;
            }
        }
        if ((cdPlazosCompuestos = grafico.getDDP().getTIPOEVOL().getPlazosCompuestosProcedimiento()) != null && cdPlazosCompuestos.getListaDatos() != null && cdPlazosCompuestos.getListaDatos().size() > 0) {
            bRecorrerPlazosCompuestos = true;
        }
        if ((bRecorrerPlazosSimplesEnTransicion || bRecorrerPlazosSimplesEnTarea || bRecorrerPlazosCompuestos) && !this.escribir("<CONTROL_PLAZOS>")) {
            return false;
        }
        if ((bRecorrerPlazosSimplesEnTransicion || bRecorrerPlazosSimplesEnTarea) && !this.escribir("<PLAZOS_SIMPLES>")) {
            return false;
        }
        if (bRecorrerPlazosSimplesEnTransicion) {
            this.generarCuerpoPlazosSimplesEnTrasicionXML(grafico);
        }
        if (bRecorrerPlazosSimplesEnTarea) {
            this.generarCuerpoPlazosSimplesEnTareaXML(grafico);
        }
        if ((bRecorrerPlazosSimplesEnTransicion || bRecorrerPlazosSimplesEnTarea) && !this.escribir("</PLAZOS_SIMPLES>")) {
            return false;
        }
        if (bRecorrerPlazosCompuestos && !this.escribir("<PLAZOS_COMPUESTOS>")) {
            return false;
        }
        this.generarCuerpoPlazosCompuestosXML(grafico);
        if (bRecorrerPlazosCompuestos && !this.escribir("</PLAZOS_COMPUESTOS>")) {
            return false;
        }
        return !bRecorrerPlazosSimplesEnTransicion && !bRecorrerPlazosSimplesEnTarea && !bRecorrerPlazosCompuestos || this.escribir("</CONTROL_PLAZOS>");
    }

    public boolean generarCuerpoPlazosSimplesEnTrasicionXML(DDPGrafico grafico) {
        if (grafico.getTransicionesDelProcInvolucradas() != null && grafico.getTransicionesDelProcInvolucradas().getListaDatos() != null) {
            TrTransicionDefProcedimiento transicion = null;
            ArrayList vDatos = grafico.getTransicionesDelProcInvolucradas().getListaDatos();
            String strXML = null;
            for (int j = 0; j < vDatos.size(); ++j) {
                TrPlazoSimple plazo = null;
                transicion = (TrTransicionDefProcedimiento)vDatos.get(j);
                strXML = null;
                if (transicion.getPlazosSimple() != null) {
                    for (int n = 0; n < transicion.getPlazosSimple().size(); ++n) {
                        strXML = null;
                        plazo = (TrPlazoSimple)transicion.getPlazosSimple().get(n);
                        strXML = plazo.toXML(1, transicion.getTransicion().getTRANID());
                        if (strXML == null || this.escribir(strXML)) continue;
                        return false;
                    }
                }
                if (transicion.getPlazoSimple() == null) continue;
                strXML = null;
                plazo = transicion.getPlazoSimple();
                strXML = plazo.toXML(1, transicion.getTransicion().getTRANID());
                if (strXML == null || this.escribir(strXML)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean generarCuerpoPlazosSimplesEnTareaXML(DDPGrafico grafico) {
        if (grafico.getTareaFaseDefProcInvolucradas() != null && grafico.getTareaFaseDefProcInvolucradas().getListaDatos() != null) {
            TrTareaEnFaseDefProcedimiento tareaEnFase = null;
            ArrayList vDatos = grafico.getTareaFaseDefProcInvolucradas().getListaDatos();
            String strXML = null;
            for (int j = 0; j < vDatos.size(); ++j) {
                TrPlazoSimple plazo = null;
                tareaEnFase = (TrTareaEnFaseDefProcedimiento)vDatos.get(j);
                strXML = null;
                if (tareaEnFase.getPlazoSimple() == null || (strXML = (plazo = tareaEnFase.getPlazoSimple()).toXML(2, tareaEnFase.getTareaEnFase().getX_ID())) == null || this.escribir(strXML)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean generarCuerpoPlazosCompuestosXML(DDPGrafico grafico) {
        if (this.m_ValidadorDefProc == null) {
            return false;
        }
        ArrayList arrPlazosCompuestos = null;
        arrPlazosCompuestos = grafico.getDDP().getTIPOEVOL().getPlazosCompuestosProcedimiento().getListaDatos();
        for (int n = 0; n < arrPlazosCompuestos.size(); ++n) {
            TrPlazoCompuestoDefProc plazo = null;
            String strXML = null;
            plazo = (TrPlazoCompuestoDefProc)arrPlazosCompuestos.get(n);
            strXML = plazo.toXML();
            if (this.bCerrandoDefinicion && !plazo.getConTransicionesFin()) {
                this.m_ValidadorDefProc.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Plazo compuesto sin transiciones en las que termina definidas", "Plazo compuesto", plazo.getABREVIATURA(), "")));
                this.m_ValidadorDefProc.incrementarAvisos();
            }
            if (strXML == null || this.escribir(strXML)) continue;
            return false;
        }
        return true;
    }

    public boolean generarCuerpoTiposOrganismoXML(DDPGrafico grafico) {
        ConjuntoDatosTiposOrganismo cdTiposOrganismo = this.getTiposOrganismoInvolucrados(grafico);
        if (cdTiposOrganismo == null) {
            return false;
        }
        if (cdTiposOrganismo.getListaDatos() == null) {
            return false;
        }
        if (cdTiposOrganismo.getListaDatos().size() < 1) {
            return false;
        }
        String strXML = null;
        String strAuxXML = null;
        if (!this.escribir("<TIPOS_ORGANISMO>")) {
            return false;
        }
        TrTipoOrganismo tipoOrganismo = null;
        for (int n = 0; n < cdTiposOrganismo.getListaDatos().size(); ++n) {
            tipoOrganismo = (TrTipoOrganismo)cdTiposOrganismo.getListaDatos().get(n);
            strXML = "";
            strAuxXML = tipoOrganismo.toXML();
            if (strAuxXML == null || this.escribir(strXML = strXML + strAuxXML)) continue;
            return false;
        }
        return this.escribir("</TIPOS_ORGANISMO>");
    }

    public boolean generarCuerpoOrganismosXML(DDPGrafico grafico) {
        ConjuntoDatosOrganismo cdOrganismos = this.getOrganismosInvolucrados(grafico);
        if (cdOrganismos == null) {
            return false;
        }
        if (cdOrganismos.getListaDatos() == null) {
            return false;
        }
        if (cdOrganismos.getListaDatos().size() < 1) {
            return false;
        }
        String strXML = null;
        String strAuxXML = null;
        if (!this.escribir("<ORGANISMOS>")) {
            return false;
        }
        TrOrganismo organismo = null;
        for (int n = 0; n < cdOrganismos.getListaDatos().size(); ++n) {
            organismo = (TrOrganismo)cdOrganismos.getListaDatos().get(n);
            strXML = "";
            strAuxXML = organismo.toXML();
            if (strAuxXML == null || this.escribir(strXML = strXML + strAuxXML)) continue;
            return false;
        }
        return this.escribir("</ORGANISMOS>");
    }

    public boolean generarCuerpoTiposIndicacionXML(DDPGrafico grafico) {
        ConjuntoDatosTiposIndicacion cdTiposIndicacion = this.getTiposIndicacionInvolucrados(grafico);
        if (cdTiposIndicacion == null) {
            return false;
        }
        if (cdTiposIndicacion.getListaDatos() == null) {
            return false;
        }
        if (cdTiposIndicacion.getListaDatos().size() < 1) {
            return false;
        }
        String strXML = null;
        String strAuxXML = null;
        if (!this.escribir("<TIPOS_INDICACION>")) {
            return false;
        }
        TrTipoIndicacionFicha tipoIndicacion = null;
        for (int n = 0; n < cdTiposIndicacion.getListaDatos().size(); ++n) {
            tipoIndicacion = (TrTipoIndicacionFicha)cdTiposIndicacion.getListaDatos().get(n);
            strXML = "";
            strAuxXML = tipoIndicacion.toXML();
            if (strAuxXML == null || this.escribir(strXML = strXML + strAuxXML)) continue;
            return false;
        }
        return this.escribir("</TIPOS_INDICACION>");
    }

    public boolean generarCuerpoOrganismosProcXML(DDPGrafico grafico) {
        if (grafico.getDDP() == null || grafico.getDDP().getTIPOEVOL() == null) {
            return false;
        }
        ConjuntoDatos cdOrganismosProc = grafico.getDDP().getTIPOEVOL().getOrganismosProcedimientoInvolucrados();
        if (cdOrganismosProc == null || cdOrganismosProc.getListaDatos() == null || cdOrganismosProc.getListaDatos().size() < 1) {
            return false;
        }
        String strXML = null;
        String strAuxXML = null;
        if (!this.escribir("<ORGANISMOS_PROCEDIMIENTO>")) {
            return false;
        }
        TrOrganismoProc organismoProc = null;
        for (int n = 0; n < cdOrganismosProc.getListaDatos().size(); ++n) {
            organismoProc = (TrOrganismoProc)cdOrganismosProc.getListaDatos().get(n);
            strXML = "";
            strAuxXML = organismoProc.toXML();
            if (strAuxXML == null || this.escribir(strXML = strXML + strAuxXML)) continue;
            return false;
        }
        return this.escribir("</ORGANISMOS_PROCEDIMIENTO>");
    }

    public boolean generarCuerpoFichasXML(DDPGrafico grafico) {
        if (grafico.getDDP() == null) {
            return false;
        }
        if (grafico.getDDP().getTIPOEVOL() == null) {
            return false;
        }
        ConjuntoDatos cdFichas = grafico.getDDP().getTIPOEVOL().getFichaProcedimientoInvolucradas();
        if (cdFichas == null) {
            return false;
        }
        if (cdFichas.getListaDatos() == null) {
            return false;
        }
        if (cdFichas.getListaDatos().size() < 1) {
            return false;
        }
        String strXML = null;
        String strAuxXML = null;
        if (!this.escribir("<FICHA_PROCEDIMIENTO>")) {
            return false;
        }
        TrIndicacionFicha indicacion = null;
        for (int n = 0; n < cdFichas.getListaDatos().size(); ++n) {
            indicacion = (TrIndicacionFicha)cdFichas.getListaDatos().get(n);
            strXML = "";
            strAuxXML = indicacion.toXML();
            if (strAuxXML == null || this.escribir(strXML = strXML + strAuxXML)) continue;
            return false;
        }
        return this.escribir("</FICHA_PROCEDIMIENTO>");
    }

    public boolean generarCuerpoTiposNormativaXML(DDPGrafico grafico) {
        ConjuntoDatosTiposNormativa cdTiposNormativa = this.getTiposNormativaInvolucrados(grafico);
        if (cdTiposNormativa == null) {
            return false;
        }
        if (cdTiposNormativa.getListaDatos() == null) {
            return false;
        }
        if (cdTiposNormativa.getListaDatos().size() < 1) {
            return false;
        }
        String strXML = null;
        String strAuxXML = null;
        if (!this.escribir("<TIPOS_NORMATIVA>")) {
            return false;
        }
        TrTipoNormativa tipoNormativa = null;
        for (int n = 0; n < cdTiposNormativa.getListaDatos().size(); ++n) {
            tipoNormativa = (TrTipoNormativa)cdTiposNormativa.getListaDatos().get(n);
            strXML = "";
            strAuxXML = tipoNormativa.toXML();
            if (strAuxXML == null || this.escribir(strXML = strXML + strAuxXML)) continue;
            return false;
        }
        return this.escribir("</TIPOS_NORMATIVA>");
    }

    public boolean generarCuerpoTiposPublicacionXML(DDPGrafico grafico) {
        ConjuntoDatosTiposPublicacion cdTiposPublicacion = this.getTiposPublicacionInvolucrados(grafico);
        if (cdTiposPublicacion == null) {
            return false;
        }
        if (cdTiposPublicacion.getListaDatos() == null) {
            return false;
        }
        if (cdTiposPublicacion.getListaDatos().size() < 1) {
            return false;
        }
        String strXML = null;
        String strAuxXML = null;
        if (!this.escribir("<TIPOS_PUBLICACION>")) {
            return false;
        }
        TrTipoPublicacion tipoPublicacion = null;
        for (int n = 0; n < cdTiposPublicacion.getListaDatos().size(); ++n) {
            tipoPublicacion = (TrTipoPublicacion)cdTiposPublicacion.getListaDatos().get(n);
            strXML = "";
            strAuxXML = tipoPublicacion.toXML();
            if (strAuxXML == null || this.escribir(strXML = strXML + strAuxXML)) continue;
            return false;
        }
        return this.escribir("</TIPOS_PUBLICACION>");
    }

    public boolean generarCuerpoAmbitosLeyXML(DDPGrafico grafico) {
        ConjuntoDatosAmbitosLey cdAmbitosLey = this.getAmbitosLeyInvolucrados(grafico);
        if (cdAmbitosLey == null) {
            return false;
        }
        if (cdAmbitosLey.getListaDatos() == null) {
            return false;
        }
        if (cdAmbitosLey.getListaDatos().size() < 1) {
            return false;
        }
        String strXML = null;
        String strAuxXML = null;
        if (!this.escribir("<AMBITOS_LEY>")) {
            return false;
        }
        TrAmbitoLey ambitoLey = null;
        for (int n = 0; n < cdAmbitosLey.getListaDatos().size(); ++n) {
            ambitoLey = (TrAmbitoLey)cdAmbitosLey.getListaDatos().get(n);
            strXML = "";
            strAuxXML = ambitoLey.toXML();
            if (strAuxXML == null || this.escribir(strXML = strXML + strAuxXML)) continue;
            return false;
        }
        return this.escribir("</AMBITOS_LEY>");
    }

    public boolean generarCuerpoNormativasXML(DDPGrafico grafico) {
        ConjuntoDatos cdNormativas = this.getNormativasInvolucradas(grafico, false);
        if (cdNormativas == null) {
            return false;
        }
        if (cdNormativas.getListaDatos() == null) {
            return false;
        }
        if (cdNormativas.getListaDatos().size() < 1) {
            return false;
        }
        String strXML = null;
        String strAuxXML = null;
        if (!this.escribir("<NORMATIVAS>")) {
            return false;
        }
        TrNormativa normativa = null;
        for (int n = 0; n < cdNormativas.getListaDatos().size(); ++n) {
            normativa = (TrNormativa)cdNormativas.getListaDatos().get(n);
            strXML = "";
            strAuxXML = normativa.toXML();
            if (strAuxXML == null || this.escribir(strXML = strXML + strAuxXML)) continue;
            return false;
        }
        return this.escribir("</NORMATIVAS>");
    }

    public boolean generarCuerpoNormativasDefProcXML(DDPGrafico grafico) {
        ConjuntoDatos cdNormativas = this.getNormativasInvolucradas(grafico, true);
        if (cdNormativas == null) {
            return false;
        }
        if (cdNormativas.getListaDatos() == null) {
            return false;
        }
        if (cdNormativas.getListaDatos().size() < 1) {
            return false;
        }
        String strXML = null;
        String strAuxXML = null;
        if (!this.escribir("<NORMATIVAS_DEFPROC>")) {
            return false;
        }
        TrNormativa normativa = null;
        for (int n = 0; n < cdNormativas.getListaDatos().size(); ++n) {
            normativa = (TrNormativa)cdNormativas.getListaDatos().get(n);
            strXML = "";
            strAuxXML = "<NORMATIVA_ID id=" + COMILLAS_DOBLES + String.valueOf(normativa.getX_ID().longValue()) + COMILLAS_DOBLES + "/>";
            if (this.escribir(strXML = strXML + strAuxXML)) continue;
            return false;
        }
        return this.escribir("</NORMATIVAS_DEFPROC>");
    }

    public boolean generarCuerpoPlantillasProcXML(DDPGrafico grafico) {
        if (this.m_ValidadorDefProc == null) {
            return false;
        }
        if (grafico.getDDP() == null) {
            return false;
        }
        if (grafico.getDDP().getTIPOEVOL() == null) {
            return false;
        }
        ConjuntoDatos cdPlantillasProc = grafico.getDDP().getTIPOEVOL().getPlantillasProcInvolucradas();
        if (cdPlantillasProc == null) {
            return false;
        }
        if (cdPlantillasProc.getListaDatos() == null) {
            return false;
        }
        if (cdPlantillasProc.getListaDatos().size() < 1) {
            return false;
        }
        String strXML = null;
        String strAuxXML = null;
        if (!this.escribir("<PLANTILLAS_PROCEDIMIENTO>")) {
            return false;
        }
        TrPlantillaProcedimiento plantillaProc = null;
        for (int n = 0; n < cdPlantillasProc.getListaDatos().size(); ++n) {
            plantillaProc = (TrPlantillaProcedimiento)cdPlantillasProc.getListaDatos().get(n);
            strXML = "";
            strAuxXML = plantillaProc.toXML(this.bCerrandoDefinicion);
            if (strAuxXML != null && !this.escribir(strXML = strXML + strAuxXML)) {
                return false;
            }
            this.m_ValidadorDefProc.copiarArchivo(plantillaProc.getRutaCompleta(), this.strOrigenXML, ModelaConf.getRutaArchivo(), plantillaProc.getNOMB_FICHERO(), "Plantilla del procedimiento", plantillaProc.getNombre(), true);
        }
        return this.escribir("</PLANTILLAS_PROCEDIMIENTO>");
    }

    public ConjuntoDatosModela getPerfilesUsuarioInvolucrados(DDPGrafico grafico) {
        if (!this.bCerrandoDefinicion && grafico.getDDPPadre() == null) {
            return grafico.getPerfilesUsuarioInvolucrados();
        }
        return grafico.getPerfilesUsuarioInvolucradosGr();
    }

    public ConjuntoDatosTipoActo getTiposActoInvolucrados(DDPGrafico grafico) {
        if (grafico.getDDPPadre() == null && (!this.bCerrandoDefinicion || this.bCerrandoDefinicion && this.exportarTodasVariables(grafico))) {
            return grafico.getTiposActoInvolucrados();
        }
        return grafico.getTiposActoInvolucradosGr();
    }

    public ConjuntoDatosModela getCondicionesInvolucradas(DDPGrafico grafico) {
        if (!this.bCerrandoDefinicion && grafico.getDDPPadre() == null) {
            return grafico.getCondicionesInvolucradas();
        }
        return grafico.getCondicionesInvolucradasGr();
    }

    public ConjuntoDatosModela getAccionesInvolucradas(DDPGrafico grafico) {
        if (!this.bCerrandoDefinicion && grafico.getDDPPadre() == null) {
            return grafico.getAccionesInvolucradas();
        }
        return grafico.getAccionesInvolucradasGr();
    }

    public ConjuntoDatosModela getAvisosInvolucrados(DDPGrafico grafico) {
        if (!this.bCerrandoDefinicion && grafico.getDDPPadre() == null) {
            return grafico.getAvisosInvolucrados();
        }
        return grafico.getAvisosInvolucradosGr();
    }

    public ConjuntoDatosModela getMetafasesInvolucradas(DDPGrafico grafico) {
        if (!this.bCerrandoDefinicion && grafico.getDDPPadre() == null) {
            return grafico.getMetafasesInvolucradas();
        }
        return grafico.getMetafasesInvolucradasGr();
    }

    public ConjuntoDatosModela getFasesInvolucradas(DDPGrafico grafico) {
        if (!this.bCerrandoDefinicion && grafico.getDDPPadre() == null) {
            return grafico.getFasesInvolucradas();
        }
        return grafico.getFasesInvolucradasGr();
    }

    public ConjuntoDatosTransicion getTransicionesInvolucradas(DDPGrafico grafico) {
        return grafico.getTransicionesInvolucradasGr();
    }

    public ConjuntoDatosModela getParametrosInvolucrados(DDPGrafico grafico) {
        if (grafico.getDDPPadre() == null && (!this.bCerrandoDefinicion || this.bCerrandoDefinicion && this.exportarTodasVariables(grafico))) {
            return grafico.getParametrosInvolucrados();
        }
        return grafico.getParametrosInvolucradosGr();
    }

    public ConjuntoDatosModela getBloquesInvolucrados(DDPGrafico grafico) {
        if (!this.bCerrandoDefinicion && grafico.getDDPPadre() == null) {
            return grafico.getBloquesInvolucrados();
        }
        return grafico.getBloquesInvolucradosGr();
    }

    public ConjuntoDatosTarea getTareasInvolucradas(DDPGrafico grafico) {
        if (!this.bCerrandoDefinicion && grafico.getDDPPadre() == null) {
            return grafico.getTareasInvolucradas();
        }
        return grafico.getTareasInvolucradasGr();
    }

    public ConjuntoDatosModela getPlantillasInvolucradas(DDPGrafico grafico) {
        if (!this.bCerrandoDefinicion && grafico.getDDPPadre() == null) {
            return grafico.getPlantillasInvolucradas();
        }
        return grafico.getPlantillasInvolucradasGr();
    }

    public ConjuntoDatosModela getTipoParrafosInvolucrados(DDPGrafico grafico) {
        if (!this.bCerrandoDefinicion && grafico.getDDPPadre() == null) {
            return grafico.getTipoParrafosInvolucrados();
        }
        return grafico.getTipoParrafosInvolucradosGr();
    }

    public ConjuntoDatosModela getTipoDocumentosInvolucrados(DDPGrafico grafico) {
        if (!this.bCerrandoDefinicion && grafico.getDDPPadre() == null) {
            return grafico.getTipoDocumentosInvolucrados();
        }
        return grafico.getTipoDocumentosInvolucradosGr();
    }

    public ConjuntoDatosModela getVariablesInvolucradas(DDPGrafico grafico) {
        if (grafico.getDDPPadre() == null && (!this.bCerrandoDefinicion || this.bCerrandoDefinicion && this.exportarTodasVariables(grafico))) {
            return grafico.getVariablesInvolucradas();
        }
        return grafico.getVariablesInvolucradasGr();
    }

    public ConjuntoDatosOrganismo getOrganismosInvolucrados(DDPGrafico grafico) {
        if (!this.bCerrandoDefinicion && grafico.getDDPPadre() == null) {
            return grafico.getOrganismosInvolucrados();
        }
        return grafico.getOrganismosInvolucradosGr();
    }

    public ConjuntoDatosTiposOrganismo getTiposOrganismoInvolucrados(DDPGrafico grafico) {
        if (!this.bCerrandoDefinicion && grafico.getDDPPadre() == null) {
            return grafico.getTiposOrganismoInvolucrados();
        }
        return grafico.getTiposOrganismoInvolucradosGr();
    }

    public ConjuntoDatosAmbitosLey getAmbitosLeyInvolucrados(DDPGrafico grafico) {
        if (!this.bCerrandoDefinicion && grafico.getDDPPadre() == null) {
            return grafico.getAmbitosLeyInvolucrados();
        }
        return grafico.getAmbitosLeyInvolucradosGr();
    }

    public ConjuntoDatosTiposPublicacion getTiposPublicacionInvolucrados(DDPGrafico grafico) {
        if (!this.bCerrandoDefinicion && grafico.getDDPPadre() == null) {
            return grafico.getTiposPublicacionInvolucrados();
        }
        return grafico.getTiposPublicacionInvolucradosGr();
    }

    public ConjuntoDatosTiposNormativa getTiposNormativaInvolucrados(DDPGrafico grafico) {
        if (!this.bCerrandoDefinicion && grafico.getDDPPadre() == null) {
            return grafico.getTiposNormativaInvolucrados();
        }
        return grafico.getTiposNormativaInvolucradosGr();
    }

    public ConjuntoDatosTiposIndicacion getTiposIndicacionInvolucrados(DDPGrafico grafico) {
        if (!this.bCerrandoDefinicion && grafico.getDDPPadre() == null) {
            return grafico.getTiposIndicacionInvolucrados();
        }
        return grafico.getTiposIndicacionInvolucradosGr();
    }

    public ConjuntoDatos getNormativasInvolucradas(DDPGrafico grafico, boolean bSoloNormativasDefProc) {
        if (!this.bCerrandoDefinicion && !bSoloNormativasDefProc) {
            return grafico.getNormativasInvolucradas();
        }
        if (grafico.getDDP() != null && grafico.getDDP().getTIPOEVOL() != null) {
            return grafico.getDDP().getTIPOEVOL().getNormativasProcedimiento();
        }
        return null;
    }

    public synchronized void addInfoResultadoListener(InfoResultadoListener l) {
        if (this.m_ValidadorDefProc == null) {
            return;
        }
        this.m_ValidadorDefProc.addInfoResultadoListener(l);
    }

    private boolean exportarTodasVariables(DDPGrafico grafico) {
        if (grafico.existenParrafosTipoDocumento()) {
            return true;
        }
        ArrayList arrReutilizables = new ArrayList();
        DDPGrafico ddpReutilizable = null;
        arrReutilizables = grafico.obtenerReutilizablesAsociados(this.bCerrandoDefinicion);
        for (int r = 0; r < arrReutilizables.size(); ++r) {
            ddpReutilizable = (DDPGrafico)arrReutilizables.get(r);
            if (!ddpReutilizable.existenParrafosTipoDocumento()) continue;
            return true;
        }
        return false;
    }

    public boolean validarTransiciones(DDPGrafico grafico) {
        if (!this.bCerrandoDefinicion) {
            return false;
        }
        if (grafico.getTransicionesInvolucradas() == null) {
            return false;
        }
        if (grafico.getTransicionesInvolucradas().getListaDatos() == null) {
            return false;
        }
        ArrayList aDatos = grafico.getTransicionesInvolucradas().getListaDatos();
        TrTransicion transicion = null;
        for (int i = 0; i < aDatos.size(); ++i) {
            transicion = (TrTransicion)aDatos.get(i);
            if (transicion == null) {
                return false;
            }
            if (!transicion.getTIPO().equals("D")) continue;
            if (transicion.getConjuntoFasesFin() == null) {
                this.m_ValidadorDefProc.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_ERROR, "Transici\u00f3n de divisi\u00f3n sin fases finales", "Transici\u00f3n", transicion.getETIQUETA(), "Compruebe el dise\u00f1o de su procedimiento")));
                if (this.m_ValidadorDefProc == null) continue;
                this.m_ValidadorDefProc.incrementarErrores();
                continue;
            }
            if (transicion.getConjuntoFasesFin().getListaDatos().size() != 0) continue;
            this.m_ValidadorDefProc.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_ERROR, "Transici\u00f3n de divisi\u00f3n sin fases finales", "Transici\u00f3n", transicion.getETIQUETA(), "Compruebe el dise\u00f1o de su procedimiento")));
            if (this.m_ValidadorDefProc == null) continue;
            this.m_ValidadorDefProc.incrementarErrores();
        }
        return true;
    }

    public TransicionPNode comprobarExistExtremoTransGr(DDPGrafico grafico, long nExtTram_id) {
        if (grafico.getCanvas() == null) {
            return null;
        }
        PLayer lyr = grafico.getCanvas().getLayer();
        if (lyr != null) {
            int nNum = lyr.getChildrenCount();
            for (int i = 0; i < nNum; ++i) {
                if (lyr.getChild(i) instanceof PLayer || !(lyr.getChild(i) instanceof TransicionPNode)) continue;
                TransicionPNode pNodo = (TransicionPNode)lyr.getChild(i);
                if (pNodo.getPNodoGraficoFaseIni().getTrFaseGrAsociada().getID().longValue() == nExtTram_id) {
                    return pNodo;
                }
                if (pNodo.getPNodoGraficoFaseFin().getTrFaseGrAsociada().getID().longValue() != nExtTram_id) continue;
                return pNodo;
            }
        }
        return null;
    }

    public boolean comprobarExisteFase(DDPGrafico grafico, long nExtTram_id) {
        if (grafico.getCanvas() == null) {
            return false;
        }
        PLayer lyr = grafico.getCanvas().getLayer();
        if (lyr != null) {
            int nNum = lyr.getChildrenCount();
            for (int i = 0; i < nNum; ++i) {
                FasePNode pNodo;
                if (lyr.getChild(i) instanceof PLayer || !(lyr.getChild(i) instanceof FasePNode) || (pNodo = (FasePNode)lyr.getChild(i)).getTrFaseGrAsociada().getTrFase().getFASEID().longValue() != nExtTram_id) continue;
                return true;
            }
        }
        return true;
    }

    private void eliminarNodosErroneos(DDPGrafico grafico, ArrayList nodosErroneos) {
        if (this.m_ValidadorDefProc == null) {
            return;
        }
        if (grafico.getCanvas() == null) {
            return;
        }
        if (nodosErroneos == null) {
            return;
        }
        if (nodosErroneos.size() == 0) {
            return;
        }
        for (int nCont = 0; nCont < nodosErroneos.size(); ++nCont) {
            PNodoGrafico nodoAux = (PNodoGrafico)nodosErroneos.get(nCont);
            if (nodoAux.getTipo().equals("FA")) {
                TransicionPNode transPNode = this.comprobarExistExtremoTransGr(grafico, nodoAux.getTrFaseGrAsociada().getID().longValue());
                this.m_ValidadorDefProc.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Gr\u00e1fico de fase sin fase asociada", "Extremo de transici\u00f3n(gr\u00e1fico de fase) ", "", "Extremo de transici\u00f3n del tipo " + nodoAux.getTipo() + " eliminado")));
                if (transPNode != null) {
                    this.m_ValidadorDefProc.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Gr\u00e1fico de fase sin fase asociada", "Extremo de transici\u00f3n(gr\u00e1fico de fase) ", "", "Eliminadas transiciones asociadas al extremo de transici\u00f3n")));
                    transPNode.eliminarTransicion(true, true);
                }
                this.m_ValidadorDefProc.incrementarAvisos();
            } else {
                this.m_ValidadorDefProc.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Extremo de transici\u00f3n sin gr\u00e1fico de transici\u00f3n asociado", "Extremo de transici\u00f3n", "", "Extremo de transici\u00f3n del tipo " + nodoAux.getTipo() + " eliminado")));
                if (this.m_ValidadorDefProc != null) {
                    this.m_ValidadorDefProc.incrementarAvisos();
                }
            }
            grafico.getCanvas().eliminarPNodoGrafico(nodoAux);
        }
    }

    public ValidadorDefProcedimiento getValidador() {
        return this.m_ValidadorDefProc;
    }

    public void inicarProcesoValidacion(DDPGrafico grafico) {
        if (grafico == null) {
            return;
        }
        if (this.m_ValidadorDefProc == null) {
            return;
        }
        this.m_ValidadorDefProc.setGenerar(true);
        if (grafico.getDDPPadre() == null) {
            this.m_ValidadorDefProc.validarDefProdedimiento(grafico);
        } else {
            this.m_ValidadorDefProc.validarDefProdedimiento(grafico.getDDPPadre());
        }
    }

    public boolean comprimirXml(String strRutaArch) {
        if (this.m_ValidadorDefProc == null) {
            return false;
        }
        return this.m_ValidadorDefProc.comprimirXml(strRutaArch);
    }

    public void setComprimir(boolean bComprimir) {
        if (this.m_ValidadorDefProc == null) {
            return;
        }
        this.m_ValidadorDefProc.setComprimir(bComprimir);
    }

    public void eliminarListaArchivosCopiados() {
        if (this.m_ValidadorDefProc == null) {
            return;
        }
        this.m_ValidadorDefProc.eliminarListaArchivosCopiados();
    }

    public boolean generarCuerpoPostItXML(DDPGrafico grafico) {
        if (grafico.getCanvas() == null) {
            return false;
        }
        String strInicio = "<GRAFICOS_POST_IT>";
        if (!this.escribir(strInicio)) {
            return false;
        }
        PLayer lyr = grafico.getCanvas().getLayer();
        if (lyr != null) {
            int nNum = lyr.getChildrenCount();
            for (int i = 0; i < nNum; ++i) {
                if (lyr.getChild(i) instanceof PLayer || !(lyr.getChild(i) instanceof PostItPNode)) continue;
                PostItPNode postIt = (PostItPNode)lyr.getChild(i);
                this.escribir(postIt.toXMLCabecera());
            }
        }
        return this.escribir("</GRAFICOS_POST_IT>");
    }
}

