/*
 * Decompiled with CFR 0.152.
 */
package modela.graf;

import java.util.ArrayList;
import modela.bd.obj.TrAccion;
import modela.bd.obj.TrAccionTareaFase;
import modela.bd.obj.TrAccionTransicion;
import modela.bd.obj.TrAviso;
import modela.bd.obj.TrAvisoTareaFase;
import modela.bd.obj.TrAvisoTransicion;
import modela.bd.obj.TrBloque;
import modela.bd.obj.TrBloquePermitido;
import modela.bd.obj.TrCondicion;
import modela.bd.obj.TrCondicionTareaFase;
import modela.bd.obj.TrCondicionTransicion;
import modela.bd.obj.TrDocumentoPermitido;
import modela.bd.obj.TrFase;
import modela.bd.obj.TrIndicacionFicha;
import modela.bd.obj.TrMetafase;
import modela.bd.obj.TrNormativa;
import modela.bd.obj.TrOrganismoProc;
import modela.bd.obj.TrParametro;
import modela.bd.obj.TrParrafoTipDoc;
import modela.bd.obj.TrPerfilTareaFase;
import modela.bd.obj.TrPerfilTransEvol;
import modela.bd.obj.TrPerfilUsuario;
import modela.bd.obj.TrPlantilla;
import modela.bd.obj.TrPlantillaProcedimiento;
import modela.bd.obj.TrPlazoCompuestoDefProc;
import modela.bd.obj.TrTarea;
import modela.bd.obj.TrTareaEnFase;
import modela.bd.obj.TrTareaEnFaseDefProcedimiento;
import modela.bd.obj.TrTipoActo;
import modela.bd.obj.TrTipoDocumento;
import modela.bd.obj.TrTipoParrafo;
import modela.bd.obj.TrTransicion;
import modela.bd.obj.TrTransicionDefProcedimiento;
import modela.bd.obj.TrVariable;
import modela.graf.DDPGrafico;

public class DestructorDDP {
    DDPGrafico ddp = null;

    public DestructorDDP() {
        this.ddp = new DDPGrafico();
    }

    public DestructorDDP(DDPGrafico pDDP) {
        this.ddp = pDDP;
    }

    public void setDDP(DDPGrafico paramDDP) {
        this.ddp = paramDDP;
    }

    public DDPGrafico getDDP() {
        return this.ddp;
    }

    public int eliminarMetafases(Object[] arrMetafases) {
        if (this.ddp == null) {
            return 0;
        }
        if (arrMetafases == null) {
            return 0;
        }
        if (arrMetafases.length < 1) {
            return 0;
        }
        int nObjetosEliminados = 0;
        TrMetafase metafaseAux = null;
        TrMetafase metafaseActivaDDP = this.ddp.obtenerMetafaseActiva();
        for (int n = 0; n < arrMetafases.length; ++n) {
            metafaseAux = (TrMetafase)arrMetafases[n];
            if (this.entidadRelacionada(metafaseAux)) continue;
            if (metafaseActivaDDP != null && metafaseActivaDDP.getMETAID().longValue() == metafaseAux.getMETAID().longValue()) {
                this.ddp.establecerMetafaseActiva(null);
            }
            this.ddp.getMetafasesInvolucradas().remove(metafaseAux);
            ++nObjetosEliminados;
        }
        return nObjetosEliminados;
    }

    public int eliminarTiposActo(Object[] arrTiposActo) {
        if (this.ddp == null) {
            return 0;
        }
        if (arrTiposActo == null) {
            return 0;
        }
        if (arrTiposActo.length < 1) {
            return 0;
        }
        int nObjectosEliminados = 0;
        TrTipoActo tipoActoAux = null;
        for (int n = 0; n < arrTiposActo.length; ++n) {
            tipoActoAux = (TrTipoActo)arrTiposActo[n];
            if (this.entidadRelacionada(tipoActoAux)) continue;
            this.ddp.getTiposActoInvolucrados().remove(tipoActoAux);
            ++nObjectosEliminados;
        }
        return nObjectosEliminados;
    }

    public int eliminarTareas(Object[] arrTareas) {
        if (this.ddp == null) {
            return 0;
        }
        if (arrTareas == null) {
            return 0;
        }
        if (arrTareas.length < 1) {
            return 0;
        }
        int nObjectosEliminados = 0;
        TrTarea tareaAux = null;
        for (int n = 0; n < arrTareas.length; ++n) {
            tareaAux = (TrTarea)arrTareas[n];
            if (this.entidadRelacionada(tareaAux)) continue;
            this.ddp.getTareasInvolucradas().remove(tareaAux);
            ++nObjectosEliminados;
        }
        return nObjectosEliminados;
    }

    public int eliminarTiposDocumento(Object[] arrTiposDoc) {
        if (this.ddp == null) {
            return 0;
        }
        if (arrTiposDoc == null) {
            return 0;
        }
        if (arrTiposDoc.length < 1) {
            return 0;
        }
        int nObjectosEliminados = 0;
        TrTipoDocumento tipoDocAux = null;
        for (int n = 0; n < arrTiposDoc.length; ++n) {
            tipoDocAux = (TrTipoDocumento)arrTiposDoc[n];
            if (this.entidadRelacionada(tipoDocAux)) continue;
            this.ddp.getTipoDocumentosInvolucrados().remove(tipoDocAux);
            ++nObjectosEliminados;
        }
        return nObjectosEliminados;
    }

    public int eliminarBloques(Object[] arrBloques) {
        if (this.ddp == null) {
            return 0;
        }
        if (arrBloques == null) {
            return 0;
        }
        if (arrBloques.length < 1) {
            return 0;
        }
        int nObjectosEliminados = 0;
        TrBloque bloqueAux = null;
        for (int n = 0; n < arrBloques.length; ++n) {
            bloqueAux = (TrBloque)arrBloques[n];
            if (this.entidadRelacionada(bloqueAux)) continue;
            this.ddp.getBloquesInvolucrados().remove(bloqueAux);
            ++nObjectosEliminados;
        }
        return nObjectosEliminados;
    }

    public int eliminarTareasEnFase(Object[] arrTareasEnFase) {
        if (this.ddp == null) {
            return 0;
        }
        if (arrTareasEnFase == null) {
            return 0;
        }
        if (arrTareasEnFase.length < 1) {
            return 0;
        }
        int nObjectosEliminados = 0;
        TrTareaEnFase tareaEnFaseAux = null;
        for (int n = 0; n < arrTareasEnFase.length; ++n) {
            tareaEnFaseAux = (TrTareaEnFase)arrTareasEnFase[n];
            if (this.entidadRelacionada(tareaEnFaseAux)) continue;
            if (tareaEnFaseAux.getFase() != null && tareaEnFaseAux.getFase().getConjuntoTareasEnFase() != null && tareaEnFaseAux.getFase().getConjuntoTareasEnFase().getListaDatos() != null && tareaEnFaseAux.getFase().getConjuntoTareasEnFase().getListaDatos().size() > 0) {
                tareaEnFaseAux.getFase().getConjuntoTareasEnFase().remove(tareaEnFaseAux);
            }
            ++nObjectosEliminados;
        }
        return nObjectosEliminados;
    }

    public int eliminarTareasEnFaseDefProc(Object[] arrTareasEnFaseDefProc) {
        if (this.ddp == null) {
            return 0;
        }
        if (arrTareasEnFaseDefProc == null) {
            return 0;
        }
        if (arrTareasEnFaseDefProc.length < 1) {
            return 0;
        }
        int nObjectosEliminados = 0;
        TrTareaEnFaseDefProcedimiento tareaEnFaseDefProcAux = null;
        for (int n = 0; n < arrTareasEnFaseDefProc.length; ++n) {
            tareaEnFaseDefProcAux = (TrTareaEnFaseDefProcedimiento)arrTareasEnFaseDefProc[n];
            if (this.entidadRelacionada(tareaEnFaseDefProcAux)) continue;
            if (this.ddp.getTareaFaseDefProcInvolucradas() != null) {
                this.ddp.getTareaFaseDefProcInvolucradas().remove(tareaEnFaseDefProcAux);
            }
            ++nObjectosEliminados;
        }
        return nObjectosEliminados;
    }

    public int eliminarAcciones(Object[] arrAcciones) {
        if (this.ddp == null) {
            return 0;
        }
        if (arrAcciones == null) {
            return 0;
        }
        if (arrAcciones.length < 1) {
            return 0;
        }
        int nObjectosEliminados = 0;
        TrAccion accionAux = null;
        for (int n = 0; n < arrAcciones.length; ++n) {
            accionAux = (TrAccion)arrAcciones[n];
            if (this.entidadRelacionada(accionAux)) continue;
            this.ddp.getAccionesInvolucradas().remove(accionAux);
            ++nObjectosEliminados;
        }
        return nObjectosEliminados;
    }

    public int eliminarCondiciones(Object[] arrCondiciones) {
        if (this.ddp == null) {
            return 0;
        }
        if (arrCondiciones == null) {
            return 0;
        }
        if (arrCondiciones.length < 1) {
            return 0;
        }
        int nObjectosEliminados = 0;
        TrCondicion condicionAux = null;
        for (int n = 0; n < arrCondiciones.length; ++n) {
            condicionAux = (TrCondicion)arrCondiciones[n];
            if (this.entidadRelacionada(condicionAux)) continue;
            this.ddp.getCondicionesInvolucradas().remove(condicionAux);
            ++nObjectosEliminados;
        }
        return nObjectosEliminados;
    }

    public int eliminarAvisos(Object[] arrAvisos) {
        if (this.ddp == null) {
            return 0;
        }
        if (arrAvisos == null) {
            return 0;
        }
        if (arrAvisos.length < 1) {
            return 0;
        }
        int nObjectosEliminados = 0;
        TrAviso avisoAux = null;
        for (int n = 0; n < arrAvisos.length; ++n) {
            avisoAux = (TrAviso)arrAvisos[n];
            if (this.entidadRelacionada(avisoAux)) continue;
            this.ddp.getAvisosInvolucrados().remove(avisoAux);
            ++nObjectosEliminados;
        }
        return nObjectosEliminados;
    }

    public int eliminarTiposParrafo(Object[] arrTiposParrafo) {
        if (this.ddp == null) {
            return 0;
        }
        if (arrTiposParrafo == null) {
            return 0;
        }
        if (arrTiposParrafo.length < 1) {
            return 0;
        }
        int nObjectosEliminados = 0;
        TrTipoParrafo tipoParrafoAux = null;
        for (int n = 0; n < arrTiposParrafo.length; ++n) {
            tipoParrafoAux = (TrTipoParrafo)arrTiposParrafo[n];
            if (this.entidadRelacionada(tipoParrafoAux)) continue;
            this.ddp.getTipoParrafosInvolucrados().remove(tipoParrafoAux);
            ++nObjectosEliminados;
        }
        return nObjectosEliminados;
    }

    public int eliminarVariables(Object[] arrVariables) {
        if (this.ddp == null) {
            return 0;
        }
        if (arrVariables == null) {
            return 0;
        }
        if (arrVariables.length < 1) {
            return 0;
        }
        int nObjectosEliminados = 0;
        TrVariable variableAux = null;
        for (int n = 0; n < arrVariables.length; ++n) {
            variableAux = (TrVariable)arrVariables[n];
            if (this.entidadRelacionada(variableAux)) continue;
            this.ddp.getVariablesInvolucradas().remove(variableAux);
            ++nObjectosEliminados;
        }
        return nObjectosEliminados;
    }

    public int eliminarPlantillas(Object[] arrPlantillas) {
        if (this.ddp == null) {
            return 0;
        }
        if (arrPlantillas == null) {
            return 0;
        }
        if (arrPlantillas.length < 1) {
            return 0;
        }
        int nObjectosEliminados = 0;
        TrPlantilla plantillaAux = null;
        for (int n = 0; n < arrPlantillas.length; ++n) {
            plantillaAux = (TrPlantilla)arrPlantillas[n];
            if (this.entidadRelacionada(plantillaAux)) continue;
            this.ddp.getPlantillasInvolucradas().remove(plantillaAux);
            ++nObjectosEliminados;
        }
        return nObjectosEliminados;
    }

    public int eliminarPlantillasProc(Object[] arrPlantillas) {
        if (this.ddp == null) {
            return 0;
        }
        if (arrPlantillas == null) {
            return 0;
        }
        if (arrPlantillas.length < 1) {
            return 0;
        }
        int nObjectosEliminados = 0;
        TrPlantillaProcedimiento plantillaAux = null;
        for (int n = 0; n < arrPlantillas.length; ++n) {
            plantillaAux = (TrPlantillaProcedimiento)arrPlantillas[n];
            if (this.entidadRelacionada(plantillaAux)) continue;
            this.ddp.getDDP().getTIPOEVOL().getPlantillasProcInvolucradas().remove(plantillaAux);
            ++nObjectosEliminados;
        }
        return nObjectosEliminados;
    }

    public int eliminarFichaProcedimiento(Object[] arrFichas) {
        if (this.ddp == null) {
            return 0;
        }
        if (arrFichas == null) {
            return 0;
        }
        if (arrFichas.length < 1) {
            return 0;
        }
        int nObjectosEliminados = 0;
        TrIndicacionFicha fichaAux = null;
        for (int n = 0; n < arrFichas.length; ++n) {
            fichaAux = (TrIndicacionFicha)arrFichas[n];
            if (this.entidadRelacionada(fichaAux)) continue;
            this.ddp.getDDP().getTIPOEVOL().getFichaProcedimientoInvolucradas().remove(fichaAux);
            ++nObjectosEliminados;
        }
        return nObjectosEliminados;
    }

    public int eliminarOrganismoProcedimiento(Object[] arrOrganismosProc) {
        if (this.ddp == null || arrOrganismosProc == null || arrOrganismosProc.length < 1) {
            return 0;
        }
        int nObjectosEliminados = 0;
        TrOrganismoProc orgaAux = null;
        for (int n = 0; n < arrOrganismosProc.length; ++n) {
            orgaAux = (TrOrganismoProc)arrOrganismosProc[n];
            if (this.entidadRelacionada(orgaAux)) continue;
            this.ddp.getDDP().getTIPOEVOL().getOrganismosProcedimientoInvolucrados().remove(orgaAux);
            ++nObjectosEliminados;
        }
        return nObjectosEliminados;
    }

    public int eliminarPlazoCompuesto(Object[] arrPlazos) {
        if (this.ddp == null) {
            return 0;
        }
        if (arrPlazos == null) {
            return 0;
        }
        if (arrPlazos.length < 1) {
            return 0;
        }
        int nObjectosEliminados = 0;
        TrPlazoCompuestoDefProc plazoAux = null;
        for (int n = 0; n < arrPlazos.length; ++n) {
            plazoAux = (TrPlazoCompuestoDefProc)arrPlazos[n];
            if (this.entidadRelacionada(plazoAux)) continue;
            this.ddp.getDDP().getTIPOEVOL().getPlazosCompuestosProcedimiento().remove(plazoAux);
            ++nObjectosEliminados;
        }
        return nObjectosEliminados;
    }

    public int eliminarNormativasProcedimiento(Object[] arrNormativasProc) {
        if (this.ddp == null) {
            return 0;
        }
        if (arrNormativasProc == null) {
            return 0;
        }
        if (arrNormativasProc.length < 1) {
            return 0;
        }
        int nObjectosEliminados = 0;
        TrNormativa normativaAux = null;
        for (int n = 0; n < arrNormativasProc.length; ++n) {
            normativaAux = (TrNormativa)arrNormativasProc[n];
            if (this.entidadRelacionada(normativaAux)) continue;
            this.ddp.getDDP().getTIPOEVOL().getNormativasProcedimiento().remove(normativaAux);
            ++nObjectosEliminados;
        }
        return nObjectosEliminados;
    }

    public int eliminarParametros(Object[] arrParametros) {
        if (this.ddp == null) {
            return 0;
        }
        if (arrParametros == null) {
            return 0;
        }
        if (arrParametros.length < 1) {
            return 0;
        }
        int nObjectosEliminados = 0;
        TrParametro parametroAux = null;
        for (int n = 0; n < arrParametros.length; ++n) {
            parametroAux = (TrParametro)arrParametros[n];
            if (this.entidadRelacionada(parametroAux)) continue;
            this.ddp.getParametrosInvolucrados().remove(parametroAux);
            ++nObjectosEliminados;
        }
        return nObjectosEliminados;
    }

    public int eliminarPerfilesU(Object[] arrPerfilesU) {
        if (this.ddp == null) {
            return 0;
        }
        if (arrPerfilesU == null) {
            return 0;
        }
        if (arrPerfilesU.length < 1) {
            return 0;
        }
        int nObjectosEliminados = 0;
        TrPerfilUsuario perfilAux = null;
        for (int n = 0; n < arrPerfilesU.length; ++n) {
            perfilAux = (TrPerfilUsuario)arrPerfilesU[n];
            if (this.entidadRelacionada(perfilAux)) continue;
            this.ddp.getPerfilesUsuarioInvolucrados().remove(perfilAux);
            ++nObjectosEliminados;
        }
        return nObjectosEliminados;
    }

    private boolean entidadRelacionada(Object entidad) {
        int c;
        ArrayList<DDPGrafico> listaGraficos = new ArrayList<DDPGrafico>();
        DDPGrafico graficoAux = null;
        if (this.ddp.getDDPPadre() == null) {
            listaGraficos.add(this.ddp);
            for (c = 0; c < this.ddp.getListaDDPs().size(); ++c) {
                listaGraficos.add((DDPGrafico)this.ddp.getListaDDPs().get(c));
            }
        } else {
            listaGraficos.add(this.ddp.getDDPPadre());
            for (c = 0; c < this.ddp.getDDPPadre().getListaDDPs().size(); ++c) {
                listaGraficos.add((DDPGrafico)this.ddp.getDDPPadre().getListaDDPs().get(c));
            }
        }
        if (entidad instanceof TrMetafase) {
            TrMetafase metaAux = (TrMetafase)entidad;
            if (this.ddp.getFasesInvolucradas() == null) {
                return false;
            }
            if (this.ddp.getFasesInvolucradas().getListaDatos() == null) {
                return false;
            }
            if (this.ddp.getFasesInvolucradas().getListaDatos().size() < 1) {
                return false;
            }
            TrFase faseAux = null;
            ArrayList arrFases = this.ddp.getFasesInvolucradas().getListaDatos();
            for (int n = 0; n < arrFases.size(); ++n) {
                faseAux = (TrFase)arrFases.get(n);
                if (faseAux.getMETAFASE() == null || faseAux.getMETAFASE().getMETAID().longValue() != metaAux.getMETAID().longValue()) continue;
                return true;
            }
            return false;
        }
        if (entidad instanceof TrTipoActo) {
            int n;
            TrTipoActo tipoAux = (TrTipoActo)entidad;
            boolean validarTransiciones = true;
            if (this.ddp.getTransicionesInvolucradas() == null) {
                validarTransiciones = false;
            }
            if (this.ddp.getTransicionesInvolucradas().getListaDatos() == null) {
                validarTransiciones = false;
            }
            if (this.ddp.getTransicionesInvolucradas().getListaDatos().size() < 1) {
                validarTransiciones = false;
            }
            if (validarTransiciones) {
                TrTransicion transiAux = null;
                ArrayList arrTransi = this.ddp.getTransicionesInvolucradas().getListaDatos();
                for (n = 0; n < arrTransi.size(); ++n) {
                    transiAux = (TrTransicion)arrTransi.get(n);
                    if (transiAux.getTipoActo() == null || transiAux.getTipoActo().getTIPOID().longValue() != tipoAux.getTIPOID().longValue()) continue;
                    return true;
                }
            }
            if (this.ddp.getVariablesInvolucradas() == null) {
                return false;
            }
            if (this.ddp.getVariablesInvolucradas().getListaDatos() == null) {
                return false;
            }
            if (this.ddp.getVariablesInvolucradas().getListaDatos().size() < 1) {
                return false;
            }
            TrVariable variableAux = null;
            ArrayList arrVariables = this.ddp.getVariablesInvolucradas().getListaDatos();
            for (n = 0; n < arrVariables.size(); ++n) {
                variableAux = (TrVariable)arrVariables.get(n);
                if (variableAux.getTipoActo() == null || variableAux.getTipoActo().getTIPOID().longValue() != tipoAux.getTIPOID().longValue()) continue;
                return true;
            }
            return false;
        }
        if (entidad instanceof TrTarea) {
            TrTarea tareaAux = (TrTarea)entidad;
            if (this.ddp.getFasesInvolucradas() == null) {
                return false;
            }
            if (this.ddp.getFasesInvolucradas().getListaDatos() == null) {
                return false;
            }
            if (this.ddp.getFasesInvolucradas().getListaDatos().size() < 1) {
                return false;
            }
            TrFase faseAux = null;
            TrTareaEnFase tareaEnFaseAux = null;
            ArrayList arrFases = this.ddp.getFasesInvolucradas().getListaDatos();
            for (int n = 0; n < arrFases.size(); ++n) {
                faseAux = (TrFase)arrFases.get(n);
                if (faseAux.getConjuntoTareasEnFase() == null || faseAux.getConjuntoTareasEnFase().getListaDatos() == null) continue;
                ArrayList arrTareasEnFase = faseAux.getConjuntoTareasEnFase().getListaDatos();
                for (int i = 0; i < arrTareasEnFase.size(); ++i) {
                    tareaEnFaseAux = (TrTareaEnFase)arrTareasEnFase.get(i);
                    if (tareaEnFaseAux.getTarea() == null || tareaEnFaseAux.getTarea().getID_TAREA().longValue() != tareaAux.getID_TAREA().longValue()) continue;
                    return true;
                }
            }
            return false;
        }
        if (entidad instanceof TrTipoDocumento) {
            TrTipoDocumento tipoDocAux = (TrTipoDocumento)entidad;
            if (this.ddp.getTareasInvolucradas() == null) {
                return false;
            }
            if (this.ddp.getTareasInvolucradas().getListaDatos() == null) {
                return false;
            }
            if (this.ddp.getTareasInvolucradas().getListaDatos().size() < 1) {
                return false;
            }
            TrTarea tareaAux = null;
            ArrayList arrTareas = this.ddp.getTareasInvolucradas().getListaDatos();
            for (int n = 0; n < arrTareas.size(); ++n) {
                tareaAux = (TrTarea)arrTareas.get(n);
                if (!(tareaAux instanceof TrDocumentoPermitido) || ((TrDocumentoPermitido)tareaAux).getTipoDocumento() == null || ((TrDocumentoPermitido)tareaAux).getTipoDocumento().getXID().longValue() != tipoDocAux.getXID().longValue()) continue;
                return true;
            }
            return false;
        }
        if (entidad instanceof TrBloque) {
            TrBloque bloqueAux = (TrBloque)entidad;
            if (this.ddp.getTareasInvolucradas() == null) {
                return false;
            }
            if (this.ddp.getTareasInvolucradas().getListaDatos() == null) {
                return false;
            }
            if (this.ddp.getTareasInvolucradas().getListaDatos().size() < 1) {
                return false;
            }
            TrTarea tareaAux = null;
            ArrayList arrTareas = this.ddp.getTareasInvolucradas().getListaDatos();
            for (int n = 0; n < arrTareas.size(); ++n) {
                tareaAux = (TrTarea)arrTareas.get(n);
                if (!(tareaAux instanceof TrBloquePermitido) || ((TrBloquePermitido)tareaAux).getBloqueFin() == null || ((TrBloquePermitido)tareaAux).getBloqueFin().getBloqueId().getPkVal().longValue() != bloqueAux.getBloqueId().getPkVal().longValue()) continue;
                return true;
            }
            return false;
        }
        if (entidad instanceof TrTareaEnFase) {
            TrTareaEnFase tareaEnFaseAux = (TrTareaEnFase)entidad;
            boolean validarTareas = true;
            for (int d = 0; d < listaGraficos.size(); ++d) {
                graficoAux = (DDPGrafico)listaGraficos.get(d);
                validarTareas = true;
                if (graficoAux.getTareaFaseDefProcInvolucradas() == null) {
                    validarTareas = false;
                }
                if (graficoAux.getTareaFaseDefProcInvolucradas().getListaDatos() == null) {
                    validarTareas = false;
                }
                if (graficoAux.getTareaFaseDefProcInvolucradas().getListaDatos().size() < 1) {
                    validarTareas = false;
                }
                if (!validarTareas) continue;
                TrTareaEnFaseDefProcedimiento tareaEnFaseDefProcAux = null;
                ArrayList arrTareasEnFaseDefProc = graficoAux.getTareaFaseDefProcInvolucradas().getListaDatos();
                for (int n = 0; n < arrTareasEnFaseDefProc.size(); ++n) {
                    tareaEnFaseDefProcAux = (TrTareaEnFaseDefProcedimiento)arrTareasEnFaseDefProc.get(n);
                    if (tareaEnFaseDefProcAux.getTareaEnFase() == null || tareaEnFaseDefProcAux.getTareaEnFase().getX_ID().longValue() != tareaEnFaseAux.getX_ID().longValue()) continue;
                    return true;
                }
            }
            return false;
        }
        if (entidad instanceof TrTareaEnFaseDefProcedimiento) {
            return false;
        }
        if (entidad instanceof TrAccion) {
            TrAccion accionAux = (TrAccion)entidad;
            boolean validarTransiciones = true;
            boolean validarTareas = true;
            for (int d = 0; d < listaGraficos.size(); ++d) {
                int i;
                int n;
                graficoAux = (DDPGrafico)listaGraficos.get(d);
                validarTransiciones = true;
                if (graficoAux.getTransicionesDelProcInvolucradas() == null) {
                    validarTransiciones = false;
                }
                if (graficoAux.getTransicionesDelProcInvolucradas().getListaDatos() == null) {
                    validarTransiciones = false;
                }
                if (graficoAux.getTransicionesDelProcInvolucradas().getListaDatos().size() < 1) {
                    validarTransiciones = false;
                }
                if (validarTransiciones) {
                    TrTransicionDefProcedimiento transicionAux = null;
                    ArrayList arrTransicionesDefProc = graficoAux.getTransicionesDelProcInvolucradas().getListaDatos();
                    ArrayList arrAccionesEnTransi = null;
                    TrAccionTransicion accionTransicion = null;
                    for (n = 0; n < arrTransicionesDefProc.size(); ++n) {
                        transicionAux = (TrTransicionDefProcedimiento)arrTransicionesDefProc.get(n);
                        if (transicionAux.getConjuntoAccionTransicion() == null || transicionAux.getConjuntoAccionTransicion().getListaDatos() == null) continue;
                        arrAccionesEnTransi = transicionAux.getConjuntoAccionTransicion().getListaDatos();
                        for (i = 0; i < arrAccionesEnTransi.size(); ++i) {
                            accionTransicion = (TrAccionTransicion)arrAccionesEnTransi.get(i);
                            if (accionTransicion == null || accionTransicion.getAccion() == null || accionAux.getXID().longValue() != accionTransicion.getAccion().getXID().longValue()) continue;
                            return true;
                        }
                    }
                }
                validarTareas = true;
                if (graficoAux.getTareaFaseDefProcInvolucradas() == null) {
                    validarTareas = false;
                }
                if (graficoAux.getTareaFaseDefProcInvolucradas().getListaDatos() == null) {
                    validarTareas = false;
                }
                if (graficoAux.getTareaFaseDefProcInvolucradas().getListaDatos().size() < 1) {
                    validarTareas = false;
                }
                if (!validarTareas) continue;
                TrTareaEnFaseDefProcedimiento tareaAux = null;
                ArrayList arrTareasDefProc = graficoAux.getTareaFaseDefProcInvolucradas().getListaDatos();
                ArrayList arrAccionesEnTareas = null;
                TrAccionTareaFase accionTarea = null;
                for (n = 0; n < arrTareasDefProc.size(); ++n) {
                    tareaAux = (TrTareaEnFaseDefProcedimiento)arrTareasDefProc.get(n);
                    if (tareaAux.getConjuntoAccionTareaFase() == null || tareaAux.getConjuntoAccionTareaFase().getListaDatos() == null) continue;
                    arrAccionesEnTareas = tareaAux.getConjuntoAccionTareaFase().getListaDatos();
                    for (i = 0; i < arrAccionesEnTareas.size(); ++i) {
                        accionTarea = (TrAccionTareaFase)arrAccionesEnTareas.get(i);
                        if (accionTarea == null || accionTarea.getAccion() == null || accionAux.getXID().longValue() != accionTarea.getAccion().getXID().longValue()) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        if (entidad instanceof TrCondicion) {
            TrCondicion condicionAux = (TrCondicion)entidad;
            boolean validarTransiciones = true;
            boolean validarTareas = true;
            for (int d = 0; d < listaGraficos.size(); ++d) {
                int i;
                int n;
                graficoAux = (DDPGrafico)listaGraficos.get(d);
                validarTransiciones = true;
                if (graficoAux.getTransicionesDelProcInvolucradas() == null) {
                    validarTransiciones = false;
                }
                if (graficoAux.getTransicionesDelProcInvolucradas().getListaDatos() == null) {
                    validarTransiciones = false;
                }
                if (graficoAux.getTransicionesDelProcInvolucradas().getListaDatos().size() < 1) {
                    validarTransiciones = false;
                }
                if (validarTransiciones) {
                    TrTransicionDefProcedimiento transicionAux = null;
                    ArrayList arrTransicionesDefProc = graficoAux.getTransicionesDelProcInvolucradas().getListaDatos();
                    ArrayList arrCondicionesEnTransi = null;
                    TrCondicionTransicion condicionTransicion = null;
                    for (n = 0; n < arrTransicionesDefProc.size(); ++n) {
                        transicionAux = (TrTransicionDefProcedimiento)arrTransicionesDefProc.get(n);
                        if (transicionAux.getConjuntoCondicionTransicion() == null || transicionAux.getConjuntoCondicionTransicion().getListaDatos() == null) continue;
                        arrCondicionesEnTransi = transicionAux.getConjuntoCondicionTransicion().getListaDatos();
                        for (i = 0; i < arrCondicionesEnTransi.size(); ++i) {
                            condicionTransicion = (TrCondicionTransicion)arrCondicionesEnTransi.get(i);
                            if (condicionTransicion == null || condicionTransicion.getCondicion() == null || condicionAux.getXID().longValue() != condicionTransicion.getCondicion().getXID().longValue()) continue;
                            return true;
                        }
                    }
                }
                validarTareas = true;
                if (graficoAux.getTareaFaseDefProcInvolucradas() == null) {
                    validarTareas = false;
                }
                if (graficoAux.getTareaFaseDefProcInvolucradas().getListaDatos() == null) {
                    validarTareas = false;
                }
                if (graficoAux.getTareaFaseDefProcInvolucradas().getListaDatos().size() < 1) {
                    validarTareas = false;
                }
                if (!validarTareas) continue;
                TrTareaEnFaseDefProcedimiento tareaAux = null;
                ArrayList arrTareasDefProc = graficoAux.getTareaFaseDefProcInvolucradas().getListaDatos();
                ArrayList arrCondicionesEnTareas = null;
                TrCondicionTareaFase condicionTarea = null;
                for (n = 0; n < arrTareasDefProc.size(); ++n) {
                    tareaAux = (TrTareaEnFaseDefProcedimiento)arrTareasDefProc.get(n);
                    if (tareaAux.getConjuntoCondicionTareaFase() == null || tareaAux.getConjuntoCondicionTareaFase().getListaDatos() == null) continue;
                    arrCondicionesEnTareas = tareaAux.getConjuntoCondicionTareaFase().getListaDatos();
                    for (i = 0; i < arrCondicionesEnTareas.size(); ++i) {
                        condicionTarea = (TrCondicionTareaFase)arrCondicionesEnTareas.get(i);
                        if (condicionTarea == null || condicionTarea.getCondicion() == null || condicionAux.getXID().longValue() != condicionTarea.getCondicion().getXID().longValue()) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        if (entidad instanceof TrAviso) {
            TrAviso avisoAux = (TrAviso)entidad;
            boolean validarTransiciones = true;
            boolean validarTareas = true;
            for (int d = 0; d < listaGraficos.size(); ++d) {
                int i;
                int n;
                graficoAux = (DDPGrafico)listaGraficos.get(d);
                validarTransiciones = true;
                if (graficoAux.getTransicionesDelProcInvolucradas() == null) {
                    validarTransiciones = false;
                }
                if (graficoAux.getTransicionesDelProcInvolucradas().getListaDatos() == null) {
                    validarTransiciones = false;
                }
                if (graficoAux.getTransicionesDelProcInvolucradas().getListaDatos().size() < 1) {
                    validarTransiciones = false;
                }
                if (validarTransiciones) {
                    TrTransicionDefProcedimiento transicionAux = null;
                    ArrayList arrTransicionesDefProc = graficoAux.getTransicionesDelProcInvolucradas().getListaDatos();
                    ArrayList arrAvisosEnTransi = null;
                    TrAvisoTransicion avisoTransicion = null;
                    for (n = 0; n < arrTransicionesDefProc.size(); ++n) {
                        transicionAux = (TrTransicionDefProcedimiento)arrTransicionesDefProc.get(n);
                        if (transicionAux.getConjuntoAvisoTransicion() == null || transicionAux.getConjuntoAvisoTransicion().getListaDatos() == null) continue;
                        arrAvisosEnTransi = transicionAux.getConjuntoAvisoTransicion().getListaDatos();
                        for (i = 0; i < arrAvisosEnTransi.size(); ++i) {
                            avisoTransicion = (TrAvisoTransicion)arrAvisosEnTransi.get(i);
                            if (avisoTransicion == null || avisoTransicion.getAviso() == null || avisoAux.getXID().longValue() != avisoTransicion.getAviso().getXID().longValue()) continue;
                            return true;
                        }
                    }
                }
                validarTareas = true;
                if (graficoAux.getTareaFaseDefProcInvolucradas() == null) {
                    validarTareas = false;
                }
                if (graficoAux.getTareaFaseDefProcInvolucradas().getListaDatos() == null) {
                    validarTareas = false;
                }
                if (graficoAux.getTareaFaseDefProcInvolucradas().getListaDatos().size() < 1) {
                    validarTareas = false;
                }
                if (!validarTareas) continue;
                TrTareaEnFaseDefProcedimiento tareaAux = null;
                ArrayList arrTareasDefProc = graficoAux.getTareaFaseDefProcInvolucradas().getListaDatos();
                ArrayList arrAvisosEnTareas = null;
                TrAvisoTareaFase avisoTarea = null;
                for (n = 0; n < arrTareasDefProc.size(); ++n) {
                    tareaAux = (TrTareaEnFaseDefProcedimiento)arrTareasDefProc.get(n);
                    if (tareaAux.getConjuntoAvisoTareaFase() == null || tareaAux.getConjuntoAvisoTareaFase().getListaDatos() == null) continue;
                    arrAvisosEnTareas = tareaAux.getConjuntoAvisoTareaFase().getListaDatos();
                    for (i = 0; i < arrAvisosEnTareas.size(); ++i) {
                        avisoTarea = (TrAvisoTareaFase)arrAvisosEnTareas.get(i);
                        if (avisoTarea == null || avisoTarea.getAviso() == null || avisoAux.getXID().longValue() != avisoTarea.getAviso().getXID().longValue()) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        if (entidad instanceof TrTipoParrafo) {
            TrTipoParrafo tipoParrafoAux = (TrTipoParrafo)entidad;
            if (this.ddp.getTipoDocumentosInvolucrados() == null) {
                return false;
            }
            if (this.ddp.getTipoDocumentosInvolucrados().getListaDatos() == null) {
                return false;
            }
            if (this.ddp.getTipoDocumentosInvolucrados().getListaDatos().size() < 1) {
                return false;
            }
            TrTipoDocumento tipoDocAux = null;
            ArrayList arrTiposDoc = this.ddp.getTipoDocumentosInvolucrados().getListaDatos();
            for (int n = 0; n < arrTiposDoc.size(); ++n) {
                tipoDocAux = (TrTipoDocumento)arrTiposDoc.get(n);
                if (tipoDocAux.getParrafoTipoDoc() == null || tipoDocAux.getParrafoTipoDoc().size() <= 0) continue;
                for (int i = 0; i < tipoDocAux.getParrafoTipoDoc().size(); ++i) {
                    TrParrafoTipDoc tipoPAux;
                    if (tipoDocAux.getParrafoTipoDoc() == null || tipoDocAux.getParrafoTipoDoc().size() <= 0 || (tipoPAux = (TrParrafoTipDoc)tipoDocAux.getParrafoTipoDoc().get(i)).getTipoParrafo() == null || tipoPAux.getTipoParrafo().getXID().longValue() != tipoParrafoAux.getXID().longValue()) continue;
                    return true;
                }
            }
            return false;
        }
        if (entidad instanceof TrVariable) {
            TrVariable variableAux = (TrVariable)entidad;
            if (this.ddp.getTipoDocumentosInvolucrados() == null) {
                return false;
            }
            if (this.ddp.getTipoDocumentosInvolucrados().getListaDatos() == null) {
                return false;
            }
            if (this.ddp.getTipoDocumentosInvolucrados().getListaDatos().size() < 1) {
                return false;
            }
            TrTipoDocumento tipoDocAux = null;
            ArrayList arrTiposDoc = this.ddp.getTipoDocumentosInvolucrados().getListaDatos();
            for (int n = 0; n < arrTiposDoc.size(); ++n) {
                tipoDocAux = (TrTipoDocumento)arrTiposDoc.get(n);
                if (tipoDocAux.getVariables() == null || tipoDocAux.getVariables().size() <= 0) continue;
                for (int i = 0; i < tipoDocAux.getVariables().size(); ++i) {
                    TrVariable varAux = (TrVariable)tipoDocAux.getVariables().get(i);
                    if (varAux.getVARIABLEID().getPkVal().longValue() != variableAux.getVARIABLEID().getPkVal().longValue()) continue;
                    return true;
                }
            }
            return false;
        }
        if (entidad instanceof TrPlantilla) {
            TrPlantilla plantillaAux = (TrPlantilla)entidad;
            if (this.ddp.getTipoDocumentosInvolucrados() == null) {
                return false;
            }
            if (this.ddp.getTipoDocumentosInvolucrados().getListaDatos() == null) {
                return false;
            }
            if (this.ddp.getTipoDocumentosInvolucrados().getListaDatos().size() < 1) {
                return false;
            }
            TrTipoDocumento tipoDocAux = null;
            ArrayList arrTiposDoc = this.ddp.getTipoDocumentosInvolucrados().getListaDatos();
            for (int n = 0; n < arrTiposDoc.size(); ++n) {
                tipoDocAux = (TrTipoDocumento)arrTiposDoc.get(n);
                if (tipoDocAux.getPlantilla() == null || tipoDocAux.getPlantilla().getXID().longValue() != plantillaAux.getXID().longValue()) continue;
                return true;
            }
            return false;
        }
        if (entidad instanceof TrParametro) {
            TrParametro parametroAux = (TrParametro)entidad;
            boolean validarVariables = true;
            if (this.ddp.getVariablesInvolucradas() == null) {
                validarVariables = false;
            }
            if (this.ddp.getVariablesInvolucradas().getListaDatos() == null) {
                validarVariables = false;
            }
            if (this.ddp.getVariablesInvolucradas().getListaDatos().size() < 1) {
                validarVariables = false;
            }
            if (validarVariables) {
                TrVariable variableAux = null;
                ArrayList arrVariables = this.ddp.getVariablesInvolucradas().getListaDatos();
                for (int n = 0; n < arrVariables.size(); ++n) {
                    variableAux = (TrVariable)arrVariables.get(n);
                    if (variableAux.getParametros() == null) continue;
                    for (int i = 0; i < variableAux.getParametros().size(); ++i) {
                        if (parametroAux.getPARAMID().getPkVal().longValue() != ((TrParametro)variableAux.getParametros().get(i)).getPARAMID().getPkVal().longValue()) continue;
                        return true;
                    }
                }
            }
            if (this.ddp.getBloquesInvolucrados() == null) {
                return false;
            }
            if (this.ddp.getBloquesInvolucrados().getListaDatos() == null) {
                return false;
            }
            if (this.ddp.getBloquesInvolucrados().getListaDatos().size() < 1) {
                return false;
            }
            TrBloque bloqueAux = null;
            ArrayList arrBloques = this.ddp.getBloquesInvolucrados().getListaDatos();
            for (int b = 0; b < arrBloques.size(); ++b) {
                bloqueAux = (TrBloque)arrBloques.get(b);
                if (bloqueAux.getParametros() == null) continue;
                for (int bi = 0; bi < bloqueAux.getParametros().size(); ++bi) {
                    if (parametroAux.getPARAMID().getPkVal().longValue() != ((TrParametro)bloqueAux.getParametros().get(bi)).getPARAMID().getPkVal().longValue()) continue;
                    return true;
                }
            }
            return false;
        }
        if (entidad instanceof TrPerfilUsuario) {
            TrPerfilUsuario perfilAux = (TrPerfilUsuario)entidad;
            boolean validarTransiciones = true;
            boolean validarTareas = true;
            for (int d = 0; d < listaGraficos.size(); ++d) {
                int i;
                int n;
                graficoAux = (DDPGrafico)listaGraficos.get(d);
                validarTransiciones = true;
                if (graficoAux.getTransicionesDelProcInvolucradas() == null) {
                    validarTransiciones = false;
                }
                if (graficoAux.getTransicionesDelProcInvolucradas().getListaDatos() == null) {
                    validarTransiciones = false;
                }
                if (graficoAux.getTransicionesDelProcInvolucradas().getListaDatos().size() < 1) {
                    validarTransiciones = false;
                }
                if (validarTransiciones) {
                    TrTransicionDefProcedimiento transicionAux = null;
                    ArrayList arrTransicionesDefProc = graficoAux.getTransicionesDelProcInvolucradas().getListaDatos();
                    ArrayList arrPerfilesEnTransi = null;
                    TrPerfilTransEvol perfilTransicion = null;
                    for (n = 0; n < arrTransicionesDefProc.size(); ++n) {
                        transicionAux = (TrTransicionDefProcedimiento)arrTransicionesDefProc.get(n);
                        if (transicionAux.getConjuntoPerfilTransEvol() == null || transicionAux.getConjuntoPerfilTransEvol().getListaDatos() == null) continue;
                        arrPerfilesEnTransi = transicionAux.getConjuntoPerfilTransEvol().getListaDatos();
                        for (i = 0; i < arrPerfilesEnTransi.size(); ++i) {
                            perfilTransicion = (TrPerfilTransEvol)arrPerfilesEnTransi.get(i);
                            if (perfilTransicion == null || perfilTransicion.getPERFIL() == null || perfilAux.getX_PEUS().longValue() != perfilTransicion.getPERFIL().getX_PEUS().longValue()) continue;
                            return true;
                        }
                    }
                }
                validarTareas = true;
                if (graficoAux.getTareaFaseDefProcInvolucradas() == null) {
                    validarTareas = false;
                }
                if (graficoAux.getTareaFaseDefProcInvolucradas().getListaDatos() == null) {
                    validarTareas = false;
                }
                if (graficoAux.getTareaFaseDefProcInvolucradas().getListaDatos().size() < 1) {
                    validarTareas = false;
                }
                if (!validarTareas) continue;
                TrTareaEnFaseDefProcedimiento tareaAux = null;
                ArrayList arrTareasDefProc = graficoAux.getTareaFaseDefProcInvolucradas().getListaDatos();
                ArrayList arrPerfilesEnTareas = null;
                TrPerfilTareaFase perfilTarea = null;
                for (n = 0; n < arrTareasDefProc.size(); ++n) {
                    tareaAux = (TrTareaEnFaseDefProcedimiento)arrTareasDefProc.get(n);
                    if (tareaAux.getConjuntoPerfilesTareaFase() == null || tareaAux.getConjuntoPerfilesTareaFase().getListaDatos() == null) continue;
                    arrPerfilesEnTareas = tareaAux.getConjuntoPerfilesTareaFase().getListaDatos();
                    for (i = 0; i < arrPerfilesEnTareas.size(); ++i) {
                        perfilTarea = (TrPerfilTareaFase)arrPerfilesEnTareas.get(i);
                        if (perfilTarea == null || perfilTarea.getPERFIL() == null || perfilAux.getX_PEUS().longValue() != perfilTarea.getPERFIL().getX_PEUS().longValue()) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        if (entidad instanceof TrPlazoCompuestoDefProc) {
            return false;
        }
        if (entidad instanceof TrNormativa) {
            return false;
        }
        return false;
    }
}

