/*
 * Decompiled with CFR 0.152.
 */
package modela.graf;

import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import gdtel.ui.piccolo.activities.PParpadeoActivity;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import modela.bd.obj.TrExpediente;
import modela.bd.obj.TrExpedienteEnFase;
import modela.bean.BeanModela;
import modela.graf.DDPGrafico;
import modela.ui.piccolo.nodes.DivisionPNode;
import modela.ui.piccolo.nodes.PNodoGrafico;
import modela.ui.piccolo.nodes.PostItPNode;
import modela.ui.piccolo.nodes.TransicionPNode;

public class ExpedienteGrafico {
    private TrExpediente expediente = null;
    private ArrayList listaFasesExpediente = null;
    private TrExpedienteEnFase expedienteEnFaseActivo = null;
    private BeanModela beanAsociado = null;
    private ArrayList listaRectangulos = null;
    private boolean bPausado = false;
    private boolean bStopEvolucion = false;

    public TrExpediente getExpediente() {
        return this.expediente;
    }

    public void setExpediente(TrExpediente pExpediente) {
        this.expediente = pExpediente;
    }

    public void setBeanAsociado(BeanModela bean) {
        this.beanAsociado = bean;
    }

    public boolean representarExpedienteEnFase(long pDelayPintado, boolean pbDesplazarVista, long pDelayDesplazamientoVista, int pTipoVista) {
        int n;
        if (this.expediente == null) {
            return false;
        }
        if (this.expediente.getGrafico() == null) {
            return false;
        }
        if (pTipoVista != 1 && pTipoVista != 4 && pTipoVista != 2 && pTipoVista != 3) {
            return false;
        }
        this.listaFasesExpediente = this.expediente.getExpedientesEnFase();
        if (pbDesplazarVista && pTipoVista == 1 && !this.bStopEvolucion) {
            this.expediente.getGrafico().getCanvas().aplicarVista(pTipoVista, pDelayDesplazamientoVista, null);
            if (this.expediente.getGrafico().getListaDDPs().size() > 0) {
                for (n = 0; n < this.expediente.getGrafico().getListaDDPs().size(); ++n) {
                    ((DDPGrafico)this.expediente.getGrafico().getListaDDPs().get(n)).getCanvas().aplicarVista(pTipoVista, pDelayDesplazamientoVista, null);
                }
            }
            this.esperarDurante(pDelayDesplazamientoVista + 250L);
        }
        this.expediente.getGrafico().getCanvas().repaint();
        if (this.expediente.getGrafico().getListaDDPs().size() > 0) {
            for (n = 0; n < this.expediente.getGrafico().getListaDDPs().size(); ++n) {
                ((DDPGrafico)this.expediente.getGrafico().getListaDDPs().get(n)).getCanvas().repaint();
            }
        }
        this.bPausado = pDelayPintado > 0L;
        this.bStopEvolucion = false;
        boolean bTransicionesNoLocalizadas = false;
        for (int n2 = 0; n2 < this.listaFasesExpediente.size(); ++n2) {
            if (this.bStopEvolucion) {
                return this.trasPeticionDeParada();
            }
            this.esperarDurante(pDelayPintado);
            this.expedienteEnFaseActivo = (TrExpedienteEnFase)this.listaFasesExpediente.get(n2);
            if (this.expedienteEnFaseActivo.getTransicion() != null) {
                if (this.bStopEvolucion) {
                    return this.trasPeticionDeParada();
                }
                if (this.expedienteEnFaseActivo.getTransicion().getTIPO().equals("N") || this.expedienteEnFaseActivo.getTransicion().getTIPO().equals("I") || this.expedienteEnFaseActivo.getTransicion().getTIPO().equals("EN") || this.expedienteEnFaseActivo.getTransicion().getTIPO().equals("ES")) {
                    this.beanAsociado.seleccionarTabAsociado(this.expedienteEnFaseActivo.getGrafico());
                    this.representarTipoInicioNormalYEventos(pbDesplazarVista, pDelayDesplazamientoVista, pTipoVista);
                }
                if (this.bStopEvolucion) {
                    return this.trasPeticionDeParada();
                }
                if (this.expedienteEnFaseActivo.getTransicion().getTIPO().equals("U")) {
                    this.beanAsociado.seleccionarTabAsociado(this.expedienteEnFaseActivo.getGrafico());
                    this.representarTipoUnion(pbDesplazarVista, pDelayDesplazamientoVista, pTipoVista);
                }
                if (this.bStopEvolucion) {
                    return this.trasPeticionDeParada();
                }
                if (this.expedienteEnFaseActivo.getTransicion().getTIPO().equals("D")) {
                    this.beanAsociado.seleccionarTabAsociado(this.expedienteEnFaseActivo.getGrafico());
                    this.representarTipoDivision(pbDesplazarVista, pDelayDesplazamientoVista, pTipoVista);
                }
                this.expediente.getGrafico().getCanvas().repaint();
                if (this.expediente.getGrafico().getListaDDPs().size() <= 0) continue;
                for (int n22 = 0; n22 < this.expediente.getGrafico().getListaDDPs().size(); ++n22) {
                    ((DDPGrafico)this.expediente.getGrafico().getListaDDPs().get(n22)).getCanvas().repaint();
                }
                continue;
            }
            System.out.println("\n- [ATENCI\u00d3N] El expediente apunta a transiciones que no vienen en el DDP:");
            System.out.println("- ID Transici\u00f3n: " + this.expedienteEnFaseActivo.getTRANSICION_ID());
            System.out.println("- Descripci\u00f3n Transici\u00f3n: " + this.expedienteEnFaseActivo.getDescripcionTransicion());
            System.out.println("- Puede esta transici\u00f3n ya no exista o est\u00e9 invalidada en el procedimiento");
            bTransicionesNoLocalizadas = true;
        }
        if (bTransicionesNoLocalizadas) {
            JOptionPane.showMessageDialog(this.beanAsociado, "No se puede representar la evoluci\u00f3n por ciertas transiciones:\nConsulte la consola Java para m\u00e1s detalle.", "Applet de Model@", 2);
        }
        return true;
    }

    private void representarTipoInicioNormalYEventos(boolean pbDesplazarVista, long pDelayDesplazamientoVista, int pTipoVista) {
        ArrayList arrGraficos = this.expedienteEnFaseActivo.getGrafico().getCanvas().obtenerGraficosRelacionados(this.expedienteEnFaseActivo.getTransicion());
        if (arrGraficos == null) {
            return;
        }
        if (arrGraficos.size() != 3) {
            return;
        }
        ArrayList<Rectangle2D> arrExtensiones = new ArrayList<Rectangle2D>();
        for (int g = 0; g < arrGraficos.size(); ++g) {
            if (arrGraficos.get(g) instanceof PPath) {
                arrExtensiones.add(((PPath)arrGraficos.get(g)).getGlobalBounds().getBounds2D());
                continue;
            }
            if (!(arrGraficos.get(g) instanceof PNodoGrafico) || arrGraficos.get(g) instanceof PostItPNode) continue;
            arrExtensiones.add(((PNodoGrafico)arrGraficos.get(g)).getGlobalBounds().getBounds2D());
        }
        Rectangle2D rectanguloEnfoque = this.expedienteEnFaseActivo.getGrafico().getCanvas().calcularExtension(arrExtensiones);
        if (rectanguloEnfoque == null) {
            return;
        }
        if (pbDesplazarVista && (pTipoVista == 2 || pTipoVista == 4 || pTipoVista == 3) && !this.bStopEvolucion) {
            this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarVista(pTipoVista, pDelayDesplazamientoVista, rectanguloEnfoque);
            this.esperarDurante(pDelayDesplazamientoVista + 250L);
        }
        PNodoGrafico graficoInicio = (PNodoGrafico)arrGraficos.get(0);
        PNodoGrafico graficoFin = (PNodoGrafico)arrGraficos.get(1);
        TransicionPNode graficoTransi = (TransicionPNode)arrGraficos.get(2);
        if (graficoInicio == null || graficoFin == null || graficoTransi == null) {
            return;
        }
        if (this.expedienteEnFaseActivo.getFECHA_FINALIZACION() != null) {
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoInicio, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_COLOR_FIJO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoTransi, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_COLOR_FIJO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoFin, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_COLOR_FIJO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
        } else {
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoInicio, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_COLOR_FIJO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoTransi, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_COLOR_FIJO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoFin, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_PARPADEO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
        }
        if (pbDesplazarVista && !this.bStopEvolucion && pTipoVista == 3) {
            this.esperarDurante(pDelayDesplazamientoVista);
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarVista(1, 1000L, null);
                this.esperarDurante(pDelayDesplazamientoVista + 250L);
            }
        }
    }

    private void representarTipoDivision(boolean pbDesplazarVista, long pDelayDesplazamientoVista, int pTipoVista) {
        PNodoGrafico graficoFaseIni = null;
        TransicionPNode graficoTransi = null;
        PNodoGrafico graficoNodoDiv = null;
        TransicionPNode graficoTransiDiv = null;
        PNodoGrafico graficoFaseFin = null;
        graficoTransi = this.expedienteEnFaseActivo.getGrafico().getCanvas().localizarGraficoTransicion(this.expedienteEnFaseActivo.getTransicion());
        if (graficoTransi == null) {
            return;
        }
        if (graficoTransi.getPNodoGraficoFaseIni() != null && graficoTransi.getPNodoGraficoFaseIni().getTrFaseGrAsociada() != null) {
            graficoFaseIni = this.expedienteEnFaseActivo.getGrafico().getCanvas().localizarGraficoFase(graficoTransi.getPNodoGraficoFaseIni().getTrFaseGrAsociada().getID());
        }
        if (graficoTransi.getPNodoGraficoFaseFin() != null && graficoTransi.getPNodoGraficoFaseFin().getTrFaseGrAsociada() != null) {
            graficoNodoDiv = this.expedienteEnFaseActivo.getGrafico().getCanvas().localizarGraficoFase(graficoTransi.getPNodoGraficoFaseFin().getTrFaseGrAsociada().getID());
        }
        if (graficoFaseIni == null || graficoNodoDiv == null) {
            return;
        }
        ArrayList arrRamificaciones = this.expedienteEnFaseActivo.getGrafico().getCanvas().localizarGraficosTransicionRelacionados(graficoNodoDiv.getTrFaseGrAsociada().getID(), "D");
        if (arrRamificaciones != null) {
            TransicionPNode graficoAux = null;
            for (int n = 0; n < arrRamificaciones.size(); ++n) {
                graficoAux = (TransicionPNode)arrRamificaciones.get(n);
                if (graficoAux.getPNodoGraficoFaseIni() == null || !(graficoAux.getPNodoGraficoFaseIni() instanceof DivisionPNode) || graficoAux.getPNodoGraficoFaseFin() == null || graficoAux.getPNodoGraficoFaseFin().getTrFaseGrAsociada() == null || graficoAux.getPNodoGraficoFaseFin().getTrFaseGrAsociada().getTrFase() == null || graficoAux.getPNodoGraficoFaseFin().getTrFaseGrAsociada().getTrFase().getFASEID().longValue() != this.expedienteEnFaseActivo.getFase().getFASEID().longValue()) continue;
                graficoTransiDiv = graficoAux;
                graficoFaseFin = graficoAux.getPNodoGraficoFaseFin();
            }
        }
        if (graficoFaseFin == null || graficoTransiDiv == null) {
            return;
        }
        if (pbDesplazarVista && (pTipoVista == 2 || pTipoVista == 4 || pTipoVista == 3)) {
            this.listaRectangulos = new ArrayList();
            this.listaRectangulos.add(graficoFaseIni.getGlobalBounds().getBounds2D());
            this.listaRectangulos.add(graficoTransi.getGlobalBounds().getBounds2D());
            this.listaRectangulos.add(graficoNodoDiv.getGlobalBounds().getBounds2D());
            this.listaRectangulos.add(graficoFaseFin.getGlobalBounds().getBounds2D());
            this.listaRectangulos.add(graficoTransiDiv.getGlobalBounds().getBounds2D());
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarVista(pTipoVista, pDelayDesplazamientoVista, this.expedienteEnFaseActivo.getGrafico().getCanvas().calcularExtension(this.listaRectangulos));
                this.esperarDurante(pDelayDesplazamientoVista + 250L);
            }
        }
        if (this.expedienteEnFaseActivo.getFECHA_FINALIZACION() != null) {
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoFaseIni, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_COLOR_FIJO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoTransi, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_COLOR_FIJO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoNodoDiv, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_COLOR_FIJO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoTransiDiv, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_COLOR_FIJO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoFaseFin, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_COLOR_FIJO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
        } else {
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoFaseIni, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_COLOR_FIJO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoTransi, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_COLOR_FIJO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoNodoDiv, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_COLOR_FIJO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoTransiDiv, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_COLOR_FIJO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoFaseFin, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_PARPADEO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
        }
        if (pbDesplazarVista && !this.bStopEvolucion && pTipoVista == 3) {
            this.esperarDurante(pDelayDesplazamientoVista);
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarVista(1, 1000L, null);
                this.esperarDurante(pDelayDesplazamientoVista + 250L);
            }
        }
    }

    private void representarTipoUnion(boolean pbDesplazarVista, long pDelayDesplazamientoVista, int pTipoVista) {
        ArrayList arrGraficos = this.expedienteEnFaseActivo.getGrafico().getCanvas().obtenerGraficosRelacionados(this.expedienteEnFaseActivo.getTransicion());
        if (arrGraficos == null) {
            return;
        }
        if (arrGraficos.size() != 5) {
            return;
        }
        ArrayList<Rectangle2D> arrExtensiones = new ArrayList<Rectangle2D>();
        for (int g = 0; g < arrGraficos.size(); ++g) {
            if (arrGraficos.get(g) instanceof PPath) {
                arrExtensiones.add(((PPath)arrGraficos.get(g)).getGlobalBounds().getBounds2D());
                continue;
            }
            if (!(arrGraficos.get(g) instanceof PNodoGrafico) || arrGraficos.get(g) instanceof PostItPNode) continue;
            arrExtensiones.add(((PNodoGrafico)arrGraficos.get(g)).getGlobalBounds().getBounds2D());
        }
        Rectangle2D rectanguloEnfoque = this.expedienteEnFaseActivo.getGrafico().getCanvas().calcularExtension(arrExtensiones);
        if (rectanguloEnfoque == null) {
            return;
        }
        if (pbDesplazarVista && (pTipoVista == 2 || pTipoVista == 4 || pTipoVista == 3) && !this.bStopEvolucion) {
            this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarVista(pTipoVista, pDelayDesplazamientoVista, rectanguloEnfoque);
            this.esperarDurante(pDelayDesplazamientoVista + 250L);
        }
        PNodoGrafico graficoFaseIni = (PNodoGrafico)arrGraficos.get(1);
        TransicionPNode graficoTransi = (TransicionPNode)arrGraficos.get(0);
        PNodoGrafico graficoNodoUni = (PNodoGrafico)arrGraficos.get(2);
        TransicionPNode graficoTransiUni = (TransicionPNode)arrGraficos.get(4);
        PNodoGrafico graficoFaseFin = (PNodoGrafico)arrGraficos.get(3);
        if (graficoFaseIni == null || graficoTransi == null || graficoNodoUni == null || graficoTransiUni == null || graficoFaseFin == null) {
            return;
        }
        if (this.expedienteEnFaseActivo.getFECHA_FINALIZACION() != null) {
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoFaseIni, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_COLOR_FIJO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoTransi, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_COLOR_FIJO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoNodoUni, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_COLOR_FIJO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoTransiUni, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_COLOR_FIJO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoFaseFin, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_COLOR_FIJO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
        } else {
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoFaseIni, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_COLOR_FIJO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoTransi, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_COLOR_FIJO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoNodoUni, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_COLOR_FIJO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoTransiUni, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_COLOR_FIJO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarEstilo(graficoFaseFin, this.expedienteEnFaseActivo.getGrafico().getCanvas().EFECTO_PARPADEO, -1L, PParpadeoActivity.APLICAR_A_RELLENO);
            }
            if (this.bPausado) {
                this.esperarDurante(750L);
            }
        }
        if (pbDesplazarVista && !this.bStopEvolucion && pTipoVista == 3) {
            this.esperarDurante(pDelayDesplazamientoVista);
            if (!this.bStopEvolucion) {
                this.expedienteEnFaseActivo.getGrafico().getCanvas().aplicarVista(1, 1000L, null);
                this.esperarDurante(pDelayDesplazamientoVista + 250L);
            }
        }
    }

    public boolean eliminarActivities() {
        if (this.expediente == null) {
            return false;
        }
        if (this.expediente.getGrafico() == null) {
            return false;
        }
        if (this.expediente.getGrafico().getCanvas() == null) {
            return false;
        }
        boolean resul = this.expediente.getGrafico().getCanvas().eliminarActivities();
        if (this.expediente.getGrafico().getListaDDPs().size() > 0) {
            for (int n = 0; n < this.expediente.getGrafico().getListaDDPs().size(); ++n) {
                ((DDPGrafico)this.expediente.getGrafico().getListaDDPs().get(n)).getCanvas().eliminarActivities();
            }
        }
        return resul;
    }

    private void esperarDurante(long nMilisegundos) {
        if (this.bStopEvolucion) {
            return;
        }
        try {
            Thread.sleep(nMilisegundos);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void pararEvolucionEnCurso() {
        this.bStopEvolucion = true;
    }

    public boolean trasPeticionDeParada() {
        int n;
        PBounds boundsTotal = this.expediente.getGrafico().getCanvas().getCamera().getUnionOfLayerFullBounds();
        this.expediente.getGrafico().getCanvas().getCamera().animateViewToCenterBounds((Rectangle2D)boundsTotal, true, 750L);
        if (this.expediente.getGrafico().getListaDDPs().size() > 0) {
            for (n = 0; n < this.expediente.getGrafico().getListaDDPs().size(); ++n) {
                boundsTotal = ((DDPGrafico)this.expediente.getGrafico().getListaDDPs().get(n)).getCanvas().getCamera().getUnionOfLayerFullBounds();
                ((DDPGrafico)this.expediente.getGrafico().getListaDDPs().get(n)).getCanvas().getCamera().animateViewToCenterBounds((Rectangle2D)boundsTotal, true, 750L);
            }
        }
        this.representarExpedienteEnFase(0L, false, 0L, 1);
        this.expediente.getGrafico().getCanvas().repaint();
        if (this.expediente.getGrafico().getListaDDPs().size() > 0) {
            for (n = 0; n < this.expediente.getGrafico().getListaDDPs().size(); ++n) {
                ((DDPGrafico)this.expediente.getGrafico().getListaDDPs().get(n)).getCanvas().repaint();
            }
        }
        return true;
    }
}

