/*
 * Decompiled with CFR 0.152.
 */
package modela.graf;

import gdtel.bd.tpo.TpoPK;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import modela.bd.obj.TrCaducidadExpediente;
import modela.bd.obj.TrExpediente;
import modela.bd.obj.TrExpedienteEnFase;
import modela.bd.obj.TrExpedienteRelacionado;
import modela.bd.obj.TrFase;
import modela.bd.obj.TrInteresado;
import modela.bd.obj.TrModificacionCaducidad;
import modela.bd.obj.TrTarea;
import modela.bd.obj.TrTareaExpediente;
import modela.bd.obj.TrTipoTarea;
import modela.bd.obj.TrTransicion;
import modela.bd.obj.TrUsuarioAsignado;
import modela.graf.DDPGrafico;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class LectorXMLExpediente
extends DefaultHandler {
    private DDPGrafico grafico;
    private Locator locator = null;
    private TrExpediente expedienteActivo = null;
    private TrInteresado interesadoActivo = null;
    private TrTareaExpediente tareaExpedienteActiva = null;
    private TrExpedienteEnFase expedienteEnFaseActivo = null;
    private TrUsuarioAsignado usuarioAsignadoActivo = null;
    private TrExpedienteRelacionado expedienteRelacionadoActivo = null;
    private TrCaducidadExpediente caducidadActiva = null;
    private TrModificacionCaducidad modificacionCaducidadActiva = null;
    private boolean bEnTareaExpediente = false;

    public boolean leerImputStream(InputStream inputStream) {
        if (inputStream == null) {
            return false;
        }
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = saxFactory.newSAXParser();
            saxParser.parse(inputStream, (DefaultHandler)this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean leerURL(String strURL) {
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = saxFactory.newSAXParser();
            saxParser.parse(strURL, (DefaultHandler)this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("- [ Error ] Durante la lectura del XML del Expediente: ");
            System.out.println("- Intentando crear fichero temporal en " + strURL);
            InputStream in = null;
            File f = null;
            try {
                URL url = new URL(strURL);
                in = url.openStream();
                if (in != null) {
                    int k;
                    int aBuffSize = 1;
                    String StringFromWS = "";
                    byte[] buff = new byte[aBuffSize];
                    ByteArrayOutputStream xOutputStream = new ByteArrayOutputStream(aBuffSize);
                    while ((k = in.read(buff)) != -1) {
                        ((OutputStream)xOutputStream).write(buff, 0, k);
                    }
                    StringFromWS = StringFromWS + ((Object)xOutputStream).toString();
                    String nombreFile = System.getProperty("java.io.tmpdir", "c:/");
                    if (!nombreFile.endsWith("/") && !nombreFile.endsWith("\\")) {
                        nombreFile = nombreFile + System.getProperty("file.separator");
                    }
                    nombreFile = nombreFile + "BeanModela_" + System.currentTimeMillis() + ".exp";
                    FileWriter fw = new FileWriter(nombreFile);
                    fw.write(StringFromWS);
                    fw.close();
                    f = new File(nombreFile);
                    strURL = f.getAbsolutePath();
                    System.out.println("- Parseando fichero temporal en " + strURL);
                    SAXParser saxParser = saxFactory.newSAXParser();
                    saxParser.parse(strURL, (DefaultHandler)this);
                    if (f.exists()) {
                        f.delete();
                    }
                }
                return false;
            }
            catch (Exception e) {
                if (f == null) {
                    e.printStackTrace();
                    return false;
                }
                if (f.exists()) {
                    f.delete();
                }
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() {
        System.out.println("- [ Info ] Comienza la lectura del documento XML del Expediente...");
        if (this.grafico == null) {
            return;
        }
    }

    public void endDocument() {
        System.out.println("- Termina la lectura del documento XML del Expediente");
    }

    public void startElement(String uri, String localName, String qName, Attributes att) throws SAXException {
        if (qName.equals("EXPEDIENTE")) {
            try {
                this.crearExpediente(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("DEFINICI\u00d3N DE EXPEDIENTE:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("INTERESADO")) {
            try {
                this.crearInteresado(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("INTERESADO:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("FASE_EXP")) {
            try {
                this.crearFaseExp(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("FASE DEL EXPEDIENTE:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("TAREA_EXP")) {
            this.bEnTareaExpediente = true;
            try {
                this.crearTareaExp(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("TAREA DEL EXPEDIENTE:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("USU_ASIGNADO")) {
            try {
                this.crearUsuarioAsignadoExp(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("USUARIO ASIGNADO AL EXPEDIENTE:\nError durante el proceso de carga");
            }
            return;
        }
        if (qName.equals("EXP_RELACIONADO")) {
            try {
                this.crearExpedienteRelacionadoExp(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("EXPEDIENTE RELACIONADO:\nError durante el proceso de carga");
            }
        }
        if (qName.equals("CADUCIDAD_EXP")) {
            try {
                this.crearCaducidadExp(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("CADUCIDAD DEL EXPEDIENTE:\nError durante el proceso de carga");
            }
        }
        if (qName.equals("MODIF_CADUCIDAD")) {
            try {
                this.crearModificacionDeCaducidad(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("MODIFICACI\u00d3N DE CADUCIDAD:\nError durante el proceso de carga");
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("EXPEDIENTE") && this.expedienteActivo != null && this.grafico != null) {
            this.expedienteActivo.setGrafico(this.grafico);
            this.grafico.setExpediente(this.expedienteActivo);
            this.setGrafico(this.grafico);
            this.setExpediente(this.expedienteActivo);
        }
        if (qName.equals("INTERESADO")) {
            if (!this.bEnTareaExpediente) {
                if (this.expedienteActivo != null && this.interesadoActivo != null) {
                    this.expedienteActivo.addInteresadoExpediente(this.interesadoActivo);
                }
            } else if (this.tareaExpedienteActiva != null && this.interesadoActivo != null) {
                this.tareaExpedienteActiva.addInteresadoExpedienteDocumento(this.interesadoActivo);
            }
            this.interesadoActivo = null;
        }
        if (qName.equals("FASE_EXP") && this.expedienteActivo != null && this.expedienteEnFaseActivo != null) {
            this.expedienteActivo.addEvolucion(this.expedienteEnFaseActivo);
            this.expedienteEnFaseActivo.setExpediente(this.expedienteActivo);
            this.expedienteEnFaseActivo = null;
        }
        if (qName.equals("TAREA_EXP")) {
            this.bEnTareaExpediente = false;
            if (this.expedienteActivo != null && this.tareaExpedienteActiva != null) {
                this.expedienteActivo.addTarea(this.tareaExpedienteActiva);
                this.tareaExpedienteActiva.setExpediente(this.expedienteActivo);
                this.addTareaToFaseExpediente();
                this.tareaExpedienteActiva = null;
            }
        }
        if (qName.equals("USU_ASIGNADO") && this.expedienteActivo != null && this.usuarioAsignadoActivo != null) {
            this.expedienteActivo.addUsuario(this.usuarioAsignadoActivo);
            this.usuarioAsignadoActivo = null;
        }
        if (qName.equals("EXP_RELACIONADO") && this.expedienteActivo != null && this.expedienteRelacionadoActivo != null) {
            this.expedienteActivo.addExpedienteRelacionado(this.expedienteRelacionadoActivo);
            this.expedienteRelacionadoActivo = null;
        }
        if (qName.equals("CADUCIDAD_EXP") && this.expedienteActivo != null && this.caducidadActiva != null) {
            this.expedienteActivo.addCaducidad(this.caducidadActiva);
            this.caducidadActiva = null;
        }
        if (qName.equals("MODIF_CADUCIDAD") && this.caducidadActiva != null && this.modificacionCaducidadActiva != null) {
            this.caducidadActiva.addModificacionCaducidad(this.modificacionCaducidadActiva);
            this.modificacionCaducidadActiva = null;
        }
    }

    public void warning(SAXParseException e) throws SAXException {
        System.out.println("\u00b7 [ Alerta ] " + e.getMessage());
    }

    public void error(SAXParseException e) throws SAXException {
        System.out.println("- [ Error ] Durante la lectura del XML del Expediente");
        throw new SAXException(e.getMessage());
    }

    public void fatalError(SAXParseException e) throws SAXException {
        System.out.println("- [ Error ] Durante la lectura del XML del Expediente:");
        System.out.println("- Linea: " + this.locator.getLineNumber());
        System.out.println("- Columna: " + this.locator.getColumnNumber());
        System.out.println("- PublicID: " + this.locator.getPublicId());
        System.out.println("- SystemID: " + this.locator.getSystemId());
        System.out.println(e.getMessage());
        throw new SAXException(e.getMessage());
    }

    public TrExpediente getExpediente() {
        return this.expedienteActivo;
    }

    public void setExpediente(TrExpediente pExpediente) {
        this.expedienteActivo = pExpediente;
    }

    public void setGrafico(DDPGrafico grafico) {
        this.grafico = grafico;
    }

    public DDPGrafico getGrafico() {
        return this.grafico;
    }

    public boolean crearExpediente(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.expedienteActivo = new TrExpediente();
        if (att.getValue("id") == null) {
            return false;
        }
        TpoPK idExp = new TpoPK(new BigDecimal(att.getValue("id")));
        this.expedienteActivo.setID(idExp);
        if (att.getValue("numero") != null) {
            this.expedienteActivo.setNUMERO(att.getValue("numero"));
        }
        if (att.getValue("titulo") != null) {
            this.expedienteActivo.setTITULO(att.getValue("titulo"));
        }
        if (att.getValue("organo") != null) {
            this.expedienteActivo.setORGANO(att.getValue("organo"));
        }
        if (att.getValue("organo_envia") != null) {
            this.expedienteActivo.setOrganoEnvia(att.getValue("organo_envia"));
        }
        if (att.getValue("sistema") == null) {
            return false;
        }
        this.expedienteActivo.setDEF_SISTEMA(att.getValue("sistema"));
        if (att.getValue("motor_tramita") != null) {
            this.expedienteActivo.setMotorTramita(att.getValue("motor_tramita"));
        }
        if (att.getValue("def_procedimiento_id") == null) {
            return false;
        }
        BigDecimal idDDP = new BigDecimal(att.getValue("def_procedimiento_id"));
        this.expedienteActivo.setIdDDP(idDDP);
        if (att.getValue("def_procedimiento") == null) {
            return false;
        }
        this.expedienteActivo.setDDP(att.getValue("def_procedimiento"));
        if (att.getValue("observaciones") != null) {
            this.expedienteActivo.setObservaciones(att.getValue("observaciones"));
        }
        if (att.getValue("componente_archv") != null) {
            this.expedienteActivo.setNombreArchivador(att.getValue("componente_archv"));
        }
        if (att.getValue("fecha_archivo") != null) {
            this.expedienteActivo.setFechaArchivo(att.getValue("fecha_archivo"));
        }
        return true;
    }

    public boolean crearInteresado(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.interesadoActivo = new TrInteresado();
        if (att.getValue("nif_cif") == null) {
            return false;
        }
        this.interesadoActivo.setNIF(att.getValue("nif_cif"));
        if (att.getValue("nombre") == null) {
            return false;
        }
        this.interesadoActivo.setNOMBRE(att.getValue("nombre"));
        if (att.getValue("razon_interes") == null) {
            return false;
        }
        this.interesadoActivo.setCodigoRazonInteres(att.getValue("razon_interes"));
        if (att.getValue("relacion_exp") == null) {
            return false;
        }
        this.interesadoActivo.setRELACIONEXP(att.getValue("relacion_exp"));
        if (att.getValue("anagrama_fiscal") != null) {
            this.interesadoActivo.setAnagramaFiscal(att.getValue("anagrama_fiscal"));
        }
        if (att.getValue("comentarios") != null) {
            this.interesadoActivo.setComentariosAlInteresado(att.getValue("comentarios"));
        }
        if (att.getValue("observaciones") != null) {
            this.interesadoActivo.setObservaciones(att.getValue("observaciones"));
        }
        return true;
    }

    public boolean crearFaseExp(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.expedienteEnFaseActivo = new TrExpedienteEnFase();
        if (att.getValue("id") == null) {
            return false;
        }
        TpoPK idExpEnFase = new TpoPK(new BigDecimal(att.getValue("id")));
        this.expedienteEnFaseActivo.setID(idExpEnFase);
        if (att.getValue("fase_id") == null) {
            return false;
        }
        BigDecimal idFase = new BigDecimal(att.getValue("fase_id"));
        this.expedienteEnFaseActivo.setFASE_ID(idFase);
        if (att.getValue("denominacion") == null) {
            return false;
        }
        this.expedienteEnFaseActivo.setDescripcionFase(att.getValue("denominacion"));
        if (att.getValue("metafase") == null) {
            return false;
        }
        this.expedienteEnFaseActivo.setNombreMetafase(att.getValue("metafase"));
        if (att.getValue("transicion_id") == null) {
            return false;
        }
        BigDecimal idTransicion = new BigDecimal(att.getValue("transicion_id"));
        this.expedienteEnFaseActivo.setTRANSICION_ID(idTransicion);
        if (att.getValue("transicion") == null) {
            return false;
        }
        this.expedienteEnFaseActivo.setDescripcionTransicion(att.getValue("transicion"));
        if (att.getValue("fase_padre_id") != null) {
            BigDecimal idFasePadre = new BigDecimal(att.getValue("fase_padre_id"));
            this.expedienteEnFaseActivo.setFASE_PADRE_ID(idFasePadre);
        }
        if (att.getValue("fecha_comienzo") == null) {
            return false;
        }
        this.expedienteEnFaseActivo.setFECHA_COMIENZO(att.getValue("fecha_comienzo"));
        if (att.getValue("fecha_maxima") != null) {
            this.expedienteEnFaseActivo.setFECHA_MAXIMA(att.getValue("fecha_maxima"));
        }
        if (att.getValue("fecha_finalizacion") != null) {
            this.expedienteEnFaseActivo.setFECHA_FINALIZACION(att.getValue("fecha_finalizacion"));
        }
        if (att.getValue("observaciones") != null) {
            this.expedienteEnFaseActivo.setOBSERVACIONES(att.getValue("observaciones"));
        }
        if (att.getValue("usuario") == null) {
            return false;
        }
        this.expedienteEnFaseActivo.setUSUARIO(att.getValue("usuario"));
        if (att.getValue("nombre") == null) {
            return false;
        }
        this.expedienteEnFaseActivo.setNombreApellUsuario(att.getValue("nombre"));
        if (att.getValue("abierta_evento") != null) {
            if (att.getValue("abierta_evento").equals("S")) {
                this.expedienteEnFaseActivo.setAbiertaEvento(true);
            } else {
                this.expedienteEnFaseActivo.setAbiertaEvento(false);
            }
        } else {
            return false;
        }
        if (att.getValue("def_procedimiento_id") == null) {
            return false;
        }
        BigDecimal idDefProc = new BigDecimal(att.getValue("def_procedimiento_id"));
        this.expedienteEnFaseActivo.setIdDefProc(idDefProc);
        if (att.getValue("def_procedimiento") == null) {
            return false;
        }
        this.expedienteEnFaseActivo.setNombreProcedimiento(att.getValue("def_procedimiento"));
        TrFase faseEncontrada = null;
        faseEncontrada = this.grafico.obtenerFase(this.expedienteEnFaseActivo.getFASE_ID());
        if (faseEncontrada == null) {
            return false;
        }
        this.expedienteEnFaseActivo.setFase(faseEncontrada);
        TrTransicion transicionEncontrada = null;
        transicionEncontrada = this.grafico.obtenerTransicion(this.expedienteEnFaseActivo.getTRANSICION_ID());
        if (transicionEncontrada == null) {
            return false;
        }
        this.expedienteEnFaseActivo.setTransicion(transicionEncontrada);
        if (this.grafico.getDDP() == null || this.grafico.getDDP().getTIPOEVOL() == null) {
            return false;
        }
        if (this.grafico.getDDP().getTIPOEVOL().getTIEVID().longValue() == this.expedienteEnFaseActivo.getIdDefProc().longValue()) {
            this.expedienteEnFaseActivo.setGrafico(this.grafico);
        } else {
            this.expedienteEnFaseActivo.setGrafico(this.grafico.obtenerDDPReutilizable(this.expedienteEnFaseActivo.getIdDefProc()));
        }
        if (this.expedienteEnFaseActivo.getGrafico() == null) {
            return false;
        }
        if (transicionEncontrada.getTIPO().equals("N") || transicionEncontrada.getTIPO().equals("D") || transicionEncontrada.getTIPO().equals("U")) {
            if (transicionEncontrada.getTrFaseIni() != null) {
                this.expedienteEnFaseActivo.setNombreFase(transicionEncontrada.getTrFaseIni().getNombre());
                this.expedienteEnFaseActivo.setDescripcionFase(transicionEncontrada.getTrFaseIni().getDescripcion());
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean crearTareaExp(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.tareaExpedienteActiva = new TrTareaExpediente();
        if (att.getValue("id") == null) {
            return false;
        }
        TpoPK idTareaExp = new TpoPK(new BigDecimal(att.getValue("id")));
        this.tareaExpedienteActiva.setID(idTareaExp);
        if (att.getValue("fase") == null) {
            return false;
        }
        this.tareaExpedienteActiva.setNombreFase(att.getValue("fase"));
        if (att.getValue("fase_exp_id") == null) {
            return false;
        }
        BigDecimal idFaseExp = new BigDecimal(att.getValue("fase_exp_id"));
        this.tareaExpedienteActiva.setIdExpFase(idFaseExp);
        if (att.getValue("tarea") == null) {
            return false;
        }
        this.tareaExpedienteActiva.setDescripcionTarea(att.getValue("tarea"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        this.tareaExpedienteActiva.setDescripcionTareaEnFase(att.getValue("descripcion"));
        if (att.getValue("descartada") != null) {
            if (att.getValue("descartada").equals("S")) {
                this.tareaExpedienteActiva.setDescartada(true);
            } else {
                this.tareaExpedienteActiva.setDescartada(false);
            }
        } else {
            return false;
        }
        if (att.getValue("fecha_comienzo") != null) {
            this.tareaExpedienteActiva.setFechaComienzo(att.getValue("fecha_comienzo"));
        }
        if (att.getValue("fecha_maxima") != null) {
            this.tareaExpedienteActiva.setFechaMaxima(att.getValue("fecha_maxima"));
        }
        if (att.getValue("fecha_finalizacion") != null) {
            this.tareaExpedienteActiva.setFechaFinalizacion(att.getValue("fecha_finalizacion"));
        }
        if (att.getValue("observaciones") != null) {
            this.tareaExpedienteActiva.setObservaciones(att.getValue("observaciones"));
        }
        if (att.getValue("usuario") == null) {
            return false;
        }
        this.tareaExpedienteActiva.setUsuario(att.getValue("usuario"));
        if (att.getValue("nombre") == null) {
            return false;
        }
        this.tareaExpedienteActiva.setNombreApellUsuario(att.getValue("nombre"));
        if (att.getValue("estado") == null) {
            return false;
        }
        this.tareaExpedienteActiva.setEstadoTarea(att.getValue("estado"));
        if (att.getValue("tipo") != null) {
            String strTipo = att.getValue("tipo");
            TrTipoTarea tipoTarea = TrTipoTarea.obtenerTipoTarea(strTipo);
            if (tipoTarea == null) {
                return false;
            }
            this.tareaExpedienteActiva.setTipoTarea(tipoTarea.getTipo());
        } else {
            this.tareaExpedienteActiva.setTipoTarea(TrTipoTarea.MANIPULAR_DATOS.getTipo());
        }
        if (this.expedienteActivo.getExpedientesEnFase() != null) {
            TrExpedienteEnFase expedienteFaseAux = null;
            for (int n = 0; n < this.expedienteActivo.getExpedientesEnFase().size(); ++n) {
                expedienteFaseAux = (TrExpedienteEnFase)this.expedienteActivo.getExpedientesEnFase().get(n);
                if (expedienteFaseAux.getID().getPkVal().longValue() != this.tareaExpedienteActiva.getIdExpFase().longValue()) continue;
                this.tareaExpedienteActiva.setFase(expedienteFaseAux.getFase());
            }
        }
        if (this.grafico.getTareasInvolucradas() != null && this.grafico.getTareasInvolucradas().getListaDatos() != null && this.tareaExpedienteActiva.getDescripcionTarea() != null) {
            TrTarea tareaAux = null;
            for (int n = 0; n < this.grafico.getTareasInvolucradas().getListaDatos().size(); ++n) {
                tareaAux = (TrTarea)this.grafico.getTareasInvolucradas().getListaDatos().get(n);
                if (!tareaAux.getNombre().equals(this.tareaExpedienteActiva.getDescripcionTarea())) continue;
                this.tareaExpedienteActiva.setTarea(tareaAux);
            }
        }
        return true;
    }

    public void addTareaToFaseExpediente() {
        if (this.expedienteActivo == null) {
            return;
        }
        if (this.tareaExpedienteActiva == null) {
            return;
        }
        if (this.tareaExpedienteActiva.getIdExpFase() == null) {
            return;
        }
        if (this.expedienteActivo.getExpedientesEnFase() != null) {
            TrExpedienteEnFase expedienteFaseAux = null;
            for (int n = 0; n < this.expedienteActivo.getExpedientesEnFase().size(); ++n) {
                expedienteFaseAux = (TrExpedienteEnFase)this.expedienteActivo.getExpedientesEnFase().get(n);
                if (expedienteFaseAux.getID().getPkVal().longValue() != this.tareaExpedienteActiva.getIdExpFase().longValue()) continue;
                expedienteFaseAux.addTareaExpediente(this.tareaExpedienteActiva);
            }
        }
    }

    public boolean crearUsuarioAsignadoExp(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.usuarioAsignadoActivo = new TrUsuarioAsignado();
        if (att.getValue("usuario") == null) {
            return false;
        }
        this.usuarioAsignadoActivo.setCodigoUsuario(att.getValue("usuario"));
        if (att.getValue("nombre") == null) {
            return false;
        }
        this.usuarioAsignadoActivo.setNombreApellidos(att.getValue("nombre"));
        if (att.getValue("tipo") == null) {
            return false;
        }
        this.usuarioAsignadoActivo.setTipoUsuario(att.getValue("tipo"));
        if (att.getValue("alta") == null) {
            return false;
        }
        this.usuarioAsignadoActivo.setFechaAlta(att.getValue("alta"));
        if (att.getValue("baja") != null) {
            this.usuarioAsignadoActivo.setFechaBaja(att.getValue("baja"));
        }
        if (att.getValue("razon_asigna") != null) {
            this.usuarioAsignadoActivo.setRazonAsignacion(att.getValue("razon_asigna"));
        }
        return true;
    }

    public boolean crearExpedienteRelacionadoExp(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.expedienteRelacionadoActivo = new TrExpedienteRelacionado();
        if (att.getValue("exp_id") == null) {
            return false;
        }
        TpoPK idExpRela = new TpoPK(new BigDecimal(att.getValue("exp_id")));
        this.expedienteRelacionadoActivo.setIdExpRelacionado(idExpRela);
        if (att.getValue("tipo") == null) {
            return false;
        }
        this.expedienteRelacionadoActivo.setTipo(att.getValue("tipo"));
        if (att.getValue("observaciones") != null) {
            this.expedienteRelacionadoActivo.setObservaciones(att.getValue("observaciones"));
        }
        if (att.getValue("componente") != null) {
            this.expedienteRelacionadoActivo.setNombreComponente(att.getValue("componente"));
        }
        if (att.getValue("numero") != null) {
            this.expedienteRelacionadoActivo.setNumero(att.getValue("numero"));
        }
        if (att.getValue("titulo") != null) {
            this.expedienteRelacionadoActivo.setTitulo(att.getValue("titulo"));
        }
        return true;
    }

    public boolean crearCaducidadExp(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.caducidadActiva = new TrCaducidadExpediente();
        if (att.getValue("abreviatura") == null) {
            return false;
        }
        this.caducidadActiva.setAbreviatura(att.getValue("abreviatura"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        this.caducidadActiva.setDescripcion(att.getValue("descripcion"));
        if (att.getValue("tipo") == null) {
            return false;
        }
        this.caducidadActiva.setTipo(att.getValue("tipo"));
        if (att.getValue("fecha_inicio") == null) {
            return false;
        }
        this.caducidadActiva.setFechaInicio(att.getValue("fecha_inicio"));
        if (att.getValue("fecha_limite") != null) {
            this.caducidadActiva.setFechaLimite(att.getValue("fecha_limite"));
        }
        return true;
    }

    public boolean crearModificacionDeCaducidad(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.modificacionCaducidadActiva = new TrModificacionCaducidad();
        if (att.getValue("tipo") == null) {
            return false;
        }
        this.modificacionCaducidadActiva.setTipo(att.getValue("tipo"));
        if (att.getValue("usuario") == null) {
            return false;
        }
        this.modificacionCaducidadActiva.setUsuario(att.getValue("usuario"));
        if (att.getValue("nombre") == null) {
            return false;
        }
        this.modificacionCaducidadActiva.setNombreApellUsuario(att.getValue("nombre"));
        if (att.getValue("fecha_inicio") == null) {
            return false;
        }
        this.modificacionCaducidadActiva.setFechaInicio(att.getValue("fecha_inicio"));
        if (att.getValue("fecha_final") != null) {
            this.modificacionCaducidadActiva.setFechaFinal(att.getValue("fecha_final"));
        }
        return true;
    }
}

