/*
 * Decompiled with CFR 0.152.
 */
package modela.graf;

import edu.umd.cs.piccolo.PLayer;
import gdtel.bd.ConjuntoDatos;
import gdtel.util.CopiadorArchivos;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import modela.bd.ConjuntoDatosModela;
import modela.bd.obj.ConjuntoDatosTareaEnFase;
import modela.bd.obj.ConjuntoDatosTareaFaseDefProcedimiento;
import modela.bd.obj.ConjuntoDatosTransicion;
import modela.bd.obj.ConjuntoDatosTransicionDefProcedimiento;
import modela.bd.obj.TrAccionTareaFase;
import modela.bd.obj.TrAccionTransicion;
import modela.bd.obj.TrAvisoTareaFase;
import modela.bd.obj.TrAvisoTransicion;
import modela.bd.obj.TrCondicionTareaFase;
import modela.bd.obj.TrCondicionTransicion;
import modela.bd.obj.TrMetafase;
import modela.bd.obj.TrMetafaseGr;
import modela.bd.obj.TrParrafoTipDoc;
import modela.bd.obj.TrPlantillaProcedimiento;
import modela.bd.obj.TrPlazoCompuestoDefProc;
import modela.bd.obj.TrTareaEnFase;
import modela.bd.obj.TrTareaEnFaseDefProcedimiento;
import modela.bd.obj.TrTipoDocumento;
import modela.bd.obj.TrTipoParrafo;
import modela.bd.obj.TrTransicion;
import modela.bd.obj.TrTransicionDefProcedimiento;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.event.InfoResultado;
import modela.ui.event.InfoResultadoEvent;
import modela.ui.event.InfoResultadoListener;
import modela.ui.piccolo.nodes.FasePNode;
import modela.ui.piccolo.nodes.PNodoGrafico;
import modela.ui.piccolo.nodes.PostItPNode;
import modela.ui.piccolo.nodes.TransicionPNode;

public class ValidadorDefProcedimiento {
    private final transient ArrayList infoResultadoListeners = new ArrayList(2);
    public ArrayList m_listaArchivosCopiados = null;
    int nErrores = 0;
    int nAvisos = 0;
    String strOrigenXML = null;
    boolean m_bComprimir = false;
    boolean m_bGenerar = false;

    public ValidadorDefProcedimiento() {
        this.inicializarContadores();
    }

    public synchronized void addInfoResultadoListener(InfoResultadoListener l) {
        if (!this.infoResultadoListeners.contains(l)) {
            this.infoResultadoListeners.add(l);
        }
    }

    public synchronized void removeInfoResultadoListener(InfoResultadoListener l) {
        this.infoResultadoListeners.remove(l);
    }

    protected void fireObtenerResultado(InfoResultadoEvent e) {
        List listeners = (List)this.infoResultadoListeners.clone();
        int count = listeners.size();
        for (int i = 0; i < count; ++i) {
            ((InfoResultadoListener)listeners.get(i)).obtenerResultado(e);
        }
    }

    public void fireFinal() {
        if (this.getErrores() > 0) {
            this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_ERROR, "Fin del proceso con errores", "", "", "Revise los archivos de salida adjuntos")));
            this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_ERROR, "No olvide revisar los archivos de salida adjuntos", "", "", "")));
        } else if (this.getAvisos() > 0) {
            this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Fin del proceso con avisos", "", "", "Revise los archivos de salida adjuntos")));
            this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "No olvide revisar los archivos de salida adjuntos", "", "", "")));
        } else {
            this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_CORRECTO, "Fin del proceso", "", "", "Revise los archivos de salida adjuntos")));
            this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_CORRECTO, "No olvide revisar los archivos de salida adjuntos", "", "", "")));
        }
    }

    public boolean validarDefProdedimiento(DDPGrafico grafico) {
        if (grafico == null) {
            return false;
        }
        if (grafico.getDDP() == null) {
            return false;
        }
        if (grafico.getDDP().getDDPGID() == null) {
            return false;
        }
        if (grafico.getDDP().getTIPOEVOL() == null) {
            return false;
        }
        this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_INICIO, "Iniciando proceso de validaci\u00f3n", "", "", "")));
        this.validarDefinicion(grafico);
        boolean bValidarInformacionGrafica = grafico.existeInfoGraf();
        if (bValidarInformacionGrafica) {
            this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_CORRECTO, "Validando informaci\u00f3n gr\u00e1fica", "", "", "")));
            if (!this.validarGrafico(grafico)) {
                return false;
            }
        }
        if (!this.m_bGenerar) {
            this.fireFinal();
        }
        return true;
    }

    public boolean validarDefinicion(DDPGrafico grafico) {
        if (grafico == null) {
            return false;
        }
        if (grafico.getDDP() == null) {
            return false;
        }
        if (grafico.getDDP().getDDPGID() == null) {
            return false;
        }
        if (grafico.getDDP().getTIPOEVOL() == null) {
            return false;
        }
        if (grafico.getDDPPadre() == null) {
            this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_CORRECTO, "Validando definici\u00f3n del procedimiento", "Definici\u00f3n de procedimiento", grafico.getDDP().getTIPOEVOL().getABREVIATURA(), "")));
        } else {
            this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_CORRECTO, "Validando m\u00f3dulo reutilizable", "M\u00f3dulo reutilizable", grafico.getDDP().getTIPOEVOL().getABREVIATURA(), "")));
        }
        this.strOrigenXML = grafico.getPathSimple();
        this.validarTipoParrafos(grafico);
        this.validarTipoDocumentos(grafico);
        ArrayList arrReutilizables = new ArrayList();
        DDPGrafico ddpReutilizable = null;
        arrReutilizables = grafico.obtenerReutilizablesAsociados(true);
        for (int r = 0; r < arrReutilizables.size(); ++r) {
            ddpReutilizable = (DDPGrafico)arrReutilizables.get(r);
            this.validarDefinicion(ddpReutilizable);
        }
        ConjuntoDatosTransicion cdTransicionAux = grafico.getTransicionesInvolucradasGr();
        if (cdTransicionAux != null) {
            if (cdTransicionAux.obtenerNumRegistros() > 0 && grafico.getTransicionesDelProcInvolucradas() != null) {
                ConjuntoDatosTransicionDefProcedimiento cdValidar = grafico.getTransicionesDelProcInvolucradas();
                TrTransicionDefProcedimiento trAux = null;
                for (int t = 0; t < cdValidar.obtenerNumRegistros(); ++t) {
                    int ac;
                    trAux = (TrTransicionDefProcedimiento)cdValidar.getListaDatos().get(t);
                    if ((trAux.getConjuntoPerfilTransEvol() == null || trAux.getConjuntoPerfilTransEvol().getListaDatos() == null || trAux.getConjuntoPerfilTransEvol().getListaDatos().size() < 1) && trAux.getTransicion() != null) {
                        this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Transici\u00f3n sin perfiles asociados", "Transici\u00f3n", trAux.getTransicion().getETIQUETA(), "Compruebe que no ha olvidado asociar perfiles a esta transici\u00f3n")));
                    }
                    if (trAux.getTransicion() == null) continue;
                    if (grafico.getCanvas() != null && grafico.getCanvas().localizarGraficosTransicion(trAux.getTransicion()).size() < 1) {
                        this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Transici\u00f3n sin dibujar en el procedimiento", "Transici\u00f3n", trAux.getTransicion().getETIQUETA(), "Compruebe que no ha olvidado representar gr\u00e1ficamente esta transici\u00f3n en su procedimiento")));
                    }
                    if (!trAux.getTransicion().isValida()) {
                        this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Transici\u00f3n marcada como no v\u00e1lida", "Transici\u00f3n", trAux.getTransicion().getETIQUETA(), "Compruebe que no ha olvidado eliminar esta transici\u00f3n. Los elementos no v\u00e1lidos pueden crear conflictos al importar el procedimiento en las HAT")));
                    }
                    if (trAux.getConjuntoAccionTransicion() != null && trAux.getConjuntoAccionTransicion().getListaDatos() != null) {
                        for (ac = 0; ac < trAux.getConjuntoAccionTransicion().getListaDatos().size(); ++ac) {
                            TrAccionTransicion accionTransiAux = (TrAccionTransicion)trAux.getConjuntoAccionTransicion().getListaDatos().get(ac);
                            if (accionTransiAux == null || accionTransiAux.isValida()) continue;
                            this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Acci\u00f3n marcada como no v\u00e1lida", "Acci\u00f3n en Transici\u00f3n", accionTransiAux.getNombre() + " [ en " + trAux.getNombre() + " ]", "Compruebe que no ha olvidado eliminar esta acci\u00f3n. Los elementos no v\u00e1lidos pueden crear conflictos al importar el procedimiento en las HAT")));
                        }
                    }
                    if (trAux.getConjuntoCondicionTransicion() != null && trAux.getConjuntoCondicionTransicion().getListaDatos() != null) {
                        for (ac = 0; ac < trAux.getConjuntoCondicionTransicion().getListaDatos().size(); ++ac) {
                            TrCondicionTransicion condicionTransiAux = (TrCondicionTransicion)trAux.getConjuntoCondicionTransicion().getListaDatos().get(ac);
                            if (condicionTransiAux == null || condicionTransiAux.isValida()) continue;
                            this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Condici\u00f3n marcada como no v\u00e1lida", "Condici\u00f3n en Transici\u00f3n", condicionTransiAux.getNombre() + " [ en " + trAux.getNombre() + " ]", "Compruebe que no ha olvidado eliminar esta condici\u00f3n. Los elementos no v\u00e1lidos pueden crear conflictos al importar el procedimiento en las HAT")));
                        }
                    }
                    if (trAux.getConjuntoAvisoTransicion() == null || trAux.getConjuntoAvisoTransicion().getListaDatos() == null) continue;
                    for (ac = 0; ac < trAux.getConjuntoAvisoTransicion().getListaDatos().size(); ++ac) {
                        TrAvisoTransicion avisoTransiAux = (TrAvisoTransicion)trAux.getConjuntoAvisoTransicion().getListaDatos().get(ac);
                        if (avisoTransiAux == null || avisoTransiAux.isValida()) continue;
                        this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Aviso marcado como no v\u00e1lido", "Aviso en Transici\u00f3n", avisoTransiAux.getNombre() + " [ en " + trAux.getNombre() + " ]", "Compruebe que no ha olvidado eliminar este aviso. Los elementos no v\u00e1lidos pueden crear conflictos al importar el procedimiento en las HAT")));
                    }
                }
            }
            this.validarTransiciones(grafico);
        }
        this.validarTareasEnFase(grafico);
        ConjuntoDatosModela cdPerfilesAux = grafico.getPerfilesUsuarioInvolucradosGr();
        if (cdPerfilesAux == null || cdPerfilesAux.obtenerNumRegistros() > 0) {
            // empty if block
        }
        this.validarPlazosCompuestos(grafico);
        this.validarPlantillasProc(grafico);
        return true;
    }

    public boolean validarTipoParrafos(DDPGrafico grafico) {
        ConjuntoDatosModela cdTiposParrafoAux = grafico.getTipoParrafosInvolucradosGr();
        if (cdTiposParrafoAux != null && cdTiposParrafoAux.obtenerNumRegistros() > 0) {
            ArrayList vDatos = cdTiposParrafoAux.getListaDatos();
            TrTipoParrafo tipoParrafo = null;
            for (int j = 0; j < vDatos.size(); ++j) {
                String strXML = "";
                tipoParrafo = (TrTipoParrafo)vDatos.get(j);
                String strAuxXML = tipoParrafo.toXML(true);
                if (strAuxXML == null) {
                    return false;
                }
                strXML = strXML + strAuxXML;
                if (tipoParrafo.getNombreFichero() == null || tipoParrafo.getNombreFichero().equals("")) continue;
                this.validarArchivo(tipoParrafo.getRutaCompleta(), this.strOrigenXML, ModelaConf.getRutaArchivo(), tipoParrafo.getNombreFichero(), "Tipo de p\u00e1rrafo", tipoParrafo.getNombre(), false);
            }
            return true;
        }
        return false;
    }

    public boolean validarArchivo(String rutaArchivo, String rutaOrigen, String rutaDestino, String archivo, String tipoEntidad, String entidad, boolean avisarAusencia) {
        String archivoOrigen;
        if (rutaOrigen == null) {
            rutaOrigen = "C:";
        }
        this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_CORRECTO, "Validando archivo", tipoEntidad, entidad, "")));
        if (archivo == null || archivo.equals("")) {
            if (avisarAusencia) {
                this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_ERROR, "La entidad no tiene archivo asociado", tipoEntidad, entidad, "Aseg\u00farese de asociar un archivo a la entidad")));
                this.incrementarErrores();
            }
            return false;
        }
        String sep = System.getProperty("file.separator");
        if (sep == null) {
            sep = "/";
        }
        if (CopiadorArchivos.existeArchivo(archivoOrigen = rutaArchivo)) {
            this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_CORRECTO, "Archivo encontrado: " + archivoOrigen, tipoEntidad, entidad, "")));
        } else {
            String strRutaPorDefecto = rutaOrigen + sep + archivo;
            if (CopiadorArchivos.existeArchivo(strRutaPorDefecto)) {
                this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Archivo encontrado en ruta por defecto: " + strRutaPorDefecto, tipoEntidad, entidad, "Compruebe que \u00e9ste es el archivo que desea")));
                this.incrementarAvisos();
            } else {
                this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_ERROR, "Archivo no encontrado: Ni en " + archivoOrigen + " ni en la ruta por defecto " + strRutaPorDefecto, tipoEntidad, entidad, "Localice y copie el archivo a alguna de las rutas indicadas en la columna Informaci\u00f3n")));
                this.incrementarErrores();
            }
        }
        return true;
    }

    public boolean validarTipoDocumentos(DDPGrafico grafico) {
        ConjuntoDatosModela cdTiposDocumentoAux = grafico.getTipoDocumentosInvolucradosGr();
        if (cdTiposDocumentoAux != null && cdTiposDocumentoAux.obtenerNumRegistros() > 0) {
            ArrayList vDatos = cdTiposDocumentoAux.getListaDatos();
            TrTipoDocumento tipoDocumento = null;
            for (int j = 0; j < vDatos.size(); ++j) {
                String strXML = "";
                tipoDocumento = (TrTipoDocumento)vDatos.get(j);
                String strAuxXML = tipoDocumento.toXML(true);
                if (strAuxXML == null) {
                    return false;
                }
                strXML = strXML + strAuxXML;
                if (tipoDocumento.getT_Nom_Fichero() != null && !tipoDocumento.getT_Nom_Fichero().equals("")) {
                    this.validarArchivo(tipoDocumento.getRuta(), this.strOrigenXML, ModelaConf.getRutaArchivo(), tipoDocumento.getT_Nom_Fichero(), "Tipo de documento - Plantilla Office", tipoDocumento.getNombre(), true);
                } else if (tipoDocumento.getVariables() != null && tipoDocumento.getVariables().size() > 0) {
                    this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Tipo de documento con variables pero sin plantilla binaria Open Office asociada", "Tipo documento", tipoDocumento.getNombre(), "Compruebe que no ha olvidado asociar una plantilla binaria Open Office")));
                }
                if (tipoDocumento.getParrafoTipoDoc() == null) continue;
                for (int i = 0; i < tipoDocumento.getParrafoTipoDoc().size(); ++i) {
                    TrParrafoTipDoc parrafo = (TrParrafoTipDoc)tipoDocumento.getParrafoTipoDoc().get(i);
                    if (parrafo.getNOMB_FICHERO() == null || parrafo.getNOMB_FICHERO().equals("")) continue;
                    this.validarArchivo(parrafo.getRutaCompleta(), this.strOrigenXML, ModelaConf.getRutaArchivo(), parrafo.getNOMB_FICHERO(), "P\u00e1rrafo del tipo de documento", parrafo.getNombre(), false);
                }
            }
            return true;
        }
        return false;
    }

    public boolean validarTransiciones(DDPGrafico grafico) {
        if (grafico.getTransicionesInvolucradasGr() == null) {
            return false;
        }
        if (grafico.getTransicionesInvolucradasGr().getListaDatos() == null) {
            return false;
        }
        ArrayList aDatos = grafico.getTransicionesInvolucradas().getListaDatos();
        TrTransicion transicion = null;
        for (int i = 0; i < aDatos.size(); ++i) {
            transicion = (TrTransicion)aDatos.get(i);
            if (transicion == null) {
                return false;
            }
            if (!transicion.getTIPO().equals("D")) continue;
            if (transicion.getConjuntoFasesFin() == null) {
                this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_ERROR, "Transici\u00f3n de divisi\u00f3n sin fases finales", "Transici\u00f3n", transicion.getETIQUETA(), "Compruebe el dise\u00f1o de su procedimiento")));
                this.incrementarErrores();
                continue;
            }
            if (transicion.getConjuntoFasesFin().getListaDatos().size() != 0) continue;
            this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_ERROR, "Transici\u00f3n de divisi\u00f3n sin fases finales", "Transici\u00f3n", transicion.getETIQUETA(), "Compruebe el dise\u00f1o de su procedimiento")));
            this.incrementarErrores();
        }
        return true;
    }

    public boolean validarTareasEnFase(DDPGrafico grafico) {
        boolean bProcesarTareasFase = true;
        if (grafico.getTareaFaseDefProcInvolucradas() == null) {
            bProcesarTareasFase = false;
        }
        if (grafico.getTareaFaseDefProcInvolucradas().getListaDatos() == null) {
            bProcesarTareasFase = false;
        }
        if (grafico.getTareaFaseDefProcInvolucradas().getListaDatos().size() < 1) {
            bProcesarTareasFase = false;
        }
        if (bProcesarTareasFase) {
            ArrayList listaTareasFaseProc = grafico.getTareaFaseDefProcInvolucradas().getListaDatos();
            TrTareaEnFaseDefProcedimiento tareaFase = null;
            ConjuntoDatosTareaEnFase cdTareasEnFase = new ConjuntoDatosTareaEnFase();
            ArrayList<TrTareaEnFase> listaTareasEnFaseFinal = new ArrayList<TrTareaEnFase>();
            cdTareasEnFase.setListaDatos(listaTareasEnFaseFinal);
            for (int n = 0; n < listaTareasFaseProc.size(); ++n) {
                tareaFase = (TrTareaEnFaseDefProcedimiento)listaTareasFaseProc.get(n);
                if (tareaFase.getTareaEnFase() == null || listaTareasEnFaseFinal.contains(tareaFase.getTareaEnFase())) continue;
                listaTareasEnFaseFinal.add(tareaFase.getTareaEnFase());
            }
            if (listaTareasEnFaseFinal.size() > 0 && grafico.getTareaFaseDefProcInvolucradas() != null) {
                ConjuntoDatosTareaFaseDefProcedimiento cdValidar = grafico.getTareaFaseDefProcInvolucradas();
                TrTareaEnFaseDefProcedimiento tareaAux = null;
                String strAuxiliar = "";
                for (int t = 0; t < cdValidar.obtenerNumRegistros(); ++t) {
                    int ac;
                    tareaAux = (TrTareaEnFaseDefProcedimiento)cdValidar.getListaDatos().get(t);
                    if (tareaAux.getConjuntoPerfilesTareaFase() != null && tareaAux.getConjuntoPerfilesTareaFase().getListaDatos() != null && tareaAux.getConjuntoPerfilesTareaFase().getListaDatos().size() >= 1) continue;
                    if (tareaAux.getTareaEnFase() != null) {
                        strAuxiliar = "";
                        if (tareaAux.getTareaEnFase().getFase() != null) {
                            strAuxiliar = " [ en " + tareaAux.getTareaEnFase().getFase() + " ]";
                        }
                        this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Tarea en fase sin perfiles asociados", "Tarea en fase", tareaAux.getTareaEnFase().getETIQUETA() + strAuxiliar, "Compruebe que no ha olvidado asociar perfiles a esta tarea en fase")));
                    }
                    if (!tareaAux.getTareaEnFase().isValida()) {
                        this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Tarea en fase marcada como no v\u00e1lida", "Tarea en fase", tareaAux.getTareaEnFase().getETIQUETA() + strAuxiliar, "Compruebe que no ha olvidado eliminar esta tarea en fase. Los elementos no v\u00e1lidos pueden crear conflictos al importar el procedimiento en las HAT")));
                    }
                    if (tareaAux.getConjuntoAccionTareaFase() != null && tareaAux.getConjuntoAccionTareaFase().getListaDatos() != null) {
                        for (ac = 0; ac < tareaAux.getConjuntoAccionTareaFase().getListaDatos().size(); ++ac) {
                            TrAccionTareaFase accionTareaAux = (TrAccionTareaFase)tareaAux.getConjuntoAccionTareaFase().getListaDatos().get(ac);
                            if (accionTareaAux == null || accionTareaAux.isValida()) continue;
                            this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Acci\u00f3n marcada como no v\u00e1lida", "Acci\u00f3n en Tarea en Fase", accionTareaAux.getNombre() + " [ en " + tareaAux.getNombre() + " ]", "Compruebe que no ha olvidado eliminar esta acci\u00f3n. Los elementos no v\u00e1lidos pueden crear conflictos al importar el procedimiento en las HAT")));
                        }
                    }
                    if (tareaAux.getConjuntoCondicionTareaFase() != null && tareaAux.getConjuntoCondicionTareaFase().getListaDatos() != null) {
                        for (ac = 0; ac < tareaAux.getConjuntoCondicionTareaFase().getListaDatos().size(); ++ac) {
                            TrCondicionTareaFase condicionTareaAux = (TrCondicionTareaFase)tareaAux.getConjuntoCondicionTareaFase().getListaDatos().get(ac);
                            if (condicionTareaAux == null || condicionTareaAux.isValida()) continue;
                            this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Condici\u00f3n marcada como no v\u00e1lida", "Condici\u00f3n en Tarea en Fase", condicionTareaAux.getNombre() + " [ en " + tareaAux.getNombre() + " ]", "Compruebe que no ha olvidado eliminar esta condici\u00f3n. Los elementos no v\u00e1lidos pueden crear conflictos al importar el procedimiento en las HAT")));
                        }
                    }
                    if (tareaAux.getConjuntoAvisoTareaFase() == null || tareaAux.getConjuntoAvisoTareaFase().getListaDatos() == null) continue;
                    for (ac = 0; ac < tareaAux.getConjuntoAvisoTareaFase().getListaDatos().size(); ++ac) {
                        TrAvisoTareaFase avisoTareaAux = (TrAvisoTareaFase)tareaAux.getConjuntoAvisoTareaFase().getListaDatos().get(ac);
                        if (avisoTareaAux == null || avisoTareaAux.isValida()) continue;
                        this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Acci\u00f3n marcada como no v\u00e1lida", "Aviso en Tarea en Fase", avisoTareaAux.getNombre() + " [ en " + tareaAux.getNombre() + " ]", "Compruebe que no ha olvidado eliminar esta acci\u00f3n. Los elementos no v\u00e1lidos pueden crear conflictos al importar el procedimiento en las HAT")));
                    }
                }
            }
        }
        return true;
    }

    public boolean validarPlazosCompuestos(DDPGrafico grafico) {
        ArrayList arrPlazosCompuestos = null;
        arrPlazosCompuestos = grafico.getDDP().getTIPOEVOL().getPlazosCompuestosProcedimiento().getListaDatos();
        for (int n = 0; n < arrPlazosCompuestos.size(); ++n) {
            TrPlazoCompuestoDefProc plazo = null;
            plazo = (TrPlazoCompuestoDefProc)arrPlazosCompuestos.get(n);
            if (plazo.getConTransicionesFin()) continue;
            this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Plazo compuesto sin transiciones en las que termina definidas", "Plazo compuesto", plazo.getABREVIATURA(), "Compruebe que no ha olvidado asociar transiciones finales a este plazo compuesto")));
            this.incrementarAvisos();
        }
        return true;
    }

    public boolean validarPlantillasProc(DDPGrafico grafico) {
        if (grafico.getDDP() == null) {
            return false;
        }
        if (grafico.getDDP().getTIPOEVOL() == null) {
            return false;
        }
        ConjuntoDatos cdPlantillasProc = grafico.getDDP().getTIPOEVOL().getPlantillasProcInvolucradas();
        if (cdPlantillasProc == null) {
            return false;
        }
        if (cdPlantillasProc.getListaDatos() == null) {
            return false;
        }
        if (cdPlantillasProc.getListaDatos().size() < 1) {
            return false;
        }
        String strXML = null;
        String strAuxXML = null;
        TrPlantillaProcedimiento plantillaProc = null;
        for (int n = 0; n < cdPlantillasProc.getListaDatos().size(); ++n) {
            plantillaProc = (TrPlantillaProcedimiento)cdPlantillasProc.getListaDatos().get(n);
            strXML = "";
            strAuxXML = plantillaProc.toXML(true);
            if (strAuxXML != null) {
                strXML = strXML + strAuxXML;
            }
            this.validarArchivo(plantillaProc.getRutaCompleta(), this.strOrigenXML, ModelaConf.getRutaArchivo(), plantillaProc.getNOMB_FICHERO(), "Plantilla del procedimiento", plantillaProc.getNombre(), true);
        }
        return true;
    }

    public boolean validarGrafico(DDPGrafico grafico) {
        if (!this.validarMetafasesGr(grafico)) {
            return false;
        }
        if (!this.validarExtremosTransicion(grafico)) {
            return false;
        }
        return this.validarTransicionGr(grafico);
    }

    public boolean validarMetafasesGr(DDPGrafico grafico) {
        if (grafico.getMetafasesInvolucradasGr() == null) {
            return false;
        }
        if (grafico.getMetafasesInvolucradasGr().getListaDatos() == null) {
            return false;
        }
        if (grafico.getMetafasesInvolucradasGr().getListaDatos().size() < 1) {
            return false;
        }
        for (int n = 0; n < grafico.getMetafasesInvolucradasGr().getListaDatos().size(); ++n) {
            TrMetafase metafaseAux = new TrMetafase();
            TrMetafaseGr metafaseGrAux = new TrMetafaseGr();
            metafaseAux = (TrMetafase)grafico.getMetafasesInvolucradasGr().getListaDatos().get(n);
            if (metafaseAux == null) {
                return false;
            }
            metafaseGrAux = metafaseAux.getPropiedadesGraficas();
            if (metafaseGrAux != null) continue;
            return false;
        }
        return true;
    }

    public boolean validarExtremosTransicion(DDPGrafico grafico) {
        if (grafico.getCanvas() == null) {
            return false;
        }
        PLayer lyr = grafico.getCanvas().getLayer();
        if (lyr != null) {
            ArrayList<PNodoGrafico> nodosErroneos = new ArrayList<PNodoGrafico>();
            int nNum = lyr.getChildrenCount();
            for (int i = 0; i < nNum; ++i) {
                if (lyr.getChild(i) instanceof PLayer || !(lyr.getChild(i) instanceof PNodoGrafico) || lyr.getChild(i) instanceof PostItPNode) continue;
                PNodoGrafico pNodo = (PNodoGrafico)lyr.getChild(i);
                if (!pNodo.getTipo().equals("FA")) {
                    if (this.comprobarExistExtremoTransGr(grafico, pNodo.getTrFaseGrAsociada().getID().longValue()) != null) continue;
                    nodosErroneos.add(pNodo);
                    continue;
                }
                if (pNodo.getTrFaseGrAsociada() != null) {
                    if (pNodo.getTrFaseGrAsociada().getTrFase() != null) {
                        if (this.comprobarExisteFase(grafico, pNodo.getTrFaseGrAsociada().getTrFase().getFASEID().longValue())) continue;
                        nodosErroneos.add(pNodo);
                        continue;
                    }
                    nodosErroneos.add(pNodo);
                    continue;
                }
                nodosErroneos.add(pNodo);
            }
            this.eliminarNodosErroneos(grafico, nodosErroneos);
        }
        return true;
    }

    public boolean validarTransicionGr(DDPGrafico grafico) {
        if (grafico.getCanvas() == null) {
            return false;
        }
        PLayer lyr = grafico.getCanvas().getLayer();
        if (lyr != null) {
            int nNum = lyr.getChildrenCount();
            for (int i = 0; i < nNum; ++i) {
                if (!(lyr.getChild(i) instanceof PLayer) && !(lyr.getChild(i) instanceof TransicionPNode)) continue;
            }
        }
        return true;
    }

    public TransicionPNode comprobarExistExtremoTransGr(DDPGrafico grafico, long nExtTram_id) {
        if (grafico.getCanvas() == null) {
            return null;
        }
        PLayer lyr = grafico.getCanvas().getLayer();
        if (lyr != null) {
            int nNum = lyr.getChildrenCount();
            for (int i = 0; i < nNum; ++i) {
                if (lyr.getChild(i) instanceof PLayer || !(lyr.getChild(i) instanceof TransicionPNode)) continue;
                TransicionPNode pNodo = (TransicionPNode)lyr.getChild(i);
                if (pNodo.getPNodoGraficoFaseIni().getTrFaseGrAsociada().getID().longValue() == nExtTram_id) {
                    return pNodo;
                }
                if (pNodo.getPNodoGraficoFaseFin().getTrFaseGrAsociada().getID().longValue() != nExtTram_id) continue;
                return pNodo;
            }
        }
        return null;
    }

    public boolean comprobarExisteFase(DDPGrafico grafico, long nExtTram_id) {
        if (grafico.getCanvas() == null) {
            return false;
        }
        PLayer lyr = grafico.getCanvas().getLayer();
        if (lyr != null) {
            int nNum = lyr.getChildrenCount();
            for (int i = 0; i < nNum; ++i) {
                FasePNode pNodo;
                if (lyr.getChild(i) instanceof PLayer || !(lyr.getChild(i) instanceof FasePNode) || (pNodo = (FasePNode)lyr.getChild(i)).getTrFaseGrAsociada().getTrFase().getFASEID().longValue() != nExtTram_id) continue;
                return true;
            }
        }
        return true;
    }

    private void eliminarNodosErroneos(DDPGrafico grafico, ArrayList nodosErroneos) {
        if (grafico.getCanvas() == null) {
            return;
        }
        if (nodosErroneos == null) {
            return;
        }
        if (nodosErroneos.size() == 0) {
            return;
        }
        for (int nCont = 0; nCont < nodosErroneos.size(); ++nCont) {
            PNodoGrafico nodoAux = (PNodoGrafico)nodosErroneos.get(nCont);
            if (nodoAux.getTipo().equals("FA")) {
                TransicionPNode transPNode = this.comprobarExistExtremoTransGr(grafico, nodoAux.getTrFaseGrAsociada().getID().longValue());
                this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Gr\u00e1fico de fase sin fase asociada", "Extremo de transici\u00f3n(gr\u00e1fico de fase) ", "", "Extremo de transici\u00f3n del tipo " + nodoAux.getTipo() + " eliminado")));
                if (transPNode != null) {
                    this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Gr\u00e1fico de fase sin fase asociada", "Extremo de transici\u00f3n(gr\u00e1fico de fase) ", "", "Eliminadas transiciones asociadas al extremo de transici\u00f3n")));
                    transPNode.eliminarTransicion(true, true);
                }
                this.incrementarAvisos();
            } else {
                this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Extremo de transici\u00f3n sin gr\u00e1fico de transici\u00f3n asociado", "Extremo de transici\u00f3n", "", "Extremo de transici\u00f3n del tipo " + nodoAux.getTipo() + " eliminado")));
                this.incrementarAvisos();
            }
            grafico.getCanvas().eliminarPNodoGrafico(nodoAux);
        }
    }

    public void inicializarContadores() {
        this.nErrores = 0;
        this.nAvisos = 0;
    }

    public void incrementarAvisos() {
        ++this.nAvisos;
    }

    public void incrementarErrores() {
        ++this.nErrores;
    }

    public int getAvisos() {
        return this.nAvisos;
    }

    public int getErrores() {
        return this.nErrores;
    }

    public boolean copiarArchivo(String rutaArchivo, String rutaOrigen, String rutaDestino, String archivo, String tipoEntidad, String entidad, boolean avisarAusencia) {
        String archivoEnDestino;
        String archivoOrigen;
        boolean bOrigenEncontrado = true;
        if (rutaOrigen == null) {
            rutaOrigen = "C:";
        }
        this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_CORRECTO, "Exportando archivo", tipoEntidad, entidad, "")));
        if (archivo == null || archivo.equals("")) {
            if (avisarAusencia) {
                this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_ERROR, "La entidad no tiene archivo asociado", tipoEntidad, entidad, "Aseg\u00farese de asociar un archivo a la entidad")));
                this.incrementarErrores();
            }
            return false;
        }
        String sep = System.getProperty("file.separator");
        if (sep == null) {
            sep = "/";
        }
        if (!CopiadorArchivos.existeArchivo(archivoOrigen = rutaArchivo)) {
            bOrigenEncontrado = false;
            String strRutaPorDefecto = rutaOrigen + sep + archivo;
            if (CopiadorArchivos.existeArchivo(strRutaPorDefecto)) {
                bOrigenEncontrado = true;
                archivoOrigen = strRutaPorDefecto;
                this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Archivo encontrado en ruta por defecto: " + strRutaPorDefecto, tipoEntidad, entidad, "Compruebe que \u00e9ste es el archivo que desea")));
                this.incrementarAvisos();
            }
        }
        if (CopiadorArchivos.existeArchivo(archivoEnDestino = rutaDestino + sep + archivo)) {
            this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_AVISO, "Archivo origen " + archivoOrigen + " ya existe en destino " + archivoEnDestino, tipoEntidad, entidad, "")));
            this.addListaArchivosCopiados(archivoEnDestino);
            this.incrementarAvisos();
            return false;
        }
        if (bOrigenEncontrado) {
            try {
                CopiadorArchivos.copia(archivoOrigen, rutaDestino);
                this.addListaArchivosCopiados(archivoEnDestino);
            }
            catch (Exception ex) {
                this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_ERROR, "Error al copiar el archivo " + archivoOrigen + "en el destino " + rutaDestino, tipoEntidad, entidad, "Compruebe que existen las rutas de origen y destino y que tenga espacio en el disco")));
                this.incrementarErrores();
                return false;
            }
        } else {
            this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_ERROR, "No se pudo encontrar el archivo " + archivoOrigen, tipoEntidad, entidad, "Local\u00edcelo y coloque el archivo en el origen o en el destino donde vaya a realizar la exportaci\u00f3n")));
            this.incrementarErrores();
            return false;
        }
        this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_CORRECTO, "El archivo " + archivoOrigen + " se export\u00f3 correctamente en " + rutaDestino, tipoEntidad, entidad, "")));
        return true;
    }

    public void addListaArchivosCopiados(String strArchivoEnDestino) {
        if (this.m_listaArchivosCopiados == null) {
            this.m_listaArchivosCopiados = new ArrayList();
        }
        this.m_listaArchivosCopiados.add(strArchivoEnDestino);
    }

    public ArrayList getListaArchivosCopiados() {
        if (this.m_listaArchivosCopiados == null) {
            return null;
        }
        return (ArrayList)this.m_listaArchivosCopiados.clone();
    }

    public void eliminarListaArchivosCopiados() {
        if (this.m_listaArchivosCopiados == null) {
            return;
        }
        this.m_listaArchivosCopiados.clear();
        this.m_listaArchivosCopiados = null;
    }

    public void setGenerar(boolean bGenerar) {
        this.m_bGenerar = bGenerar;
    }

    public boolean comprimirXml(String strRutaArch) {
        int BUFFER = 2048;
        this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_INICIO, "Iniciando proceso de compresi\u00f3n", "", "", "")));
        if (strRutaArch == null) {
            this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_ERROR, "Error al comprimir el procedimiento ", "", "", "Aseg\u00farese de que existen los ficheros asociados al procedimiento en las rutas de origen y de que tenga espacio en el disco")));
            this.incrementarErrores();
            this.fireFinal();
            return false;
        }
        if (strRutaArch.equals("")) {
            this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_ERROR, "Error al comprimir el procedimiento ", "", "", "Aseg\u00farese de que existen los ficheros asociados al procedimiento en las rutas de origen y de que tenga espacio en el disco")));
            this.incrementarErrores();
            this.fireFinal();
            return false;
        }
        String strFile = strRutaArch;
        String strFileZip = strFile.replaceAll(".xml", ".zip");
        try {
            BufferedInputStream origin = null;
            FileOutputStream dest = new FileOutputStream(strFileZip);
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[BUFFER];
            File[] files = new File[1];
            if (this.m_listaArchivosCopiados != null) {
                if (this.m_listaArchivosCopiados.size() > 0) {
                    files = null;
                    files = new File[this.m_listaArchivosCopiados.size() + 1];
                    files[0] = new File(strFile);
                    for (int j = 0; j < this.m_listaArchivosCopiados.size(); ++j) {
                        files[j + 1] = new File((String)this.m_listaArchivosCopiados.get(j));
                    }
                } else {
                    files[0] = new File(strFile);
                }
            } else {
                files[0] = new File(strFile);
            }
            ArrayList<String> strYaAdds = new ArrayList<String>();
            for (int i = 0; i < files.length; ++i) {
                int count;
                if (strYaAdds.size() != 0 && strYaAdds.contains(files[i].getAbsolutePath())) continue;
                FileInputStream fi = new FileInputStream(files[i].getAbsolutePath());
                origin = new BufferedInputStream(fi, BUFFER);
                ZipEntry entry = new ZipEntry(files[i].getName());
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, BUFFER)) != -1) {
                    out.write(data, 0, count);
                }
                origin.close();
                strYaAdds.add(files[i].getAbsolutePath());
            }
            out.close();
        }
        catch (Exception e) {
            this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_ERROR, "Error al comprimir el procedimiento ", "", "", "Aseg\u00farese de que existen los ficheros asociados al procedimiento en las rutas de origen y de que tenga espacio en el disco")));
            this.incrementarErrores();
            this.fireFinal();
            e.printStackTrace();
            return false;
        }
        this.fireObtenerResultado(new InfoResultadoEvent(new InfoResultado(InfoResultado.TIPO_CORRECTO, "El procedimiento se comprimi\u00f3 correctamente en " + strFileZip, "", "", "")));
        this.fireFinal();
        return true;
    }

    public boolean getComprimir() {
        return this.m_bComprimir;
    }

    public void setComprimir(boolean bComprimir) {
        this.m_bComprimir = bComprimir;
    }
}

