/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.piccolo.handlers;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import modela.conf.ModelaConf;
import modela.ui.piccolo.PCanvasModela;
import modela.ui.piccolo.events.GraficoGeneradoEvent;
import modela.ui.piccolo.events.GraficoGeneradoListener;
import modela.ui.piccolo.handlers.PGrTransicionEventHandler;
import modela.ui.piccolo.nodes.FasePNode;
import modela.ui.piccolo.nodes.FinPNode;
import modela.ui.piccolo.nodes.TransicionPNode;

public class FinProcedimientoCreationEventHandler
extends PGrTransicionEventHandler {
    protected TransicionPNode tr = null;
    protected FasePNode faseGIni = null;
    protected FinPNode faseGFin = null;
    private TransicionPNode trNew = null;
    private Point2D pInicial = null;
    private transient ArrayList GraficoGeneradoListeners = new ArrayList(2);

    public FinProcedimientoCreationEventHandler(PNode param1, PNode param2, PCanvasModela pCanvas) {
        super(param1, param2, pCanvas);
    }

    public void cancelarProceso(PInputEvent e) {
        this.eliminarPath();
        this.eliminarLayer(e);
        this.pInicial = null;
        this.trNew = null;
    }

    public void mouseMoved(PInputEvent e) {
        if (this.trNew == null) {
            return;
        }
        if (this.faseGFin == null) {
            return;
        }
        Point2D pActual = e.getPosition();
        this.faseGFin.centerBoundsOnPoint(pActual.getX() + this.faseGFin.getBounds().getWidth() / 2.0 + 1.0, pActual.getY());
        this.trNew.updateBounds();
        this.trNew.repaint();
        this.faseGFin.repaint();
        this.dragPoint = e.getPosition();
        this.updateRectangle();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mousePressed(PInputEvent e) {
        Point2D pActual = null;
        if (e.getButton() == 3) {
            this.cancelarProceso(e);
            return;
        }
        if (e.getButton() != 1) return;
        this.eliminarPath();
        this.pressPoint = e.getPosition();
        if (e.getClickCount() > 1) {
            ModelaConf.setCreacionRapidaTransiciones(false);
            if ((e.getModifiers() & 2) != 0) {
                ModelaConf.setCreacionRapidaTransiciones(true);
            }
            if (this.trNew == null) {
                return;
            }
            this.trNew.setPNodoGraficoFaseFin(this.faseGFin);
            if (this.faseGIni.getTrFaseGrAsociada() != null && this.faseGFin.getTrFaseGrAsociada() != null) {
                this.faseGFin.getTrFaseGrAsociada().setTrFase(this.faseGIni.getTrFaseGrAsociada().getTrFase());
                System.out.println("- [ Info ] Transici\u00f3n creada: " + this.trNew);
            }
            GraficoGeneradoEvent ggE = new GraficoGeneradoEvent((Object)this);
            ggE.setTipo(8);
            ggE.setGraficoGenerado(this.trNew);
            this.fireGraficoGenerado(ggE);
            this.cancelarProceso(e);
            return;
        }
        pActual = e.getPosition();
        this.crearPath(e);
        if (e.getPickedNode() instanceof FasePNode) {
            if (this.trNew != null) return;
            this.trNew = new TransicionPNode("F", this.getCanvas());
            this.crearLayer(e);
            this.crearPath(e);
            this.faseGIni = (FasePNode)e.getPickedNode();
            this.trNew.setPNodoGraficoFaseIni(this.faseGIni);
            this.pInicial = pActual;
            this.faseGFin = new FinPNode(this.getCanvas());
            this.trNew.setPickable(true);
            this.layer.addChild((PNode)this.trNew);
            this.layer.addChild((PNode)this.faseGFin);
            this.faseGFin.centerBoundsOnPoint(pActual.getX() + this.faseGFin.getBounds().getWidth() / 2.0 + 1.0, pActual.getY());
            this.trNew.getPoints2D().addElement(this.pInicial.clone());
            this.trNew.updateBounds();
            this.faseGFin.repaint();
            return;
        } else if (this.trNew != null) {
            this.trNew.getPoints2D().addElement(pActual.clone());
            this.faseGFin.centerBoundsOnPoint(pActual.getX() + this.faseGFin.getBounds().getWidth() / 2.0 + 1.0, pActual.getY());
            this.trNew.updateBounds();
            this.trNew.repaint();
            this.faseGFin.repaint();
            return;
        } else {
            this.cancelarProceso(e);
            return;
        }
    }

    public synchronized void addGraficoGeneradoListener(GraficoGeneradoListener l) {
        if (!this.GraficoGeneradoListeners.contains(l)) {
            this.GraficoGeneradoListeners.add(l);
        }
    }

    public synchronized void removeGraficoGeneradoListener(GraficoGeneradoListener l) {
        this.GraficoGeneradoListeners.remove(l);
    }

    protected void fireGraficoGenerado(GraficoGeneradoEvent e) {
        List listeners = (List)this.GraficoGeneradoListeners.clone();
        int count = listeners.size();
        for (int i = 0; i < count; ++i) {
            ((GraficoGeneradoListener)listeners.get(i)).obtenerGraficoGenerado(e);
        }
    }
}

