/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.piccolo.handlers;

import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.handles.PHandle;
import edu.umd.cs.piccolox.util.PLocator;
import gdtel.ui.graf.Geometria;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import modela.ui.piccolo.nodes.TransicionPNode;

public class PNodeHandle
extends PHandle {
    private static final long serialVersionUID = 5168281607633735591L;
    Point2D puntoAsociado = null;
    int nIndex = 0;
    private TransicionPNode transiPNode = null;

    public PNodeHandle(TransicionPNode pTransiPNode, PLocator aLocator, Point2D nuevoPuntoAsociado, int nNuevoIndice) {
        super(aLocator);
        this.transiPNode = pTransiPNode;
        this.puntoAsociado = nuevoPuntoAsociado;
        this.nIndex = nNuevoIndice;
    }

    public Point2D getPunto() {
        return this.puntoAsociado;
    }

    public int getIndice() {
        return this.nIndex;
    }

    public TransicionPNode getTransiPNode() {
        return this.transiPNode;
    }

    public void setTransiPNode(TransicionPNode nuevaTransiPNode) {
        this.transiPNode = nuevaTransiPNode;
    }

    public void dragHandle(PDimension aLocalDimension, PInputEvent aEvent) {
        if (this.transiPNode == null) {
            return;
        }
        if (this.transiPNode.getPoints2D() == null) {
            return;
        }
        if (this.transiPNode.getPNodoGraficoFaseIni() == null) {
            return;
        }
        if (this.transiPNode.getPNodoGraficoFaseFin() == null) {
            return;
        }
        if (this.transiPNode.getCanvas() != null && this.transiPNode.getCanvas().getDiagrama() != null && this.transiPNode.getCanvas().getDiagrama().isBloqueado()) {
            return;
        }
        this.localToParent((Dimension2D)aLocalDimension);
        double xPretendida = ((Point2D)this.transiPNode.getPoints2D().elementAt(this.getIndice())).getX() + aLocalDimension.getWidth();
        double yPretendida = ((Point2D)this.transiPNode.getPoints2D().elementAt(this.getIndice())).getY() + aLocalDimension.getHeight();
        double margenIzquierdo = 0.0;
        double margenDerecho = 0.0;
        double margenSuperior = 0.0;
        double margenInferior = 0.0;
        double distanciaIzquierda = 0.0;
        double distanciaDerecha = 0.0;
        double minimaDistanciaLateral = 0.0;
        double distanciaArriba = 0.0;
        double distanciaAbajo = 0.0;
        double minimaDistanciaVertical = 0.0;
        if (this.getIndice() == 0 || this.getIndice() >= this.transiPNode.getPoints2D().size() - 1) {
            if (this.getIndice() == 0) {
                margenIzquierdo = this.transiPNode.getPNodoGraficoFaseIni().getGlobalBounds().getX();
                margenDerecho = margenIzquierdo + this.transiPNode.getPNodoGraficoFaseIni().getGlobalBounds().getWidth();
                margenSuperior = this.transiPNode.getPNodoGraficoFaseIni().getGlobalBounds().getY();
                margenInferior = margenSuperior + this.transiPNode.getPNodoGraficoFaseIni().getGlobalBounds().getHeight();
            } else if (this.getIndice() >= this.transiPNode.getPoints2D().size() - 1) {
                margenIzquierdo = this.transiPNode.getPNodoGraficoFaseFin().getGlobalBounds().getX();
                margenDerecho = margenIzquierdo + this.transiPNode.getPNodoGraficoFaseFin().getGlobalBounds().getWidth();
                margenSuperior = this.transiPNode.getPNodoGraficoFaseFin().getGlobalBounds().getY();
                margenInferior = margenSuperior + this.transiPNode.getPNodoGraficoFaseFin().getGlobalBounds().getHeight();
            }
            if (xPretendida > margenIzquierdo && xPretendida < margenDerecho && yPretendida > margenSuperior && yPretendida < margenInferior) {
                distanciaIzquierda = Math.abs(xPretendida - margenIzquierdo);
                minimaDistanciaLateral = distanciaIzquierda <= (distanciaDerecha = Math.abs(margenDerecho - xPretendida)) ? distanciaIzquierda : distanciaDerecha;
                if (minimaDistanciaLateral <= (minimaDistanciaVertical = (distanciaArriba = Math.abs(yPretendida - margenSuperior)) <= (distanciaAbajo = Math.abs(margenInferior - yPretendida)) ? distanciaArriba : distanciaAbajo)) {
                    xPretendida = distanciaIzquierda <= distanciaDerecha ? margenIzquierdo : margenDerecho;
                } else {
                    yPretendida = distanciaArriba <= distanciaAbajo ? margenSuperior : margenInferior;
                }
            }
            if (xPretendida < margenIzquierdo) {
                xPretendida = margenIzquierdo;
            }
            if (xPretendida > margenDerecho) {
                xPretendida = margenDerecho;
            }
            if (yPretendida < margenSuperior) {
                yPretendida = margenSuperior;
            }
            if (yPretendida > margenInferior) {
                yPretendida = margenInferior;
            }
        }
        ((Point2D)this.transiPNode.getPoints2D().elementAt(this.getIndice())).setLocation(xPretendida, yPretendida);
        this.transiPNode.updateBounds();
        this.relocateHandle();
    }

    public void endHandleDrag(Point2D p1, PInputEvent p2) {
        if (this.transiPNode.getPoints2D() == null) {
            return;
        }
        if (this.transiPNode.getPoints2D().size() < 2) {
            return;
        }
        if (this.getIndice() != 0 && this.getIndice() < this.transiPNode.getPoints2D().size() - 1) {
            if (this.transiPNode != null) {
                this.transiPNode.notificarCreacionAExtremos();
            }
            return;
        }
        double margenIzquierdo = 0.0;
        double margenDerecho = 0.0;
        double margenSuperior = 0.0;
        double margenInferior = 0.0;
        Point2D puntoInicioRecta = new Point2D.Double();
        Point2D puntoFinalRecta = new Point2D.Double();
        if (this.getIndice() == 0) {
            margenIzquierdo = this.transiPNode.getPNodoGraficoFaseIni().getGlobalBounds().getX();
            margenDerecho = margenIzquierdo + this.transiPNode.getPNodoGraficoFaseIni().getGlobalBounds().getWidth();
            margenSuperior = this.transiPNode.getPNodoGraficoFaseIni().getGlobalBounds().getY();
            margenInferior = margenSuperior + this.transiPNode.getPNodoGraficoFaseIni().getGlobalBounds().getHeight();
            puntoFinalRecta = (Point2D)this.transiPNode.getPoints2D().get(0);
            puntoInicioRecta = (Point2D)this.transiPNode.getPoints2D().get(1);
        } else if (this.getIndice() >= this.transiPNode.getPoints2D().size() - 1) {
            margenIzquierdo = this.transiPNode.getPNodoGraficoFaseFin().getGlobalBounds().getX();
            margenDerecho = margenIzquierdo + this.transiPNode.getPNodoGraficoFaseFin().getGlobalBounds().getWidth();
            margenSuperior = this.transiPNode.getPNodoGraficoFaseFin().getGlobalBounds().getY();
            margenInferior = margenSuperior + this.transiPNode.getPNodoGraficoFaseFin().getGlobalBounds().getHeight();
            puntoInicioRecta = (Point2D)this.transiPNode.getPoints2D().get(this.transiPNode.getPoints2D().size() - 2);
            puntoFinalRecta = (Point2D)this.transiPNode.getPoints2D().get(this.transiPNode.getPoints2D().size() - 1);
        }
        Point2D.Double puntoDeCorte = null;
        puntoDeCorte = Geometria.puntoDeCorte(puntoInicioRecta, puntoFinalRecta, margenIzquierdo, margenDerecho, margenSuperior, margenInferior);
        if (puntoDeCorte != null) {
            ((Point2D)this.transiPNode.getPoints2D().elementAt(this.getIndice())).setLocation(puntoDeCorte.getX(), puntoDeCorte.getY());
            this.transiPNode.updateBounds();
            this.relocateHandle();
        }
        if (this.transiPNode != null) {
            this.transiPNode.notificarCreacionAExtremos();
        }
        this.transiPNode.setRecalcularDistancia(true);
    }
}

