/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.piccolo.handlers;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.util.ArrayList;
import java.util.List;
import modela.ui.piccolo.PCanvasModela;
import modela.ui.piccolo.events.GraficoGeneradoEvent;
import modela.ui.piccolo.events.GraficoGeneradoListener;
import modela.ui.piccolo.handlers.PSelectionEventHandlerEx;
import modela.ui.piccolo.nodes.PNodoGrafico;
import modela.ui.piccolo.nodes.PostItPNode;

public class PostItCreationEventHandler
extends PSelectionEventHandlerEx {
    private PostItPNode graficoPostIt = null;
    private PCanvasModela canvas = null;
    private transient ArrayList GraficoGeneradoListeners = new ArrayList(2);

    public PostItCreationEventHandler(PNode param1, PNode param2, PCanvasModela pCanvas) {
        super(param1, param2);
        this.canvas = pCanvas;
        this.graficoPostIt = null;
    }

    public void cancelarProceso(PInputEvent e) {
        this.graficoPostIt = null;
    }

    public void mousePressed(PInputEvent e) {
        PNodoGrafico nodoAsociadoAlaNota = null;
        if (e.getButton() == 3) {
            this.cancelarProceso(e);
            return;
        }
        if (e.getButton() == 1) {
            if (e.getPickedNode() instanceof PNodoGrafico && !(e.getPickedNode() instanceof PostItPNode)) {
                nodoAsociadoAlaNota = (PNodoGrafico)e.getPickedNode();
            } else if (!(e.getPickedNode() instanceof PCamera)) {
                this.cancelarProceso(e);
                return;
            }
        }
        if (this.canvas == null) {
            this.cancelarProceso(e);
            return;
        }
        this.graficoPostIt = new PostItPNode(this.canvas);
        this.graficoPostIt.setX(e.getPosition().getX() - this.graficoPostIt.getGlobalBounds().getWidth() / 2.0);
        this.graficoPostIt.setY(e.getPosition().getY() - this.graficoPostIt.getGlobalBounds().getHeight() / 2.0);
        if (nodoAsociadoAlaNota != null) {
            this.graficoPostIt.setPNodoGraficoAsociado(nodoAsociadoAlaNota);
            this.graficoPostIt.posicionarInicialmente();
            this.graficoPostIt.readaptarBounds();
            nodoAsociadoAlaNota.addPostIt(this.graficoPostIt);
        }
        if (this.canvas.getDiagrama() == null) {
            this.cancelarProceso(e);
            return;
        }
        GraficoGeneradoEvent ggE = new GraficoGeneradoEvent((Object)this);
        this.graficoPostIt.setPickable(true);
        ggE.setTipo(9);
        ggE.setGraficoGenerado(this.graficoPostIt);
        this.fireGraficoGenerado(ggE);
        this.cancelarProceso(e);
    }

    public synchronized void addGraficoGeneradoListener(GraficoGeneradoListener l) {
        if (!this.GraficoGeneradoListeners.contains(l)) {
            this.GraficoGeneradoListeners.add(l);
        }
    }

    public synchronized void removeGraficoGeneradoListener(GraficoGeneradoListener l) {
        this.GraficoGeneradoListeners.remove(l);
    }

    protected void fireGraficoGenerado(GraficoGeneradoEvent e) {
        List listeners = (List)this.GraficoGeneradoListeners.clone();
        int count = listeners.size();
        for (int i = 0; i < count; ++i) {
            ((GraficoGeneradoListener)listeners.get(i)).obtenerGraficoGenerado(e);
        }
    }
}

