/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.piccolo.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.event.PSelectionEventHandler;
import edu.umd.cs.piccolox.swing.PViewport;
import gdtel.ui.piccolo.AccionPCanvas;
import gdtel.ui.swing.excontrols.JFiltroTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import modela.bd.obj.ConjuntoDatosFase;
import modela.bd.obj.TrFase;
import modela.bd.obj.TrFaseGr;
import modela.bd.obj.TrTareaEnFase;
import modela.bd.obj.TrTareaEnFaseDefProcedimiento;
import modela.bd.obj.TrTipoEvol;
import modela.bd.obj.TrTipoTarea;
import modela.bd.obj.TrTransicion;
import modela.bd.obj.TrTransicionDefProcedimiento;
import modela.conf.ModelaConf;
import modela.ui.ModelaUI;
import modela.ui.piccolo.PCanvasModela;
import modela.ui.piccolo.PScrollCanvas;
import modela.ui.piccolo.nodes.ImagenPNode;
import modela.ui.piccolo.nodes.PNodoGrafico;
import modela.ui.piccolo.nodes.TransicionPNode;
import modela.ui.swing.EliminarGraficoFaseJDialog;
import modela.ui.swing.PropGraficoFase;

public class FasePNode
extends PNodoGrafico {
    private static final long serialVersionUID = -3349879145291175785L;
    boolean bMostrarMetafase;
    boolean bMostrarTipoEvolucion;
    protected static final int SEPARACION_SOMBRA = 5;
    protected static int GROSOR_MARGENES = 1;
    Point2D.Double punto1LineaMetafase;
    Point2D.Double punto2LineaMetafase;
    Point2D.Double punto1LineaReutilizable;
    Point2D.Double punto2LineaReutilizable;
    Point2D.Double punto1SeparadorVReutilizable;
    Point2D.Double punto2SeparadorVReutilizable;
    Point2D.Double punto1LineaVNumGraficos;
    Point2D.Double punto2LineaVNumGraficos;
    Point2D.Double punto1LineaHNumGraficos;
    Point2D.Double punto2LineaHNumGraficos;
    int sizeFuenteTextoMetafase = 12;
    int sizeFuenteTextoReutilizable = 12;
    int sizeFuenteTextoNumGraficos = 10;
    protected JMenuItem menuAddTarea = null;
    private JMenuItem menuEliminarGr = null;
    private JMenuItem menuSetMetafase = null;
    private ImagenPNode generarPNode = null;
    private ImagenPNode incorporarPNode = null;
    private ImagenPNode manipularPNode = null;
    private ImagenPNode otrosPNode = null;
    private ImagenPNode generarMultiplePNode = null;
    private ImagenPNode incorporarMultiplePNode = null;
    public boolean bPosicionarIconos = true;
    private boolean bResaltarBajoPuntero = false;
    Color colorResaltar;
    protected Rectangle recReutiTmp;
    boolean bCursorSobreReutilizable;

    public FasePNode(PCanvasModela pCanvas) {
        this.sTipo = "FA";
        this.canvas = pCanvas;
        this.arrPalabras = new ArrayList();
        this.arrLongitudSegmento = new ArrayList();
        this.arrLineas = new ArrayList();
        this.bEnEdicion = false;
        this.bResaltarBajoPuntero = false;
        this.bMostrarMetafase = true;
        this.bMostrarTipoEvolucion = true;
        this.transicionesEntrada = new ArrayList();
        this.transicionesSalida = new ArrayList();
        this.colorFondo = null;
        this.colorTexto = null;
        this.colorBorde = Color.black;
        if (this.getTrFaseGrAsociada() != null) {
            this.colorFondo = this.getTrFaseGrAsociada().getColorFondo();
            this.colorTexto = this.getTrFaseGrAsociada().getColorTexto();
        }
        this.faseGraficaAsociada = null;
        this.sTexto = "Sin descripci\u00f3n";
        this.sizeFuenteTexto = 15;
        this.setBounds(120.0, 120.0, 15.0 + 9.0 * (double)this.sTexto.length(), 75.0);
        this.addListeners();
        this.addIconosHijos();
    }

    public FasePNode(TrFaseGr nuevaFase, PCanvasModela pCanvas) {
        this.sTipo = "FA";
        this.canvas = pCanvas;
        this.arrPalabras = new ArrayList();
        this.arrLongitudSegmento = new ArrayList();
        this.arrLineas = new ArrayList();
        this.bEnEdicion = false;
        this.bResaltarBajoPuntero = false;
        this.bMostrarMetafase = true;
        this.bMostrarTipoEvolucion = true;
        this.transicionesEntrada = new ArrayList();
        this.transicionesSalida = new ArrayList();
        this.colorFondo = null;
        this.colorTexto = null;
        this.colorBorde = Color.black;
        if (nuevaFase != null) {
            this.colorFondo = nuevaFase.getColorFondo();
            this.colorTexto = nuevaFase.getColorTexto();
        }
        this.sizeFuenteTexto = 15;
        this.faseGraficaAsociada = nuevaFase;
        if (this.faseGraficaAsociada.getTrFase() != null) {
            this.sTexto = this.faseGraficaAsociada.getNombre();
        }
        if (nuevaFase != null) {
            this.inicializarBounds(nuevaFase.getX(), nuevaFase.getY(), nuevaFase.getAncho(), nuevaFase.getAlto());
        } else {
            this.inicializarBounds();
        }
        this.addListeners();
        this.addIconosHijos();
    }

    private void addListeners() {
        this.addInputEventListener((PInputEventListener)new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent myEvent) {
                FasePNode.this.onRightClick(myEvent);
            }

            public void mouseMoved(PInputEvent event) {
                if (FasePNode.this.canvas != null && FasePNode.this.canvas.getModificaTransiciones() != null && (FasePNode.this.canvas.getModificaTransiciones().isModificandoFaseFinal() || FasePNode.this.canvas.getModificaTransiciones().isModificandoFaseInicial())) {
                    FasePNode.this.aplicarResaltado(true);
                }
                FasePNode.this.comprobarPunteroSobreReutilizable((int)event.getPosition().getX(), (int)event.getPosition().getY());
            }

            public void mouseExited(PInputEvent e) {
                FasePNode.this.aplicarResaltado(false);
                FasePNode.this.bCursorSobreReutilizable = false;
            }
        });
    }

    public String toString() {
        if (this.faseGraficaAsociada == null) {
            return "";
        }
        if (this.faseGraficaAsociada.getTrFase() == null) {
            return "";
        }
        return this.faseGraficaAsociada.getNombre();
    }

    public void setsText(String str) {
        this.sTexto = str;
    }

    public String getsTexto() {
        return this.sTexto;
    }

    public boolean isEditando() {
        return this.bEnEdicion;
    }

    public void updateBounds() {
        PBounds bounds = this.getBounds();
        this.setBounds((Rectangle2D)bounds);
    }

    public void eliminar() {
        if (this.canvas == null) {
            return;
        }
        if (this.getTrFaseGrAsociada() == null) {
            this.canvas.eliminarPNodoGrafico(this);
            return;
        }
        if (this.getTrFaseGrAsociada().getTrFase() == null) {
            this.canvas.eliminarPNodoGrafico(this);
            return;
        }
        boolean eliminarFase = false;
        boolean eliminarTransicion = false;
        int modoDeTrabajo = 1;
        ArrayList arrayTransiSinGraficos = null;
        ArrayList graficosAsociadosAlaFase = null;
        graficosAsociadosAlaFase = this.canvas.localizarGraficosFase(this.getTrFaseGrAsociada().getTrFase(), "FA");
        if (graficosAsociadosAlaFase != null && graficosAsociadosAlaFase.size() > 1) {
            modoDeTrabajo = 2;
        }
        if (modoDeTrabajo == 1 && this.canvas.getDiagrama() != null && this.canvas.getDiagrama().isFaseUtilizadaEnTransicionesDefProcSinGraficos(this.getTrFaseGrAsociada().getTrFase())) {
            modoDeTrabajo = 2;
        }
        EliminarGraficoFaseJDialog delDialogo = new EliminarGraficoFaseJDialog();
        delDialogo.setLocationRelativeTo((Component)((Object)this.canvas));
        delDialogo.setModoTrabajo(modoDeTrabajo);
        delDialogo.setVisible(true);
        if (delDialogo.isCancelado()) {
            return;
        }
        eliminarFase = delDialogo.eliminarFase();
        eliminarTransicion = delDialogo.eliminarTransiciones();
        TrTransicionDefProcedimiento transiDefProcAux = null;
        TransicionPNode transiPNodeAux = null;
        if ((eliminarFase || eliminarTransicion) && this.canvas.getDiagrama() != null) {
            arrayTransiSinGraficos = this.canvas.obtenerTransiciones(false, true);
            TrTransicion transiSinGrafRelacionada = null;
            TrFase faseFinvAux = null;
            for (int nS = 0; nS < arrayTransiSinGraficos.size(); ++nS) {
                transiSinGrafRelacionada = (TrTransicion)arrayTransiSinGraficos.get(nS);
                if (transiSinGrafRelacionada.getTrFaseIni() != null && transiSinGrafRelacionada.getTrFaseIni().getFASEID().longValue() == this.getTrFaseGrAsociada().getTrFase().getFASEID().longValue()) {
                    transiPNodeAux = new TransicionPNode(transiSinGrafRelacionada.getTIPO(), this.canvas);
                    transiPNodeAux.setTrTransicion(transiSinGrafRelacionada);
                    if (!transiPNodeAux.controlRelacionEnPlazosSimple()) {
                        return;
                    }
                    if (!transiPNodeAux.controlRelacionEnPlazosCompuestos()) {
                        return;
                    }
                    if (this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiDefProcAux = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(transiSinGrafRelacionada.getID())) != null) {
                        this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().remove(transiDefProcAux);
                    }
                    if (this.canvas.getDiagrama().obtenerAparicionesDeTransicion(transiSinGrafRelacionada) == 0 && this.canvas.getDiagrama().getTransicionesInvolucradas() != null) {
                        this.canvas.getDiagrama().getTransicionesInvolucradas().remove(transiSinGrafRelacionada);
                    }
                }
                if (!transiSinGrafRelacionada.getTIPO().equals("D")) {
                    if (transiSinGrafRelacionada.getFaseFin() == null || transiSinGrafRelacionada.getFaseFin().getFASEID().longValue() != this.getTrFaseGrAsociada().getTrFase().getFASEID().longValue()) continue;
                    transiPNodeAux = new TransicionPNode(transiSinGrafRelacionada.getTIPO(), this.canvas);
                    transiPNodeAux.setTrTransicion(transiSinGrafRelacionada);
                    if (!transiPNodeAux.controlRelacionEnPlazosSimple()) {
                        return;
                    }
                    if (!transiPNodeAux.controlRelacionEnPlazosCompuestos()) {
                        return;
                    }
                    if (this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiDefProcAux = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(transiSinGrafRelacionada.getID())) != null) {
                        this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().remove(transiDefProcAux);
                    }
                    if (this.canvas.getDiagrama().obtenerAparicionesDeTransicion(transiSinGrafRelacionada) != 0 || this.canvas.getDiagrama().getTransicionesInvolucradas() == null) continue;
                    this.canvas.getDiagrama().getTransicionesInvolucradas().remove(transiSinGrafRelacionada);
                    continue;
                }
                if (transiSinGrafRelacionada.getConjuntoFasesFin() == null) continue;
                for (int nD = 0; nD < transiSinGrafRelacionada.getConjuntoFasesFin().obtenerNumRegistros(); ++nD) {
                    faseFinvAux = (TrFase)transiSinGrafRelacionada.getConjuntoFasesFin().obtenerDato(nD);
                    if (faseFinvAux.getFASEID().longValue() != this.getTrFaseGrAsociada().getTrFase().getFASEID().longValue()) continue;
                    transiPNodeAux = new TransicionPNode(transiSinGrafRelacionada.getTIPO(), this.canvas);
                    transiPNodeAux.setTrTransicion(transiSinGrafRelacionada);
                    if (!transiPNodeAux.controlRelacionEnPlazosSimple()) {
                        return;
                    }
                    if (!transiPNodeAux.controlRelacionEnPlazosCompuestos()) {
                        return;
                    }
                    if (this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiDefProcAux = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(transiSinGrafRelacionada.getID())) != null) {
                        this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().remove(transiDefProcAux);
                    }
                    if (this.canvas.getDiagrama().obtenerAparicionesDeTransicion(transiSinGrafRelacionada) != 0 || this.canvas.getDiagrama().getTransicionesInvolucradas() == null) continue;
                    this.canvas.getDiagrama().getTransicionesInvolucradas().remove(transiSinGrafRelacionada);
                }
            }
        }
        TransicionPNode transiRelacionada = null;
        ArrayList transicionesAborrar = this.canvas.localizarGraficosTransicionRelacionados(this.getTrFaseGrAsociada().getID(), "FA");
        for (int nt = 0; nt < transicionesAborrar.size(); ++nt) {
            transiRelacionada = (TransicionPNode)transicionesAborrar.get(nt);
            if (transiRelacionada.getTrTransicion() != null) {
                PNodoGrafico nodoABorrar = null;
                transiRelacionada.eliminarHandlesVertices();
                if (transiRelacionada.getTrTransicion().getTIPO().equals("N")) {
                    if (this.canvas.getDiagrama() != null && (eliminarFase || !eliminarFase && eliminarTransicion)) {
                        if (!transiRelacionada.controlRelacionEnPlazosSimple()) {
                            return;
                        }
                        if (!transiRelacionada.controlRelacionEnPlazosCompuestos()) {
                            return;
                        }
                        if (this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiDefProcAux = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(transiRelacionada.getTrTransicion().getID())) != null) {
                            this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().remove(transiDefProcAux);
                        }
                        if (this.canvas.getDiagrama().obtenerAparicionesDeTransicion(transiRelacionada.getTrTransicion()) == 0 && this.canvas.getDiagrama().getTransicionesInvolucradas() != null) {
                            this.canvas.getDiagrama().getTransicionesInvolucradas().remove(transiRelacionada.getTrTransicion());
                        }
                    }
                } else if (transiRelacionada.getTrTransicion().getTIPO().equals("EN") || transiRelacionada.getTrTransicion().getTIPO().equals("ES") || transiRelacionada.getTrTransicion().getTIPO().equals("I")) {
                    if (this.canvas.getDiagrama() != null && (eliminarFase || !eliminarFase && eliminarTransicion)) {
                        if (!transiRelacionada.controlRelacionEnPlazosSimple()) {
                            return;
                        }
                        if (!transiRelacionada.controlRelacionEnPlazosCompuestos()) {
                            return;
                        }
                        if (this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiDefProcAux = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(transiRelacionada.getTrTransicion().getID())) != null) {
                            this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().remove(transiDefProcAux);
                        }
                        if (this.canvas.getDiagrama().obtenerAparicionesDeTransicion(transiRelacionada.getTrTransicion()) == 0 && this.canvas.getDiagrama().getTransicionesInvolucradas() != null) {
                            this.canvas.getDiagrama().getTransicionesInvolucradas().remove(transiRelacionada.getTrTransicion());
                        }
                    }
                    if (transiRelacionada.getPNodoGraficoFaseIni() != null) {
                        this.canvas.eliminarPNodoGrafico(transiRelacionada.getPNodoGraficoFaseIni());
                    } else if (transiRelacionada.getTransicionGr() != null && transiRelacionada.getTransicionGr().getGraficoExtremoInicial() != null) {
                        nodoABorrar = this.canvas.localizarGraficoFase(transiRelacionada.getTransicionGr().getGraficoExtremoInicial().getID());
                        this.canvas.eliminarPNodoGrafico(nodoABorrar);
                    }
                } else if (transiRelacionada.getTrTransicion().getTIPO().equals("F")) {
                    if (this.canvas.getDiagrama() != null && (eliminarFase || !eliminarFase && eliminarTransicion)) {
                        if (!transiRelacionada.controlRelacionEnPlazosSimple()) {
                            return;
                        }
                        if (!transiRelacionada.controlRelacionEnPlazosCompuestos()) {
                            return;
                        }
                        if (this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiDefProcAux = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(transiRelacionada.getTrTransicion().getID())) != null) {
                            this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().remove(transiDefProcAux);
                        }
                        if (this.canvas.getDiagrama().obtenerAparicionesDeTransicion(transiRelacionada.getTrTransicion()) == 0 && this.canvas.getDiagrama().getTransicionesInvolucradas() != null) {
                            this.canvas.getDiagrama().getTransicionesInvolucradas().remove(transiRelacionada.getTrTransicion());
                        }
                    }
                    if (transiRelacionada.getPNodoGraficoFaseFin() != null) {
                        this.canvas.eliminarPNodoGrafico(transiRelacionada.getPNodoGraficoFaseFin());
                    } else if (transiRelacionada.getTransicionGr() != null && transiRelacionada.getTransicionGr().getGraficoExtremoFinal() != null) {
                        nodoABorrar = this.canvas.localizarGraficoFase(transiRelacionada.getTransicionGr().getGraficoExtremoFinal().getID());
                        this.canvas.eliminarPNodoGrafico(nodoABorrar);
                    }
                } else if (transiRelacionada.getTrTransicion().getTIPO().equals("D")) {
                    if (transiRelacionada.getPNodoGraficoFaseIni() != null) {
                        if (!transiRelacionada.getPNodoGraficoFaseIni().getTipo().equals("D")) {
                            if (this.canvas.getDiagrama() != null && (eliminarFase || !eliminarFase && eliminarTransicion)) {
                                if (!transiRelacionada.controlRelacionEnPlazosSimple()) {
                                    return;
                                }
                                if (!transiRelacionada.controlRelacionEnPlazosCompuestos()) {
                                    return;
                                }
                                if (this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiDefProcAux = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(transiRelacionada.getTrTransicion().getID())) != null) {
                                    this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().remove(transiDefProcAux);
                                }
                                if (this.canvas.getDiagrama().obtenerAparicionesDeTransicion(transiRelacionada.getTrTransicion()) == 0 && this.canvas.getDiagrama().getTransicionesInvolucradas() != null) {
                                    this.canvas.getDiagrama().getTransicionesInvolucradas().remove(transiRelacionada.getTrTransicion());
                                }
                            }
                            nodoABorrar = transiRelacionada.getPNodoGraficoFaseFin() != null ? transiRelacionada.getPNodoGraficoFaseFin() : this.canvas.localizarGraficoFase(transiRelacionada.getTrTransicion().getTrFaseIni(), "D");
                            nodoABorrar = transiRelacionada.getPNodoGraficoFaseFin();
                            this.canvas.eliminarPNodoGrafico(nodoABorrar);
                            TransicionPNode transiAborrar = null;
                            PNodoGrafico graficoAuxFaseFin = null;
                            for (int f = 0; f < transiRelacionada.getTrTransicion().getConjuntoFasesFin().obtenerNumRegistros(); ++f) {
                                graficoAuxFaseFin = this.canvas.localizarGraficoFase((TrFase)transiRelacionada.getTrTransicion().getConjuntoFasesFin().obtenerDato(f));
                                if (graficoAuxFaseFin != null) {
                                    transiAborrar = this.canvas.localizarGraficoTransicion(transiRelacionada.getTrTransicion().getTRANID(), nodoABorrar.getTrFaseGrAsociada().getID(), graficoAuxFaseFin.getTrFaseGrAsociada().getID());
                                }
                                this.canvas.eliminarPNodoGrafico((PNode)transiAborrar);
                            }
                        } else if (transiRelacionada.getTrTransicion().getConjuntoFasesFin() != null) {
                            TrTransicionDefProcedimiento transiProc;
                            if (transiRelacionada.getPNodoGraficoFaseFin() != null) {
                                transiRelacionada.getTrTransicion().getConjuntoFasesFin().remove(transiRelacionada.getPNodoGraficoFaseFin().getTrFaseGrAsociada().getTrFase());
                            }
                            if (this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiProc = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(transiRelacionada.getTrTransicion().getTRANID().doubleValue())) != null && transiRelacionada.getPNodoGraficoFaseFin() != null && transiRelacionada.getPNodoGraficoFaseFin().getTrFaseGrAsociada() != null && transiRelacionada.getPNodoGraficoFaseFin().getTrFaseGrAsociada().getTrFase() != null) {
                                transiProc.removePlazoSimpleAsociadoAFase(transiRelacionada.getPNodoGraficoFaseFin().getTrFaseGrAsociada().getTrFase().getFASEID());
                            }
                        }
                    }
                } else if (transiRelacionada.getTrTransicion().getTIPO().equals("U") && this.canvas.getDiagrama() != null && (eliminarFase || !eliminarFase && eliminarTransicion)) {
                    if (!transiRelacionada.controlRelacionEnPlazosSimple()) {
                        return;
                    }
                    if (!transiRelacionada.controlRelacionEnPlazosCompuestos()) {
                        return;
                    }
                    if (this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiDefProcAux = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(transiRelacionada.getTrTransicion().getID())) != null) {
                        this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().remove(transiDefProcAux);
                    }
                    if (this.canvas.getDiagrama().obtenerAparicionesDeTransicion(transiRelacionada.getTrTransicion()) == 0 && this.canvas.getDiagrama().getTransicionesInvolucradas() != null) {
                        this.canvas.getDiagrama().getTransicionesInvolucradas().remove(transiRelacionada.getTrTransicion());
                    }
                }
            } else if (transiRelacionada.getTrTransicion() == null) {
                TransicionPNode transiTmp = null;
                ArrayList transicionesTmp = this.canvas.localizarGraficosTransicionUni(transiRelacionada.getPNodoGraficoFaseIni().getTrFaseGrAsociada().getID());
                for (int ntmp = 0; ntmp < transicionesTmp.size(); ++ntmp) {
                    transiTmp = (TransicionPNode)transicionesTmp.get(ntmp);
                    if (!transiTmp.controlRelacionEnPlazosSimple()) {
                        return;
                    }
                    if (!transiTmp.controlRelacionEnPlazosCompuestos()) {
                        return;
                    }
                    this.canvas.eliminarPNodoGrafico((PNode)transiTmp);
                    if (this.canvas.getDiagrama() == null || !eliminarFase && (eliminarFase || !eliminarTransicion)) continue;
                    if (this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiDefProcAux = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(transiTmp.getTrTransicion().getID())) != null) {
                        this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().remove(transiDefProcAux);
                    }
                    if (this.canvas.getDiagrama().obtenerAparicionesDeTransicion(transiTmp.getTrTransicion()) != 0 || this.canvas.getDiagrama().getTransicionesInvolucradas() == null) continue;
                    this.canvas.getDiagrama().getTransicionesInvolucradas().remove(transiTmp.getTrTransicion());
                }
                this.canvas.eliminarPNodoGrafico(transiRelacionada.getPNodoGraficoFaseIni());
            }
            this.canvas.eliminarPNodoGrafico((PNode)transiRelacionada);
        }
        this.canvas.eliminarPNodoGrafico(this);
        if (eliminarFase && this.canvas.getDiagrama() != null) {
            if (this.canvas.getDiagrama().getTareaFaseDefProcInvolucradas() != null && this.canvas.getDiagrama().getTareaFaseDefProcInvolucradas().obtenerNumRegistros() > 0) {
                TrTareaEnFaseDefProcedimiento tareaProcAux = null;
                for (int t = this.canvas.getDiagrama().getTareaFaseDefProcInvolucradas().getListaDatos().size() - 1; t >= 0; --t) {
                    tareaProcAux = (TrTareaEnFaseDefProcedimiento)this.canvas.getDiagrama().getTareaFaseDefProcInvolucradas().getListaDatos().get(t);
                    if (tareaProcAux.getTareaEnFase() == null || tareaProcAux.getTareaEnFase().getFase().getFASEID().longValue() != this.getTrFaseGrAsociada().getTrFase().getFASEID().longValue()) continue;
                    this.canvas.getDiagrama().getTareaFaseDefProcInvolucradas().remove(tareaProcAux);
                }
            }
            if (this.canvas.getDiagrama().getFasesInvolucradas() != null) {
                this.canvas.getDiagrama().getFasesInvolucradas().remove(this.getTrFaseGrAsociada().getTrFase());
            }
        }
        if ((eliminarFase || eliminarTransicion) && this.canvas.getDiagrama() != null && this.canvas.getDiagrama().getTransicionesInvolucradas() != null && this.canvas.getDiagrama().getTransicionesInvolucradas().obtenerNumRegistros() > 0) {
            TrTransicion transiEliminar = null;
            for (int t = this.canvas.getDiagrama().getTransicionesInvolucradas().getListaDatos().size() - 1; t >= 0; --t) {
                transiEliminar = (TrTransicion)this.canvas.getDiagrama().getTransicionesInvolucradas().getListaDatos().get(t);
                if (this.canvas.getDiagrama().isTransicionAsociadaAProcedimiento(transiEliminar)) continue;
                if (transiEliminar.getTrFaseIni() != null && transiEliminar.getTrFaseIni().getFASEID().longValue() == this.getTrFaseGrAsociada().getTrFase().getFASEID().longValue()) {
                    this.canvas.getDiagrama().getTransicionesInvolucradas().remove(transiEliminar);
                }
                if (!transiEliminar.getTIPO().equals("D")) {
                    if (transiEliminar.getFaseFin() == null || transiEliminar.getFaseFin().getFASEID().longValue() != this.getTrFaseGrAsociada().getTrFase().getFASEID().longValue()) continue;
                    this.canvas.getDiagrama().getTransicionesInvolucradas().remove(transiEliminar);
                    continue;
                }
                if (transiEliminar.getConjuntoFasesFin() == null) continue;
                TrFase faseFinvAux = null;
                for (int nD = 0; nD < transiEliminar.getConjuntoFasesFin().obtenerNumRegistros(); ++nD) {
                    faseFinvAux = (TrFase)transiEliminar.getConjuntoFasesFin().obtenerDato(nD);
                    if (faseFinvAux.getFASEID().longValue() != this.getTrFaseGrAsociada().getTrFase().getFASEID().longValue()) continue;
                    this.canvas.getDiagrama().getTransicionesInvolucradas().remove(transiEliminar);
                }
            }
        }
        ((PSelectionEventHandler)this.canvas.getSelectionEventHandler()).unselectAll();
    }

    private void editarNombreFase() {
        if (this.getTrFaseGrAsociada() == null) {
            return;
        }
        if (this.getTrFaseGrAsociada().getTrFase() == null) {
            return;
        }
        this.bEnEdicion = true;
        this.textEdit = new JFiltroTextField();
        this.textEdit.setCambiarColorAlModificar(false);
        this.textEdit.setFont(ModelaConf.getFuentePostIt().deriveFont(this.nSizeLetraEdicion));
        this.textEdit.establecerTipografia(1);
        this.textEdit.setTipoFiltro(1);
        this.textEdit.setNumItems(50);
        this.textEdit.setHorizontalAlignment(0);
        this.textEdit.setText(this.getTrFaseGrAsociada().getTrFase().getNOMBRE());
        this.textEdit.setBackground(Color.WHITE);
        this.textEdit.setForeground(Color.BLACK);
        if (this.getTrFaseGrAsociada().getTrFase().getMETAFASE() != null && this.getTrFaseGrAsociada().getTrFase().getMETAFASE().getPropiedadesGraficas() != null) {
            this.textEdit.setBackground(this.getTrFaseGrAsociada().getTrFase().getMETAFASE().getPropiedadesGraficas().getColorFondo());
            this.textEdit.setForeground(this.getTrFaseGrAsociada().getTrFase().getMETAFASE().getPropiedadesGraficas().getColorTexto());
        }
        if (this.colorFondo != null) {
            this.textEdit.setBackground(this.colorFondo);
        }
        if (this.colorTexto != null) {
            this.textEdit.setForeground(this.colorTexto);
        }
        this.textEdit.setVisible(true);
        this.posicionarTextEdit();
        this.textEdit.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent anEvent) {
                if (anEvent.getKeyChar() == '\n') {
                    FasePNode.this.validarEdicionNombreFase();
                } else if (anEvent.getKeyChar() == '\u001b') {
                    FasePNode.this.cancelarEdicionNombreFase();
                }
            }
        });
        this.textEdit.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!FasePNode.this.validarEdicionNombreFase() && FasePNode.this.textEdit != null) {
                    FasePNode.this.textEdit.requestFocus();
                    FasePNode.this.textEdit.selectAll();
                }
            }
        });
        this.canvas.add(this.textEdit);
        if (this.textEdit != null) {
            this.textEdit.requestFocus();
            this.textEdit.selectAll();
        }
    }

    private void posicionarTextEdit() {
        if (!this.bEnEdicion) {
            return;
        }
        if (this.textEdit == null) {
            return;
        }
        double posXtextEdit = this.getGlobalBounds().getX();
        double posYtextEdit = this.getGlobalBounds().getOrigin().getY() + 0.2 * this.getGlobalBounds().getSize().getHeight();
        double altoTextEdit = this.getGlobalBounds().getY() + (double)((int)this.getGlobalBounds().getHeight()) - posYtextEdit;
        if (this.bMostrarTipoEvolucion && this.getTrFaseGrAsociada() != null && this.getTrFaseGrAsociada().getTrFase() != null && this.getTrFaseGrAsociada().getTrFase().getTIPOEVOL() != null) {
            altoTextEdit -= 0.2 * this.getGlobalBounds().getSize().getHeight();
        }
        double anchoTextEdit = this.getGlobalBounds().getWidth();
        double gbX = posXtextEdit - this.canvas.getCamera().getViewBounds().getOrigin().getX();
        double vbX = this.canvas.getCamera().getViewBounds().getWidth();
        double dAncho = this.canvas.getWidth();
        posXtextEdit = gbX * dAncho / vbX;
        double gbY = posYtextEdit - this.canvas.getCamera().getViewBounds().getOrigin().getY();
        double vbY = this.canvas.getCamera().getViewBounds().getHeight();
        double dAlto = this.canvas.getHeight();
        posYtextEdit = gbY * dAlto / vbY;
        if ((anchoTextEdit = (double)((int)(anchoTextEdit * this.canvas.getCamera().getViewScale()))) * (altoTextEdit = (double)((int)(altoTextEdit * this.canvas.getCamera().getViewScale()))) < 4000.0) {
            if (anchoTextEdit < 100.0) {
                anchoTextEdit = 100.0;
            }
            if (altoTextEdit < 40.0) {
                altoTextEdit = 40.0;
            }
        } else {
            this.textEdit.setBorder(null);
        }
        this.textEdit.setBounds((int)posXtextEdit + 1, (int)posYtextEdit + 1, (int)anchoTextEdit - 1, (int)altoTextEdit - 1);
    }

    void cancelarEdicionNombreFase() {
        for (int nC = 0; nC < this.canvas.getComponents().length; ++nC) {
            if (!(this.canvas.getComponent(nC) instanceof JTextField)) continue;
            this.canvas.remove(nC);
        }
        this.textEdit = null;
        this.canvas.repaint();
        this.bEnEdicion = false;
    }

    boolean validarEdicionNombreFase() {
        if (this.textEdit == null) {
            this.cancelarEdicionNombreFase();
            return false;
        }
        if (this.canvas.getDiagrama() == null) {
            this.cancelarEdicionNombreFase();
            return false;
        }
        if (this.canvas.getDiagrama().getFasesInvolucradas() == null) {
            this.cancelarEdicionNombreFase();
            return false;
        }
        if (this.canvas.getDiagrama().getFasesInvolucradas().getListaDatos() == null) {
            this.cancelarEdicionNombreFase();
            return false;
        }
        if (this.textEdit.getText().equals("")) {
            this.cancelarEdicionNombreFase();
            JOptionPane.showMessageDialog((Component)((Object)this.canvas), "Imposible modificar:\nDebe indicar un nombre.", "Atenci\u00f3n", 2);
            return false;
        }
        if (!this.textEdit.getText().equals(this.getTrFaseGrAsociada().getTrFase().getNOMBRE())) {
            TrFase faseValidar = new TrFase();
            faseValidar.setNOMBRE(this.textEdit.getText());
            if (((ConjuntoDatosFase)this.canvas.getDiagrama().getFasesInvolucradas()).existeElemento(faseValidar, true) != null) {
                this.cancelarEdicionNombreFase();
                JOptionPane.showMessageDialog((Component)((Object)this.canvas), "Imposible modificar:\nYa existe una fase con el nombre indicado.", "Atenci\u00f3n", 2);
                return false;
            }
        }
        this.getTrFaseGrAsociada().getTrFase().setNOMBRE(this.textEdit.getText());
        if (this.getTrFaseGrAsociada().getTrFase().getDESCRIPCION().equals("--")) {
            this.getTrFaseGrAsociada().getTrFase().setDESCRIPCION(this.textEdit.getText());
        }
        this.cancelarEdicionNombreFase();
        this.canvas.graficoModificado(this);
        return true;
    }

    public void addIconosHijos() {
        this.generarPNode = new ImagenPNode(4);
        this.generarMultiplePNode = new ImagenPNode(8);
        this.incorporarPNode = new ImagenPNode(5);
        this.incorporarMultiplePNode = new ImagenPNode(9);
        this.manipularPNode = new ImagenPNode(6);
        this.otrosPNode = new ImagenPNode(7);
        this.generarPNode.setFasePNode(this);
        this.generarMultiplePNode.setFasePNode(this);
        this.incorporarPNode.setFasePNode(this);
        this.incorporarMultiplePNode.setFasePNode(this);
        this.manipularPNode.setFasePNode(this);
        this.otrosPNode.setFasePNode(this);
        this.generarPNode.setVisible(false);
        this.generarMultiplePNode.setVisible(false);
        this.incorporarMultiplePNode.setVisible(false);
        this.incorporarPNode.setVisible(false);
        this.manipularPNode.setVisible(false);
        this.otrosPNode.setVisible(false);
    }

    public void posicionarIconosHijos() {
        if (this.getTrFaseGrAsociada() == null) {
            return;
        }
        if (this.generarPNode != null) {
            this.posicionarIconoGenerar();
        }
        if (this.generarMultiplePNode != null) {
            this.posicionarIconoGenerar();
        }
        if (this.incorporarPNode != null) {
            this.posicionarIconoIncorporar();
        }
        if (this.incorporarMultiplePNode != null) {
            this.posicionarIconoIncorporar();
        }
        if (this.manipularPNode != null) {
            this.posicionarIconoManipular();
        }
        if (this.otrosPNode != null) {
            this.posicionarIconoOtros();
        }
    }

    private void posicionarIconoGenerar() {
        this.generarPNode.setVisible(false);
        this.generarPNode.setPickable(false);
        this.generarMultiplePNode.setVisible(false);
        this.generarMultiplePNode.setPickable(false);
        if (this.getTrFaseGrAsociada() == null) {
            return;
        }
        if (this.getTrFaseGrAsociada().getTrFase() == null) {
            return;
        }
        if (ModelaConf.getMostrarIconoTareaGenerar()) {
            PBounds pb = this.getBounds();
            if (this.existeTipoTareaMultiple(TrTipoTarea.GENERAR_DOCUMENTO)) {
                this.crearIcono(8);
                if (!this.bMostrarMetafase) {
                    this.generarMultiplePNode.setOffset(pb.getWidth() + pb.getX() - 0.1 * pb.getWidth(), pb.getY());
                    this.generarMultiplePNode.setPickable(true);
                    this.generarMultiplePNode.setVisible(true);
                } else {
                    this.generarMultiplePNode.setOffset(pb.getWidth() + pb.getX() - 0.1 * pb.getWidth(), pb.getY() + 0.2 * pb.getSize().getHeight());
                    this.generarMultiplePNode.setPickable(true);
                    this.generarMultiplePNode.setVisible(true);
                }
            } else if (this.existeTipoTarea(TrTipoTarea.GENERAR_DOCUMENTO)) {
                this.crearIcono(4);
                if (!this.bMostrarMetafase) {
                    this.generarPNode.setOffset(pb.getWidth() + pb.getX() - 0.1 * pb.getWidth(), pb.getY());
                    this.generarPNode.setPickable(true);
                    this.generarPNode.setVisible(true);
                } else {
                    this.generarPNode.setOffset(pb.getWidth() + pb.getX() - 0.1 * pb.getWidth(), pb.getY() + 0.2 * pb.getSize().getHeight());
                    this.generarPNode.setPickable(true);
                    this.generarPNode.setVisible(true);
                }
            }
        }
    }

    private void posicionarIconoIncorporar() {
        this.incorporarPNode.setVisible(false);
        this.incorporarPNode.setPickable(false);
        this.incorporarMultiplePNode.setVisible(false);
        this.incorporarMultiplePNode.setPickable(false);
        if (this.getTrFaseGrAsociada() == null) {
            return;
        }
        if (this.getTrFaseGrAsociada().getTrFase() == null) {
            return;
        }
        if (ModelaConf.getMostrarIconoTareaIncorporar()) {
            PBounds pb = this.getBounds();
            if (this.existeTipoTareaMultiple(TrTipoTarea.INCORPORAR_DOCUMENTO)) {
                this.crearIcono(9);
                if (!this.bMostrarMetafase) {
                    this.incorporarMultiplePNode.setOffset(pb.getWidth() + pb.getX() - 0.1 * pb.getWidth(), pb.getY() + pb.getHeight() * 0.22);
                    this.incorporarMultiplePNode.setPickable(true);
                    this.incorporarMultiplePNode.setVisible(true);
                } else {
                    this.incorporarMultiplePNode.setOffset(pb.getWidth() + pb.getX() - 0.1 * pb.getWidth(), pb.getY() + pb.getHeight() * 0.2 + 0.2 * pb.getSize().getHeight());
                    this.incorporarMultiplePNode.setPickable(true);
                    this.incorporarMultiplePNode.setVisible(true);
                }
            } else if (this.existeTipoTarea(TrTipoTarea.INCORPORAR_DOCUMENTO)) {
                this.crearIcono(5);
                if (!this.bMostrarMetafase) {
                    this.incorporarPNode.setOffset(pb.getWidth() + pb.getX() - 0.1 * pb.getWidth(), pb.getY() + pb.getHeight() * 0.22);
                    this.incorporarPNode.setPickable(true);
                    this.incorporarPNode.setVisible(true);
                } else {
                    this.incorporarPNode.setOffset(pb.getWidth() + pb.getX() - 0.1 * pb.getWidth(), pb.getY() + pb.getHeight() * 0.2 + 0.2 * pb.getSize().getHeight());
                    this.incorporarPNode.setPickable(true);
                    this.incorporarPNode.setVisible(true);
                }
            }
        }
    }

    private void posicionarIconoManipular() {
        this.manipularPNode.setVisible(false);
        this.manipularPNode.setPickable(false);
        if (this.getTrFaseGrAsociada() == null) {
            return;
        }
        if (this.getTrFaseGrAsociada().getTrFase() == null) {
            return;
        }
        if (ModelaConf.getMostrarIconoTareaManipular() && this.existeTipoTarea(TrTipoTarea.MANIPULAR_DATOS)) {
            PBounds pb = this.getBounds();
            this.crearIcono(6);
            if (!this.bMostrarMetafase) {
                this.manipularPNode.setOffset(pb.getWidth() + pb.getX() - 0.1 * pb.getWidth(), pb.getY() + pb.getHeight() * 0.44);
                this.manipularPNode.setPickable(true);
                this.manipularPNode.setVisible(true);
            } else {
                this.manipularPNode.setOffset(pb.getWidth() + pb.getX() - 0.1 * pb.getWidth(), pb.getY() + pb.getHeight() * 0.4 + 0.2 * pb.getSize().getHeight());
                this.manipularPNode.setPickable(true);
                this.manipularPNode.setVisible(true);
            }
        }
    }

    private void posicionarIconoOtros() {
        this.otrosPNode.setVisible(false);
        this.otrosPNode.setPickable(false);
        if (this.getTrFaseGrAsociada() == null) {
            return;
        }
        if (this.getTrFaseGrAsociada().getTrFase() == null) {
            return;
        }
        if (ModelaConf.getMostrarIconoTareaOtros() && this.existeTipoTarea(TrTipoTarea.OTROS)) {
            PBounds pb = this.getBounds();
            this.crearIcono(7);
            if (!this.bMostrarMetafase) {
                this.otrosPNode.setOffset(pb.getWidth() + pb.getX() - 0.1 * pb.getWidth(), pb.getY() + pb.getHeight() * 0.66);
                this.otrosPNode.setPickable(true);
                this.otrosPNode.setVisible(true);
            } else {
                this.otrosPNode.setOffset(pb.getWidth() + pb.getX() - 0.1 * pb.getWidth(), pb.getY() + pb.getHeight() * 0.6 + 0.2 * pb.getSize().getHeight());
                this.otrosPNode.setPickable(true);
                this.otrosPNode.setVisible(true);
            }
        }
    }

    public void endResizeBounds() {
        this.bPosicionarIconos = true;
    }

    public boolean ComprobarExistencaTareasGenerar() {
        if (this.getTrFaseGrAsociada() == null) {
            return false;
        }
        if (this.getTrFaseGrAsociada().getTrFase() == null) {
            return false;
        }
        if (this.getTrFaseGrAsociada().getTrFase().getConjuntoTareasEnFase() == null) {
            return false;
        }
        ArrayList vDatosAccion = this.getTrFaseGrAsociada().getTrFase().getConjuntoTareasEnFase().getListaDatos();
        TrTareaEnFase tareaFase = null;
        for (int i = 0; i < vDatosAccion.size(); ++i) {
            tareaFase = (TrTareaEnFase)vDatosAccion.get(i);
            if (tareaFase == null || tareaFase.getTarea() == null || tareaFase.getTarea().getTrTipoTarea() != TrTipoTarea.GENERAR_DOCUMENTO) continue;
            return true;
        }
        return false;
    }

    public boolean ComprobarExistencaTareasIncorporar() {
        if (this.getTrFaseGrAsociada() == null) {
            return false;
        }
        if (this.getTrFaseGrAsociada().getTrFase() == null) {
            return false;
        }
        if (this.getTrFaseGrAsociada().getTrFase().getConjuntoTareasEnFase() == null) {
            return false;
        }
        ArrayList vDatosAccion = this.getTrFaseGrAsociada().getTrFase().getConjuntoTareasEnFase().getListaDatos();
        TrTareaEnFase tareaFase = null;
        for (int i = 0; i < vDatosAccion.size(); ++i) {
            tareaFase = (TrTareaEnFase)vDatosAccion.get(i);
            if (tareaFase == null || tareaFase.getTarea() == null || tareaFase.getTarea().getTrTipoTarea() != TrTipoTarea.INCORPORAR_DOCUMENTO) continue;
            return true;
        }
        return false;
    }

    public boolean ComprobarExistencaTareasManipular() {
        if (this.getTrFaseGrAsociada() == null) {
            return false;
        }
        if (this.getTrFaseGrAsociada().getTrFase() == null) {
            return false;
        }
        if (this.getTrFaseGrAsociada().getTrFase().getConjuntoTareasEnFase() == null) {
            return false;
        }
        ArrayList vDatosAccion = this.getTrFaseGrAsociada().getTrFase().getConjuntoTareasEnFase().getListaDatos();
        TrTareaEnFase tareaFase = null;
        for (int i = 0; i < vDatosAccion.size(); ++i) {
            tareaFase = (TrTareaEnFase)vDatosAccion.get(i);
            if (tareaFase == null || tareaFase.getTarea() == null || tareaFase.getTarea().getTrTipoTarea() != TrTipoTarea.MANIPULAR_DATOS) continue;
            return true;
        }
        return false;
    }

    public boolean ComprobarExistencaTareasOtros() {
        if (this.getTrFaseGrAsociada() == null) {
            return false;
        }
        if (this.getTrFaseGrAsociada().getTrFase() == null) {
            return false;
        }
        if (this.getTrFaseGrAsociada().getTrFase().getConjuntoTareasEnFase() == null) {
            return false;
        }
        ArrayList vDatosAccion = this.getTrFaseGrAsociada().getTrFase().getConjuntoTareasEnFase().getListaDatos();
        TrTareaEnFase tareaFase = null;
        for (int i = 0; i < vDatosAccion.size(); ++i) {
            tareaFase = (TrTareaEnFase)vDatosAccion.get(i);
            if (tareaFase == null || tareaFase.getTarea() == null || tareaFase.getTarea().getTrTipoTarea() != TrTipoTarea.OTROS) continue;
            return true;
        }
        return false;
    }

    protected void crearIcono(int nIcono) {
        boolean bAdd = true;
        for (int n = 0; n < this.getChildrenCount(); ++n) {
            if (!(this.getChild(n) instanceof ImagenPNode) || ((ImagenPNode)this.getChild(n)).getTipoImagen() != nIcono) continue;
            bAdd = false;
        }
        if (bAdd) {
            switch (nIcono) {
                case 4: {
                    this.addChild((PNode)this.generarPNode);
                    break;
                }
                case 8: {
                    this.addChild((PNode)this.generarMultiplePNode);
                    break;
                }
                case 5: {
                    this.addChild((PNode)this.incorporarPNode);
                    break;
                }
                case 9: {
                    this.addChild((PNode)this.incorporarMultiplePNode);
                    break;
                }
                case 6: {
                    this.addChild((PNode)this.manipularPNode);
                    break;
                }
                case 7: {
                    this.addChild((PNode)this.otrosPNode);
                }
            }
        }
    }

    public PCanvasModela getCanvas() {
        return this.canvas;
    }

    public boolean existeTipoTarea(TrTipoTarea tipoTarea) {
        if (this.canvas == null) {
            return false;
        }
        if (this.canvas.getDiagrama() == null) {
            return false;
        }
        if (this.canvas.getDiagrama().getTareaFaseDefProcInvolucradas() == null) {
            return false;
        }
        if (this.canvas.getDiagrama().getTareaFaseDefProcInvolucradas().getListaDatos() == null) {
            return false;
        }
        if (this.canvas.getDiagrama().getTareaFaseDefProcInvolucradas().getListaDatos().size() <= 0) {
            return false;
        }
        if (this.getTrFaseGrAsociada() == null) {
            return false;
        }
        if (this.getTrFaseGrAsociada().getTrFase() == null) {
            return false;
        }
        return this.canvas.getDiagrama().getTareaFaseDefProcInvolucradas().existeTipoTarea(this.getTrFaseGrAsociada().getTrFase().getID(), tipoTarea);
    }

    public boolean existeTipoTareaMultiple(TrTipoTarea tipoTarea) {
        if (this.canvas == null) {
            return false;
        }
        if (this.canvas.getDiagrama() == null) {
            return false;
        }
        if (this.canvas.getDiagrama().getTareaFaseDefProcInvolucradas() == null) {
            return false;
        }
        if (this.canvas.getDiagrama().getTareaFaseDefProcInvolucradas().getListaDatos() == null) {
            return false;
        }
        if (this.canvas.getDiagrama().getTareaFaseDefProcInvolucradas().getListaDatos().size() <= 0) {
            return false;
        }
        if (this.getTrFaseGrAsociada() == null) {
            return false;
        }
        if (this.getTrFaseGrAsociada().getTrFase() == null) {
            return false;
        }
        return this.canvas.getDiagrama().getTareaFaseDefProcInvolucradas().existeTipoTareaMultiple(this.getTrFaseGrAsociada().getTrFase().getID(), tipoTarea);
    }

    public void aplicarResaltado(boolean bResaltar) {
        this.bResaltarBajoPuntero = bResaltar;
        this.repaint();
    }

    public void eliminar(boolean bEliminarFase, boolean bEliminarTransiciones) {
        if (this.canvas == null) {
            return;
        }
        if (this.getTrFaseGrAsociada() == null) {
            this.canvas.eliminarPNodoGrafico(this);
            return;
        }
        if (this.getTrFaseGrAsociada().getTrFase() == null) {
            this.canvas.eliminarPNodoGrafico(this);
            return;
        }
        boolean eliminarFase = false;
        boolean eliminarTransicion = false;
        eliminarFase = bEliminarFase;
        eliminarTransicion = bEliminarTransiciones;
        int modoDeTrabajo = 1;
        ArrayList arrayTransiSinGraficos = null;
        ArrayList graficosAsociadosAlaFase = null;
        graficosAsociadosAlaFase = this.canvas.localizarGraficosFase(this.getTrFaseGrAsociada().getTrFase(), "FA");
        if (graficosAsociadosAlaFase != null && graficosAsociadosAlaFase.size() > 1) {
            modoDeTrabajo = 2;
            eliminarFase = false;
        }
        if (modoDeTrabajo == 1 && this.canvas.getDiagrama() != null && this.canvas.getDiagrama().isFaseUtilizadaEnTransicionesDefProcSinGraficos(this.getTrFaseGrAsociada().getTrFase())) {
            modoDeTrabajo = 2;
            eliminarFase = false;
        }
        TrTransicionDefProcedimiento transiDefProcAux = null;
        TransicionPNode transiPNodeAux = null;
        if ((eliminarFase || eliminarTransicion) && this.canvas.getDiagrama() != null) {
            arrayTransiSinGraficos = this.canvas.obtenerTransiciones(false, true);
            TrTransicion transiSinGrafRelacionada = null;
            TrFase faseFinvAux = null;
            for (int nS = 0; nS < arrayTransiSinGraficos.size(); ++nS) {
                transiSinGrafRelacionada = (TrTransicion)arrayTransiSinGraficos.get(nS);
                if (transiSinGrafRelacionada.getTrFaseIni() != null && transiSinGrafRelacionada.getTrFaseIni().getFASEID().longValue() == this.getTrFaseGrAsociada().getTrFase().getFASEID().longValue()) {
                    transiPNodeAux = new TransicionPNode(transiSinGrafRelacionada.getTIPO(), this.canvas);
                    transiPNodeAux.setTrTransicion(transiSinGrafRelacionada);
                    if (!transiPNodeAux.controlRelacionEnPlazosSimple()) {
                        return;
                    }
                    if (!transiPNodeAux.controlRelacionEnPlazosCompuestos()) {
                        return;
                    }
                    if (this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiDefProcAux = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(transiSinGrafRelacionada.getID())) != null) {
                        this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().remove(transiDefProcAux);
                    }
                    if (this.canvas.getDiagrama().obtenerAparicionesDeTransicion(transiSinGrafRelacionada) == 0 && this.canvas.getDiagrama().getTransicionesInvolucradas() != null) {
                        this.canvas.getDiagrama().getTransicionesInvolucradas().remove(transiSinGrafRelacionada);
                    }
                }
                if (!transiSinGrafRelacionada.getTIPO().equals("D")) {
                    if (transiSinGrafRelacionada.getFaseFin() == null || transiSinGrafRelacionada.getFaseFin().getFASEID().longValue() != this.getTrFaseGrAsociada().getTrFase().getFASEID().longValue()) continue;
                    transiPNodeAux = new TransicionPNode(transiSinGrafRelacionada.getTIPO(), this.canvas);
                    transiPNodeAux.setTrTransicion(transiSinGrafRelacionada);
                    if (!transiPNodeAux.controlRelacionEnPlazosSimple()) {
                        return;
                    }
                    if (!transiPNodeAux.controlRelacionEnPlazosCompuestos()) {
                        return;
                    }
                    if (this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiDefProcAux = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(transiSinGrafRelacionada.getID())) != null) {
                        this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().remove(transiDefProcAux);
                    }
                    if (this.canvas.getDiagrama().obtenerAparicionesDeTransicion(transiSinGrafRelacionada) != 0 || this.canvas.getDiagrama().getTransicionesInvolucradas() == null) continue;
                    this.canvas.getDiagrama().getTransicionesInvolucradas().remove(transiSinGrafRelacionada);
                    continue;
                }
                if (transiSinGrafRelacionada.getConjuntoFasesFin() == null) continue;
                for (int nD = 0; nD < transiSinGrafRelacionada.getConjuntoFasesFin().obtenerNumRegistros(); ++nD) {
                    faseFinvAux = (TrFase)transiSinGrafRelacionada.getConjuntoFasesFin().obtenerDato(nD);
                    if (faseFinvAux.getFASEID().longValue() != this.getTrFaseGrAsociada().getTrFase().getFASEID().longValue()) continue;
                    transiPNodeAux = new TransicionPNode(transiSinGrafRelacionada.getTIPO(), this.canvas);
                    transiPNodeAux.setTrTransicion(transiSinGrafRelacionada);
                    if (!transiPNodeAux.controlRelacionEnPlazosSimple()) {
                        return;
                    }
                    if (!transiPNodeAux.controlRelacionEnPlazosCompuestos()) {
                        return;
                    }
                    if (this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiDefProcAux = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(transiSinGrafRelacionada.getID())) != null) {
                        this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().remove(transiDefProcAux);
                    }
                    if (this.canvas.getDiagrama().obtenerAparicionesDeTransicion(transiSinGrafRelacionada) != 0 || this.canvas.getDiagrama().getTransicionesInvolucradas() == null) continue;
                    this.canvas.getDiagrama().getTransicionesInvolucradas().remove(transiSinGrafRelacionada);
                }
            }
        }
        TransicionPNode transiRelacionada = null;
        ArrayList transicionesAborrar = this.canvas.localizarGraficosTransicionRelacionados(this.getTrFaseGrAsociada().getID(), "FA");
        for (int nt = 0; nt < transicionesAborrar.size(); ++nt) {
            transiRelacionada = (TransicionPNode)transicionesAborrar.get(nt);
            if (transiRelacionada.getTrTransicion() != null) {
                PNodoGrafico nodoABorrar = null;
                transiRelacionada.eliminarHandlesVertices();
                if (transiRelacionada.getTrTransicion().getTIPO().equals("N")) {
                    if (this.canvas.getDiagrama() != null && (eliminarFase || !eliminarFase && eliminarTransicion)) {
                        if (!transiRelacionada.controlRelacionEnPlazosSimple()) {
                            return;
                        }
                        if (!transiRelacionada.controlRelacionEnPlazosCompuestos()) {
                            return;
                        }
                        if (this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiDefProcAux = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(transiRelacionada.getTrTransicion().getID())) != null) {
                            this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().remove(transiDefProcAux);
                        }
                        if (this.canvas.getDiagrama().obtenerAparicionesDeTransicion(transiRelacionada.getTrTransicion()) == 0 && this.canvas.getDiagrama().getTransicionesInvolucradas() != null) {
                            this.canvas.getDiagrama().getTransicionesInvolucradas().remove(transiRelacionada.getTrTransicion());
                        }
                    }
                } else if (transiRelacionada.getTrTransicion().getTIPO().equals("EN") || transiRelacionada.getTrTransicion().getTIPO().equals("ES") || transiRelacionada.getTrTransicion().getTIPO().equals("I")) {
                    if (this.canvas.getDiagrama() != null && (eliminarFase || !eliminarFase && eliminarTransicion)) {
                        if (!transiRelacionada.controlRelacionEnPlazosSimple()) {
                            return;
                        }
                        if (!transiRelacionada.controlRelacionEnPlazosCompuestos()) {
                            return;
                        }
                        if (this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiDefProcAux = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(transiRelacionada.getTrTransicion().getID())) != null) {
                            this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().remove(transiDefProcAux);
                        }
                        if (this.canvas.getDiagrama().obtenerAparicionesDeTransicion(transiRelacionada.getTrTransicion()) == 0 && this.canvas.getDiagrama().getTransicionesInvolucradas() != null) {
                            this.canvas.getDiagrama().getTransicionesInvolucradas().remove(transiRelacionada.getTrTransicion());
                        }
                    }
                    if (transiRelacionada.getPNodoGraficoFaseIni() != null) {
                        this.canvas.eliminarPNodoGrafico(transiRelacionada.getPNodoGraficoFaseIni());
                    } else if (transiRelacionada.getTransicionGr() != null && transiRelacionada.getTransicionGr().getGraficoExtremoInicial() != null) {
                        nodoABorrar = this.canvas.localizarGraficoFase(transiRelacionada.getTransicionGr().getGraficoExtremoInicial().getID());
                        this.canvas.eliminarPNodoGrafico(nodoABorrar);
                    }
                } else if (transiRelacionada.getTrTransicion().getTIPO().equals("F")) {
                    if (this.canvas.getDiagrama() != null && (eliminarFase || !eliminarFase && eliminarTransicion)) {
                        if (!transiRelacionada.controlRelacionEnPlazosSimple()) {
                            return;
                        }
                        if (!transiRelacionada.controlRelacionEnPlazosCompuestos()) {
                            return;
                        }
                        if (this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiDefProcAux = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(transiRelacionada.getTrTransicion().getID())) != null) {
                            this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().remove(transiDefProcAux);
                        }
                        if (this.canvas.getDiagrama().obtenerAparicionesDeTransicion(transiRelacionada.getTrTransicion()) == 0 && this.canvas.getDiagrama().getTransicionesInvolucradas() != null) {
                            this.canvas.getDiagrama().getTransicionesInvolucradas().remove(transiRelacionada.getTrTransicion());
                        }
                    }
                    if (transiRelacionada.getPNodoGraficoFaseFin() != null) {
                        this.canvas.eliminarPNodoGrafico(transiRelacionada.getPNodoGraficoFaseFin());
                    } else if (transiRelacionada.getTransicionGr() != null && transiRelacionada.getTransicionGr().getGraficoExtremoFinal() != null) {
                        nodoABorrar = this.canvas.localizarGraficoFase(transiRelacionada.getTransicionGr().getGraficoExtremoFinal().getID());
                        this.canvas.eliminarPNodoGrafico(nodoABorrar);
                    }
                } else if (transiRelacionada.getTrTransicion().getTIPO().equals("D")) {
                    if (transiRelacionada.getPNodoGraficoFaseIni() != null) {
                        if (!transiRelacionada.getPNodoGraficoFaseIni().getTipo().equals("D")) {
                            if (this.canvas.getDiagrama() != null && (eliminarFase || !eliminarFase && eliminarTransicion)) {
                                if (!transiRelacionada.controlRelacionEnPlazosSimple()) {
                                    return;
                                }
                                if (!transiRelacionada.controlRelacionEnPlazosCompuestos()) {
                                    return;
                                }
                                if (this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiDefProcAux = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(transiRelacionada.getTrTransicion().getID())) != null) {
                                    this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().remove(transiDefProcAux);
                                }
                                if (this.canvas.getDiagrama().obtenerAparicionesDeTransicion(transiRelacionada.getTrTransicion()) == 0 && this.canvas.getDiagrama().getTransicionesInvolucradas() != null) {
                                    this.canvas.getDiagrama().getTransicionesInvolucradas().remove(transiRelacionada.getTrTransicion());
                                }
                            }
                            nodoABorrar = transiRelacionada.getPNodoGraficoFaseFin() != null ? transiRelacionada.getPNodoGraficoFaseFin() : this.canvas.localizarGraficoFase(transiRelacionada.getTrTransicion().getTrFaseIni(), "D");
                            nodoABorrar = transiRelacionada.getPNodoGraficoFaseFin();
                            this.canvas.eliminarPNodoGrafico(nodoABorrar);
                            TransicionPNode transiAborrar = null;
                            PNodoGrafico graficoAuxFaseFin = null;
                            for (int f = 0; f < transiRelacionada.getTrTransicion().getConjuntoFasesFin().obtenerNumRegistros(); ++f) {
                                graficoAuxFaseFin = this.canvas.localizarGraficoFase((TrFase)transiRelacionada.getTrTransicion().getConjuntoFasesFin().obtenerDato(f));
                                if (graficoAuxFaseFin != null) {
                                    transiAborrar = this.canvas.localizarGraficoTransicion(transiRelacionada.getTrTransicion().getTRANID(), nodoABorrar.getTrFaseGrAsociada().getID(), graficoAuxFaseFin.getTrFaseGrAsociada().getID());
                                }
                                this.canvas.eliminarPNodoGrafico((PNode)transiAborrar);
                            }
                        } else if (transiRelacionada.getTrTransicion().getConjuntoFasesFin() != null) {
                            TrTransicionDefProcedimiento transiProc;
                            if (transiRelacionada.getPNodoGraficoFaseFin() != null) {
                                transiRelacionada.getTrTransicion().getConjuntoFasesFin().remove(transiRelacionada.getPNodoGraficoFaseFin().getTrFaseGrAsociada().getTrFase());
                            }
                            if (this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiProc = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(transiRelacionada.getTrTransicion().getTRANID().doubleValue())) != null && transiRelacionada.getPNodoGraficoFaseFin() != null && transiRelacionada.getPNodoGraficoFaseFin().getTrFaseGrAsociada() != null && transiRelacionada.getPNodoGraficoFaseFin().getTrFaseGrAsociada().getTrFase() != null) {
                                transiProc.removePlazoSimpleAsociadoAFase(transiRelacionada.getPNodoGraficoFaseFin().getTrFaseGrAsociada().getTrFase().getFASEID());
                            }
                        }
                    }
                } else if (transiRelacionada.getTrTransicion().getTIPO().equals("U") && this.canvas.getDiagrama() != null && (eliminarFase || !eliminarFase && eliminarTransicion)) {
                    if (!transiRelacionada.controlRelacionEnPlazosSimple()) {
                        return;
                    }
                    if (!transiRelacionada.controlRelacionEnPlazosCompuestos()) {
                        return;
                    }
                    if (this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiDefProcAux = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(transiRelacionada.getTrTransicion().getID())) != null) {
                        this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().remove(transiDefProcAux);
                    }
                    if (this.canvas.getDiagrama().obtenerAparicionesDeTransicion(transiRelacionada.getTrTransicion()) == 0 && this.canvas.getDiagrama().getTransicionesInvolucradas() != null) {
                        this.canvas.getDiagrama().getTransicionesInvolucradas().remove(transiRelacionada.getTrTransicion());
                    }
                }
            } else if (transiRelacionada.getTrTransicion() == null) {
                TransicionPNode transiTmp = null;
                ArrayList transicionesTmp = this.canvas.localizarGraficosTransicionUni(transiRelacionada.getPNodoGraficoFaseIni().getTrFaseGrAsociada().getID());
                for (int ntmp = 0; ntmp < transicionesTmp.size(); ++ntmp) {
                    transiTmp = (TransicionPNode)transicionesTmp.get(ntmp);
                    if (!transiTmp.controlRelacionEnPlazosSimple()) {
                        return;
                    }
                    if (!transiTmp.controlRelacionEnPlazosCompuestos()) {
                        return;
                    }
                    this.canvas.eliminarPNodoGrafico((PNode)transiTmp);
                    if (this.canvas.getDiagrama() == null || !eliminarFase && (eliminarFase || !eliminarTransicion)) continue;
                    if (this.canvas.getDiagrama().getTransicionesDelProcInvolucradas() != null && (transiDefProcAux = this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(transiTmp.getTrTransicion().getID())) != null) {
                        this.canvas.getDiagrama().getTransicionesDelProcInvolucradas().remove(transiDefProcAux);
                    }
                    if (this.canvas.getDiagrama().obtenerAparicionesDeTransicion(transiTmp.getTrTransicion()) != 0 || this.canvas.getDiagrama().getTransicionesInvolucradas() == null) continue;
                    this.canvas.getDiagrama().getTransicionesInvolucradas().remove(transiTmp.getTrTransicion());
                }
                this.canvas.eliminarPNodoGrafico(transiRelacionada.getPNodoGraficoFaseIni());
            }
            this.canvas.eliminarPNodoGrafico((PNode)transiRelacionada);
        }
        this.canvas.eliminarPNodoGrafico(this);
        if (eliminarFase && this.canvas.getDiagrama() != null) {
            if (this.canvas.getDiagrama().getTareaFaseDefProcInvolucradas() != null && this.canvas.getDiagrama().getTareaFaseDefProcInvolucradas().obtenerNumRegistros() > 0) {
                TrTareaEnFaseDefProcedimiento tareaProcAux = null;
                for (int t = this.canvas.getDiagrama().getTareaFaseDefProcInvolucradas().getListaDatos().size() - 1; t >= 0; --t) {
                    tareaProcAux = (TrTareaEnFaseDefProcedimiento)this.canvas.getDiagrama().getTareaFaseDefProcInvolucradas().getListaDatos().get(t);
                    if (tareaProcAux.getTareaEnFase() == null || tareaProcAux.getTareaEnFase().getFase().getFASEID().longValue() != this.getTrFaseGrAsociada().getTrFase().getFASEID().longValue()) continue;
                    this.canvas.getDiagrama().getTareaFaseDefProcInvolucradas().remove(tareaProcAux);
                }
            }
            if (this.canvas.getDiagrama().getFasesInvolucradas() != null) {
                this.canvas.getDiagrama().getFasesInvolucradas().remove(this.getTrFaseGrAsociada().getTrFase());
            }
        }
        if ((eliminarFase || eliminarTransicion) && this.canvas.getDiagrama() != null && this.canvas.getDiagrama().getTransicionesInvolucradas() != null && this.canvas.getDiagrama().getTransicionesInvolucradas().obtenerNumRegistros() > 0) {
            TrTransicion transiEliminar = null;
            for (int t = this.canvas.getDiagrama().getTransicionesInvolucradas().getListaDatos().size() - 1; t >= 0; --t) {
                transiEliminar = (TrTransicion)this.canvas.getDiagrama().getTransicionesInvolucradas().getListaDatos().get(t);
                if (this.canvas.getDiagrama().isTransicionAsociadaAProcedimiento(transiEliminar)) continue;
                if (transiEliminar.getTrFaseIni() != null && transiEliminar.getTrFaseIni().getFASEID().longValue() == this.getTrFaseGrAsociada().getTrFase().getFASEID().longValue()) {
                    this.canvas.getDiagrama().getTransicionesInvolucradas().remove(transiEliminar);
                }
                if (!transiEliminar.getTIPO().equals("D")) {
                    if (transiEliminar.getFaseFin() == null || transiEliminar.getFaseFin().getFASEID().longValue() != this.getTrFaseGrAsociada().getTrFase().getFASEID().longValue()) continue;
                    this.canvas.getDiagrama().getTransicionesInvolucradas().remove(transiEliminar);
                    continue;
                }
                if (transiEliminar.getConjuntoFasesFin() == null) continue;
                TrFase faseFinvAux = null;
                for (int nD = 0; nD < transiEliminar.getConjuntoFasesFin().obtenerNumRegistros(); ++nD) {
                    faseFinvAux = (TrFase)transiEliminar.getConjuntoFasesFin().obtenerDato(nD);
                    if (faseFinvAux.getFASEID().longValue() != this.getTrFaseGrAsociada().getTrFase().getFASEID().longValue()) continue;
                    this.canvas.getDiagrama().getTransicionesInvolucradas().remove(transiEliminar);
                }
            }
        }
        ((PSelectionEventHandler)this.canvas.getSelectionEventHandler()).unselectAll();
    }

    public void mostrarReutilizableAsociado(FasePNode faseClic) {
        if (faseClic == null) {
            return;
        }
        if (faseClic.getTrFaseGrAsociada() == null) {
            return;
        }
        if (faseClic.getTrFaseGrAsociada().getTrFase() == null) {
            return;
        }
        if (faseClic.getTrFaseGrAsociada().getTrFase().getTIPOEVOL() == null) {
            return;
        }
        try {
            this.seleccionarTabAsociado(faseClic.getTrFaseGrAsociada().getTrFase().getTIPOEVOL());
        }
        catch (Exception ex) {
            System.out.println("\u00b7 [ Error ] Se han producido errores al tratar de mostrar el Reutilizable asociado");
        }
    }

    private void seleccionarTabAsociado(TrTipoEvol tipoEvolucionBuscada) {
        if (tipoEvolucionBuscada == null) {
            return;
        }
        if (!(this.canvas.getParent() instanceof PViewport)) {
            return;
        }
        if (!(((PViewport)this.canvas.getParent()).getParent() instanceof PScrollCanvas)) {
            return;
        }
        if (!(((PScrollCanvas)((Object)((PViewport)this.canvas.getParent()).getParent())).getParent() instanceof JTabbedPane)) {
            return;
        }
        JTabbedPane tabbedCanvas = (JTabbedPane)((PScrollCanvas)((Object)((PViewport)this.canvas.getParent()).getParent())).getParent();
        if (tabbedCanvas.getTabCount() <= 1) {
            return;
        }
        if (tabbedCanvas.getSelectedComponent() instanceof PScrollCanvas && (((PScrollCanvas)((Object)tabbedCanvas.getSelectedComponent())).getCanvas().getDiagrama() == null || ((PScrollCanvas)((Object)tabbedCanvas.getSelectedComponent())).getCanvas().getDiagrama().getDDP() == null || ((PScrollCanvas)((Object)tabbedCanvas.getSelectedComponent())).getCanvas().getDiagrama().getDDP().getTIPOEVOL() == null)) {
            return;
        }
        if (tabbedCanvas.getSelectedComponent() instanceof PScrollCanvas && ((PScrollCanvas)((Object)tabbedCanvas.getSelectedComponent())).getCanvas().getDiagrama().getDDP().getTIPOEVOL().getTIEVID().longValue() == tipoEvolucionBuscada.getTIEVID().longValue()) {
            return;
        }
        for (int n = 0; n <= tabbedCanvas.getTabCount() - 1; ++n) {
            if (!(tabbedCanvas.getComponentAt(n) instanceof PScrollCanvas) || ((PScrollCanvas)((Object)tabbedCanvas.getComponentAt(n))).getCanvas() == null || ((PScrollCanvas)((Object)tabbedCanvas.getComponentAt(n))).getCanvas().getDiagrama() == null || ((PScrollCanvas)((Object)tabbedCanvas.getComponentAt(n))).getCanvas().getDiagrama().getDDP() == null || ((PScrollCanvas)((Object)tabbedCanvas.getComponentAt(n))).getCanvas().getDiagrama().getDDP().getTIPOEVOL() == null || ((PScrollCanvas)((Object)tabbedCanvas.getComponentAt(n))).getCanvas().getDiagrama().getDDP().getTIPOEVOL().getTIEVID().longValue() != tipoEvolucionBuscada.getTIEVID().longValue()) continue;
            tabbedCanvas.setSelectedIndex(n);
            break;
        }
    }

    void comprobarPunteroSobreReutilizable(int posPunteroX, int posPunteroY) {
        this.bCursorSobreReutilizable = false;
        if (this.recReutiTmp != null) {
            this.bCursorSobreReutilizable = this.recReutiTmp.inside(posPunteroX, posPunteroY);
        }
        this.repaint();
    }

    protected void paint(PPaintContext paintContext) {
        try {
            PBounds clipActual;
            PBounds xyAndSizeFase = this.getBounds();
            Graphics2D g2 = paintContext.getGraphics();
            g2.setStroke(this.stroke);
            if (this.canvas != null && (clipActual = this.canvas.getClipActual()) != null && this.canvas.isImprimiendo()) {
                g2.setClip((int)clipActual.getX() - 10, (int)clipActual.getY() - 10, (int)clipActual.getWidth() + 20, (int)clipActual.getHeight() + 20);
            }
            this.drawGraficoFase(g2, (int)xyAndSizeFase.getOrigin().getX(), (int)xyAndSizeFase.getOrigin().getY(), (int)xyAndSizeFase.getSize().getWidth(), (int)xyAndSizeFase.getSize().getHeight(), true);
            this.drawSeccionMetafases(xyAndSizeFase, g2);
            this.drawSeccionFase(xyAndSizeFase, g2);
            this.drawSeccionNumGraficos(xyAndSizeFase, g2);
            this.drawSeccionReutilizable(xyAndSizeFase, g2);
            this.setBounds((Rectangle2D)this.getBounds());
            this.reposicionarGraficosAsociados();
            g2.setClip(null);
            if (this.bEnEdicion) {
                this.posicionarTextEdit();
            }
            if (this.bPosicionarIconos) {
                this.posicionarIconosHijos();
                this.bPosicionarIconos = false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void drawGraficoFase(Graphics2D gr, int x, int y, int width, int height, boolean raised) {
        if (this.bResaltarBajoPuntero) {
            this.colorResaltar = ModelaUI.colorSeleccionGraficos;
            gr.setPaint(this.colorResaltar);
        } else if (this.colorFondo == null) {
            if (this.getTrFaseGrAsociada() != null && this.getTrFaseGrAsociada().getTrFase() != null && this.getTrFaseGrAsociada().getTrFase().getMETAFASE() != null) {
                gr.setPaint(this.getTrFaseGrAsociada().getTrFase().getMETAFASE().getPropiedadesGraficas().getColorFondo());
            }
        } else {
            gr.setPaint(this.colorFondo);
        }
        gr.setPaintMode();
        GROSOR_MARGENES = 1;
        if (this.canvas.isImprimiendo()) {
            GROSOR_MARGENES = 3;
        }
        Paint p = gr.getPaint();
        Color c = gr.getColor();
        Color brighter = c.brighter();
        Color darker = c.darker();
        if (!raised) {
            gr.setColor(darker);
        } else if (p != c) {
            gr.setColor(c);
        }
        gr.fillRect(x, y, width, height);
        if (this.colorBorde == null) {
            this.colorBorde = Color.black;
        }
        gr.setColor(this.colorBorde);
        gr.drawRect(x, y, width, height);
        if (ModelaConf.getMostrarSombraGraficos()) {
            gr.setColor(raised ? darker : brighter);
            gr.fillRect(x + 5, y + height + GROSOR_MARGENES + 1, width - 5 + GROSOR_MARGENES + ModelaConf.getGrosorSombraGraficos() + 1, ModelaConf.getGrosorSombraGraficos());
            gr.fillRect(x + width + GROSOR_MARGENES + 1, y + 5, ModelaConf.getGrosorSombraGraficos(), height - 5 + GROSOR_MARGENES + 2);
        }
        gr.setPaint(p);
        gr.setPaintMode();
    }

    private void drawCadena(Graphics2D contexto, String cadena, int posX, int posY) {
        if (contexto == null || cadena == null) {
            return;
        }
        if (contexto.getClip() == null) {
            return;
        }
        if (this.arrPalabras == null) {
            return;
        }
        if (this.arrLongitudSegmento == null) {
            return;
        }
        if (this.arrLineas == null) {
            return;
        }
        FontMetrics fmCadena = contexto.getFontMetrics();
        Rectangle2D rectTextoCadena = fmCadena.getStringBounds(cadena, contexto);
        if (contexto.getClip().getBounds().getWidth() > rectTextoCadena.getWidth()) {
            contexto.drawString(cadena, posX, posY);
            return;
        }
        this.arrPalabras.clear();
        String strAuxPalabras = cadena;
        String strPalabra = "";
        int posEspacioBlanco = strAuxPalabras.indexOf(" ");
        while (posEspacioBlanco >= 0) {
            strPalabra = strAuxPalabras.substring(0, posEspacioBlanco);
            strAuxPalabras = strAuxPalabras.substring(posEspacioBlanco + 1, strAuxPalabras.length());
            posEspacioBlanco = strAuxPalabras.indexOf(" ");
            this.arrPalabras.add(strPalabra);
        }
        this.arrPalabras.add(strAuxPalabras);
        String strAux = "";
        int nPalabra = 0;
        this.arrLongitudSegmento.clear();
        Integer nLongitudSegmento = new Integer(0);
        boolean espacioEnBlanco = false;
        boolean bSalirWhile = true;
        boolean bLineaPorPalabra = false;
        while (nPalabra < this.arrPalabras.size()) {
            if (nPalabra == 0 || espacioEnBlanco) {
                strAux = (String)this.arrPalabras.get(nPalabra);
                espacioEnBlanco = false;
            } else {
                strAux = strAux + " " + (String)this.arrPalabras.get(nPalabra);
            }
            rectTextoCadena = fmCadena.getStringBounds(strAux, contexto);
            if (contexto.getClip().getBounds().getWidth() >= rectTextoCadena.getWidth()) {
                nLongitudSegmento = new Integer(strAux.length());
                ++nPalabra;
                bSalirWhile = false;
                continue;
            }
            if (!bSalirWhile) {
                this.arrLongitudSegmento.add(nLongitudSegmento);
                espacioEnBlanco = true;
                bSalirWhile = true;
                continue;
            }
            bLineaPorPalabra = true;
            break;
        }
        this.arrLineas.clear();
        if (!bLineaPorPalabra) {
            this.arrLongitudSegmento.add(nLongitudSegmento);
            int nInicioCorte = 0;
            int nFinCorte = 0;
            String segmentoAux = "";
            nInicioCorte = 0;
            nFinCorte = 0;
            for (int n = 0; n < this.arrLongitudSegmento.size(); ++n) {
                nFinCorte = nInicioCorte + (Integer)this.arrLongitudSegmento.get(n);
                segmentoAux = cadena.substring(nInicioCorte, nFinCorte);
                this.arrLineas.add(segmentoAux);
                nInicioCorte = nFinCorte + 1;
            }
        } else {
            this.arrLineas.clear();
            for (int p = 0; p < this.arrPalabras.size(); ++p) {
                this.arrLineas.add(this.arrPalabras.get(p));
            }
        }
        if (this.arrLineas.size() > 1) {
            int posXLinea = posX;
            int posYLinea = posY - fmCadena.getAscent() * this.arrLineas.size() / 2 + fmCadena.getAscent() / this.arrLineas.size();
            int nAnchoLineaEnPantalla = 0;
            String strLineaAEscribir = "";
            for (int nLinea = 0; nLinea < this.arrLineas.size(); ++nLinea) {
                strLineaAEscribir = (String)this.arrLineas.get(nLinea);
                strLineaAEscribir = strLineaAEscribir.trim();
                nAnchoLineaEnPantalla = (int)fmCadena.getStringBounds(strLineaAEscribir, contexto).getWidth();
                posXLinea = (int)this.getBounds().getCenter2D().getX() - nAnchoLineaEnPantalla / 2;
                contexto.drawString(strLineaAEscribir, posXLinea, posYLinea);
                posYLinea += fmCadena.getAscent();
            }
        } else {
            contexto.drawString(cadena, posX, posY);
        }
    }

    private void drawSeccionMetafases(PBounds limitesFase, Graphics2D contextoGrafico) {
        String strMetafase = "Sin descripci\u00f3n";
        if (this.faseGraficaAsociada != null && this.faseGraficaAsociada.getTrFase() != null && this.faseGraficaAsociada.getTrFase().getMETAFASE() != null) {
            strMetafase = this.faseGraficaAsociada.getTrFase().getMETAFASE().getNOMBRE();
        }
        contextoGrafico.setFont(ModelaConf.getFuenteMetafase());
        this.punto1LineaMetafase = new Point2D.Double(limitesFase.getOrigin().getX(), limitesFase.getOrigin().getY() + 0.2 * limitesFase.getSize().getHeight());
        this.punto2LineaMetafase = new Point2D.Double(limitesFase.getOrigin().getX() + limitesFase.getSize().getWidth(), limitesFase.getOrigin().getY() + 0.2 * limitesFase.getSize().getHeight());
        if (this.bMostrarMetafase) {
            PBounds pbMeta = new PBounds(limitesFase.getOrigin().getX(), limitesFase.getOrigin().getY(), limitesFase.getSize().getWidth(), 0.2 * limitesFase.getSize().getHeight());
            FontMetrics fmMeta = contextoGrafico.getFontMetrics();
            int nFontHeightMeta = fmMeta.getAscent();
            Rectangle2D rectTextoMeta = fmMeta.getStringBounds(strMetafase, contextoGrafico);
            int posXTextMeta = (int)pbMeta.getCenter2D().getX() - (int)rectTextoMeta.getBounds().getWidth() / 2;
            int posYTextMeta = (int)pbMeta.getCenter2D().getY() + nFontHeightMeta / 2;
            if (this.colorTexto == null) {
                if (this.getTrFaseGrAsociada() != null && this.getTrFaseGrAsociada().getTrFase() != null && this.getTrFaseGrAsociada().getTrFase().getMETAFASE() != null) {
                    contextoGrafico.setPaint(this.getTrFaseGrAsociada().getTrFase().getMETAFASE().getPropiedadesGraficas().getColorTexto());
                }
            } else {
                contextoGrafico.setPaint(this.colorTexto);
            }
            contextoGrafico.setPaintMode();
            contextoGrafico.drawLine((int)this.punto1LineaMetafase.x, (int)this.punto1LineaMetafase.y, (int)this.punto2LineaMetafase.x, (int)this.punto2LineaMetafase.y);
            contextoGrafico.setClip((int)pbMeta.getX(), (int)pbMeta.getY(), (int)pbMeta.getWidth(), (int)pbMeta.getHeight());
            if (this.colorTexto == null) {
                if (this.getTrFaseGrAsociada() != null && this.getTrFaseGrAsociada().getTrFase() != null && this.getTrFaseGrAsociada().getTrFase().getMETAFASE() != null) {
                    contextoGrafico.setPaint(this.getTrFaseGrAsociada().getTrFase().getMETAFASE().getPropiedadesGraficas().getColorTexto());
                }
            } else {
                contextoGrafico.setPaint(this.colorTexto);
            }
            contextoGrafico.setPaintMode();
            contextoGrafico.drawString(strMetafase, posXTextMeta, posYTextMeta);
            contextoGrafico.setClip(null);
        }
    }

    private void drawSeccionFase(PBounds limitesFase, Graphics2D contextoGrafico) {
        String strFase = "Sin descripci\u00f3n";
        if (this.faseGraficaAsociada != null && this.faseGraficaAsociada.getTrFase() != null) {
            strFase = this.faseGraficaAsociada.getTrFase().getNOMBRE();
        }
        contextoGrafico.setFont(ModelaConf.getFuenteGrFase());
        FontMetrics fm = contextoGrafico.getFontMetrics();
        this.nFontHeight = fm.getAscent();
        Rectangle2D rectTexto = fm.getStringBounds(strFase, contextoGrafico);
        int posXText = (int)limitesFase.getCenter2D().getX() - (int)rectTexto.getBounds().getWidth() / 2;
        int posYText = (int)limitesFase.getCenter2D().getY() + this.nFontHeight / 2;
        contextoGrafico.setClip((int)this.getBounds().getX(), (int)this.getBounds().getY(), (int)this.getBounds().getWidth(), (int)this.getBounds().getHeight());
        if (this.colorTexto == null) {
            if (this.getTrFaseGrAsociada() != null && this.getTrFaseGrAsociada().getTrFase() != null && this.getTrFaseGrAsociada().getTrFase().getMETAFASE() != null) {
                contextoGrafico.setPaint(this.getTrFaseGrAsociada().getTrFase().getMETAFASE().getPropiedadesGraficas().getColorTexto());
            }
        } else {
            contextoGrafico.setPaint(this.colorTexto);
        }
        contextoGrafico.setPaintMode();
        this.drawCadena(contextoGrafico, strFase, posXText, posYText);
        contextoGrafico.setClip(null);
    }

    private void drawSeccionNumGraficos(PBounds limitesFase, Graphics2D contextoGrafico) {
        int numGraf = 0;
        ArrayList graficosAsociadosAlaFase = null;
        if (this.getTrFaseGrAsociada() != null) {
            graficosAsociadosAlaFase = this.canvas.localizarGraficosFaseEnCanvasActual(this.getTrFaseGrAsociada().getTrFase(), "FA");
        }
        if (graficosAsociadosAlaFase != null) {
            numGraf = graficosAsociadosAlaFase.size();
        }
        this.punto1LineaVNumGraficos = new Point2D.Double(limitesFase.getOrigin().getX() + 0.1 * limitesFase.getSize().getWidth(), limitesFase.getOrigin().getY() + 0.2 * limitesFase.getSize().getHeight());
        this.punto2LineaVNumGraficos = new Point2D.Double(limitesFase.getOrigin().getX() + 0.1 * limitesFase.getSize().getWidth(), limitesFase.getOrigin().getY() + 0.33 * limitesFase.getSize().getHeight());
        this.punto1LineaHNumGraficos = new Point2D.Double(limitesFase.getOrigin().getX(), limitesFase.getOrigin().getY() + 0.33 * limitesFase.getSize().getHeight());
        this.punto2LineaHNumGraficos = this.punto2LineaVNumGraficos;
        if (ModelaConf.getmostrarNumeroGraficosAsociados() && numGraf > 1) {
            contextoGrafico.setFont(new Font("Monospaced", 1, this.sizeFuenteTextoNumGraficos));
            String cad = "" + numGraf;
            contextoGrafico.drawLine((int)this.punto1LineaVNumGraficos.x, (int)this.punto1LineaVNumGraficos.y, (int)this.punto2LineaVNumGraficos.x, (int)this.punto2LineaVNumGraficos.y);
            contextoGrafico.drawLine((int)this.punto1LineaHNumGraficos.x, (int)this.punto1LineaHNumGraficos.y, (int)this.punto2LineaHNumGraficos.x, (int)this.punto2LineaHNumGraficos.y);
            PBounds pbNum = new PBounds(limitesFase.getOrigin().getX(), this.punto1LineaVNumGraficos.y, this.punto1LineaVNumGraficos.x - limitesFase.getOrigin().getX(), this.punto2LineaVNumGraficos.y - this.punto1LineaVNumGraficos.y);
            FontMetrics fmNum = contextoGrafico.getFontMetrics();
            int nFontHeightNum = fmNum.getAscent() / 2;
            Rectangle2D rectTextoNum = fmNum.getStringBounds(cad, contextoGrafico);
            int posXTextNum = (int)pbNum.getCenter2D().getX() - (int)rectTextoNum.getBounds().getWidth() / 2;
            int posYTextNum = (int)pbNum.getCenter2D().getY() + nFontHeightNum / 2;
            contextoGrafico.setClip((int)pbNum.getX(), (int)pbNum.getY(), (int)pbNum.getWidth(), (int)pbNum.getHeight());
            contextoGrafico.drawString(cad, posXTextNum, posYTextNum);
            contextoGrafico.setClip(null);
        }
    }

    private void drawSeccionReutilizable(PBounds limitesFase, Graphics2D contextoGrafico) {
        this.recReutiTmp = null;
        contextoGrafico.setFont(new Font("Monospaced", 0, this.sizeFuenteTextoReutilizable));
        this.punto1LineaReutilizable = new Point2D.Double(limitesFase.getOrigin().getX(), limitesFase.getOrigin().getY() + 0.8 * limitesFase.getSize().getHeight());
        this.punto2LineaReutilizable = new Point2D.Double(limitesFase.getOrigin().getX() + limitesFase.getSize().getWidth(), limitesFase.getOrigin().getY() + 0.8 * limitesFase.getSize().getHeight());
        this.punto1SeparadorVReutilizable = new Point2D.Double(limitesFase.getOrigin().getX() + 0.2 * limitesFase.getSize().getWidth(), this.punto1LineaReutilizable.y);
        this.punto2SeparadorVReutilizable = new Point2D.Double(limitesFase.getOrigin().getX() + 0.2 * limitesFase.getSize().getWidth(), limitesFase.getOrigin().getY() + limitesFase.getSize().getHeight());
        if (this.bMostrarTipoEvolucion && this.getTrFaseGrAsociada() != null && this.getTrFaseGrAsociada().getTrFase() != null && this.getTrFaseGrAsociada().getTrFase().getTIPOEVOL() != null) {
            this.recReutiTmp = new Rectangle((int)this.getFullBounds().getX(), (int)((double)((int)this.getFullBounds().getY()) + (double)((int)this.getFullBounds().getHeight()) * 0.8), (int)(this.getFullBounds().getWidth() * 0.2), (int)((double)((int)this.getFullBounds().getHeight()) - (double)((int)this.getFullBounds().getHeight()) * 0.8));
            String strRe = "R";
            String strEvo = this.getTrFaseGrAsociada().getTrFase().getTIPOEVOL().getNombre();
            contextoGrafico.drawLine((int)this.punto1SeparadorVReutilizable.x, (int)this.punto1SeparadorVReutilizable.y, (int)this.punto2SeparadorVReutilizable.x, (int)this.punto2SeparadorVReutilizable.y);
            contextoGrafico.drawLine((int)this.punto1LineaReutilizable.x, (int)this.punto1LineaReutilizable.y, (int)this.punto2LineaReutilizable.x, (int)this.punto2LineaReutilizable.y);
            PBounds pbRe = new PBounds(limitesFase.getOrigin().getX(), this.punto1LineaReutilizable.y, this.punto1SeparadorVReutilizable.x - limitesFase.getOrigin().getX(), this.punto2SeparadorVReutilizable.y - this.punto1LineaReutilizable.y);
            FontMetrics fmRe = contextoGrafico.getFontMetrics();
            int nFontHeightRe = fmRe.getAscent() / 2;
            Rectangle2D rectTextoRe = fmRe.getStringBounds(strRe, contextoGrafico);
            int posXTextRe = (int)pbRe.getCenter2D().getX() - (int)rectTextoRe.getBounds().getWidth() / 2;
            int posYTextRe = (int)pbRe.getCenter2D().getY() + nFontHeightRe / 2;
            contextoGrafico.setClip((int)pbRe.getX(), (int)pbRe.getY(), (int)pbRe.getWidth(), (int)pbRe.getHeight());
            Color colorAntAux = contextoGrafico.getColor();
            if (this.bCursorSobreReutilizable && this.canvas.getAccionActual() == AccionPCanvas.ACCION_SEL) {
                contextoGrafico.setColor(Color.red);
                contextoGrafico.setFont(new Font("Monospaced", 1, this.sizeFuenteTextoReutilizable));
            }
            contextoGrafico.drawString(strRe, posXTextRe, posYTextRe);
            contextoGrafico.setColor(colorAntAux);
            contextoGrafico.setFont(new Font("Monospaced", 0, this.sizeFuenteTextoReutilizable));
            contextoGrafico.setClip(null);
            PBounds pbEvo = new PBounds(this.punto1SeparadorVReutilizable.getX(), this.punto1SeparadorVReutilizable.getY(), limitesFase.getSize().getWidth() - pbRe.getSize().getWidth(), pbRe.getSize().getHeight());
            FontMetrics fmEvo = contextoGrafico.getFontMetrics();
            int nFontHeightEvo = fmEvo.getAscent() / 2;
            Rectangle2D rectTextoEvo = fmEvo.getStringBounds(strEvo, contextoGrafico);
            int posXTextEvo = (int)pbEvo.getCenter2D().getX() - (int)rectTextoEvo.getBounds().getWidth() / 2;
            int posYTextEvo = (int)pbEvo.getCenter2D().getY() + nFontHeightEvo / 2;
            contextoGrafico.setClip((int)pbEvo.getX(), (int)pbEvo.getY(), (int)pbEvo.getWidth(), (int)pbEvo.getHeight());
            contextoGrafico.drawString(strEvo, posXTextEvo, posYTextEvo);
            contextoGrafico.setClip(null);
        }
    }

    public void onRightClick(PInputEvent e) {
        if (e.getButton() == 3 && !(e.getPickedNode() instanceof ImagenPNode)) {
            if (this.canvas.getAccionActual() == AccionPCanvas.ACCION_SEL && this.crearPopupMenu() && !this.popup.isVisible()) {
                Point2D p = e.getCanvasPosition();
                this.popup.show((JComponent)e.getComponent(), (int)p.getX(), (int)p.getY());
            }
        } else if (e.getButton() == 1 && e.getClickCount() > 1 && !(e.getPickedNode() instanceof ImagenPNode)) {
            boolean bClicSobreRecReutilizable = false;
            if (this.recReutiTmp != null) {
                bClicSobreRecReutilizable = this.recReutiTmp.inside((int)e.getPosition().getX(), (int)e.getPosition().getY());
            }
            if (this.canvas.getAccionActual() == AccionPCanvas.ACCION_SEL) {
                if (!bClicSobreRecReutilizable) {
                    this.editarNombreFase();
                } else {
                    this.mostrarReutilizableAsociado(this);
                }
            }
        }
    }

    public boolean crearPopupMenu() {
        super.crearPopupMenu();
        this.menuAddTarea = new JMenuItem("Tareas");
        this.menuProp = new JMenuItem("Propiedades");
        this.menuPropGr = new JMenuItem("Propiedades del gr\u00e1fico");
        this.menuEliminarGr = new JMenuItem("Eliminar");
        this.menuSetMetafase = new JMenuItem("Asignar metafase");
        this.menuProp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FasePNode.this.fasePropiedades_ActionPerformed(ae);
            }
        });
        this.menuPropGr.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FasePNode.this.fasePropiedadesGr_ActionPerformed(ae);
            }
        });
        this.menuEliminarGr.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FasePNode.this.canvas.eliminarFasesSeleccionadas();
            }
        });
        this.menuSetMetafase.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FasePNode.this.canvas.asignarMetafase();
            }
        });
        this.menuAddTarea.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FasePNode.this.mostrarTarea_ActionPerformed(ae);
            }
        });
        this.popup.add((Component)this.menuSetMetafase, 0);
        this.popup.add((Component)this.menuAddTarea, 1);
        this.popup.add((Component)new JSeparator(), 2);
        this.popup.add((Component)this.menuEliminarGr, 3);
        this.popup.add((Component)new JSeparator(), 4);
        this.popup.add((Component)this.menuProp, 5);
        this.popup.add((Component)this.menuPropGr, 6);
        this.popup.add((Component)new JSeparator(), 7);
        return true;
    }

    public void eliminarPopupMenu() {
        super.eliminarPopupMenu();
        ActionListener[] actionListener = null;
        int nActions = 0;
        int i = 0;
        this.popup = null;
        if (this.menuProp != null) {
            actionListener = this.menuProp.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuProp.removeActionListener(actionListener[i]);
            }
            this.menuProp = null;
        }
        if (this.menuPropGr != null) {
            actionListener = this.menuPropGr.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuPropGr.removeActionListener(actionListener[i]);
            }
            this.menuPropGr = null;
        }
        if (this.menuEliminarGr != null) {
            actionListener = this.menuEliminarGr.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuEliminarGr.removeActionListener(actionListener[i]);
            }
            this.menuEliminarGr = null;
        }
        if (this.menuSetMetafase != null) {
            actionListener = this.menuSetMetafase.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuSetMetafase.removeActionListener(actionListener[i]);
            }
            this.menuSetMetafase = null;
        }
        if (this.menuAddTarea != null) {
            actionListener = this.menuAddTarea.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuAddTarea.removeActionListener(actionListener[i]);
            }
            this.menuAddTarea = null;
        }
    }

    void fasePropiedades_ActionPerformed(ActionEvent e) {
        this.eliminarPopupMenu();
        if (this.faseGraficaAsociada == null) {
            return;
        }
        if (this.faseGraficaAsociada.getTrFase() == null) {
            return;
        }
        this.canvas.propiedadesGraficosSelec(1);
        this.bPosicionarIconos = true;
    }

    void fasePropiedadesGr_ActionPerformed(ActionEvent e) {
        this.eliminarPopupMenu();
        if (this.faseGraficaAsociada == null) {
            return;
        }
        if (this.faseGraficaAsociada.getTrFase() == null) {
            return;
        }
        PropGraficoFase dlgProp = new PropGraficoFase();
        dlgProp.setColor(this.colorFondo);
        dlgProp.setColorTexto(this.colorTexto);
        dlgProp.setMostrarMetafase(this.bMostrarMetafase);
        dlgProp.actualizarCampos();
        dlgProp.setVisible(true);
        if (dlgProp.getAcepta()) {
            this.colorFondo = dlgProp.getColor();
            this.colorTexto = dlgProp.getColorTexto();
            if (this.getTrFaseGrAsociada() != null) {
                this.getTrFaseGrAsociada().setColorFondo(this.colorFondo);
            }
            if (this.getTrFaseGrAsociada() != null) {
                this.getTrFaseGrAsociada().setColorTexto(this.colorTexto);
            }
            this.bMostrarMetafase = dlgProp.getMostrarMetafase();
            this.bMostrarTipoEvolucion = dlgProp.getMostrarDDP();
            this.repaint();
        }
        this.bPosicionarIconos = true;
    }

    void mostrarTarea_ActionPerformed(ActionEvent e) {
        if (this.canvas != null && this.getTrFaseGrAsociada() != null && this.getTrFaseGrAsociada().getTrFase() != null) {
            this.canvas.mostrarTareaFaseDefProc(this.getTrFaseGrAsociada().getTrFase());
            this.bPosicionarIconos = true;
        }
    }

    public void inicializarBounds() {
        int nTexto = this.sTexto.length();
        if (this.faseGraficaAsociada != null && this.faseGraficaAsociada.getTrFase() != null && this.faseGraficaAsociada.getTrFase().getMETAFASE() != null && this.faseGraficaAsociada.getTrFase().getMETAFASE().getNombre() != null && this.faseGraficaAsociada.getTrFase().getMETAFASE().getNombre().length() > nTexto) {
            nTexto = this.faseGraficaAsociada.getTrFase().getMETAFASE().getNombre().length();
        }
        double dX = 120.0;
        double dY = 120.0;
        double dWidth = 15.0 + 9.0 * (double)nTexto;
        double dHeight = 75.0;
        if (dWidth > 250.0) {
            dWidth = 250.0;
        }
        this.setBounds(dX, dY, dWidth, dHeight);
    }

    public void inicializarBounds(double dX, double dY, double dWidth, double dHeight) {
        if (dWidth == 0.0 && dHeight == 0.0 && dX == 0.0 && dY == 0.0) {
            this.inicializarBounds();
            return;
        }
        this.setBounds(dX, dY, dWidth, dHeight);
    }
}

