/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.piccolo.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.event.PSelectionEventHandler;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import modela.bd.obj.ConjuntoDatosTareaFaseDefProcedimiento;
import modela.bd.obj.TrTareaEnFaseDefProcedimiento;
import modela.bd.obj.TrTipoTarea;
import modela.bd.obj.TrTransicionDefProcedimiento;
import modela.conf.ModelaConf;
import modela.ui.ModelaUI;
import modela.ui.piccolo.PCanvasModela;
import modela.ui.piccolo.nodes.FasePNode;
import modela.ui.piccolo.nodes.PToolTipText;
import modela.ui.piccolo.nodes.TransicionPNode;

public class ImagenPNode
extends PImage {
    private static final long serialVersionUID = -3876477229634990708L;
    private ImageIcon imagenAsociada;
    public static final int ICONO_TIPO_ACCION = 1;
    public static final int ICONO_TIPO_CONDICION = 2;
    public static final int ICONO_TIPO_AVISO = 3;
    public static final int ICONO_TIPO_AVISO_PERFILES = 10;
    public static final int ICONO_TIPO_PERFILES = 11;
    public static final int ICONO_TIPO_TAREA_GENERAR = 4;
    public static final int ICONO_TIPO_TAREA_INCORPORAR = 5;
    public static final int ICONO_TIPO_TAREA_MANIPULAR = 6;
    public static final int ICONO_TIPO_TAREA_OTROS = 7;
    public static final int ICONO_TIPO_TAREA_GENERAR_MULTIPLE = 8;
    public static final int ICONO_TIPO_TAREA_INCORPORAR_MULTIPLE = 9;
    private final JPopupMenu popup = new JPopupMenu();
    private final JMenuItem menuPropiedades = new JMenuItem("Definir men\u00fa");
    private int m_nTipo = 0;
    private FasePNode m_FasePNode;
    private TransicionPNode m_TransicionPNode;
    private PCanvasModela canvas;
    public PToolTipText toolTipGrafico;
    private boolean bMantenerToolTip = false;
    PBounds boundAnterior = null;

    public ImagenPNode(int nTipoIcono) {
        try {
            this.inicializarPImage(nTipoIcono);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addInputEventListener((PInputEventListener)new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent myEvent) {
                ImagenPNode.this.onRightClick(myEvent);
            }

            public void mouseEntered(PInputEvent myEvent) {
                String textoTip;
                if (!ModelaConf.getMostrarToolTipConClic() && (textoTip = ImagenPNode.this.obtenerToolTipExtendido()) != null) {
                    ImagenPNode.this.mostrarToolTipExtendido(textoTip);
                }
            }

            public void mouseExited(PInputEvent myEvent) {
                ImagenPNode.this.ocultarToolTipExtendido();
            }
        });
        this.popup.add(this.menuPropiedades);
    }

    private void inicializarPImage(int nTipoIcono) {
        this.m_FasePNode = null;
        this.m_TransicionPNode = null;
        this.canvas = null;
        this.toolTipGrafico = null;
        this.bMantenerToolTip = false;
        if (nTipoIcono == 1) {
            this.m_nTipo = 1;
            this.imagenAsociada = new ImageIcon(((Object)((Object)this)).getClass().getResource(ModelaUI.IMG_ACCION_TRANSICION));
        } else if (nTipoIcono == 2) {
            this.m_nTipo = 2;
            this.imagenAsociada = new ImageIcon(((Object)((Object)this)).getClass().getResource(ModelaUI.IMG_CONDICION_TRANSICION));
        } else if (nTipoIcono == 3) {
            this.m_nTipo = 3;
            this.imagenAsociada = new ImageIcon(((Object)((Object)this)).getClass().getResource(ModelaUI.IMG_AVISO_TRANSICION));
        } else if (nTipoIcono == 10) {
            this.m_nTipo = 10;
            this.imagenAsociada = new ImageIcon(((Object)((Object)this)).getClass().getResource(ModelaUI.IMG_AVISO_PERFILES_TRANSICION));
        } else if (nTipoIcono == 11) {
            this.m_nTipo = 11;
            this.imagenAsociada = new ImageIcon(((Object)((Object)this)).getClass().getResource(ModelaUI.IMG_PERFILES_TRANSICION));
        } else if (nTipoIcono == 4) {
            this.m_nTipo = 4;
            this.imagenAsociada = new ImageIcon(((Object)((Object)this)).getClass().getResource(ModelaUI.IMG_TAREA_GENERAR));
        } else if (nTipoIcono == 8) {
            this.m_nTipo = 8;
            this.imagenAsociada = new ImageIcon(((Object)((Object)this)).getClass().getResource(ModelaUI.IMG_TAREA_GENERAR_MULTIPLE));
        } else if (nTipoIcono == 5) {
            this.m_nTipo = 5;
            this.imagenAsociada = new ImageIcon(((Object)((Object)this)).getClass().getResource(ModelaUI.IMG_TAREA_INCORPORAR));
        } else if (nTipoIcono == 9) {
            this.m_nTipo = 9;
            this.imagenAsociada = new ImageIcon(((Object)((Object)this)).getClass().getResource(ModelaUI.IMG_TAREA_INCORPORAR_MULTIPLE));
        } else if (nTipoIcono == 6) {
            this.m_nTipo = 6;
            this.imagenAsociada = new ImageIcon(((Object)((Object)this)).getClass().getResource(ModelaUI.IMG_TAREA_MANIPULAR));
        } else if (nTipoIcono == 7) {
            this.m_nTipo = 7;
            this.imagenAsociada = new ImageIcon(((Object)((Object)this)).getClass().getResource(ModelaUI.IMG_TAREA_OTROS));
        }
        this.setImage(this.imagenAsociada.getImage());
    }

    protected void setXeY(double dCoorX, double dCoorY) {
        this.offset(dCoorX, dCoorY);
    }

    public void onRightClick(PInputEvent e) {
        if (e.getButton() == 1) {
            if (e.getClickCount() > 1) {
                if (this.m_nTipo == 4 || this.m_nTipo == 8 || this.m_nTipo == 5 || this.m_nTipo == 9 || this.m_nTipo == 6 || this.m_nTipo == 7) {
                    if (this.m_FasePNode != null && this.m_FasePNode.getCanvas() != null) {
                        if (this.m_FasePNode.getCanvas().getSelectionEventHandler() == null || !(this.m_FasePNode.getCanvas().getSelectionEventHandler() instanceof PSelectionEventHandler)) {
                            return;
                        }
                        if (this.m_FasePNode.getTrFaseGrAsociada() != null && this.m_FasePNode.getTrFaseGrAsociada().getTrFase() != null) {
                            this.m_FasePNode.getCanvas().mostrarTareaFaseDefProc(this.m_FasePNode.getTrFaseGrAsociada().getTrFase());
                            this.m_FasePNode.bPosicionarIconos = true;
                            this.m_FasePNode.getCanvas().actualizarIconosFs();
                        }
                    }
                } else if (this.m_nTipo == 1 || this.m_nTipo == 3 || this.m_nTipo == 2) {
                    if (this.m_TransicionPNode != null) {
                        if (this.m_nTipo == 1) {
                            this.m_TransicionPNode.accion_ActionPerformed(null);
                        } else if (this.m_nTipo == 3) {
                            this.m_TransicionPNode.aviso_ActionPerformed(null);
                        } else if (this.m_nTipo == 2) {
                            this.m_TransicionPNode.condicion_ActionPerformed(null);
                        }
                    }
                } else if ((this.m_nTipo == 10 || this.m_nTipo == 11) && this.m_TransicionPNode != null) {
                    this.m_TransicionPNode.permiso_ActionPerformed(null);
                }
                if (this.toolTipGrafico != null && this.toolTipGrafico.getVisible()) {
                    String textoTip = this.obtenerToolTipExtendido();
                    if (textoTip != null) {
                        this.actualizarToolTipExtendido(textoTip);
                    } else {
                        this.bMantenerToolTip = false;
                        this.ocultarToolTipExtendido();
                    }
                }
            }
        } else if (e.isRightMouseButton()) {
            boolean bl = this.bMantenerToolTip = !this.bMantenerToolTip;
            if (!this.bMantenerToolTip) {
                this.ocultarToolTipExtendido();
            } else {
                String textoTip = this.obtenerToolTipExtendido();
                if (textoTip != null) {
                    this.mostrarToolTipExtendido(textoTip);
                }
            }
        }
    }

    public void setFasePNode(FasePNode fasePNode) {
        this.m_FasePNode = fasePNode;
        this.canvas = this.m_FasePNode != null ? this.m_FasePNode.getCanvas() : null;
    }

    public void setTransicionPNode(TransicionPNode transiPNode) {
        this.m_TransicionPNode = transiPNode;
        this.canvas = this.m_TransicionPNode != null ? this.m_TransicionPNode.getCanvas() : null;
    }

    public int getTipoImagen() {
        return this.m_nTipo;
    }

    public String obtenerToolTipExtendido() {
        String textoMostradoComoToolTip = "";
        boolean bDatosEncontrados = false;
        if ((this.m_nTipo == 4 || this.m_nTipo == 8 || this.m_nTipo == 5 || this.m_nTipo == 9 || this.m_nTipo == 6 || this.m_nTipo == 7) && this.m_FasePNode != null && this.m_FasePNode.getCanvas() != null && this.m_FasePNode.getCanvas().getDiagrama() != null && this.m_FasePNode.getTrFaseGrAsociada() != null && this.m_FasePNode.getTrFaseGrAsociada().getTrFase() != null) {
            int t;
            ConjuntoDatosTareaFaseDefProcedimiento tareasAsociadas = this.m_FasePNode.getCanvas().getDiagrama().getTareasEnFaseDefProc(this.m_FasePNode.getTrFaseGrAsociada().getTrFase());
            TrTareaEnFaseDefProcedimiento tareaAux = null;
            textoMostradoComoToolTip = "[ " + this.m_FasePNode.getTrFaseGrAsociada().getTrFase().getNombre() + " ]\n";
            if (this.m_nTipo == 4 || this.m_nTipo == 8) {
                textoMostradoComoToolTip = textoMostradoComoToolTip + "Documentos a Generar: \n";
                for (t = 0; t < tareasAsociadas.getListaDatos().size(); ++t) {
                    tareaAux = (TrTareaEnFaseDefProcedimiento)tareasAsociadas.getListaDatos().get(t);
                    if (tareaAux.getTareaEnFase() == null || !(tareaAux.getTareaEnFase().getTarea() != null & tareaAux.getTareaEnFase().getTarea().getTrTipoTarea().equals(TrTipoTarea.GENERAR_DOCUMENTO))) continue;
                    textoMostradoComoToolTip = textoMostradoComoToolTip + " - " + tareasAsociadas.getListaDatos().get(t) + "\n";
                    bDatosEncontrados = true;
                }
            } else if (this.m_nTipo == 5 || this.m_nTipo == 9) {
                textoMostradoComoToolTip = textoMostradoComoToolTip + "Documentos a Incorporar: \n";
                for (t = 0; t < tareasAsociadas.getListaDatos().size(); ++t) {
                    tareaAux = (TrTareaEnFaseDefProcedimiento)tareasAsociadas.getListaDatos().get(t);
                    if (tareaAux.getTareaEnFase() == null || !(tareaAux.getTareaEnFase().getTarea() != null & tareaAux.getTareaEnFase().getTarea().getTrTipoTarea().equals(TrTipoTarea.INCORPORAR_DOCUMENTO))) continue;
                    textoMostradoComoToolTip = textoMostradoComoToolTip + " - " + tareasAsociadas.getListaDatos().get(t) + "\n";
                    bDatosEncontrados = true;
                }
            } else if (this.m_nTipo == 6) {
                textoMostradoComoToolTip = textoMostradoComoToolTip + "Manipulaci\u00f3n de Datos: \n";
                for (t = 0; t < tareasAsociadas.getListaDatos().size(); ++t) {
                    tareaAux = (TrTareaEnFaseDefProcedimiento)tareasAsociadas.getListaDatos().get(t);
                    if (tareaAux.getTareaEnFase() == null || !(tareaAux.getTareaEnFase().getTarea() != null & tareaAux.getTareaEnFase().getTarea().getTrTipoTarea().equals(TrTipoTarea.MANIPULAR_DATOS))) continue;
                    textoMostradoComoToolTip = textoMostradoComoToolTip + " - " + tareasAsociadas.getListaDatos().get(t) + "\n";
                    bDatosEncontrados = true;
                }
            } else if (this.m_nTipo == 7) {
                textoMostradoComoToolTip = textoMostradoComoToolTip + "Otras tareas: \n";
                for (t = 0; t < tareasAsociadas.getListaDatos().size(); ++t) {
                    tareaAux = (TrTareaEnFaseDefProcedimiento)tareasAsociadas.getListaDatos().get(t);
                    if (tareaAux.getTareaEnFase() == null || !(tareaAux.getTareaEnFase().getTarea() != null & tareaAux.getTareaEnFase().getTarea().getTrTipoTarea().equals(TrTipoTarea.OTROS))) continue;
                    textoMostradoComoToolTip = textoMostradoComoToolTip + " - " + tareasAsociadas.getListaDatos().get(t) + "\n";
                    bDatosEncontrados = true;
                }
            }
        }
        if ((this.m_nTipo == 11 || this.m_nTipo == 1 || this.m_nTipo == 2 || this.m_nTipo == 3) && this.m_TransicionPNode != null && this.m_TransicionPNode.getCanvas() != null && this.m_TransicionPNode.getCanvas().getDiagrama() != null && this.m_TransicionPNode.getTrTransicion() != null) {
            TrTransicionDefProcedimiento trDefProc = this.m_TransicionPNode.getCanvas().getDiagrama().getTransicionesDelProcInvolucradas().getTransicionDefProcedimiento(this.m_TransicionPNode.getTrTransicion().getID());
            textoMostradoComoToolTip = "[ " + this.m_TransicionPNode.getTrTransicion().getNombre() + " ]\n";
            if (this.m_nTipo == 11) {
                textoMostradoComoToolTip = textoMostradoComoToolTip + "Perfiles: \n";
                if (trDefProc != null) {
                    for (int t = 0; t < trDefProc.getConjuntoPerfilTransEvol().getListaDatos().size(); ++t) {
                        textoMostradoComoToolTip = textoMostradoComoToolTip + " - " + trDefProc.getConjuntoPerfilTransEvol().getListaDatos().get(t) + "\n";
                        bDatosEncontrados = true;
                    }
                }
            } else if (this.m_nTipo == 1) {
                textoMostradoComoToolTip = textoMostradoComoToolTip + "Acciones: \n";
                if (trDefProc != null) {
                    for (int t = 0; t < trDefProc.getConjuntoAccionTransicion().getListaDatos().size(); ++t) {
                        textoMostradoComoToolTip = textoMostradoComoToolTip + " - " + trDefProc.getConjuntoAccionTransicion().getListaDatos().get(t) + "\n";
                        bDatosEncontrados = true;
                    }
                }
            } else if (this.m_nTipo == 2) {
                textoMostradoComoToolTip = textoMostradoComoToolTip + "Condiciones: \n";
                if (trDefProc != null) {
                    for (int t = 0; t < trDefProc.getConjuntoCondicionTransicion().getListaDatos().size(); ++t) {
                        textoMostradoComoToolTip = textoMostradoComoToolTip + " - " + trDefProc.getConjuntoCondicionTransicion().getListaDatos().get(t) + "\n";
                        bDatosEncontrados = true;
                    }
                }
            } else if (this.m_nTipo == 3) {
                textoMostradoComoToolTip = textoMostradoComoToolTip + "Avisos: \n";
                if (trDefProc != null) {
                    for (int t = 0; t < trDefProc.getConjuntoAvisoTransicion().getListaDatos().size(); ++t) {
                        textoMostradoComoToolTip = textoMostradoComoToolTip + " - " + trDefProc.getConjuntoAvisoTransicion().getListaDatos().get(t) + "\n";
                        bDatosEncontrados = true;
                    }
                }
            }
        }
        if (bDatosEncontrados) {
            return textoMostradoComoToolTip;
        }
        return null;
    }

    public void mostrarToolTipExtendido(String textoAmostrar) {
        if (this.toolTipGrafico != null) {
            this.actualizarToolTipExtendido(textoAmostrar);
            return;
        }
        if (textoAmostrar == null || textoAmostrar.equals("")) {
            return;
        }
        if (this.canvas == null || this.canvas.getLayer() == null) {
            return;
        }
        if (this.toolTipGrafico != null && this.toolTipGrafico.getVisible()) {
            return;
        }
        this.toolTipGrafico = new PToolTipText(this.canvas, this);
        this.toolTipGrafico.setFont(ModelaConf.getFuenteToolTip());
        this.toolTipGrafico.setTextPaint(ModelaConf.getColorTextoToolTip());
        this.toolTipGrafico.setOffset(this.getGlobalBounds().getX() + this.getGlobalBounds().getWidth() * 2.0, this.getGlobalBounds().getY());
        this.toolTipGrafico.setText(textoAmostrar);
        this.canvas.getLayer().addChild((PNode)this.toolTipGrafico);
        this.toolTipGrafico.setVisible(true);
        this.canvas.repaint();
    }

    public void actualizarToolTipExtendido(String nuevoTexto) {
        if (this.canvas == null || this.canvas.getLayer() == null) {
            return;
        }
        if (this.toolTipGrafico == null) {
            return;
        }
        this.toolTipGrafico.setText(nuevoTexto);
        this.toolTipGrafico.setPickable(true);
        this.toolTipGrafico.setVisible(true);
        this.canvas.repaint();
    }

    public void ocultarToolTipExtendido() {
        if (this.canvas == null || this.canvas.getLayer() == null) {
            return;
        }
        if (this.bMantenerToolTip) {
            return;
        }
        if (this.toolTipGrafico != null) {
            this.toolTipGrafico.setPickable(false);
            this.toolTipGrafico.setVisible(false);
            this.canvas.repaint();
        }
    }

    public void eliminarToolTipExtendido() {
        if (this.toolTipGrafico != null) {
            try {
                this.canvas.getLayer().removeChild((PNode)this.toolTipGrafico);
            }
            catch (Exception e) {
                System.out.println("\u00b7 [ Error ] No se ha encontrado el toolTipExtendido sobre el canvas");
            }
            this.toolTipGrafico.setVisible(false);
            this.canvas.repaint();
        }
        this.bMantenerToolTip = false;
        this.toolTipGrafico = null;
    }

    protected void paint(PPaintContext arg0) {
        super.paint(arg0);
        if (this.toolTipGrafico != null && this.cambiaBounds()) {
            this.toolTipGrafico.readaptarBounds();
        }
    }

    public boolean cambiaBounds() {
        if (this.boundAnterior == null) {
            this.boundAnterior = this.getGlobalFullBounds();
            return true;
        }
        PBounds boundsAux = this.getGlobalFullBounds();
        if (boundsAux.equals((Object)this.boundAnterior)) {
            return false;
        }
        this.boundAnterior = this.getGlobalFullBounds();
        return true;
    }
}

