/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.piccolo.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.event.PSelectionEventHandler;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import javax.swing.ImageIcon;
import modela.conf.ModelaConf;
import modela.ui.ModelaUI;
import modela.ui.piccolo.PCanvasModela;
import modela.ui.piccolo.nodes.ImagenPNode;

public class PToolTipText
extends PText {
    private static final long serialVersionUID = -8095724798544199582L;
    Image imagenToolTip = new ImageIcon(((Object)((Object)this)).getClass().getResource(ModelaUI.IMG_TOOL_TIP_PAGINA)).getImage();
    ImagenPNode pImagenAsociada = null;
    protected Stroke stroke = new BasicStroke(1.0f, 1, 1);
    boolean bCalcularDistancia = true;
    double xDistancia = 0.0;
    double yDistancia = 0.0;
    private final PCanvasModela canvas;

    public PToolTipText() {
        this.canvas = null;
        this.pImagenAsociada = null;
    }

    public PToolTipText(PCanvasModela pCanvas, ImagenPNode pImagen) {
        this.canvas = pCanvas;
        this.pImagenAsociada = pImagen;
    }

    protected void paint(PPaintContext paintContext) {
        if (ModelaConf.getMostrarToolTip()) {
            try {
                PBounds clipActual;
                this.setPickable(true);
                Graphics2D g2 = paintContext.getGraphics();
                g2.setStroke(this.stroke);
                g2.setClip(null);
                if (this.canvas != null && (clipActual = this.canvas.getClipActual()) != null && this.canvas.isImprimiendo()) {
                    g2.setClip((int)clipActual.getX() - 30, (int)clipActual.getY() - 30, (int)clipActual.getWidth() + 40, (int)clipActual.getHeight() + 40);
                }
                g2.setPaint(ModelaConf.getColorFondoToolTip());
                g2.fillRoundRect((int)this.getBounds().getX() - 10, (int)this.getBounds().getY() - 10, (int)this.getBounds().getWidth() + 20, (int)this.getBounds().getHeight() + 20, 10, 10);
                if (!this.getFont().equals(ModelaConf.getFuenteToolTip())) {
                    this.setFont(ModelaConf.getFuenteToolTip());
                }
                if (this.getTextPaint() != ModelaConf.getColorTextoToolTip()) {
                    this.setTextPaint(ModelaConf.getColorTextoToolTip());
                }
                super.paint(paintContext);
                g2.setClip(null);
                this.setBounds((Rectangle2D)this.getBounds());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (this.canvas.getSelectionEventHandler() != null && this.canvas.getSelectionEventHandler() instanceof PSelectionEventHandler) {
                ((PSelectionEventHandler)this.canvas.getSelectionEventHandler()).undecorateSelectedNode((PNode)this);
            }
            this.setPickable(false);
        }
    }

    public void readaptarBounds() {
        double margenIzquierdo = 0.0;
        double margenDerecho = 0.0;
        double margenSuperior = 0.0;
        double margenInferior = 0.0;
        double xParaPostIt = 0.0;
        double yParaPostIt = 0.0;
        margenIzquierdo = this.pImagenAsociada.getGlobalBounds().getX();
        margenDerecho = margenIzquierdo + this.pImagenAsociada.getGlobalBounds().getWidth();
        margenSuperior = this.pImagenAsociada.getGlobalBounds().getY();
        margenInferior = margenSuperior + this.pImagenAsociada.getGlobalBounds().getHeight();
        if (this.bCalcularDistancia) {
            this.xDistancia = (this.getBounds().getX() - 10.0 - margenIzquierdo) / (margenDerecho - margenIzquierdo) * 100.0;
            this.yDistancia = (this.getBounds().getY() - 10.0 - margenSuperior) / (margenInferior - margenSuperior) * 100.0;
            this.bCalcularDistancia = false;
        }
        xParaPostIt = margenIzquierdo + this.xDistancia * (margenDerecho - margenIzquierdo) / 100.0;
        yParaPostIt = margenSuperior + this.yDistancia * (margenInferior - margenSuperior) / 100.0;
        this.setX(xParaPostIt);
        this.setY(yParaPostIt);
        this.repaint();
    }

    public void eliminar() {
        if (this.pImagenAsociada != null) {
            this.pImagenAsociada.eliminarToolTipExtendido();
        }
    }
}

