/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.obj.TrAccionTransicion;
import modela.bd.obj.TrTransicionDefProcedimiento;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.Portapapeles;
import modela.ui.swing.PropAccionTransicionJPanel;
import modela.ui.swing.renderers.AtributosListRenderer;

public class MantenimientoAccionTransicionJDialog
extends MantenimientoJDialog {
    private static final long serialVersionUID = -5522570093605648793L;
    PropAccionTransicionJPanel pPanel;
    private final JLabel tituloLabel = new JLabel("Acciones asociadas");
    DDPGrafico grafico = null;
    private final int ANCHO_ACTUAL = 650;
    private final int ALTO_ACTUAL = 515;
    TrTransicionDefProcedimiento transicionDefProc = null;

    public MantenimientoAccionTransicionJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.setTitle("Mantenimiento de acciones en transici\u00f3n");
        this.pPanel = new PropAccionTransicionJPanel();
        this.pPanel.inicializarCampos(7);
        this.transicionDefProc = null;
        this.setPanelAtributable(this.pPanel);
        this.setSize(new Dimension(this.ANCHO_ACTUAL, this.ALTO_ACTUAL));
        this.tituloLabel.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.tituloLabel.setForeground(ModelaUI.colorSeleccion);
        this.botones.permitirEliminar(true);
        this.listaAsignable.setTipoAlmacenado(2);
        this.listaAsignable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    if (MantenimientoAccionTransicionJDialog.this.listaAsignable.crearPopupMenu() && !MantenimientoAccionTransicionJDialog.this.listaAsignable.popup.isVisible()) {
                        Portapapeles.setGrafico(MantenimientoAccionTransicionJDialog.this.grafico);
                        MantenimientoAccionTransicionJDialog.this.listaAsignable.popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                    return;
                }
                if (e.getSource() != null) {
                    if (e.getClickCount() == 2) {
                        MantenimientoAccionTransicionJDialog.this.dobleClick();
                        return;
                    }
                    Point p = e.getPoint();
                    int index = MantenimientoAccionTransicionJDialog.this.listaAsignable.locationToIndex(p);
                    if (index >= 0 && index <= MantenimientoAccionTransicionJDialog.this.listaAsignable.getNumItems()) {
                        IAsignable objAsig = MantenimientoAccionTransicionJDialog.this.listaAsignable.getElementAt(index);
                        MantenimientoAccionTransicionJDialog.this.establecerModoTrabajo(2);
                        MantenimientoAccionTransicionJDialog.this.pPanel.setValoresAsignables(objAsig);
                        if (!MantenimientoAccionTransicionJDialog.this.isDesdeSeleccionLimitada()) {
                            MantenimientoAccionTransicionJDialog.this.botones.modificarButton_mousePressed(e);
                        }
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (MantenimientoAccionTransicionJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoAccionTransicionJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoAccionTransicionJDialog.this.establecerModoTrabajo(7);
                    MantenimientoAccionTransicionJDialog.this.pPanel.limpiarCampos();
                    return;
                }
            }
        });
        this.listaAsignable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent kevt) {
                super.keyReleased(kevt);
                if (MantenimientoAccionTransicionJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoAccionTransicionJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoAccionTransicionJDialog.this.establecerModoTrabajo(7);
                    MantenimientoAccionTransicionJDialog.this.pPanel.limpiarCampos();
                } else {
                    IAsignable objAsig = (IAsignable)MantenimientoAccionTransicionJDialog.this.listaAsignable.getSelectedValue();
                    MantenimientoAccionTransicionJDialog.this.establecerModoTrabajo(2);
                    MantenimientoAccionTransicionJDialog.this.pPanel.setValoresAsignables(objAsig);
                    if (!MantenimientoAccionTransicionJDialog.this.isDesdeSeleccionLimitada()) {
                        MantenimientoAccionTransicionJDialog.this.botones.modificarButton_mousePressed(null);
                    }
                }
            }
        });
        this.listaAsignable.setCellRenderer(new AtributosListRenderer());
        this.getContentPane().add((Component)this.tituloLabel, new XYConstraints(20, 15, 170, 25));
        this.addControles(this.ANCHO_ACTUAL, this.ALTO_ACTUAL, 4);
        ModelaConf.setVentanaActiva(this);
    }

    public boolean eliminarElemento() {
        if (this.grafico == null) {
            return false;
        }
        if (this.grafico.getDestructorDDP() == null) {
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            return false;
        }
        String msgPanel = new String();
        this.establecerModoTrabajo(2);
        int nElementos = this.listaAsignable.getSelectedValues().length;
        Object[] options = new Object[]{"Aceptar", "Cancelar"};
        msgPanel = nElementos > 1 ? "\u00bfConfirma eliminar los elementos seleccionados?" : "\u00bfConfirma eliminar el elemento seleccionado?";
        int n = JOptionPane.showOptionDialog(this, msgPanel, "Eliminar", 0, 3, null, options, options[1]);
        if (n == -1) {
            n = 1;
        }
        if (n == 1) {
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.pPanel.restaurarColoresDeFondo();
            return false;
        }
        this.refrescarGrafico();
        int[] indicesEliminar = this.listaAsignable.getSelectedIndices();
        for (int ind = indicesEliminar.length - 1; ind >= 0; --ind) {
            this.listaAsignable.removeItem(indicesEliminar[ind]);
        }
        this.listaAsignable.setSelectedIndex(-1);
        this.establecerModoTrabajo(7);
        this.pPanel.limpiarCampos();
        if (this.transicionDefProc != null) {
            this.transicionDefProc.getConjuntoAccionTransicion().setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public boolean modificarElemento() {
        this.establecerModoTrabajo(3);
        return true;
    }

    public boolean insertarElemento() {
        this.establecerModoTrabajo(1);
        this.pPanel.inicializarFoco();
        return true;
    }

    public void setTransicionDefProc(TrTransicionDefProcedimiento transiAsociada) {
        this.transicionDefProc = transiAsociada;
    }

    public boolean aplicar() {
        boolean bRespuesta = false;
        if (this.getAccion() == 1) {
            bRespuesta = this.aplicarNuevo();
        } else if (this.getAccion() == 3) {
            bRespuesta = this.aplicarModificar();
        }
        if (!bRespuesta) {
            this.botones.setModoModificarPorDefault(false);
        }
        return bRespuesta;
    }

    public boolean aplicarNuevo() {
        double accionID = this.pPanel.getAccionSeleccionada();
        if (!this.comprobarExistenciaAccion(accionID, -1)) {
            TrAccionTransicion accion = null;
            if (!this.pPanel.obtenerValoresCampos()) {
                return false;
            }
            accion = (TrAccionTransicion)this.pPanel.getValoresAsignables();
            if (accion == null) {
                return false;
            }
            this.listaAsignable.addItem(accion);
            this.listaAsignable.setSelectedValue(accion, true);
            this.listaAsignable.updateUI();
            if (this.transicionDefProc != null) {
                this.transicionDefProc.getConjuntoAccionTransicion().setListaDatos(this.listaAsignable.toArrayList());
            }
        } else {
            JOptionPane.showMessageDialog(this, "Imposible asociar la acci\u00f3n:\nLa acci\u00f3n ya existe en la lista de acciones en transici\u00f3n.", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            return false;
        }
        return true;
    }

    public boolean aplicarModificar() {
        int nSelectedIndex;
        double accionID = this.pPanel.getAccionSeleccionada();
        if (!this.comprobarExistenciaAccion(accionID, nSelectedIndex = this.listaAsignable.getSelectedIndex())) {
            if (!this.pPanel.obtenerValoresCampos()) {
                return false;
            }
            this.listaAsignable.updateUI();
            if (this.transicionDefProc != null) {
                this.transicionDefProc.getConjuntoAccionTransicion().setListaDatos(this.listaAsignable.toArrayList());
            }
        } else {
            JOptionPane.showMessageDialog(this, "Imposible asociar la acci\u00f3n:\nLa acci\u00f3n ya existe en la lista de acciones en transici\u00f3n.", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            return false;
        }
        return true;
    }

    public boolean refrescarGrafico() {
        if (this.elementosAsignados != null) {
            this.elementosAsignados.setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public boolean cancelar() {
        if (this.listaAsignable == null) {
            this.pPanel.limpiarCampos();
            this.establecerModoTrabajo(7);
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            this.establecerModoTrabajo(7);
            this.pPanel.limpiarCampos();
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        int index = this.listaAsignable.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        this.listaAsignable.setSelectedIndex(index);
        IAsignable obj = this.listaAsignable.getElementAt(index);
        this.pPanel.setValoresAsignables(obj);
        this.establecerModoTrabajo(2);
        return true;
    }

    public void cerrar() {
        this.refrescarGrafico();
    }

    public void inicializarListaElementos(ConjuntoDatos cdElementos) {
        if (cdElementos != null) {
            cdElementos.ordenar();
        }
        super.inicializarListaElementos(cdElementos);
    }

    public void setAccionesInvolucradas(ConjuntoDatos cdAcciones) {
        if (this.pPanel != null) {
            this.pPanel.setAccionesInvolucradas(cdAcciones);
        }
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        this.grafico = nuevoGrafico;
        this.pPanel.setGrafico(this.grafico);
    }

    public boolean comprobarExistenciaAccion(double accionID, int nSelectedIndex) {
        if (accionID < 0.0) {
            return false;
        }
        if (this.listaAsignable.getNumItems() <= 0) {
            return false;
        }
        boolean bID = false;
        boolean bEncontrado = false;
        for (int i = 0; i < this.listaAsignable.getNumItems() && !bEncontrado; ++i) {
            bID = false;
            TrAccionTransicion accionAux = (TrAccionTransicion)this.listaAsignable.getElementAt(i);
            if (accionAux != null && i != nSelectedIndex && accionAux.getAccion() != null && accionID == accionAux.getAccion().getID()) {
                bID = true;
            }
            if (!bID) continue;
            bEncontrado = true;
        }
        return bEncontrado;
    }
}

