/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.ConjuntoDatosModela;
import modela.bd.obj.TrBloque;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.PropBloqueJPanel;

public class MantenimientoBloquesJDialog
extends MantenimientoJDialog {
    private static final long serialVersionUID = -1576293036383402735L;
    PropBloqueJPanel pPanel;
    private final JLabel tituloLabel = new JLabel("Lista de Bloques");
    private DDPGrafico grafico = null;
    private final int ANCHO_ACTUAL = 680;
    private final int ALTO_ACTUAL = 515;

    public MantenimientoBloquesJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.setTitle("Mantenimiento de bloques");
        this.pPanel = new PropBloqueJPanel();
        this.pPanel.inicializarCampos(7);
        this.setPanelAtributable(this.pPanel);
        this.setSize(new Dimension(this.ANCHO_ACTUAL, this.ALTO_ACTUAL));
        this.tituloLabel.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.tituloLabel.setForeground(ModelaUI.colorSeleccion);
        this.botones.permitirEliminar(true);
        this.listaAsignable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                if (e.getSource() != null) {
                    if (e.getClickCount() == 2) {
                        MantenimientoBloquesJDialog.this.dobleClick();
                        return;
                    }
                    Point p = e.getPoint();
                    int index = MantenimientoBloquesJDialog.this.listaAsignable.locationToIndex(p);
                    if (index >= 0 && index <= MantenimientoBloquesJDialog.this.listaAsignable.getNumItems()) {
                        IAsignable objAsig = MantenimientoBloquesJDialog.this.listaAsignable.getElementAt(index);
                        MantenimientoBloquesJDialog.this.establecerModoTrabajo(2);
                        MantenimientoBloquesJDialog.this.pPanel.setValoresAsignables(objAsig);
                        MantenimientoBloquesJDialog.this.botones.modificarButton_mousePressed(e);
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (MantenimientoBloquesJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoBloquesJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoBloquesJDialog.this.establecerModoTrabajo(7);
                    MantenimientoBloquesJDialog.this.pPanel.limpiarCampos();
                    return;
                }
            }
        });
        this.listaAsignable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent kevt) {
                super.keyReleased(kevt);
                if (MantenimientoBloquesJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoBloquesJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoBloquesJDialog.this.establecerModoTrabajo(7);
                    MantenimientoBloquesJDialog.this.pPanel.limpiarCampos();
                } else {
                    IAsignable objAsig = (IAsignable)MantenimientoBloquesJDialog.this.listaAsignable.getSelectedValue();
                    MantenimientoBloquesJDialog.this.establecerModoTrabajo(2);
                    MantenimientoBloquesJDialog.this.pPanel.setValoresAsignables(objAsig);
                    MantenimientoBloquesJDialog.this.botones.modificarButton_mousePressed(null);
                }
            }
        });
        this.getContentPane().add((Component)this.tituloLabel, new XYConstraints(20, 15, 170, 25));
        this.addControles(this.ANCHO_ACTUAL, this.ALTO_ACTUAL, 4);
        ModelaConf.setVentanaActiva(this);
    }

    public boolean aplicar() {
        boolean bRespuesta = false;
        if (this.getAccion() == 1) {
            bRespuesta = this.aplicarNuevo();
        } else if (this.getAccion() == 3) {
            bRespuesta = this.aplicarModificar();
        }
        if (!bRespuesta) {
            this.botones.setModoModificarPorDefault(false);
        }
        return bRespuesta;
    }

    public boolean aplicarNuevo() {
        TrBloque bloque = null;
        if (!this.pPanel.obtenerValoresCampos()) {
            return false;
        }
        bloque = (TrBloque)this.pPanel.getValoresAsignables();
        if (bloque == null) {
            return false;
        }
        if (this.grafico.getBloquesInvolucrados().existeElemento(bloque, true) != null) {
            JOptionPane.showMessageDialog(this, "Imposible crear el bloque:\nYa existe un bloque con el nombre indicado.", "Atenci\u00f3n", 2);
            return false;
        }
        this.listaAsignable.addItem(bloque);
        this.listaAsignable.setSelectedValue(bloque, true);
        this.listaAsignable.updateUI();
        if (this.grafico != null) {
            ConjuntoDatosModela c = new ConjuntoDatosModela();
            c.setListaDatos(this.listaAsignable.toArrayList());
            this.grafico.setBloquesInvolucrados(c);
        }
        return true;
    }

    public boolean aplicarModificar() {
        if ((TrBloque)this.listaAsignable.getElementAt(this.listaAsignable.getSelectedIndex()) == null) {
            return false;
        }
        TrBloque bloqueAux = new TrBloque();
        bloqueAux.setBloqueId(((TrBloque)this.listaAsignable.getElementAt(this.listaAsignable.getSelectedIndex())).getBloqueId());
        bloqueAux.setNombre(this.pPanel.getNombreTmp());
        if (this.grafico.getBloquesInvolucrados().existeElemento(bloqueAux, true) != null) {
            JOptionPane.showMessageDialog(this, "Imposible modificar:\nYa existe un bloque con el nombre indicado.", "Atenci\u00f3n", 2);
            return false;
        }
        if (!this.pPanel.obtenerValoresCampos()) {
            return false;
        }
        this.listaAsignable.updateUI();
        return true;
    }

    public boolean modificarElemento() {
        this.establecerModoTrabajo(3);
        return true;
    }

    public boolean insertarElemento() {
        this.establecerModoTrabajo(1);
        this.pPanel.inicializarFoco();
        return true;
    }

    public boolean refrescarGrafico() {
        if (this.elementosAsignados != null) {
            this.elementosAsignados.setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public boolean cancelar() {
        if (this.listaAsignable == null) {
            this.pPanel.limpiarCampos();
            this.establecerModoTrabajo(7);
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            this.establecerModoTrabajo(7);
            this.pPanel.limpiarCampos();
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        int index = this.listaAsignable.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        this.listaAsignable.setSelectedIndex(index);
        IAsignable obj = this.listaAsignable.getElementAt(index);
        this.pPanel.setValoresAsignables(obj);
        this.establecerModoTrabajo(2);
        return true;
    }

    public void cerrar() {
        this.refrescarGrafico();
    }

    public void inicializarListaElementos(ConjuntoDatos cdElementos) {
        cdElementos.ordenar();
        super.inicializarListaElementos(cdElementos);
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        this.grafico = nuevoGrafico;
        this.pPanel.setGrafico(this.grafico);
    }

    public boolean eliminarElemento() {
        if (this.grafico == null) {
            return false;
        }
        if (this.grafico.getDestructorDDP() == null) {
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            return false;
        }
        String msgPanel = new String();
        int[] indicesOriginal = this.listaAsignable.getSelectedIndices();
        this.establecerModoTrabajo(2);
        int nElementos = this.listaAsignable.getSelectedValues().length;
        Object[] options = new Object[]{"Aceptar", "Cancelar"};
        msgPanel = nElementos > 1 ? "\u00bfConfirma eliminar los elementos seleccionados?" : "\u00bfConfirma eliminar el elemento seleccionado?";
        int n = JOptionPane.showOptionDialog(this, msgPanel, "Eliminar", 0, 3, null, options, options[1]);
        if (n == -1) {
            n = 1;
        }
        if (n == 1) {
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.pPanel.restaurarColoresDeFondo();
            return false;
        }
        this.refrescarGrafico();
        int resulEliminar = this.grafico.getDestructorDDP().eliminarBloques(this.listaAsignable.getSelectedValues());
        if (resulEliminar == 0) {
            msgPanel = nElementos > 1 ? "Ha sido imposible eliminar los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades." : "Ha sido imposible eliminar el elemento seleccionado.\nCompruebe que no est\u00e1 intentando eliminar un elemento relacionado con otras entidades.";
            JOptionPane.showMessageDialog(this, msgPanel, "Atenci\u00f3n", 2);
            this.listaAsignable.setSelectedIndices(indicesOriginal);
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.pPanel.restaurarColoresDeFondo();
            return false;
        }
        if (resulEliminar < nElementos) {
            JOptionPane.showMessageDialog(this, "Ha sido imposible eliminar alguno de los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades.", "Atenci\u00f3n", 2);
        }
        this.listaAsignable.setSelectedIndex(-1);
        this.establecerModoTrabajo(7);
        this.pPanel.limpiarCampos();
        this.inicializarListaElementos(this.grafico.getBloquesInvolucrados());
        return true;
    }
}

