/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.obj.ConjuntoDatosAccion;
import modela.bd.obj.ConjuntoDatosCondicion;
import modela.bd.obj.TrAccion;
import modela.bd.obj.TrAviso;
import modela.bd.obj.TrCondicion;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.PropCondicionJPanel;

public class MantenimientoCondicionJDialog
extends MantenimientoJDialog {
    private static final long serialVersionUID = -3305492563714787802L;
    private DDPGrafico grafico = null;
    PropCondicionJPanel pPanel;
    private final JLabel tituloLabel = new JLabel("Lista de condiciones");
    private final int ANCHO_ACTUAL = 680;
    private final int ALTO_ACTUAL = 515;

    public MantenimientoCondicionJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.setTitle("Mantenimiento de condiciones");
        this.pPanel = new PropCondicionJPanel();
        this.pPanel.inicializarCampos(7);
        this.setPanelAtributable(this.pPanel);
        this.setSize(new Dimension(this.ANCHO_ACTUAL, this.ALTO_ACTUAL));
        this.tituloLabel.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.tituloLabel.setForeground(ModelaUI.colorSeleccion);
        this.botones.permitirEliminar(true);
        this.listaAsignable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                if (e.getSource() != null) {
                    if (e.getClickCount() == 2) {
                        MantenimientoCondicionJDialog.this.dobleClick();
                        return;
                    }
                    Point p = e.getPoint();
                    int index = MantenimientoCondicionJDialog.this.listaAsignable.locationToIndex(p);
                    if (index >= 0 && index <= MantenimientoCondicionJDialog.this.listaAsignable.getNumItems()) {
                        IAsignable objAsig = MantenimientoCondicionJDialog.this.listaAsignable.getElementAt(index);
                        MantenimientoCondicionJDialog.this.establecerModoTrabajo(2);
                        MantenimientoCondicionJDialog.this.pPanel.setValoresAsignables(objAsig);
                        MantenimientoCondicionJDialog.this.botones.modificarButton_mousePressed(e);
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (MantenimientoCondicionJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoCondicionJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoCondicionJDialog.this.establecerModoTrabajo(7);
                    MantenimientoCondicionJDialog.this.pPanel.limpiarCampos();
                    return;
                }
            }
        });
        this.listaAsignable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent kevt) {
                super.keyReleased(kevt);
                if (MantenimientoCondicionJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoCondicionJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoCondicionJDialog.this.establecerModoTrabajo(7);
                    MantenimientoCondicionJDialog.this.pPanel.limpiarCampos();
                } else {
                    IAsignable objAsig = (IAsignable)MantenimientoCondicionJDialog.this.listaAsignable.getSelectedValue();
                    MantenimientoCondicionJDialog.this.establecerModoTrabajo(2);
                    MantenimientoCondicionJDialog.this.pPanel.setValoresAsignables(objAsig);
                    MantenimientoCondicionJDialog.this.botones.modificarButton_mousePressed(null);
                }
            }
        });
        this.getContentPane().add((Component)this.tituloLabel, new XYConstraints(20, 15, 170, 25));
        this.addControles(this.ANCHO_ACTUAL, this.ALTO_ACTUAL, 4);
        ModelaConf.setVentanaActiva(this);
    }

    public boolean modificarElemento() {
        this.establecerModoTrabajo(3);
        return true;
    }

    public boolean insertarElemento() {
        this.establecerModoTrabajo(1);
        this.pPanel.inicializarFoco();
        return true;
    }

    public boolean aplicar() {
        boolean bRespuesta = false;
        if (this.getAccion() == 1) {
            bRespuesta = this.aplicarNuevo();
        } else if (this.getAccion() == 3) {
            bRespuesta = this.aplicarModificar();
        }
        if (!bRespuesta) {
            this.botones.setModoModificarPorDefault(false);
        }
        return bRespuesta;
    }

    public boolean aplicarNuevo() {
        TrCondicion condicion = null;
        if (!this.pPanel.obtenerValoresCampos()) {
            return false;
        }
        condicion = (TrCondicion)this.pPanel.getValoresAsignables();
        if (condicion == null) {
            return false;
        }
        if (((ConjuntoDatosCondicion)this.grafico.getCondicionesInvolucradas()).existeElemento(condicion, true) != null) {
            JOptionPane.showMessageDialog(this, "Imposible crear la condici\u00f3n:\nYa existe una condici\u00f3n con el nombre indicado.", "Atenci\u00f3n", 2);
            return false;
        }
        TrAccion accionAux = new TrAccion();
        accionAux.setNombre(condicion.getNombre());
        if (((ConjuntoDatosAccion)this.grafico.getAccionesInvolucradas()).existeElemento(accionAux, false) != null) {
            JOptionPane.showMessageDialog(this, "Imposible crear la condici\u00f3n:\nYa existe una acci\u00f3n con el nombre indicado.", "Atenci\u00f3n", 2);
            return false;
        }
        TrAviso avisoAux = new TrAviso();
        avisoAux.setNOMBRE(condicion.getNombre());
        if (this.grafico.getAvisosInvolucrados().existeElemento(avisoAux, false) != null) {
            JOptionPane.showMessageDialog(this, "Imposible crear la condici\u00f3n:\nYa existe un aviso con el nombre indicado.", "Atenci\u00f3n", 2);
            return false;
        }
        this.listaAsignable.addItem(condicion);
        this.listaAsignable.setSelectedValue(condicion, true);
        this.listaAsignable.updateUI();
        if (this.grafico != null) {
            ConjuntoDatosCondicion c = new ConjuntoDatosCondicion();
            c.setListaDatos(this.listaAsignable.toArrayList());
            this.grafico.setCondicionesInvolucradas(c);
        }
        return true;
    }

    public boolean aplicarModificar() {
        if ((TrCondicion)this.listaAsignable.getElementAt(this.listaAsignable.getSelectedIndex()) == null) {
            return false;
        }
        TrCondicion condicionAux = new TrCondicion();
        condicionAux.setXID(((TrCondicion)this.listaAsignable.getElementAt(this.listaAsignable.getSelectedIndex())).getXID());
        condicionAux.setNombre(this.pPanel.getNombreTmp());
        if (((ConjuntoDatosCondicion)this.grafico.getCondicionesInvolucradas()).existeElemento(condicionAux, true) != null) {
            JOptionPane.showMessageDialog(this, "Imposible modificar:\nYa existe una condici\u00f3n con el nombre indicado.", "Atenci\u00f3n", 2);
            return false;
        }
        TrAccion accionAux = new TrAccion();
        accionAux.setNombre(condicionAux.getNombre());
        if (((ConjuntoDatosAccion)this.grafico.getAccionesInvolucradas()).existeElemento(accionAux, false) != null) {
            JOptionPane.showMessageDialog(this, "Imposible modificar:\nYa existe una acci\u00f3n con el nombre indicado.", "Atenci\u00f3n", 2);
            return false;
        }
        TrAviso avisoAux = new TrAviso();
        avisoAux.setNOMBRE(condicionAux.getNombre());
        if (this.grafico.getAvisosInvolucrados().existeElemento(avisoAux, false) != null) {
            JOptionPane.showMessageDialog(this, "Imposible modificar:\nYa existe un aviso con el nombre indicado.", "Atenci\u00f3n", 2);
            return false;
        }
        if (!this.pPanel.obtenerValoresCampos()) {
            return false;
        }
        this.listaAsignable.updateUI();
        return true;
    }

    public boolean refrescarGrafico() {
        if (this.elementosAsignados != null) {
            ((ConjuntoDatosCondicion)this.elementosAsignados).setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public boolean cancelar() {
        if (this.listaAsignable == null) {
            this.pPanel.limpiarCampos();
            this.establecerModoTrabajo(7);
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            this.establecerModoTrabajo(7);
            this.pPanel.limpiarCampos();
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        int index = this.listaAsignable.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        this.listaAsignable.setSelectedIndex(index);
        IAsignable obj = this.listaAsignable.getElementAt(index);
        this.pPanel.setValoresAsignables(obj);
        this.establecerModoTrabajo(2);
        return true;
    }

    public void cerrar() {
        this.refrescarGrafico();
    }

    public void inicializarListaElementos(ConjuntoDatos cdElementos) {
        cdElementos.ordenar();
        super.inicializarListaElementos(cdElementos);
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        this.grafico = nuevoGrafico;
        this.pPanel.setGrafico(this.grafico);
    }

    public boolean eliminarElemento() {
        if (this.grafico == null) {
            return false;
        }
        if (this.grafico.getDestructorDDP() == null) {
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            return false;
        }
        String msgPanel = new String();
        int[] indicesOriginal = this.listaAsignable.getSelectedIndices();
        this.establecerModoTrabajo(2);
        int nElementos = this.listaAsignable.getSelectedValues().length;
        Object[] options = new Object[]{"Aceptar", "Cancelar"};
        msgPanel = nElementos > 1 ? "\u00bfConfirma eliminar los elementos seleccionados?" : "\u00bfConfirma eliminar el elemento seleccionado?";
        int n = JOptionPane.showOptionDialog(this, msgPanel, "Eliminar", 0, 3, null, options, options[1]);
        if (n == -1) {
            n = 1;
        }
        if (n == 1) {
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.pPanel.restaurarColoresDeFondo();
            return false;
        }
        this.refrescarGrafico();
        int resulEliminar = this.grafico.getDestructorDDP().eliminarCondiciones(this.listaAsignable.getSelectedValues());
        if (resulEliminar == 0) {
            msgPanel = nElementos > 1 ? "Ha sido imposible eliminar los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades." : "Ha sido imposible eliminar el elemento seleccionado.\nCompruebe que no est\u00e1 intentando eliminar un elemento relacionado con otras entidades.";
            JOptionPane.showMessageDialog(this, msgPanel, "Atenci\u00f3n", 2);
            this.listaAsignable.setSelectedIndices(indicesOriginal);
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.pPanel.restaurarColoresDeFondo();
            return false;
        }
        if (resulEliminar < nElementos) {
            JOptionPane.showMessageDialog(this, "Ha sido imposible eliminar alguno de los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades.", "Atenci\u00f3n", 2);
        }
        this.listaAsignable.setSelectedIndex(-1);
        this.establecerModoTrabajo(7);
        this.pPanel.limpiarCampos();
        this.inicializarListaElementos(this.grafico.getCondicionesInvolucradas());
        return true;
    }
}

