/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.PropNormativaJPanel;

public class MantenimientoNormativaJDialog
extends MantenimientoJDialog {
    private static final long serialVersionUID = -4072035927158576315L;
    private DDPGrafico grafico = null;
    PropNormativaJPanel pPanel;
    private JLabel tituloLabel = new JLabel("Lista de normativas");
    IAsignable datosasignables = null;
    private final int ANCHO_ACTUAL = 790;
    private final int ALTO_ACTUAL = 590;

    public MantenimientoNormativaJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.setModoModificarTrasBusqueda(false);
        this.setTitle("Selecci\u00f3n de normativas");
        this.pPanel = new PropNormativaJPanel();
        this.pPanel.inicializarCampos(7);
        this.botones.setVisible(false);
        this.activarSeleccion(true);
        this.setPanelAtributable(this.pPanel);
        this.setSize(new Dimension(this.ANCHO_ACTUAL, this.ALTO_ACTUAL));
        this.tituloLabel.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.tituloLabel.setForeground(ModelaUI.colorSeleccion);
        this.listaAsignable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                if (e.getSource() != null) {
                    if (e.getClickCount() == 2) {
                        MantenimientoNormativaJDialog.this.elementosSeleccionados = null;
                        MantenimientoNormativaJDialog.this.elementoSeleccionado = (IAsignable)MantenimientoNormativaJDialog.this.listaAsignable.getSelectedValue();
                        MantenimientoNormativaJDialog.this.dispose();
                        return;
                    }
                    Point p = e.getPoint();
                    int index = MantenimientoNormativaJDialog.this.listaAsignable.locationToIndex(p);
                    if (index >= 0 && index <= MantenimientoNormativaJDialog.this.listaAsignable.getNumItems()) {
                        IAsignable objAsig = MantenimientoNormativaJDialog.this.listaAsignable.getElementAt(index);
                        MantenimientoNormativaJDialog.this.establecerModoTrabajo(2);
                        MantenimientoNormativaJDialog.this.pPanel.setValoresAsignables(objAsig);
                    }
                }
            }
        });
        this.listaAsignable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent kevt) {
                super.keyReleased(kevt);
                IAsignable objAsig = (IAsignable)MantenimientoNormativaJDialog.this.listaAsignable.getSelectedValue();
                MantenimientoNormativaJDialog.this.establecerModoTrabajo(2);
                MantenimientoNormativaJDialog.this.pPanel.setValoresAsignables(objAsig);
            }
        });
        this.getContentPane().add((Component)this.tituloLabel, new XYConstraints(20, 15, 170, 25));
        this.addControles(this.ANCHO_ACTUAL, this.ALTO_ACTUAL, 0);
        ModelaConf.setVentanaActiva(this);
    }

    public boolean modificarElemento() {
        this.establecerModoTrabajo(3);
        return true;
    }

    public boolean insertarElemento() {
        this.establecerModoTrabajo(1);
        return true;
    }

    public boolean aplicar() {
        if (this.getAccion() == 1) {
            return this.aplicarNuevo();
        }
        if (this.getAccion() == 3) {
            return this.aplicarModificar();
        }
        return false;
    }

    public boolean aplicarNuevo() {
        return true;
    }

    public boolean aplicarModificar() {
        return true;
    }

    public boolean refrescarGrafico() {
        if (this.elementosAsignados != null) {
            this.elementosAsignados.setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public boolean cancelar() {
        if (this.listaAsignable == null) {
            this.pPanel.limpiarCampos();
            this.establecerModoTrabajo(7);
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            this.establecerModoTrabajo(7);
            this.pPanel.limpiarCampos();
            return false;
        }
        int index = this.listaAsignable.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        this.listaAsignable.setSelectedIndex(index);
        IAsignable obj = this.listaAsignable.getElementAt(index);
        this.pPanel.setValoresAsignables(obj);
        this.establecerModoTrabajo(2);
        return true;
    }

    public void cerrar() {
        this.refrescarGrafico();
    }

    public void inicializarListaElementos(ConjuntoDatos cdElementos) {
        cdElementos.ordenar();
        super.inicializarListaElementos(cdElementos);
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        this.grafico = nuevoGrafico;
    }

    public boolean eliminarElemento() {
        if (this.grafico == null) {
            return false;
        }
        if (this.grafico.getDestructorDDP() == null) {
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            return false;
        }
        String msgPanel = new String();
        int[] indicesOriginal = this.listaAsignable.getSelectedIndices();
        this.establecerModoTrabajo(2);
        int nElementos = this.listaAsignable.getSelectedValues().length;
        Object[] options = new Object[]{"Aceptar", "Cancelar"};
        msgPanel = nElementos > 1 ? "\u00bfConfirma eliminar los elementos seleccionados?" : "\u00bfConfirma eliminar el elemento seleccionado?";
        int n = JOptionPane.showOptionDialog(this, msgPanel, "Eliminar", 0, 3, null, options, options[1]);
        if (n == -1) {
            n = 1;
        }
        if (n == 1) {
            this.establecerModoTrabajo(2);
            return false;
        }
        this.refrescarGrafico();
        int resulEliminar = this.grafico.getDestructorDDP().eliminarAvisos(this.listaAsignable.getSelectedValues());
        if (resulEliminar == 0) {
            msgPanel = nElementos > 1 ? "Ha sido imposible eliminar los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades." : "Ha sido imposible eliminar el elemento seleccionado.\nCompruebe que no est\u00e1 intentando eliminar un elemento relacionado con otras entidades.";
            JOptionPane.showMessageDialog(this, msgPanel, "Atenci\u00f3n", 2);
            this.listaAsignable.setSelectedIndices(indicesOriginal);
            this.establecerModoTrabajo(2);
            return false;
        }
        if (resulEliminar < nElementos) {
            JOptionPane.showMessageDialog(this, "Ha sido imposible eliminar alguno de los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades.", "Atenci\u00f3n", 2);
        }
        this.listaAsignable.setSelectedIndex(-1);
        this.establecerModoTrabajo(7);
        this.pPanel.limpiarCampos();
        this.inicializarListaElementos(this.grafico.getAvisosInvolucrados());
        return true;
    }

    public void asignarNuevaPosicionControles() {
        this.getContentPane().removeAll();
        this.listaAsignable.setFont(ModelaUI.fuentePrincipal);
        this.getContentPane().add((Component)this.tituloLabel, new XYConstraints(20, 15, 170, 25));
        this.getContentPane().add((Component)this.insertarButton, new XYConstraints(430, 480, 115, 30));
        this.getContentPane().add((Component)this.cerrarButton, new XYConstraints(565, 480, 115, 30));
        this.getContentPane().add((Component)this.listaAsignable.getScrollableArea(), new XYConstraints(20, 40, 180, 350));
        this.getContentPane().add((Component)this.pPanel, new XYConstraints(230, 10, 630, 500));
        this.setLocationRelativeTo(null);
    }

    public static void main(String[] args) {
        MantenimientoNormativaJDialog a = new MantenimientoNormativaJDialog();
        a.setVisible(true);
    }
}

