/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import gdtel.ui.swing.excontrols.CreadorButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.obj.TrNormativa;
import modela.bd.obj.TrTipoEvol;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.MantenimientoNormativaJDialog;
import modela.ui.swing.PropNormativaJPanel;

public class MantenimientoNormativaProcJDialog
extends MantenimientoJDialog {
    private static final long serialVersionUID = -5921358858695975839L;
    private DDPGrafico grafico = null;
    PropNormativaJPanel pPanel;
    private JLabel tituloLabel = new JLabel("Lista de normativas");
    private JButton botonSeleccion;
    JButton botonEliminar;
    ConjuntoDatos cd = null;
    TrTipoEvol trEvol = null;
    MantenimientoNormativaJDialog mmtoNorm = new MantenimientoNormativaJDialog();
    IAsignable datosasignables = null;
    ImageIcon agregarIconN = new ImageIcon(MantenimientoNormativaProcJDialog.class.getResource(ModelaUI.IMG_SMALL_AGREGAR));
    ImageIcon agregarIconS = new ImageIcon(MantenimientoNormativaProcJDialog.class.getResource(ModelaUI.IMG_SMALL_AGREGAR_SOBRE));
    ImageIcon agregarIconD = new ImageIcon(MantenimientoNormativaProcJDialog.class.getResource(ModelaUI.IMG_SMALL_AGREGAR_NO_ENABLED));
    ImageIcon quitarIconN = new ImageIcon(MantenimientoNormativaProcJDialog.class.getResource(ModelaUI.IMG_SMALL_QUITAR));
    ImageIcon quitarIconS = new ImageIcon(MantenimientoNormativaProcJDialog.class.getResource(ModelaUI.IMG_SMALL_QUITAR_SOBRE));
    ImageIcon quitarIconD = new ImageIcon(MantenimientoNormativaProcJDialog.class.getResource(ModelaUI.IMG_SMALL_QUITAR_NO_ENABLED));
    private final int ANCHO_ACTUAL = 790;
    private final int ALTO_ACTUAL = 590;

    public MantenimientoNormativaProcJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.setModoModificarTrasBusqueda(false);
        this.setTitle("Mantenimiento de normativas del procedimiento");
        this.botonSeleccion = (JButton)CreadorButton.crearBoton(1, false, this.agregarIconN, this.agregarIconD, this.agregarIconS, this.agregarIconS);
        this.botonEliminar = (JButton)CreadorButton.crearBoton(1, false, this.quitarIconN, this.quitarIconD, this.quitarIconS, this.quitarIconS);
        this.botonSeleccion.setBorderPainted(false);
        this.botonSeleccion.setFocusPainted(false);
        this.botonEliminar.setBorderPainted(false);
        this.botonEliminar.setFocusPainted(false);
        this.pPanel = new PropNormativaJPanel();
        this.pPanel.inicializarCampos(7);
        this.botones.setVisible(false);
        this.activarSeleccion(false);
        this.setPanelAtributable(this.pPanel);
        this.setSize(new Dimension(this.ANCHO_ACTUAL, this.ALTO_ACTUAL));
        this.tituloLabel.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.tituloLabel.setForeground(ModelaUI.colorSeleccion);
        this.listaAsignable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                if (e.getSource() != null) {
                    if (e.getClickCount() == 2) {
                        MantenimientoNormativaProcJDialog.this.dobleClick();
                        return;
                    }
                    Point p = e.getPoint();
                    int index = MantenimientoNormativaProcJDialog.this.listaAsignable.locationToIndex(p);
                    if (index >= 0 && index <= MantenimientoNormativaProcJDialog.this.listaAsignable.getNumItems()) {
                        IAsignable objAsig = MantenimientoNormativaProcJDialog.this.listaAsignable.getElementAt(index);
                        MantenimientoNormativaProcJDialog.this.establecerModoTrabajo(2);
                        MantenimientoNormativaProcJDialog.this.pPanel.setValoresAsignables(objAsig);
                        MantenimientoNormativaProcJDialog.this.botonEliminar.setEnabled(true);
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (MantenimientoNormativaProcJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoNormativaProcJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoNormativaProcJDialog.this.establecerModoTrabajo(7);
                    MantenimientoNormativaProcJDialog.this.pPanel.limpiarCampos();
                    return;
                }
            }
        });
        this.listaAsignable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent kevt) {
                super.keyReleased(kevt);
                if (MantenimientoNormativaProcJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoNormativaProcJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoNormativaProcJDialog.this.establecerModoTrabajo(7);
                    MantenimientoNormativaProcJDialog.this.pPanel.limpiarCampos();
                } else {
                    IAsignable objAsig = (IAsignable)MantenimientoNormativaProcJDialog.this.listaAsignable.getSelectedValue();
                    MantenimientoNormativaProcJDialog.this.establecerModoTrabajo(2);
                    MantenimientoNormativaProcJDialog.this.pPanel.setValoresAsignables(objAsig);
                    MantenimientoNormativaProcJDialog.this.botonEliminar.setEnabled(true);
                }
            }
        });
        this.botonSeleccion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MantenimientoNormativaProcJDialog.this.asignarNormativas(e);
            }
        });
        this.botonEliminar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MantenimientoNormativaProcJDialog.this.eliminarElemento();
            }
        });
        this.getContentPane().add((Component)this.tituloLabel, new XYConstraints(20, 15, 170, 25));
        this.addControles(this.ANCHO_ACTUAL, this.ALTO_ACTUAL, 0);
        this.getContentPane().add((Component)this.botonSeleccion, new XYConstraints(660, 500, 80, 25));
        this.getContentPane().add((Component)this.botonEliminar, new XYConstraints(742, 502, 30, 21));
        ModelaConf.setVentanaActiva(this);
    }

    public boolean modificarElemento() {
        this.establecerModoTrabajo(3);
        return true;
    }

    public boolean insertarElemento() {
        this.establecerModoTrabajo(1);
        return true;
    }

    public boolean aplicar() {
        if (this.getAccion() == 1) {
            return this.aplicarNuevo();
        }
        if (this.getAccion() == 3) {
            return this.aplicarModificar();
        }
        return false;
    }

    public boolean aplicarNuevo() {
        return true;
    }

    public boolean aplicarModificar() {
        return true;
    }

    public boolean refrescarGrafico() {
        if (this.elementosAsignados != null) {
            this.elementosAsignados.setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public boolean cancelar() {
        if (this.listaAsignable == null) {
            this.pPanel.limpiarCampos();
            this.establecerModoTrabajo(7);
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            this.establecerModoTrabajo(7);
            this.pPanel.limpiarCampos();
            return false;
        }
        int index = this.listaAsignable.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        this.listaAsignable.setSelectedIndex(index);
        IAsignable obj = this.listaAsignable.getElementAt(index);
        this.pPanel.setValoresAsignables(obj);
        this.establecerModoTrabajo(2);
        return true;
    }

    public void cerrar() {
        this.refrescarGrafico();
    }

    public void inicializarListaElementos(ConjuntoDatos cdElementos) {
        cdElementos.ordenar();
        super.inicializarListaElementos(cdElementos);
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        this.grafico = nuevoGrafico;
    }

    public boolean eliminarElemento() {
        if (this.grafico == null) {
            return false;
        }
        if (this.grafico.getDestructorDDP() == null) {
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            return false;
        }
        if (this.listaAsignable.getSelectedValues().length < 1) {
            return false;
        }
        String msgPanel = new String();
        int[] indicesOriginal = this.listaAsignable.getSelectedIndices();
        this.establecerModoTrabajo(2);
        int nElementos = this.listaAsignable.getSelectedValues().length;
        Object[] options = new Object[]{"Aceptar", "Cancelar"};
        msgPanel = nElementos > 1 ? "\u00bfConfirma eliminar los elementos seleccionados?" : "\u00bfConfirma eliminar el elemento seleccionado?";
        int n = JOptionPane.showOptionDialog(this, msgPanel, "Eliminar", 0, 3, null, options, options[1]);
        if (n == -1) {
            n = 1;
        }
        if (n == 1) {
            this.establecerModoTrabajo(2);
            return false;
        }
        this.refrescarGrafico();
        int resulEliminar = this.grafico.getDestructorDDP().eliminarNormativasProcedimiento(this.listaAsignable.getSelectedValues());
        if (resulEliminar == 0) {
            msgPanel = nElementos > 1 ? "Ha sido imposible eliminar los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades." : "Ha sido imposible eliminar el elemento seleccionado.\nCompruebe que no est\u00e1 intentando eliminar un elemento relacionado con otras entidades.";
            JOptionPane.showMessageDialog(this, msgPanel, "Atenci\u00f3n", 2);
            this.listaAsignable.setSelectedIndices(indicesOriginal);
            this.establecerModoTrabajo(2);
            return false;
        }
        if (resulEliminar < nElementos) {
            JOptionPane.showMessageDialog(this, "Ha sido imposible eliminar alguno de los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades.", "Atenci\u00f3n", 2);
        }
        this.listaAsignable.setSelectedIndex(-1);
        this.establecerModoTrabajo(7);
        this.pPanel.limpiarCampos();
        this.inicializarListaElementos(this.grafico.getDDP().getTIPOEVOL().getNormativasProcedimiento());
        return true;
    }

    public void cargarLista() {
        Object[] seleccionMultiple = null;
        TrNormativa norm = null;
        boolean insertar = true;
        seleccionMultiple = this.mmtoNorm.obtenerElementosSeleccionados();
        if (seleccionMultiple != null) {
            int t = 0;
            for (int i = 0; i < seleccionMultiple.length; ++i) {
                norm = (TrNormativa)seleccionMultiple[i];
                while (t < this.listaAsignable.getNumItems()) {
                    TrNormativa cmp = (TrNormativa)this.listaAsignable.getElementAt(t);
                    if (cmp.equals(norm)) {
                        insertar = false;
                    }
                    ++t;
                }
                if (!insertar) continue;
                this.listaAsignable.addItem(norm);
            }
            insertar = false;
        } else if (this.mmtoNorm.obtenerElementoSeleccionado() != null) {
            norm = (TrNormativa)this.mmtoNorm.obtenerElementoSeleccionado();
            for (int v = 0; v < this.listaAsignable.getNumItems(); ++v) {
                TrNormativa cmp2 = (TrNormativa)this.listaAsignable.getElementAt(v);
                if (!cmp2.equals(norm)) continue;
                insertar = false;
            }
            if (insertar) {
                this.listaAsignable.addItem(norm);
            }
        }
    }

    public void asignarNormativas(ActionEvent e) {
        this.mmtoNorm = new MantenimientoNormativaJDialog();
        if (this.grafico != null) {
            this.mmtoNorm.setGrafico(this.grafico);
            if (this.grafico.getConjuntoDatosGlobal() != null) {
                this.mmtoNorm.inicializarListaElementos(this.grafico.getNormativasInvolucradas());
            } else if (this.grafico.getDDPPadre() != null && this.grafico.getDDPPadre().getConjuntoDatosGlobal() != null) {
                this.mmtoNorm.inicializarListaElementos(this.grafico.getDDPPadre().getNormativasInvolucradas());
            }
        }
        this.mmtoNorm.setLocationRelativeTo(null);
        this.mmtoNorm.setVisible(true);
        this.cargarLista();
    }

    public void eliminarNormativas(ActionEvent e) {
        if (!this.listaAsignable.hasAnyObject()) {
            return;
        }
        if (this.listaAsignable.getSelectedValue() == null) {
            return;
        }
        Object[] options = new Object[]{"Aceptar", "Cancelar"};
        int n = JOptionPane.showOptionDialog(this, "\u00bfConfirma eliminar el elemento seleccionado?", "Eliminar", 0, 3, null, options, options[1]);
        if (n == 1) {
            this.pPanel.inicializarCampos(2);
            return;
        }
        if (this.listaAsignable.getSelectedValue() != null) {
            int index = this.listaAsignable.getSelectedIndex();
            this.listaAsignable.removeItem(index);
            if (index > 0) {
                this.listaAsignable.setSelectionInterval(index - 1, index - 1);
                this.pPanel.limpiarCampos();
                if (this.listaAsignable.getSelectedValue() != null) {
                    this.pPanel.setValoresAsignables((IAsignable)this.listaAsignable.getSelectedValue());
                }
            }
            if (!this.listaAsignable.hasAnyObject()) {
                this.pPanel.limpiarCampos();
                this.listaAsignable.setToolTipText(null);
            }
            if (this.listaAsignable.getSelectedValue() == null) {
                this.pPanel.limpiarCampos();
            }
        }
    }

    public void deshabiltarBotonesHerraminetas() {
        this.botonEliminar.setVisible(false);
        this.botonSeleccion.setVisible(false);
    }

    public void asignarNuevaPosicionControles() {
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)this.tituloLabel, new XYConstraints(20, 15, 170, 25));
        this.listaAsignable.setFont(ModelaUI.fuentePrincipal);
        this.getContentPane().add((Component)this.botonSeleccion, new XYConstraints(600, 475, 80, 25));
        this.getContentPane().add((Component)this.botonEliminar, new XYConstraints(500, 475, 80, 25));
        this.getContentPane().add((Component)this.cerrarButton, new XYConstraints(565, 510, 115, 30));
        this.getContentPane().add((Component)this.listaAsignable.getScrollableArea(), new XYConstraints(20, 40, 180, 350));
        this.getContentPane().add((Component)this.pPanel, new XYConstraints(230, 10, 630, 530));
        this.setLocationRelativeTo(null);
    }
}

