/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.bd.BotonesMantenimientoJPanel;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import gdtel.ui.swing.excontrols.CreadorButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import modela.bd.obj.TrFase;
import modela.bd.obj.TrPlazoSimple;
import modela.bd.obj.TrTransicionDefProcedimiento;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.PropPlazoSimpleJPanel;

public class MantenimientoPlazoSimpleJDialog
extends MantenimientoJDialog {
    private static final long serialVersionUID = 7364312016139493463L;
    private DDPGrafico grafico = null;
    PropPlazoSimpleJPanel pPanel;
    private JLabel tituloLabel = new JLabel("Lista de fases finales");
    ImageIcon cancelarIconN = new ImageIcon(BotonesMantenimientoJPanel.class.getResource(ModelaUI.IMG_MTTO_CANCELAR));
    ImageIcon cancelarIconD = new ImageIcon(BotonesMantenimientoJPanel.class.getResource(ModelaUI.IMG_MTTO_CANCELAR_NO_ENABLED));
    ImageIcon cancelarIconS = new ImageIcon(BotonesMantenimientoJPanel.class.getResource(ModelaUI.IMG_MTTO_CANCELAR_SOBRE));
    ImageIcon aplicarIconN = new ImageIcon(BotonesMantenimientoJPanel.class.getResource(ModelaUI.IMG_MTTO_APLICAR));
    ImageIcon aplicarIconD = new ImageIcon(BotonesMantenimientoJPanel.class.getResource(ModelaUI.IMG_MTTO_APLICAR_NO_ENABLED));
    ImageIcon aplicarIconS = new ImageIcon(BotonesMantenimientoJPanel.class.getResource(ModelaUI.IMG_MTTO_APLICAR_SOBRE));
    ImageIcon eliminarIconN = new ImageIcon(BotonesMantenimientoJPanel.class.getResource(ModelaUI.IMG_MTTO_ELIMINAR));
    ImageIcon eliminarIconD = new ImageIcon(BotonesMantenimientoJPanel.class.getResource(ModelaUI.IMG_MTTO_ELIMINAR_NO_ENABLED));
    ImageIcon eliminarIconS = new ImageIcon(BotonesMantenimientoJPanel.class.getResource(ModelaUI.IMG_MTTO_ELIMINAR_SOBRE));
    JButton eliminarButton = (JButton)CreadorButton.crearBoton(1, false, this.eliminarIconN, this.eliminarIconD, this.eliminarIconN, this.eliminarIconS);
    JButton aplicarButton = (JButton)CreadorButton.crearBoton(1, false, this.aplicarIconN, this.aplicarIconD, this.aplicarIconN, this.aplicarIconS);
    JButton cancelarButton = (JButton)CreadorButton.crearBoton(1, false, this.cancelarIconN, this.cancelarIconD, this.cancelarIconN, this.cancelarIconS);
    private TrPlazoSimple m_plazoSimple = null;
    private boolean m_bTransDiv = false;
    private TrTransicionDefProcedimiento m_transDefProc = null;
    private final int ANCHO_ACTUAL = 800;
    private final int ALTO_ACTUAL = 315;

    public MantenimientoPlazoSimpleJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.activarSeleccion(false);
        this.setTitle("Mantenimiento de  plazos simples");
        this.pPanel = new PropPlazoSimpleJPanel();
        this.pPanel.inicializarCampos(7);
        this.setPanelAtributable(this.pPanel);
        this.setSize(new Dimension(this.ANCHO_ACTUAL, this.ALTO_ACTUAL));
        this.tituloLabel.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.tituloLabel.setForeground(ModelaUI.colorSeleccion);
        this.botones.permitirEliminar(true);
        this.eliminarButton.setFocusPainted(false);
        this.aplicarButton.setFocusPainted(false);
        this.cancelarButton.setFocusPainted(false);
        this.listaAsignable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                if (e.getSource() != null) {
                    if (e.getClickCount() == 2) {
                        MantenimientoPlazoSimpleJDialog.this.elementoSeleccionado = (IAsignable)MantenimientoPlazoSimpleJDialog.this.listaAsignable.getSelectedValue();
                        MantenimientoPlazoSimpleJDialog.this.dispose();
                        return;
                    }
                    Point p = e.getPoint();
                    int index = MantenimientoPlazoSimpleJDialog.this.listaAsignable.locationToIndex(p);
                    if (index >= 0 && index <= MantenimientoPlazoSimpleJDialog.this.listaAsignable.getNumItems()) {
                        IAsignable objAsig = MantenimientoPlazoSimpleJDialog.this.listaAsignable.getElementAt(index);
                        MantenimientoPlazoSimpleJDialog.this.pPanel.setFaseActiva((TrFase)objAsig);
                        MantenimientoPlazoSimpleJDialog.this.mostrarPlazoSimple(objAsig);
                    }
                }
            }
        });
        this.listaAsignable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent kevt) {
                super.keyReleased(kevt);
                IAsignable objAsig = (IAsignable)MantenimientoPlazoSimpleJDialog.this.listaAsignable.getSelectedValue();
                MantenimientoPlazoSimpleJDialog.this.pPanel.setFaseActiva((TrFase)objAsig);
                MantenimientoPlazoSimpleJDialog.this.mostrarPlazoSimple(objAsig);
            }
        });
        this.aplicarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MantenimientoPlazoSimpleJDialog.this.aplicar_actionPerformed(e);
            }
        });
        this.eliminarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MantenimientoPlazoSimpleJDialog.this.eliminar_Performed(e);
            }
        });
        this.cancelarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MantenimientoPlazoSimpleJDialog.this.cancelar_Performed(e);
            }
        });
        this.getContentPane().add((Component)this.tituloLabel, new XYConstraints(20, 15, 195, 25));
        this.addControles(this.ANCHO_ACTUAL, this.ALTO_ACTUAL, 0);
        this.getContentPane().add((Component)this.aplicarButton, new XYConstraints(605, 193, 80, 55));
        this.getContentPane().add((Component)this.cancelarButton, new XYConstraints(695, 193, 80, 55));
        this.getContentPane().add((Component)this.eliminarButton, new XYConstraints(515, 193, 80, 55));
        ModelaConf.setVentanaActiva(this);
    }

    public boolean modificarElemento() {
        this.establecerModoTrabajo(3);
        return true;
    }

    public boolean insertarElemento() {
        this.establecerModoTrabajo(1);
        return true;
    }

    public boolean aplicar() {
        return false;
    }

    public boolean aplicarNuevo() {
        return true;
    }

    public boolean aplicarModificar() {
        return true;
    }

    public boolean refrescarGrafico() {
        return true;
    }

    public boolean cancelar() {
        return true;
    }

    public void cerrar() {
        this.refrescarGrafico();
    }

    public void inicializarListaElementos(ConjuntoDatos cdElementos) {
        super.inicializarListaElementos(cdElementos);
        this.listaAsignable.setSelectedIndex(0);
        IAsignable objAsig = this.listaAsignable.getElementAt(0);
        this.pPanel.setFaseActiva((TrFase)objAsig);
        this.mostrarPlazoSimple(objAsig);
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        this.grafico = nuevoGrafico;
        this.pPanel.setGrafico(this.grafico);
    }

    public boolean eliminarElemento() {
        return true;
    }

    boolean aplicar_actionPerformed(ActionEvent e) {
        if (!this.pPanel.obtenerValoresCampos()) {
            return false;
        }
        this.m_plazoSimple = this.pPanel.getPlazoSimple();
        this.actualizarPlazoSimple();
        this.pPanel.reiniciarColores();
        if (!this.m_bTransDiv) {
            this.dispose();
        }
        return true;
    }

    void eliminar_Performed(ActionEvent e) {
        this.pPanel.eliminarPlazoSimple();
        this.m_plazoSimple = null;
        this.eliminarPlazoSimple();
        this.pPanel.reiniciarColores();
        if (!this.m_bTransDiv) {
            this.dispose();
        }
    }

    void cancelar_Performed(ActionEvent e) {
        this.pPanel.setPlazoSimple(this.m_plazoSimple);
        this.pPanel.reiniciarColores();
        if (!this.m_bTransDiv) {
            this.dispose();
        }
    }

    public void setPlazoSimple(TrPlazoSimple plazoSimple) {
        this.m_plazoSimple = plazoSimple;
        this.pPanel.setPlazoSimple(plazoSimple);
    }

    public void setTransicionDivision(boolean bTransDiv) {
        this.m_bTransDiv = bTransDiv;
    }

    public void setTransDefProcedimiento(TrTransicionDefProcedimiento transDefProc) {
        this.m_transDefProc = transDefProc;
    }

    boolean mostrarPlazoSimple(IAsignable objAsig) {
        this.m_plazoSimple = null;
        if (this.m_transDefProc == null) {
            return false;
        }
        TrFase faseSel = (TrFase)objAsig;
        if (faseSel == null) {
            return false;
        }
        if (this.m_bTransDiv) {
            if (this.m_transDefProc.getPlazosSimple() != null) {
                boolean bEncontrado = false;
                for (int i = 0; i < this.m_transDefProc.getPlazosSimple().size() && !bEncontrado; ++i) {
                    TrPlazoSimple plazoAux = (TrPlazoSimple)this.m_transDefProc.getPlazosSimple().get(i);
                    if (plazoAux.getFaseAsociada() == null || plazoAux.getFaseAsociada().getID() != faseSel.getID()) continue;
                    this.m_plazoSimple = plazoAux;
                    bEncontrado = true;
                }
            }
        } else {
            this.m_plazoSimple = this.m_transDefProc.getPlazoSimple();
        }
        this.pPanel.setPlazoSimple(this.m_plazoSimple);
        return true;
    }

    private void actualizarPlazoSimple() {
        int nSel = this.listaAsignable.getSelectedIndex();
        IAsignable objAsig = this.listaAsignable.getElementAt(nSel);
        TrFase faseSel = (TrFase)objAsig;
        if (this.m_bTransDiv) {
            if (this.m_transDefProc.getPlazosSimple() != null) {
                boolean bEncontrado = false;
                TrPlazoSimple plazoAux = null;
                for (int i = 0; i < this.m_transDefProc.getPlazosSimple().size() && !bEncontrado; ++i) {
                    plazoAux = (TrPlazoSimple)this.m_transDefProc.getPlazosSimple().get(i);
                    if (plazoAux.getFaseAsociada() == null || plazoAux.getFaseAsociada().getID() != faseSel.getID()) continue;
                    bEncontrado = true;
                }
                if (bEncontrado) {
                    if (this.m_plazoSimple != null && plazoAux != null) {
                        plazoAux.setUnidad(this.m_plazoSimple.getUnidad());
                        plazoAux.setDESCRIPCION(this.m_plazoSimple.getDescripcion());
                        plazoAux.setNumUnidades(this.m_plazoSimple.getNumUnidades());
                        plazoAux.setFaseAsociada(faseSel);
                        plazoAux.setTransicionQueProvoca(this.m_plazoSimple.getTransicionQueProvoca());
                    }
                } else {
                    TrPlazoSimple nuevoPlazo = new TrPlazoSimple();
                    nuevoPlazo.setUnidad(this.m_plazoSimple.getUnidad());
                    nuevoPlazo.setDESCRIPCION(this.m_plazoSimple.getDescripcion());
                    nuevoPlazo.setNumUnidades(this.m_plazoSimple.getNumUnidades());
                    nuevoPlazo.setFaseAsociada(faseSel);
                    nuevoPlazo.setTransicionQueProvoca(this.m_plazoSimple.getTransicionQueProvoca());
                    this.m_transDefProc.addPlazoSimple(nuevoPlazo);
                }
            }
        } else {
            this.m_transDefProc.setPlazoSimple(this.m_plazoSimple);
        }
    }

    private void eliminarPlazoSimple() {
        int nSel = this.listaAsignable.getSelectedIndex();
        IAsignable objAsig = this.listaAsignable.getElementAt(nSel);
        TrFase faseSel = (TrFase)objAsig;
        if (this.m_bTransDiv) {
            if (this.m_transDefProc.getPlazosSimple() != null) {
                boolean bEncontrado = false;
                TrPlazoSimple plazoAux = null;
                int nElemento = -1;
                for (int i = 0; i < this.m_transDefProc.getPlazosSimple().size() && !bEncontrado; ++i) {
                    plazoAux = (TrPlazoSimple)this.m_transDefProc.getPlazosSimple().get(i);
                    if (plazoAux.getFaseAsociada() == null || plazoAux.getFaseAsociada().getID() != faseSel.getID()) continue;
                    bEncontrado = true;
                    nElemento = i;
                }
                if (bEncontrado) {
                    this.m_transDefProc.getPlazosSimple().remove(nElemento);
                }
            }
        } else {
            this.m_transDefProc.setPlazoSimple(null);
        }
    }
}

