/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.obj.ConjuntoDatosTareaEnFase;
import modela.bd.obj.TrBloquePermitido;
import modela.bd.obj.TrFase;
import modela.bd.obj.TrTareaEnFase;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.Portapapeles;
import modela.ui.swing.PropTareaEnFaseJPanel;
import modela.ui.swing.filtros.TareaEnFaseListModelFilter;
import modela.ui.swing.renderers.TareaEnFaseCellRenderer;

public class MantenimientoTareaEnFaseJDialog
extends MantenimientoJDialog {
    private static final long serialVersionUID = 8785998080428122344L;
    PropTareaEnFaseJPanel pPanel;
    private final JLabel tituloListaLabel = new JLabel();
    DDPGrafico grafico = null;
    private final JLabel jLabel1 = new JLabel();
    private String m_strTipoTarea = null;
    private TareaEnFaseListModelFilter model;
    TrFase m_faseActiva = null;
    private final int ANCHO_ACTUAL = 800;
    private final int ALTO_ACTUAL = 515;

    public MantenimientoTareaEnFaseJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public MantenimientoTareaEnFaseJDialog(String strTipoTarea) {
        this.m_strTipoTarea = strTipoTarea;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.pPanel = new PropTareaEnFaseJPanel(true);
        this.setSize(new Dimension(this.ANCHO_ACTUAL, this.ALTO_ACTUAL));
        this.setPanelAtributable(this.pPanel);
        this.establecerModoTrabajo(7);
        this.tituloListaLabel.setText("Tareas en fase ...");
        this.tituloListaLabel.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.jLabel1.setText("Lista de tareas en fase actual");
        this.jLabel1.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.jLabel1.setForeground(ModelaUI.colorSeleccion);
        this.setTitle("Mantenimiento de tareas en fases");
        this.listaAsignable.setTipoAlmacenado(5);
        this.listaAsignable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    if (MantenimientoTareaEnFaseJDialog.this.listaAsignable.crearPopupMenu() && !MantenimientoTareaEnFaseJDialog.this.listaAsignable.popup.isVisible()) {
                        Portapapeles.setGrafico(MantenimientoTareaEnFaseJDialog.this.grafico);
                        Portapapeles.setFaseActiva(MantenimientoTareaEnFaseJDialog.this.m_faseActiva);
                        MantenimientoTareaEnFaseJDialog.this.listaAsignable.popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                    return;
                }
                if (e.getSource() != null) {
                    if (e.getClickCount() == 2) {
                        MantenimientoTareaEnFaseJDialog.this.dobleClick();
                        return;
                    }
                    Point p = e.getPoint();
                    int index = MantenimientoTareaEnFaseJDialog.this.listaAsignable.locationToIndex(p);
                    if (index >= 0 && index < MantenimientoTareaEnFaseJDialog.this.listaAsignable.getNumItems()) {
                        IAsignable objAsig = MantenimientoTareaEnFaseJDialog.this.listaAsignable.getElementAt(index);
                        MantenimientoTareaEnFaseJDialog.this.establecerModoTrabajo(2);
                        MantenimientoTareaEnFaseJDialog.this.pPanel.setValoresAsignables(objAsig);
                        MantenimientoTareaEnFaseJDialog.this.botones.modificarButton_mousePressed(e);
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (MantenimientoTareaEnFaseJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoTareaEnFaseJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoTareaEnFaseJDialog.this.establecerModoTrabajo(7);
                    MantenimientoTareaEnFaseJDialog.this.pPanel.limpiarCampos();
                    return;
                }
            }
        });
        this.listaAsignable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent kevt) {
                super.keyReleased(kevt);
                if (MantenimientoTareaEnFaseJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoTareaEnFaseJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoTareaEnFaseJDialog.this.establecerModoTrabajo(7);
                    MantenimientoTareaEnFaseJDialog.this.pPanel.limpiarCampos();
                } else {
                    IAsignable objAsig = (IAsignable)MantenimientoTareaEnFaseJDialog.this.listaAsignable.getSelectedValue();
                    MantenimientoTareaEnFaseJDialog.this.establecerModoTrabajo(2);
                    MantenimientoTareaEnFaseJDialog.this.pPanel.setValoresAsignables(objAsig);
                    MantenimientoTareaEnFaseJDialog.this.botones.modificarButton_mousePressed(null);
                }
            }
        });
        this.getContentPane().add((Component)this.jLabel1, new XYConstraints(20, 15, 185, 20));
        this.listaAsignable.setCellRenderer(new TareaEnFaseCellRenderer());
        this.addControles(this.ANCHO_ACTUAL, this.ALTO_ACTUAL, 4);
        ModelaConf.setVentanaActiva(this);
    }

    public boolean eliminarElemento() {
        if (this.grafico == null) {
            return false;
        }
        if (this.grafico.getDestructorDDP() == null) {
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            return false;
        }
        String msgPanel = new String();
        int[] indicesOriginal = this.listaAsignable.getSelectedIndices();
        this.establecerModoTrabajo(2);
        int nElementos = this.listaAsignable.getSelectedValues().length;
        Object[] options = new Object[]{"Aceptar", "Cancelar"};
        msgPanel = nElementos > 1 ? "\u00bfConfirma eliminar los elementos seleccionados?" : "\u00bfConfirma eliminar el elemento seleccionado?";
        int n = JOptionPane.showOptionDialog(this, msgPanel, "Eliminar", 0, 3, null, options, options[1]);
        if (n == -1) {
            n = 1;
        }
        if (n == 1) {
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.pPanel.restaurarColoresDeFondo();
            return false;
        }
        this.refrescarGrafico();
        int resulEliminar = this.grafico.getDestructorDDP().eliminarTareasEnFase(this.listaAsignable.getSelectedValues());
        if (resulEliminar == 0) {
            msgPanel = nElementos > 1 ? "Ha sido imposible eliminar los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades." : "Ha sido imposible eliminar el elemento seleccionado.\nCompruebe que no est\u00e1 intentando eliminar un elemento relacionado con otras entidades.";
            JOptionPane.showMessageDialog(this, msgPanel, "Atenci\u00f3n", 2);
            this.listaAsignable.setSelectedIndices(indicesOriginal);
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.pPanel.restaurarColoresDeFondo();
            return false;
        }
        if (resulEliminar < nElementos) {
            JOptionPane.showMessageDialog(this, "Ha sido imposible eliminar alguno de los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades.", "Atenci\u00f3n", 2);
        }
        if (this.m_faseActiva != null && this.m_faseActiva.getConjuntoTareasEnFase() != null) {
            this.inicializarListaElementos(this.m_faseActiva.getConjuntoTareasEnFase());
        }
        this.listaAsignable.setSelectedIndex(-1);
        this.establecerModoTrabajo(7);
        this.pPanel.limpiarCampos();
        return true;
    }

    public boolean modificarElemento() {
        this.establecerModoTrabajo(3);
        return true;
    }

    public boolean insertarElemento() {
        this.establecerModoTrabajo(1);
        this.pPanel.inicializarFoco();
        return true;
    }

    public boolean aplicar() {
        boolean bRespuesta = false;
        if (this.getAccion() == 1) {
            bRespuesta = this.aplicarNuevo();
        } else if (this.getAccion() == 3) {
            bRespuesta = this.aplicarModificar();
        }
        if (!bRespuesta) {
            this.botones.setModoModificarPorDefault(false);
        }
        return bRespuesta;
    }

    public boolean aplicarNuevo() {
        TrTareaEnFase tarea = this.pPanel.getTareaEnFaseSeleccionada();
        if (!this.comprobarExistenciaTareaEnFase(tarea, -1)) {
            tarea = null;
            if (!this.pPanel.obtenerValoresCampos()) {
                return false;
            }
            tarea = (TrTareaEnFase)this.pPanel.getValoresAsignables();
            if (tarea == null) {
                return false;
            }
        } else {
            JOptionPane.showMessageDialog(this, "Imposible crear la tarea en fase:\nYa existe una tarea en fase con estas caracter\u00edsticas.", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            return false;
        }
        this.listaAsignable.addItem(tarea);
        this.listaAsignable.setSelectedValue(tarea, true);
        this.listaAsignable.updateUI();
        this.aplicarFiltro(false);
        return true;
    }

    public boolean aplicarModificar() {
        int nSelectedIndex;
        TrTareaEnFase tarea = this.pPanel.getTareaEnFaseSeleccionada();
        if (!this.comprobarExistenciaTareaEnFase(tarea, nSelectedIndex = this.listaAsignable.getSelectedIndex())) {
            if (!this.pPanel.obtenerValoresCampos()) {
                return false;
            }
        } else {
            JOptionPane.showMessageDialog(this, "Imposible modificar la tarea en fase:\nYa existe una tarea en fase con estas caracter\u00edsticas.", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            return false;
        }
        this.listaAsignable.updateUI();
        this.aplicarFiltro(false);
        return true;
    }

    public boolean cancelar() {
        if (this.listaAsignable == null) {
            this.pPanel.limpiarCampos();
            this.establecerModoTrabajo(7);
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            this.establecerModoTrabajo(7);
            this.pPanel.limpiarCampos();
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        int index = this.listaAsignable.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        this.listaAsignable.setSelectedIndex(index);
        IAsignable obj = this.listaAsignable.getElementAt(index);
        this.pPanel.setValoresAsignables(obj);
        this.establecerModoTrabajo(2);
        return true;
    }

    public boolean refrescarGrafico() {
        if (this.elementosAsignados != null) {
            ((ConjuntoDatosTareaEnFase)this.elementosAsignados).setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public void cerrar() {
        this.refrescarGrafico();
    }

    public void inicializarListaElementos(ConjuntoDatos cdElementos) {
        cdElementos.ordenar();
        super.inicializarListaElementos(cdElementos);
        this.aplicarFiltro(false);
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        this.grafico = nuevoGrafico;
        this.pPanel.setGrafico(this.grafico);
    }

    public void setTextoFaseActual(String str) {
        this.pPanel.setTextoFaseActual(str);
    }

    public void setFaseActiva(TrFase fase) {
        this.m_faseActiva = fase;
        if (this.pPanel != null) {
            this.pPanel.setFaseActiva(fase);
        }
    }

    private void aplicarFiltro(boolean bCrearModel) {
        if (this.m_strTipoTarea != null && !this.m_strTipoTarea.equals("")) {
            if (bCrearModel) {
                this.model = new TareaEnFaseListModelFilter(this.listaAsignable.getModel());
                this.model.setTareasEnFase(this.m_strTipoTarea);
                this.listaAsignable.setFiltro(this.model);
            } else {
                this.model.setTareasEnFase(this.m_strTipoTarea);
            }
        }
    }

    public boolean comprobarExistenciaTareaEnFase(TrTareaEnFase tareaFase, int nSelectedIndex) {
        if (tareaFase == null || tareaFase.getTarea() == null) {
            return false;
        }
        boolean bBloque = false;
        if (tareaFase.getTarea() instanceof TrBloquePermitido) {
            bBloque = true;
        }
        boolean bTarea = false;
        boolean bTareaLlamente = false;
        boolean bEtiqueta = false;
        boolean bValida = false;
        boolean bEncontrado = false;
        for (int i = 0; i < this.listaAsignable.getNumItems() && !bEncontrado; ++i) {
            bTarea = false;
            bTareaLlamente = false;
            bEtiqueta = false;
            bValida = false;
            bEncontrado = false;
            TrTareaEnFase tareaFaseAux = (TrTareaEnFase)this.listaAsignable.getElementAt(i);
            if (tareaFaseAux != null && i != nSelectedIndex && tareaFaseAux.getTarea() != null && tareaFase.getTarea().getID() == tareaFaseAux.getTarea().getID()) {
                bTarea = true;
                if (tareaFase.getTareaLlamante() != null) {
                    if (tareaFaseAux.getTareaLlamante() != null && tareaFase.getTareaLlamante().getID() == tareaFaseAux.getTareaLlamante().getID()) {
                        bTareaLlamente = true;
                    }
                } else if (tareaFase.getTareaLlamante() == null && tareaFaseAux.getTareaLlamante() == null) {
                    bTareaLlamente = true;
                }
                if (tareaFase.getETIQUETA().equals(tareaFaseAux.getETIQUETA())) {
                    bEtiqueta = true;
                }
                if (tareaFase.getVALIDA().equals(tareaFaseAux.getVALIDA())) {
                    bValida = true;
                }
            }
            if (bBloque) {
                if (bTarea && bTareaLlamente && bEtiqueta && bValida) {
                    bEncontrado = true;
                    continue;
                }
                bEncontrado = false;
                continue;
            }
            bEncontrado = bTarea;
        }
        return bEncontrado;
    }
}

