/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import gdtel.ui.swing.excontrols.JFiltroTextArea;
import gdtel.ui.swing.excontrols.JFiltroTextField;
import gdtel.ui.swing.excontrols.JPanelAtributable;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.obj.TrAviso;
import modela.ui.ModelaUI;

public class PropAvisoJPanel
extends JPanelAtributable {
    private static final long serialVersionUID = 2020899441202911572L;
    JFiltroTextField nombreTextField = new JFiltroTextField();
    private JLabel jLabel1 = new JLabel();
    private JLabel decripAreaLabel = new JLabel();
    private JFiltroTextArea decripTextArea = new JFiltroTextArea();
    private JLabel jLabel2 = new JLabel();
    private XYLayout xYLayout = new XYLayout();
    private Color colorFondoNombre = null;
    private Color colorFondoDescripcion = null;

    public PropAvisoJPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void jbInit() {
        this.setLayout(this.xYLayout);
        this.jLabel1.setText("Nombre:");
        this.jLabel1.setFont(ModelaUI.fuentePrincipalNegrita);
        this.decripAreaLabel.setText("Descripci\u00f3n:");
        this.decripAreaLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.jLabel2.setText("Propiedades del aviso");
        this.jLabel2.setFont(ModelaUI.fuentePrincipalNegrita);
        this.jLabel2.setForeground(ModelaUI.colorSeleccion);
        this.nombreTextField.setNumItems(50);
        this.nombreTextField.establecerTipografia(1);
        this.nombreTextField.setTipoFiltro(1);
        this.nombreTextField.setEnabled(true);
        this.nombreTextField.setEditable(false);
        this.decripTextArea.setNumItems(250);
        this.decripTextArea.establecerTipografia(1);
        this.decripTextArea.setTipoFiltro(1);
        this.decripTextArea.setEnabled(true);
        this.decripTextArea.setEditable(false);
        this.add((Component)this.jLabel2, new XYConstraints(0, 0, 200, 20));
        this.add((Component)this.jLabel1, new XYConstraints(0, 50, 100, 25));
        this.add((Component)this.nombreTextField, new XYConstraints(0, 70, 346, 25));
        this.add((Component)this.decripAreaLabel, new XYConstraints(0, 95, 120, 25));
        this.add((Component)this.decripTextArea.getScrollableArea(), new XYConstraints(0, 118, 346, 200));
        this.decripTextArea.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                if (evt.getKeyChar() == '\t') {
                    PropAvisoJPanel.this.nombreTextField.requestFocus();
                }
            }
        });
    }

    public void limpiarCampos() {
        this.nombreTextField.setText("");
        this.decripTextArea.setText("");
    }

    public void inicializarCampos(int nTipo) {
        boolean activo = false;
        switch (nTipo) {
            case 4: {
                this.conservarColoresDeFondo();
                break;
            }
            case 2: {
                activo = false;
                break;
            }
            case 3: {
                activo = true;
                break;
            }
            case 1: {
                this.iDatoAsignable = new TrAviso();
                this.limpiarCampos();
                activo = true;
            }
        }
        this.nombreTextField.setEditable(activo);
        this.decripTextArea.setEditable(activo);
    }

    public IAsignable getValoresAsignables() {
        return this.iDatoAsignable;
    }

    public void setValoresAsignables(IAsignable datosAsignables) {
        if (datosAsignables != null && datosAsignables instanceof TrAviso) {
            this.iDatoAsignable = datosAsignables;
            TrAviso Aviso = (TrAviso)datosAsignables;
            this.nombreTextField.setText(Aviso.getNOMBRE());
            this.decripTextArea.setText(Aviso.getDESCRIPCION());
        }
    }

    public String getTitulo(int n) {
        return "Mantenimiento de avisos";
    }

    public boolean obtenerValoresCampos() {
        TrAviso trAviso = null;
        boolean ok = true;
        trAviso = new TrAviso();
        trAviso = (TrAviso)this.iDatoAsignable;
        if (trAviso == null) {
            ok = false;
        } else if (this.nombreTextField.getText() == null || this.decripTextArea.getText() == null) {
            ok = false;
        } else if (this.nombreTextField.getText().equals("") || this.decripTextArea.getText().equals("")) {
            ok = false;
        }
        if (!ok) {
            JOptionPane.showMessageDialog(null, MantenimientoJDialog.TEXTO_FALTAN_ATRIBUTOS_OBLIGATORIOS, MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
        } else if (trAviso != null) {
            trAviso.setNOMBRE(this.nombreTextField.getText());
            trAviso.setDESCRIPCION(this.decripTextArea.getText());
        }
        return ok;
    }

    public String getNombreTmp() {
        return this.nombreTextField.getText();
    }

    public void inicializarFoco() {
        this.nombreTextField.requestFocus();
    }

    public void conservarColoresDeFondo() {
        this.colorFondoNombre = this.nombreTextField.getBackground();
        this.colorFondoDescripcion = this.decripTextArea.getBackground();
    }

    public void restaurarColoresDeFondo() {
        if (this.colorFondoNombre != null) {
            this.nombreTextField.setBackground(this.colorFondoNombre);
            this.colorFondoNombre = null;
        }
        if (this.colorFondoDescripcion != null) {
            this.decripTextArea.setBackground(this.colorFondoDescripcion);
            this.colorFondoDescripcion = null;
        }
    }
}

