/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import gdtel.ui.swing.excontrols.CreadorButton;
import gdtel.ui.swing.excontrols.JCheckBoxEx;
import gdtel.ui.swing.excontrols.JComboBoxEx;
import gdtel.ui.swing.excontrols.JFiltroTextArea;
import gdtel.ui.swing.excontrols.JFiltroTextField;
import gdtel.ui.swing.excontrols.JListAsignable;
import gdtel.ui.swing.excontrols.JPanelAtributable;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.obj.TrBloque;
import modela.bd.obj.TrParametro;
import modela.bd.obj.TrTipoBloque;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.MantenimientoParametrosJDialog;

public class PropBloqueJPanel
extends JPanelAtributable {
    private static final long serialVersionUID = -1388671634489078774L;
    private DDPGrafico grafico = null;
    private final XYLayout xYLayout = new XYLayout();
    private final JLabel labelCabecera = new JLabel();
    private final JLabel labelNombre = new JLabel();
    private final JLabel labelDescripcion = new JLabel();
    private final JLabel labelTipo = new JLabel();
    private final JLabel labelParametros = new JLabel();
    private final JFiltroTextField nombreField = new JFiltroTextField();
    private final JFiltroTextArea descripArea = new JFiltroTextArea();
    JCheckBoxEx informarCheck = new JCheckBoxEx();
    private final JComboBoxEx cmbTipo = new JComboBoxEx();
    private final JListAsignable listaParametros = new JListAsignable();
    ImageIcon eliminarIconN = new ImageIcon(PropBloqueJPanel.class.getResource(ModelaUI.IMG_SMALL_ELIMINAR));
    ImageIcon eliminarIconS = new ImageIcon(PropBloqueJPanel.class.getResource(ModelaUI.IMG_SMALL_ELIMINAR_SOBRE));
    ImageIcon eliminarIconD = new ImageIcon(PropBloqueJPanel.class.getResource(ModelaUI.IMG_SMALL_ELIMINAR_NO_ENABLED));
    ImageIcon agregarIconN = new ImageIcon(PropBloqueJPanel.class.getResource(ModelaUI.IMG_SMALL_AGREGAR));
    ImageIcon agregarIconS = new ImageIcon(PropBloqueJPanel.class.getResource(ModelaUI.IMG_SMALL_AGREGAR_SOBRE));
    ImageIcon agregarIconD = new ImageIcon(PropBloqueJPanel.class.getResource(ModelaUI.IMG_SMALL_AGREGAR_NO_ENABLED));
    ImageIcon flechaArribaIconN = new ImageIcon(PropBloqueJPanel.class.getResource(ModelaUI.IMG_SMALL_FLECHA_ARRIBA));
    ImageIcon flechaArribaIconD = new ImageIcon(PropBloqueJPanel.class.getResource(ModelaUI.IMG_SMALL_FLECHA_ARRIBA_NO_ENABLED));
    ImageIcon flechaArribaIconS = new ImageIcon(PropBloqueJPanel.class.getResource(ModelaUI.IMG_SMALL_FLECHA_ARRIBA_SOBRE));
    ImageIcon flechaArribaIconB = new ImageIcon(PropBloqueJPanel.class.getResource(ModelaUI.IMG_SMALL_FLECHA_ARRIBA_PRESS));
    ImageIcon flechaAbajoIconN = new ImageIcon(PropBloqueJPanel.class.getResource(ModelaUI.IMG_SMALL_FLECHA_ABAJO));
    ImageIcon flechaAbajoIconD = new ImageIcon(PropBloqueJPanel.class.getResource(ModelaUI.IMG_SMALL_FLECHA_ABAJO_NO_ENABLED));
    ImageIcon flechaAbajoIconS = new ImageIcon(PropBloqueJPanel.class.getResource(ModelaUI.IMG_SMALL_FLECHA_ABAJO_SOBRE));
    ImageIcon flechaAbajoIconB = new ImageIcon(PropBloqueJPanel.class.getResource(ModelaUI.IMG_SMALL_FLECHA_ABAJO_PRESS));
    private final JButton btnAgregarParametro = (JButton)CreadorButton.crearBoton(1, false, this.agregarIconN, this.agregarIconD, this.agregarIconS, this.agregarIconS);
    private final JButton btnEliminarParametro = (JButton)CreadorButton.crearBoton(1, false, this.eliminarIconN, this.eliminarIconD, this.eliminarIconS, this.eliminarIconS);
    private final JButton btnSubir = (JButton)CreadorButton.crearBoton(1, false, this.flechaAbajoIconN, this.flechaAbajoIconD, this.flechaAbajoIconB, this.flechaAbajoIconS);
    private final JButton btnBajar = (JButton)CreadorButton.crearBoton(1, false, this.flechaArribaIconN, this.flechaArribaIconD, this.flechaArribaIconB, this.flechaArribaIconS);
    private TrBloque bloqueSeleccionado = null;
    private Color colorFondoNombre = null;
    private Color colorFondoDescripcion = null;
    private Color colorFondoTipo = null;
    private Color colorFondoInformar = null;
    private Color colorFondoLista = null;

    public PropBloqueJPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void jbInit() {
        this.setLayout(this.xYLayout);
        this.labelCabecera.setText("Propiedades del bloque");
        this.labelCabecera.setFont(ModelaUI.fuentePrincipalNegrita);
        this.labelCabecera.setForeground(ModelaUI.colorSeleccion);
        this.labelNombre.setText("Nombre:");
        this.labelNombre.setFont(ModelaUI.fuentePrincipalNegrita);
        this.labelDescripcion.setText("Descripci\u00f3n:");
        this.labelDescripcion.setFont(ModelaUI.fuentePrincipalNegrita);
        this.labelTipo.setText("Tipo:");
        this.labelTipo.setFont(ModelaUI.fuentePrincipalNegrita);
        this.labelParametros.setText("Par\u00e1metros del bloque:");
        this.nombreField.setNumItems(50);
        this.nombreField.setTipoFiltro(1);
        this.nombreField.setEnabled(true);
        this.nombreField.setEditable(false);
        this.descripArea.setNumItems(250);
        this.descripArea.establecerTipografia(1);
        this.descripArea.setTipoFiltro(1);
        this.descripArea.setEnabled(true);
        this.descripArea.setEditable(false);
        this.informarCheck.setText("Informar");
        this.informarCheck.setEnabled(false);
        this.listaParametros.setFocusable(false);
        this.btnAgregarParametro.setBorderPainted(false);
        this.btnAgregarParametro.setFocusPainted(false);
        this.btnEliminarParametro.setBorderPainted(false);
        this.btnEliminarParametro.setFocusPainted(false);
        this.btnBajar.setBorderPainted(false);
        this.btnBajar.setFocusPainted(false);
        this.btnSubir.setBorderPainted(false);
        this.btnSubir.setFocusPainted(false);
        this.add((Component)this.labelCabecera, new XYConstraints(0, 0, 185, 15));
        this.add((Component)this.labelNombre, new XYConstraints(0, 50, 70, 20));
        this.add((Component)this.nombreField, new XYConstraints(0, 70, 315, 25));
        this.add((Component)this.labelTipo, new XYConstraints(335, 50, 65, 20));
        this.add((Component)this.cmbTipo, new XYConstraints(335, 70, 85, 25));
        this.add((Component)this.labelDescripcion, new XYConstraints(0, 95, 100, 20));
        this.add((Component)this.descripArea.getScrollableArea(), new XYConstraints(0, 115, 420, 75));
        this.add((Component)this.informarCheck, new XYConstraints(0, 198, 80, 25));
        this.add((Component)this.labelParametros, new XYConstraints(0, 235, 175, 15));
        this.add((Component)this.listaParametros.getScrollableArea(), new XYConstraints(0, 250, 385, 70));
        this.add((Component)this.btnAgregarParametro, new XYConstraints(110, 325, 85, 25));
        this.add((Component)this.btnEliminarParametro, new XYConstraints(200, 325, 85, 25));
        this.add((Component)this.btnBajar, new XYConstraints(390, 270, 30, 20));
        this.add((Component)this.btnSubir, new XYConstraints(390, 295, 30, 20));
        this.btnAgregarParametro.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropBloqueJPanel.this.btnAgregarParametroButton_actionPerformed(e);
            }
        });
        this.listaParametros.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\u007f') {
                    PropBloqueJPanel.this.eliminarParametro_actionPerformed();
                }
            }
        });
        this.btnEliminarParametro.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropBloqueJPanel.this.eliminarParametro_actionPerformed();
            }
        });
        this.btnSubir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropBloqueJPanel.this.btnSubirButton_actionPerformed(e);
            }
        });
        this.btnBajar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropBloqueJPanel.this.btnBajarButton_actionPerformed(e);
            }
        });
        this.descripArea.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                if (evt.getKeyChar() == '\t') {
                    PropBloqueJPanel.this.informarCheck.requestFocus();
                }
            }
        });
        this.cmbTipo.setEditable(false);
        this.cargarCmbTipos();
    }

    public void limpiarCampos() {
        this.nombreField.setText("");
        this.descripArea.setText("");
        this.informarCheck.setSelected(false);
        this.listaParametros.removeAllItems();
        this.cmbTipo.setSelectedIndex(0);
    }

    public void inicializarCampos(int nTipo) {
        boolean bReiniciarColoresLabel = true;
        boolean activo = false;
        switch (nTipo) {
            case 4: {
                this.conservarColoresDeFondo();
                bReiniciarColoresLabel = false;
                break;
            }
            case 2: {
                activo = false;
                bReiniciarColoresLabel = false;
                break;
            }
            case 3: {
                activo = true;
                break;
            }
            case 1: {
                this.iDatoAsignable = new TrBloque();
                this.limpiarCampos();
                activo = true;
            }
        }
        this.nombreField.setEditable(activo);
        this.descripArea.setEditable(activo);
        this.informarCheck.setEnabled(activo);
        this.btnAgregarParametro.setEnabled(activo);
        this.btnEliminarParametro.setEnabled(activo);
        this.btnSubir.setEnabled(activo);
        this.btnBajar.setEnabled(activo);
        this.listaParametros.setEnabled(activo);
        this.cmbTipo.setEnabled(activo);
        if (bReiniciarColoresLabel) {
            // empty if block
        }
    }

    public IAsignable getValoresAsignables() {
        return this.iDatoAsignable;
    }

    public boolean obtenerValoresCampos() {
        boolean ok = true;
        TrBloque trBloque = null;
        trBloque = new TrBloque();
        trBloque = (TrBloque)this.iDatoAsignable;
        if (trBloque == null) {
            ok = false;
        } else if (this.nombreField.getText() == null || this.descripArea.getText() == null) {
            ok = false;
        } else if (this.nombreField.getText().equals("") || this.descripArea.getText().equals("")) {
            ok = false;
        }
        if (this.cmbTipo.getSelectedIndex() < 0) {
            ok = false;
        }
        if (!ok) {
            JOptionPane.showMessageDialog(null, MantenimientoJDialog.TEXTO_FALTAN_ATRIBUTOS_OBLIGATORIOS, MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
        } else {
            if (trBloque != null) {
                trBloque.setNombre(this.nombreField.getText());
                trBloque.setDescripcion(this.descripArea.getText());
                trBloque.setInformar(this.informarCheck.isSelected());
            }
            int nSelectedItem = this.cmbTipo.getSelectedIndex();
            if (trBloque != null) {
                trBloque.setTipoBloque((TrTipoBloque)this.cmbTipo.getItemAt(nSelectedItem));
            }
            int i = 0;
            if (trBloque != null) {
                trBloque.limpiarListaParametros();
            }
            while (i < this.listaParametros.getNumItems()) {
                if (this.listaParametros.getElementAt(i) != null && trBloque != null) {
                    trBloque.addParametro((TrParametro)this.listaParametros.getElementAt(i));
                }
                ++i;
            }
        }
        return ok;
    }

    public void setValoresAsignables(IAsignable datosAsignables) {
        this.bloqueSeleccionado = null;
        if (datosAsignables != null && datosAsignables instanceof TrBloque) {
            this.limpiarCampos();
            this.iDatoAsignable = datosAsignables;
            TrBloque trBloque = null;
            trBloque = (TrBloque)this.iDatoAsignable;
            this.bloqueSeleccionado = (TrBloque)this.iDatoAsignable;
            if (trBloque.getNombre() != null) {
                this.nombreField.setText(trBloque.getNombre());
            }
            if (trBloque.getDescripcion() != null) {
                this.descripArea.setText(trBloque.getDescripcion());
            }
            this.informarCheck.setSelected(trBloque.isInformar());
            this.cmbTipo.setSelectedItem(trBloque.getTipoBloque());
            this.listaParametros.removeAllItems();
            ArrayList arrayParametros = trBloque.getParametros();
            for (int i = 0; i < arrayParametros.size(); ++i) {
                if (arrayParametros.get(i) == null) continue;
                TrParametro parametro = (TrParametro)arrayParametros.get(i);
                this.listaParametros.addItem(parametro);
            }
        }
    }

    public String getTitulo(int nTipo) {
        return "";
    }

    private void cargarCmbTipos() {
        this.cmbTipo.removeAllItems();
        this.cmbTipo.addItem(TrTipoBloque.WEB);
        this.cmbTipo.addItem(TrTipoBloque.FORM);
        this.cmbTipo.addItem(TrTipoBloque.REPORT);
        this.cmbTipo.addItem(TrTipoBloque.OTROS);
        this.cmbTipo.setSelectedIndex(0);
    }

    void btnAgregarParametroButton_actionPerformed(ActionEvent e) {
        MantenimientoParametrosJDialog mttoParametros = new MantenimientoParametrosJDialog();
        mttoParametros.setGrafico(this.grafico);
        if (this.grafico != null) {
            mttoParametros.inicializarListaElementos(this.grafico.getParametrosInvolucrados());
        }
        mttoParametros.setLocationRelativeTo(null);
        mttoParametros.activarSeleccion(true);
        mttoParametros.setVisible(true);
        if (mttoParametros.obtenerElementosSeleccionados() != null) {
            Object[] seleccionMultiple = null;
            seleccionMultiple = mttoParametros.obtenerElementosSeleccionados();
            if (seleccionMultiple != null) {
                boolean bInsertar = true;
                for (int i = 0; i < seleccionMultiple.length; ++i) {
                    bInsertar = true;
                    TrParametro parametro = (TrParametro)seleccionMultiple[i];
                    for (int j = 0; j < this.listaParametros.getNumItems(); ++j) {
                        TrParametro parametroAux = (TrParametro)this.listaParametros.getElementAt(j);
                        if (!parametroAux.equals(parametro)) continue;
                        bInsertar = false;
                    }
                    if (bInsertar) {
                        this.listaParametros.addItem(parametro);
                        this.btnSubir.setEnabled(false);
                        this.btnBajar.setEnabled(false);
                        this.listaParametros.setBackground(ModelaUI.colorFondoTextoModificandose);
                        continue;
                    }
                    JOptionPane.showMessageDialog(this, "El par\u00e1metro " + parametro.toString() + " ya est\u00e1 incluido en la lista.", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
                }
            }
        } else if (mttoParametros.obtenerElementoSeleccionado() != null) {
            TrParametro parametro = (TrParametro)mttoParametros.obtenerElementoSeleccionado();
            boolean bInsertar = true;
            for (int j = 0; j < this.listaParametros.getNumItems(); ++j) {
                TrParametro parametroAux = (TrParametro)this.listaParametros.getElementAt(j);
                if (!parametroAux.equals(parametro)) continue;
                bInsertar = false;
            }
            if (bInsertar) {
                this.listaParametros.addItem(parametro);
                this.btnSubir.setEnabled(false);
                this.btnBajar.setEnabled(false);
                this.listaParametros.setBackground(ModelaUI.colorFondoTextoModificandose);
            } else {
                JOptionPane.showMessageDialog(this, "El par\u00e1metro " + parametro.toString() + " ya est\u00e1 incluido en la lista.", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            }
        }
    }

    public void eliminarParametro_actionPerformed() {
        if (!this.listaParametros.hasAnyObject()) {
            this.inicializarCampos(3);
            return;
        }
        if (this.listaParametros.getSelectedValue() != null) {
            Object[] options;
            int n;
            int[] index = this.listaParametros.getSelectedIndices();
            String msgDel = "\u00bfConfirma eliminar el elemento seleccionado?";
            if (index.length > 1) {
                msgDel = "\u00bfConfirma eliminar los elementos seleccionados?";
            }
            if ((n = JOptionPane.showOptionDialog(this, msgDel, "Eliminar", 0, 3, null, options = new Object[]{"Aceptar", "Cancelar"}, options[1])) == 1 || n == -1) {
                return;
            }
            for (int d = index.length - 1; d >= 0; --d) {
                this.listaParametros.removeItem(index[d]);
            }
            this.btnSubir.setEnabled(false);
            this.btnBajar.setEnabled(false);
            this.listaParametros.setBackground(ModelaUI.colorFondoTextoModificandose);
            if (!this.listaParametros.hasAnyObject()) {
                this.listaParametros.setToolTipText(null);
            }
        }
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        this.grafico = nuevoGrafico;
    }

    public String getNombreTmp() {
        return this.nombreField.getText();
    }

    void btnBajarButton_actionPerformed(ActionEvent e) {
        if (this.bloqueSeleccionado == null) {
            return;
        }
        if (this.bloqueSeleccionado.getParametros() == null) {
            return;
        }
        if (this.bloqueSeleccionado.getParametros().size() <= 0) {
            return;
        }
        if (this.listaParametros.getNumItems() <= 0) {
            return;
        }
        if (this.listaParametros.getNumItems() < 2) {
            return;
        }
        int nSelectedItem = this.listaParametros.getSelectedIndex();
        if (nSelectedItem == 0) {
            return;
        }
        int indiceParametroOrigen = -1;
        int indiceParametroDestino = -1;
        TrParametro parametroOrigen = (TrParametro)this.listaParametros.getElementAt(nSelectedItem);
        if (parametroOrigen == null) {
            return;
        }
        if (!this.bloqueSeleccionado.getParametros().contains(parametroOrigen)) {
            return;
        }
        indiceParametroOrigen = nSelectedItem;
        if (indiceParametroOrigen == -1) {
            return;
        }
        if (this.bloqueSeleccionado.getParametros().size() <= indiceParametroOrigen) {
            return;
        }
        TrParametro parametroDestino = (TrParametro)this.listaParametros.getElementAt(nSelectedItem - 1);
        if (parametroDestino == null) {
            return;
        }
        if (!this.bloqueSeleccionado.getParametros().contains(parametroDestino)) {
            return;
        }
        indiceParametroDestino = nSelectedItem - 1;
        if (indiceParametroDestino == -1) {
            return;
        }
        if (this.bloqueSeleccionado.getParametros().size() <= indiceParametroDestino) {
            return;
        }
        TrParametro parametroAuxiliar = new TrParametro();
        parametroAuxiliar = (TrParametro)this.bloqueSeleccionado.getParametros().get(indiceParametroDestino);
        this.bloqueSeleccionado.getParametros().set(indiceParametroDestino, parametroOrigen);
        this.bloqueSeleccionado.getParametros().set(indiceParametroOrigen, parametroAuxiliar);
        this.listaParametros.removeAllItems();
        ArrayList arrayParametros = this.bloqueSeleccionado.getParametros();
        for (int i = 0; i < arrayParametros.size(); ++i) {
            if (arrayParametros.get(i) == null) continue;
            this.listaParametros.addItem((TrParametro)arrayParametros.get(i));
        }
        this.listaParametros.validate();
        this.validate();
        this.listaParametros.setSelectedIndex(nSelectedItem - 1);
        this.listaParametros.setBackground(ModelaUI.colorFondoTextoModificandose);
    }

    void btnSubirButton_actionPerformed(ActionEvent e) {
        if (this.bloqueSeleccionado == null) {
            return;
        }
        if (this.bloqueSeleccionado.getParametros() == null) {
            return;
        }
        if (this.bloqueSeleccionado.getParametros().size() <= 0) {
            return;
        }
        if (this.listaParametros.getNumItems() <= 0) {
            return;
        }
        if (this.listaParametros.getNumItems() < 2) {
            return;
        }
        int nSelectedItem = this.listaParametros.getSelectedIndex();
        if (nSelectedItem == this.listaParametros.getNumItems() - 1) {
            return;
        }
        int indiceParametroOrigen = -1;
        int indiceParametroDestino = -1;
        TrParametro parametroOrigen = (TrParametro)this.listaParametros.getElementAt(nSelectedItem);
        if (parametroOrigen == null) {
            return;
        }
        if (!this.bloqueSeleccionado.getParametros().contains(parametroOrigen)) {
            return;
        }
        indiceParametroOrigen = nSelectedItem;
        if (indiceParametroOrigen == -1) {
            return;
        }
        if (this.bloqueSeleccionado.getParametros().size() <= indiceParametroOrigen) {
            return;
        }
        TrParametro parametroDestino = (TrParametro)this.listaParametros.getElementAt(nSelectedItem + 1);
        if (parametroDestino == null) {
            return;
        }
        if (!this.bloqueSeleccionado.getParametros().contains(parametroDestino)) {
            return;
        }
        indiceParametroDestino = nSelectedItem + 1;
        if (indiceParametroDestino == -1) {
            return;
        }
        if (this.bloqueSeleccionado.getParametros().size() <= indiceParametroDestino) {
            return;
        }
        TrParametro parametroAuxiliar = new TrParametro();
        parametroAuxiliar = (TrParametro)this.bloqueSeleccionado.getParametros().get(indiceParametroDestino);
        this.bloqueSeleccionado.getParametros().set(indiceParametroDestino, parametroOrigen);
        this.bloqueSeleccionado.getParametros().set(indiceParametroOrigen, parametroAuxiliar);
        this.listaParametros.removeAllItems();
        ArrayList arrayParametros = this.bloqueSeleccionado.getParametros();
        for (int i = 0; i < arrayParametros.size(); ++i) {
            if (arrayParametros.get(i) == null) continue;
            this.listaParametros.addItem((TrParametro)arrayParametros.get(i));
        }
        this.listaParametros.validate();
        this.validate();
        this.listaParametros.setSelectedIndex(nSelectedItem + 1);
        this.listaParametros.setBackground(ModelaUI.colorFondoTextoModificandose);
    }

    public void inicializarFoco() {
        this.nombreField.requestFocus();
    }

    public void conservarColoresDeFondo() {
        this.colorFondoNombre = this.nombreField.getBackground();
        this.colorFondoDescripcion = this.descripArea.getBackground();
        this.colorFondoTipo = this.cmbTipo.getBackground();
        this.colorFondoInformar = this.informarCheck.getForeground();
        this.colorFondoLista = this.listaParametros.getBackground();
    }

    public void restaurarColoresDeFondo() {
        if (this.colorFondoNombre != null) {
            this.nombreField.setBackground(this.colorFondoNombre);
            this.colorFondoNombre = null;
        }
        if (this.colorFondoDescripcion != null) {
            this.descripArea.setBackground(this.colorFondoDescripcion);
            this.colorFondoDescripcion = null;
        }
        if (this.colorFondoTipo != null) {
            this.cmbTipo.setBackground(this.colorFondoTipo);
            this.colorFondoTipo = null;
        }
        if (this.colorFondoInformar != null) {
            this.informarCheck.setForeground(this.colorFondoInformar);
            this.colorFondoInformar = null;
        }
        if (this.colorFondoLista != null) {
            this.listaParametros.setBackground(this.colorFondoLista);
            this.colorFondoLista = null;
        }
    }
}

