/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.ui.IAsignable;
import gdtel.ui.swing.ColorChooserJDialog;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import gdtel.ui.swing.excontrols.JCheckBoxEx;
import gdtel.ui.swing.excontrols.JFiltroTextArea;
import gdtel.ui.swing.excontrols.JFiltroTextField;
import gdtel.ui.swing.excontrols.JPanelAtributable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import modela.bd.obj.TrMetafase;
import modela.bd.obj.TrMetafaseGr;
import modela.ui.ModelaUI;

public class PropMetafaseJPanel
extends JPanelAtributable {
    private static final long serialVersionUID = 6718654419961202534L;
    private final JLabel colorTextoLabel = new JLabel();
    private final JLabel colorFondoLabel = new JLabel();
    private final JPanel panelColorTexto = new JPanel();
    private JPanel panelColorFondo = new JPanel();
    private static final int PROPIEDAD_COLOR_FONDO = 1;
    private static final int PROPIEDAD_COLOR_TEXTO = 2;
    private final JLabel nombreLabel = new JLabel();
    private final JLabel ordenLabel = new JLabel();
    protected JFiltroTextField nombreField = new JFiltroTextField();
    protected JFiltroTextField ordenField = new JFiltroTextField();
    private final JLabel metaLabel = new JLabel();
    private final JLabel descripLabel = new JLabel();
    private final JFiltroTextArea descripArea = new JFiltroTextArea();
    JCheckBoxEx informarCheck = new JCheckBoxEx();
    private final XYLayout xYLayout1 = new XYLayout();
    JCheckBoxEx defaultCheck = new JCheckBoxEx();
    private Color colorFondoNombre = null;
    private Color colorFondoOrden = null;
    private Color colorFondoDescripcion = null;
    private Color colorFondoInformar = null;
    private Color colorFondoDefaultCheck = null;

    public PropMetafaseJPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void inicializarCampos(int nTipo) {
        boolean activo = false;
        switch (nTipo) {
            case 4: {
                this.conservarColoresDeFondo();
                break;
            }
            case 2: {
                activo = false;
                break;
            }
            case 3: {
                activo = true;
                break;
            }
            case 1: {
                this.iDatoAsignable = new TrMetafase();
                ((TrMetafase)this.iDatoAsignable).setNOMBRE("");
                ((TrMetafase)this.iDatoAsignable).setORDEN(null);
                ((TrMetafase)this.iDatoAsignable).setDESCRIPCION("");
                this.limpiarCampos();
                this.panelColorTexto.setBackground(Color.black);
                this.getPanelColorFondo().setBackground(Color.white);
                activo = true;
            }
        }
        this.nombreField.setEditable(activo);
        this.ordenField.setEditable(activo);
        this.descripArea.setEditable(activo);
        this.informarCheck.setEnabled(activo);
        this.defaultCheck.setEnabled(activo);
        this.panelColorTexto.setEnabled(activo);
        this.getPanelColorFondo().setEnabled(activo);
        this.colorTextoLabel.setForeground(Color.BLACK);
        this.colorFondoLabel.setForeground(Color.BLACK);
    }

    public boolean obtenerValoresCampos() {
        TrMetafase trMeta = null;
        boolean ok = true;
        if (this.nombreField.getText() == null || this.descripArea.getText() == null) {
            ok = false;
        } else if (this.nombreField.getText().equals("") || this.descripArea.getText().equals("")) {
            ok = false;
        }
        if (!ok) {
            JOptionPane.showMessageDialog(null, MantenimientoJDialog.TEXTO_FALTAN_ATRIBUTOS_OBLIGATORIOS, MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
        } else {
            trMeta = (TrMetafase)this.iDatoAsignable;
            if (trMeta == null) {
                return false;
            }
            trMeta.setNOMBRE(this.nombreField.getText());
            try {
                if (this.ordenField.getText() != null && !this.ordenField.getText().equals("")) {
                    trMeta.setORDEN(new Integer(Integer.parseInt(this.ordenField.getText())));
                } else {
                    trMeta.setORDEN(null);
                }
            }
            catch (NumberFormatException excep) {
                JOptionPane.showMessageDialog(this, "Orden no v\u00e1lido", "Atenci\u00f3n", 2);
                this.ordenField.setText("");
                return false;
            }
            trMeta.setDESCRIPCION(this.descripArea.getText());
            trMeta.setINFORMAR(this.informarCheck.isSelected());
            trMeta.setDefaultMetafase(this.defaultCheck.isSelected());
            if (trMeta.getPropiedadesGraficas() != null && trMeta.getPropiedadesGraficas().getColorFondo() != null && trMeta.getPropiedadesGraficas().getColorTexto() != null) {
                TrMetafaseGr nuevasPropiedades = new TrMetafaseGr();
                nuevasPropiedades.setColorFondo(this.getPanelColorFondo().getBackground());
                nuevasPropiedades.setColorTexto(this.panelColorTexto.getBackground());
                trMeta.setPropiedadesGraficas(nuevasPropiedades);
            }
        }
        return ok;
    }

    public String getTitulo(int nTipo) {
        String strTitulo = "";
        return strTitulo;
    }

    public void setValoresAsignables(IAsignable datosAsignables) {
        if (datosAsignables != null && datosAsignables instanceof TrMetafase) {
            this.iDatoAsignable = datosAsignables;
            TrMetafase trMeta = null;
            this.limpiarCampos();
            trMeta = (TrMetafase)this.iDatoAsignable;
            if (trMeta.getNOMBRE() != null) {
                this.nombreField.setText(trMeta.getNOMBRE());
            }
            if (trMeta.getORDEN() != null) {
                this.ordenField.setText(trMeta.getORDEN().toString());
            }
            if (trMeta.getDESCRIPCION() != null) {
                this.descripArea.setText(trMeta.getDESCRIPCION());
            }
            this.informarCheck.setSelected(trMeta.isInformar());
            this.defaultCheck.setSelected(trMeta.isDefaultMetafase());
            if (trMeta.getPropiedadesGraficas() != null) {
                TrMetafaseGr propiedadesGrActuales = trMeta.getPropiedadesGraficas();
                if (propiedadesGrActuales.getColorFondo() != null) {
                    this.getPanelColorFondo().setBackground(propiedadesGrActuales.getColorFondo());
                }
                if (propiedadesGrActuales.getColorTexto() != null) {
                    this.panelColorTexto.setBackground(propiedadesGrActuales.getColorTexto());
                }
            }
        }
    }

    public IAsignable getValoresAsignables() {
        return this.iDatoAsignable;
    }

    public void limpiarCampos() {
        this.nombreField.setText("");
        this.descripArea.setText("");
        this.ordenField.setText("");
        this.informarCheck.setSelected(false);
        this.defaultCheck.setSelected(false);
        this.panelColorTexto.setBackground(this.getBackground());
        this.getPanelColorFondo().setBackground(this.getBackground());
    }

    private void jbInit() throws Exception {
        this.setLayout(this.xYLayout1);
        this.metaLabel.setText("Propiedades de la metafase");
        this.metaLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.metaLabel.setForeground(ModelaUI.colorSeleccion);
        this.nombreLabel.setText("Nombre:");
        this.nombreLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.ordenLabel.setText("Orden:");
        this.descripLabel.setText("Descripci\u00f3n:");
        this.descripLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.nombreField.establecerTipografia(1);
        this.nombreField.setTipoFiltro(1);
        this.nombreField.setNumItems(50);
        this.nombreField.setEnabled(true);
        this.nombreField.setEditable(false);
        this.ordenField.setTipoFiltro(2);
        this.ordenField.setNumItems(2);
        this.ordenField.setEnabled(true);
        this.ordenField.setEditable(false);
        this.descripArea.setBorder(BorderFactory.createBevelBorder(1));
        this.descripArea.establecerTipografia(1);
        this.descripArea.setTipoFiltro(1);
        this.descripArea.setNumItems(250);
        this.descripArea.setEnabled(true);
        this.descripArea.setEditable(false);
        this.informarCheck.setText("Informar");
        this.defaultCheck.setText("Metafase por defecto");
        this.informarCheck.setEnabled(false);
        this.defaultCheck.setEnabled(false);
        this.add((Component)this.metaLabel, new XYConstraints(0, 0, 210, 20));
        this.add((Component)this.nombreLabel, new XYConstraints(0, 50, 68, 20));
        this.add((Component)this.nombreField, new XYConstraints(0, 70, 275, 25));
        this.add((Component)this.ordenLabel, new XYConstraints(290, 50, 45, 20));
        this.add((Component)this.ordenField, new XYConstraints(290, 70, 55, 25));
        this.add((Component)this.descripLabel, new XYConstraints(0, 95, 120, 25));
        this.add((Component)this.descripArea.getScrollableArea(), new XYConstraints(0, 115, 345, 115));
        this.add((Component)this.informarCheck, new XYConstraints(0, 235, 80, 25));
        this.add((Component)this.defaultCheck, new XYConstraints(110, 235, 150, 25));
        this.colorTextoLabel.setText("Color del texto:");
        this.colorFondoLabel.setText("Color de fondo:");
        this.panelColorTexto.setBackground(this.getBackground());
        this.getPanelColorFondo().setBackground(this.getBackground());
        this.panelColorTexto.setEnabled(false);
        this.getPanelColorFondo().setEnabled(false);
        this.panelColorTexto.setCursor(new Cursor(12));
        this.getPanelColorFondo().setCursor(new Cursor(12));
        this.panelColorTexto.setBorder(BorderFactory.createEtchedBorder());
        this.getPanelColorFondo().setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.colorTextoLabel, new XYConstraints(0, 290, 100, 25));
        this.add((Component)this.panelColorTexto, new XYConstraints(100, 288, 40, 25));
        this.add((Component)this.colorFondoLabel, new XYConstraints(0, 320, 100, 25));
        this.add((Component)this.getPanelColorFondo(), new XYConstraints(100, 318, 40, 25));
        this.getPanelColorFondo().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (PropMetafaseJPanel.this.getPanelColorFondo().isEnabled()) {
                    PropMetafaseJPanel.this.elegirColor(1);
                }
            }
        });
        this.panelColorTexto.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (PropMetafaseJPanel.this.getPanelColorFondo().isEnabled()) {
                    PropMetafaseJPanel.this.elegirColor(2);
                }
            }
        });
        this.descripArea.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                if (evt.getKeyChar() == '\t') {
                    PropMetafaseJPanel.this.informarCheck.requestFocus();
                }
            }
        });
    }

    public String getNombreTmp() {
        return this.nombreField.getText();
    }

    public boolean isDefaultTmp() {
        return this.defaultCheck.isSelected();
    }

    public void inicializarFoco() {
        this.nombreField.requestFocus();
    }

    public void conservarColoresDeFondo() {
        this.colorFondoNombre = this.nombreField.getBackground();
        this.colorFondoOrden = this.ordenField.getBackground();
        this.colorFondoDescripcion = this.descripArea.getBackground();
        this.colorFondoInformar = this.informarCheck.getForeground();
        this.colorFondoDefaultCheck = this.defaultCheck.getForeground();
    }

    public void restaurarColoresDeFondo() {
        if (this.colorFondoNombre != null) {
            this.nombreField.setBackground(this.colorFondoNombre);
            this.colorFondoNombre = null;
        }
        if (this.colorFondoOrden != null) {
            this.ordenField.setBackground(this.colorFondoOrden);
            this.colorFondoOrden = null;
        }
        if (this.colorFondoDescripcion != null) {
            this.descripArea.setBackground(this.colorFondoDescripcion);
            this.colorFondoDescripcion = null;
        }
        if (this.colorFondoInformar != null) {
            this.informarCheck.setForeground(this.colorFondoInformar);
            this.colorFondoInformar = null;
        }
        if (this.colorFondoDefaultCheck != null) {
            this.defaultCheck.setForeground(this.colorFondoDefaultCheck);
            this.colorFondoDefaultCheck = null;
        }
    }

    public void elegirColor(int nPropiedad) {
        ColorChooserJDialog colorChooser = new ColorChooserJDialog();
        colorChooser.setLocationRelativeTo(null);
        colorChooser.setVisible(true);
        if (colorChooser.getAcepta()) {
            switch (nPropiedad) {
                case 1: {
                    this.colorFondoLabel.setForeground(ModelaUI.colorFuenteEtiquetaModificandose);
                    if (colorChooser.getColorActual() != null) {
                        this.getPanelColorFondo().setBackground(colorChooser.getColorActual());
                        break;
                    }
                    this.getPanelColorFondo().setBackground(Color.WHITE);
                    break;
                }
                case 2: {
                    this.colorTextoLabel.setForeground(ModelaUI.colorFuenteEtiquetaModificandose);
                    if (colorChooser.getColorActual() != null) {
                        this.panelColorTexto.setBackground(colorChooser.getColorActual());
                        break;
                    }
                    this.panelColorTexto.setBackground(Color.WHITE);
                }
            }
        }
    }

    public void setPanelColorFondo(JPanel panelColorFondo) {
        this.panelColorFondo = panelColorFondo;
    }

    public JPanel getPanelColorFondo() {
        return this.panelColorFondo;
    }
}

