/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import gdtel.ui.swing.excontrols.CreadorButton;
import gdtel.ui.swing.excontrols.JCheckBoxEx;
import gdtel.ui.swing.excontrols.JComboBoxEx;
import gdtel.ui.swing.excontrols.JFiltroTextField;
import gdtel.ui.swing.excontrols.JPanelAtributable;
import gdtel.ui.swing.excontrols.JTableTransiciones;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.obj.ConjuntoDatosTransicion;
import modela.bd.obj.ConjuntoDatosTransicionDefProcedimiento;
import modela.bd.obj.TrPlazoCompuestoDefProc;
import modela.bd.obj.TrTransicion;
import modela.bd.obj.TrTransicionDefProcedimiento;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.MantenimientoTransicionJDialog;
import modela.ui.swing.renderers.TransicionesTableCellRenderer;

public class PropPlazoCompuestoDefProcJPanel
extends JPanelAtributable {
    private static final long serialVersionUID = 5567874658660570973L;
    private JFiltroTextField abrevTextField = new JFiltroTextField();
    private JLabel abrevLabel = new JLabel();
    private JFiltroTextField descTextField = new JFiltroTextField();
    private JLabel descLabel = new JLabel();
    private JLabel tipoLabel = new JLabel();
    private JLabel unidadesLabel = new JLabel();
    private JFiltroTextField unidadesTextField = new JFiltroTextField();
    private JLabel unidadLabel = new JLabel();
    private JComboBoxEx tipoCombo = new JComboBoxEx();
    private JComboBoxEx unidadCombo = new JComboBoxEx();
    private JCheckBoxEx isVigenteCheck = new JCheckBoxEx();
    private JLabel jLabel2 = new JLabel();
    private XYLayout xYLayout = new XYLayout();
    private JLabel tablaTransicionesIniLabel = new JLabel();
    private JTableTransiciones tablaTransicionesIni;
    private JLabel tablaTransicionesFinLabel = new JLabel();
    private JTableTransiciones tablaTransicionesFin;
    DDPGrafico grafico = null;
    ImageIcon seleccionarIconN = new ImageIcon(PropPlazoCompuestoDefProcJPanel.class.getResource(ModelaUI.IMG_SMALL_SELECCION));
    ImageIcon seleccionarIconS = new ImageIcon(PropPlazoCompuestoDefProcJPanel.class.getResource(ModelaUI.IMG_SMALL_SELECCION_SOBRE));
    ImageIcon seleccionarIconD = new ImageIcon(PropPlazoCompuestoDefProcJPanel.class.getResource(ModelaUI.IMG_SMALL_SELECCION_NO_ENABLED));
    ImageIcon eliminarIconN = new ImageIcon(PropPlazoCompuestoDefProcJPanel.class.getResource(ModelaUI.IMG_SMALL_ELIMINAR));
    ImageIcon eliminarIconS = new ImageIcon(PropPlazoCompuestoDefProcJPanel.class.getResource(ModelaUI.IMG_SMALL_ELIMINAR_SOBRE));
    ImageIcon eliminarIconD = new ImageIcon(PropPlazoCompuestoDefProcJPanel.class.getResource(ModelaUI.IMG_SMALL_ELIMINAR_NO_ENABLED));
    ImageIcon agregarIconN = new ImageIcon(PropPlazoCompuestoDefProcJPanel.class.getResource(ModelaUI.IMG_SMALL_AGREGAR));
    ImageIcon agregarIconS = new ImageIcon(PropPlazoCompuestoDefProcJPanel.class.getResource(ModelaUI.IMG_SMALL_AGREGAR_SOBRE));
    ImageIcon agregarIconD = new ImageIcon(PropPlazoCompuestoDefProcJPanel.class.getResource(ModelaUI.IMG_SMALL_AGREGAR_NO_ENABLED));
    private JButton selTablaIniButton = (JButton)CreadorButton.crearBoton(1, false, this.seleccionarIconN, this.seleccionarIconD, this.seleccionarIconS, this.seleccionarIconS);
    private JButton eliTablaIniButton = (JButton)CreadorButton.crearBoton(1, false, this.eliminarIconN, this.eliminarIconD, this.eliminarIconS, this.eliminarIconS);
    private JButton selTablaFinButton = (JButton)CreadorButton.crearBoton(1, false, this.agregarIconN, this.agregarIconD, this.agregarIconS, this.agregarIconS);
    private JButton eliTablaFinButton = (JButton)CreadorButton.crearBoton(1, false, this.eliminarIconN, this.eliminarIconD, this.eliminarIconS, this.eliminarIconS);
    TrPlazoCompuestoDefProc trPlazoCompuesto = null;
    private Color colorFondoAbreviatura = null;
    private Color colorFondoDescripcion = null;
    private Color colorFondoTipo = null;
    private Color colorFondoUnidades = null;
    private Color colorFondoUnidad = null;
    private Color colorFondoVigente = null;
    private Color colorFuenteTransiIni = null;
    private Color colorFuenteTransiFin = null;

    public PropPlazoCompuestoDefProcJPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void jbInit() {
        this.setLayout(this.xYLayout);
        this.jLabel2.setText("Propiedades de plazos compuestos en el procedimiento");
        this.jLabel2.setFont(ModelaUI.fuentePrincipalNegrita);
        this.jLabel2.setForeground(ModelaUI.colorSeleccion);
        this.abrevLabel.setText("Abreviatura:");
        this.abrevLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.descLabel.setText("Descripci\u00f3n:");
        this.descLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.tipoLabel.setText("Tipo:");
        this.tipoLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.unidadesLabel.setText("Unidades:");
        this.unidadesLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.unidadLabel.setText("Unidad:");
        this.unidadLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.abrevTextField.setNumItems(10);
        this.abrevTextField.establecerTipografia(1);
        this.abrevTextField.setTipoFiltro(1);
        this.abrevTextField.setEnabled(true);
        this.abrevTextField.setEditable(false);
        this.descTextField.setNumItems(50);
        this.descTextField.establecerTipografia(1);
        this.descTextField.setTipoFiltro(1);
        this.abrevTextField.setEnabled(true);
        this.descTextField.setEditable(false);
        this.unidadesTextField.setNumItems(2);
        this.unidadesTextField.establecerTipografia(1);
        this.unidadesTextField.setTipoFiltro(2);
        this.unidadesTextField.setEnabled(true);
        this.unidadesTextField.setEditable(false);
        this.isVigenteCheck.setText("Vigente");
        this.isVigenteCheck.setFocusPainted(true);
        this.isVigenteCheck.setEnabled(true);
        this.tablaTransicionesIniLabel.setText("Transici\u00f3n en la que empieza a contar el plazo compuesto");
        this.tablaTransicionesIniLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.tablaTransicionesIni = new JTableTransiciones();
        this.tablaTransicionesIni.setDefaultRenderer(this.tablaTransicionesIni.getColumnClass(0), new TransicionesTableCellRenderer());
        this.tablaTransicionesIni.setAutoscrolls(true);
        this.tablaTransicionesIni.setFocusable(false);
        this.tablaTransicionesFinLabel.setText("Transiciones en las que termina la cuenta para el plazo compuesto");
        this.tablaTransicionesFinLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.tablaTransicionesFin = new JTableTransiciones();
        this.tablaTransicionesFin.setDefaultRenderer(this.tablaTransicionesFin.getColumnClass(0), new TransicionesTableCellRenderer());
        this.tablaTransicionesFin.setFocusable(false);
        this.add((Component)this.jLabel2, new XYConstraints(0, 0, 400, 15));
        this.add((Component)this.abrevLabel, new XYConstraints(0, 50, 90, 20));
        this.add((Component)this.abrevTextField, new XYConstraints(90, 50, 134, 20));
        this.add((Component)this.isVigenteCheck, new XYConstraints(244, 50, 100, 20));
        this.add((Component)this.descLabel, new XYConstraints(0, 85, 100, 20));
        this.add((Component)this.descTextField, new XYConstraints(90, 85, 444, 20));
        this.add((Component)this.unidadesLabel, new XYConstraints(0, 120, 100, 20));
        this.add((Component)this.unidadesTextField, new XYConstraints(70, 120, 30, 20));
        this.add((Component)this.unidadLabel, new XYConstraints(127, 120, 65, 20));
        this.add((Component)this.unidadCombo, new XYConstraints(185, 120, 70, 20));
        this.add((Component)this.tipoLabel, new XYConstraints(295, 120, 40, 20));
        this.add((Component)this.tipoCombo, new XYConstraints(330, 120, 204, 20));
        this.add((Component)this.tablaTransicionesIniLabel, new XYConstraints(0, 150, 500, 20));
        this.add((Component)this.tablaTransicionesIni.getScroll(), new XYConstraints(0, 170, 534, 60));
        this.add((Component)this.selTablaIniButton, new XYConstraints(0, 230, 85, 25));
        this.add((Component)this.eliTablaIniButton, new XYConstraints(90, 230, 85, 25));
        this.add((Component)this.tablaTransicionesFinLabel, new XYConstraints(0, 260, 500, 20));
        this.add((Component)this.tablaTransicionesFin.getScroll(), new XYConstraints(0, 280, 534, 80));
        this.add((Component)this.selTablaFinButton, new XYConstraints(0, 360, 85, 25));
        this.add((Component)this.eliTablaFinButton, new XYConstraints(90, 360, 85, 25));
        this.eliTablaIniButton.setFocusPainted(false);
        this.eliTablaIniButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropPlazoCompuestoDefProcJPanel.this.eliTablaIniButton_actionPerformed(e);
            }
        });
        this.eliTablaFinButton.setFocusPainted(false);
        this.eliTablaFinButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropPlazoCompuestoDefProcJPanel.this.eliTablaFinButton_actionPerformed(e);
            }
        });
        this.selTablaFinButton.setFocusPainted(false);
        this.selTablaFinButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropPlazoCompuestoDefProcJPanel.this.selTablaFinButton_actionPerformed(e);
            }
        });
        this.selTablaIniButton.setFocusPainted(false);
        this.selTablaIniButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropPlazoCompuestoDefProcJPanel.this.selSimpleTablaIniButton_actionPerformed(e);
            }
        });
        this.cargarTipoCombo();
        this.cargarUnidadCombo();
    }

    public void limpiarCampos() {
        this.abrevTextField.setText("");
        this.descTextField.setText("");
        this.tipoCombo.setSelectedIndex(0);
        this.unidadCombo.setSelectedIndex(0);
        this.unidadesTextField.setText("");
        this.isVigenteCheck.setSelected(true);
        this.tablaTransicionesFin.removeAllRows();
        this.tablaTransicionesIni.removeAllRows();
    }

    public void inicializarCampos(int nTipo) {
        boolean activo = false;
        boolean bReiniciarColoresLabel = true;
        switch (nTipo) {
            case 4: {
                this.conservarColoresDeFondo();
                bReiniciarColoresLabel = false;
                break;
            }
            case 2: {
                activo = false;
                bReiniciarColoresLabel = false;
                break;
            }
            case 3: {
                activo = true;
                break;
            }
            case 1: {
                this.iDatoAsignable = new TrPlazoCompuestoDefProc();
                this.limpiarCampos();
                activo = true;
            }
        }
        this.abrevTextField.setEditable(activo);
        this.descTextField.setEditable(activo);
        this.unidadesTextField.setEditable(activo);
        this.tipoCombo.setEnabled(activo);
        this.unidadCombo.setEnabled(activo);
        this.isVigenteCheck.setEnabled(activo);
        this.eliTablaIniButton.setEnabled(activo);
        this.selTablaIniButton.setEnabled(activo);
        this.selTablaFinButton.setEnabled(activo);
        this.eliTablaFinButton.setEnabled(activo);
        this.tablaTransicionesIni.setEnabled(activo);
        this.tablaTransicionesFin.setEnabled(activo);
        if (bReiniciarColoresLabel) {
            this.tablaTransicionesIniLabel.setForeground(Color.BLACK);
            this.tablaTransicionesFinLabel.setForeground(Color.BLACK);
        }
    }

    public IAsignable getValoresAsignables() {
        return this.iDatoAsignable;
    }

    public void setValoresAsignables(IAsignable datosAsignables) {
        if (datosAsignables != null && datosAsignables instanceof TrPlazoCompuestoDefProc) {
            String unidad;
            this.iDatoAsignable = datosAsignables;
            TrPlazoCompuestoDefProc plazoComp = (TrPlazoCompuestoDefProc)datosAsignables;
            this.abrevTextField.setText(plazoComp.getABREVIATURA());
            this.descTextField.setText(plazoComp.getDESCRIPCION());
            this.unidadesTextField.setText(plazoComp.getUNIDADES().toString());
            String tipo = plazoComp.getTIPO();
            if (tipo.equals("O")) {
                this.tipoCombo.setSelectedItem("OTROS");
            }
            if (tipo.equals("P")) {
                this.tipoCombo.setSelectedItem("PLAZO DE EJECUCI\u00d3N");
            }
            if ((unidad = plazoComp.getUNIDAD()).equals("D")) {
                this.unidadCombo.setSelectedItem("D\u00cdAS");
            }
            if (unidad.equals("M")) {
                this.unidadCombo.setSelectedItem("MESES");
            }
            if (unidad.equals("A")) {
                this.unidadCombo.setSelectedItem("A\u00d1OS");
            }
            this.isVigenteCheck.setSelected(plazoComp.isVigente());
            ConjuntoDatos cdElementosFin = new ConjuntoDatos();
            Vector<Object> VinformacionFin = null;
            TrTransicion trTempFin = null;
            Object objTranFin = null;
            cdElementosFin = plazoComp.getTransicionesFin();
            if (cdElementosFin != null) {
                this.tablaTransicionesFin.removeAllRows();
                for (int i = 0; i < cdElementosFin.getListaDatos().size(); ++i) {
                    objTranFin = cdElementosFin.getListaDatos().get(i);
                    if (objTranFin instanceof TrTransicion) {
                        trTempFin = objTranFin;
                    }
                    if (trTempFin != null) {
                        VinformacionFin = new Vector<Object>();
                        VinformacionFin.add(trTempFin);
                        VinformacionFin.add(trTempFin.getDESCRIPCIONFECHA());
                        VinformacionFin.add(trTempFin.obtenerDescrpcionTipo());
                        VinformacionFin.add(trTempFin.getVALIDA());
                    }
                    this.tablaTransicionesFin.addFila(VinformacionFin);
                    this.tablaTransicionesFin.updateUI();
                }
            }
            ConjuntoDatos cdElementosIni = new ConjuntoDatos();
            Vector<Object> VinformacionIni = null;
            TrTransicion trTempIni = null;
            Object objTranIni = null;
            cdElementosIni = plazoComp.getTransicionesIni();
            if (cdElementosIni != null) {
                this.tablaTransicionesIni.removeAllRows();
                for (int i = 0; i < cdElementosIni.getListaDatos().size(); ++i) {
                    objTranIni = cdElementosIni.getListaDatos().get(i);
                    if (objTranIni instanceof TrTransicion) {
                        trTempIni = objTranIni;
                    }
                    if (trTempIni != null) {
                        VinformacionIni = new Vector<Object>();
                        VinformacionIni.add(trTempIni);
                        VinformacionIni.add(trTempIni.getDESCRIPCIONFECHA());
                        VinformacionIni.add(trTempIni.obtenerDescrpcionTipo());
                        VinformacionIni.add(trTempIni.getVALIDA());
                    }
                    this.tablaTransicionesIni.addFila(VinformacionIni);
                    this.tablaTransicionesIni.updateUI();
                }
            }
        }
    }

    public String getTitulo(int n) {
        return "Mantenimiento de plazos compuestos en el procdimiento";
    }

    public boolean obtenerValoresCampos() {
        TrPlazoCompuestoDefProc trPlazo = null;
        boolean ok = true;
        trPlazo = new TrPlazoCompuestoDefProc();
        trPlazo = (TrPlazoCompuestoDefProc)this.iDatoAsignable;
        if (trPlazo == null) {
            ok = false;
        } else if (this.abrevTextField.getText() == null || this.descTextField.getText() == null) {
            ok = false;
        } else if (this.abrevTextField.getText().equals("") || this.descTextField.getText().equals("")) {
            ok = false;
        } else if (this.unidadesTextField.getText().equals("") || this.unidadesTextField.getText().equals("")) {
            ok = false;
        } else if (this.tipoCombo.getSelectedIndex() < 0) {
            ok = false;
        } else if (this.unidadCombo.getSelectedIndex() < 0) {
            ok = false;
        } else if (this.tablaTransicionesIni.getRowCount() == 0) {
            ok = false;
        } else if (this.tablaTransicionesFin.getRowCount() == 0) {
            ok = false;
        } else if (this.tablaTransicionesIni.getRowCount() == 0) {
            ok = false;
        } else if (this.tablaTransicionesFin.getRowCount() == 0) {
            ok = false;
        }
        if (!ok) {
            JOptionPane.showMessageDialog(null, MantenimientoJDialog.TEXTO_FALTAN_ATRIBUTOS_OBLIGATORIOS, MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
        } else {
            int indexItem;
            if (trPlazo != null) {
                trPlazo.setABREVIATURA(this.abrevTextField.getText());
                trPlazo.setDESCRIPCION(this.descTextField.getText());
            }
            if ((indexItem = this.tipoCombo.getSelectedIndex()) == 0 && trPlazo != null) {
                trPlazo.setTIPO("P");
            }
            if (indexItem == 1 && trPlazo != null) {
                trPlazo.setTIPO("O");
            }
            if ((indexItem = this.unidadCombo.getSelectedIndex()) == 0 && trPlazo != null) {
                trPlazo.setUNIDAD("D");
            }
            if (indexItem == 1 && trPlazo != null) {
                trPlazo.setUNIDAD("M");
            }
            if (indexItem == 2 && trPlazo != null) {
                trPlazo.setUNIDAD("A");
            }
            if (trPlazo != null) {
                trPlazo.setUNIDADES(Integer.valueOf(this.unidadesTextField.getText()));
                trPlazo.setVigente(this.isVigenteCheck.isSelected());
            }
            ConjuntoDatos cdTransicionesFin = new ConjuntoDatos();
            Vector VVdatosTablaFin = this.tablaTransicionesFin.toVector();
            for (int i = 0; i < VVdatosTablaFin.size(); ++i) {
                Vector VectorTempFin = (Vector)VVdatosTablaFin.get(i);
                TrTransicion transicionCurrentFin = null;
                transicionCurrentFin = (TrTransicion)VectorTempFin.get(0);
                cdTransicionesFin.add(transicionCurrentFin);
            }
            if (trPlazo != null) {
                trPlazo.setTransicionesFin(cdTransicionesFin);
            }
            ConjuntoDatos cdTransicionesIni = new ConjuntoDatos();
            Vector VVdatosTablaIni = this.tablaTransicionesIni.toVector();
            for (int i = 0; i < VVdatosTablaIni.size(); ++i) {
                Vector VectorTempIni = (Vector)VVdatosTablaIni.get(i);
                TrTransicion transicionCurrentIni = null;
                transicionCurrentIni = (TrTransicion)VectorTempIni.get(0);
                cdTransicionesIni.add(transicionCurrentIni);
            }
            if (trPlazo != null) {
                trPlazo.setTransicionesIni(cdTransicionesIni);
            }
        }
        return ok;
    }

    public void cargarTipoCombo() {
        this.tipoCombo.removeAllItems();
        this.tipoCombo.addItem("PLAZO DE EJECUCI\u00d3N");
        this.tipoCombo.addItem("OTROS");
        this.tipoCombo.setSelectedIndex(0);
    }

    public void cargarUnidadCombo() {
        this.unidadCombo.removeAllItems();
        this.unidadCombo.addItem("D\u00cdAS");
        this.unidadCombo.addItem("MESES");
        this.unidadCombo.addItem("A\u00d1OS");
        this.unidadCombo.setSelectedIndex(0);
    }

    public IAsignable getValoresAsignablesTemporales() {
        TrPlazoCompuestoDefProc plazoTemp = new TrPlazoCompuestoDefProc();
        plazoTemp.setABREVIATURA(this.abrevTextField.getText());
        plazoTemp.setDESCRIPCION(this.descTextField.getText());
        int indexItem = this.tipoCombo.getSelectedIndex();
        if (indexItem == 0) {
            plazoTemp.setTIPO("P");
        }
        if (indexItem == 1) {
            plazoTemp.setTIPO("O");
        }
        if ((indexItem = this.unidadCombo.getSelectedIndex()) == 0) {
            plazoTemp.setUNIDAD("D");
        }
        if (indexItem == 1) {
            plazoTemp.setUNIDAD("M");
        }
        if (indexItem == 2) {
            plazoTemp.setUNIDAD("A");
        }
        plazoTemp.setUNIDADES(Integer.valueOf(this.unidadesTextField.getText()));
        plazoTemp.setVigente(this.isVigenteCheck.isSelected());
        return plazoTemp;
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        this.grafico = nuevoGrafico;
    }

    public void eliTablaIniButton_actionPerformed(ActionEvent e) {
        int index = this.tablaTransicionesIni.getSelectedRow();
        if (index == -1) {
            return;
        }
        this.tablaTransicionesIni.removeRow(index);
        this.tablaTransicionesIni.updateUI();
        this.updateUI();
        this.tablaTransicionesIniLabel.setForeground(ModelaUI.colorFuenteEtiquetaModificandose);
    }

    public void eliTablaFinButton_actionPerformed(ActionEvent e) {
        int index = this.tablaTransicionesFin.getSelectedRow();
        if (index == -1) {
            return;
        }
        this.tablaTransicionesFin.removeRow(index);
        this.tablaTransicionesFin.updateUI();
        this.tablaTransicionesFinLabel.setForeground(ModelaUI.colorFuenteEtiquetaModificandose);
    }

    public void selTablaFinButton_actionPerformed(ActionEvent e) {
        MantenimientoTransicionJDialog mmttTransicion = new MantenimientoTransicionJDialog(true);
        mmttTransicion.setDesdeUtilidadGrf(true);
        if (this.grafico != null) {
            mmttTransicion.setGrafico(this.grafico);
            ConjuntoDatosTransicionDefProcedimiento cd = this.grafico.getTransicionesDelProcInvolucradas();
            if (cd == null || cd.getListaDatos().size() == 0) {
                JOptionPane.showMessageDialog(null, "No existen transiciones definidas en el procedimiento", "Atenci\u00f3n", 2);
                return;
            }
            ConjuntoDatosTransicion cdTemp = new ConjuntoDatosTransicion();
            for (int j = 0; j < cd.getListaDatos().size(); ++j) {
                TrTransicionDefProcedimiento tTemp = (TrTransicionDefProcedimiento)cd.getListaDatos().get(j);
                if (tTemp == null || tTemp.getTransicion() == null) continue;
                cdTemp.add(tTemp.getTransicion());
            }
            mmttTransicion.inicializarListaElementos(cdTemp);
        }
        mmttTransicion.setLocationRelativeTo(null);
        mmttTransicion.setVisible(true);
        boolean encontrado = false;
        Object[] elemento = mmttTransicion.obtenerElementosSeleccionados();
        if (elemento == null || elemento.length == 0) {
            return;
        }
        for (int h = 0; h < elemento.length; ++h) {
            TrTransicion elementoTransFin = (TrTransicion)elemento[h];
            Vector vectorAux = this.tablaTransicionesFin.toVector();
            for (int l = 0; l < vectorAux.size(); ++l) {
                TrTransicion elementoAux = (TrTransicion)this.tablaTransicionesFin.getValueAt(l, 0);
                if (elementoAux.getID() != elementoTransFin.getID()) continue;
                encontrado = true;
            }
            if (encontrado) continue;
            this.tablaTransicionesFin.introducirElementos(elementoTransFin);
            encontrado = false;
            this.tablaTransicionesFinLabel.setForeground(ModelaUI.colorFuenteEtiquetaModificandose);
        }
    }

    public void selMultipleTablaIniButton_actionPerformed(ActionEvent e) {
        MantenimientoTransicionJDialog mmttTransicion = new MantenimientoTransicionJDialog(true);
        mmttTransicion.setDesdeUtilidadGrf(true);
        if (this.grafico != null) {
            mmttTransicion.setGrafico(this.grafico);
            ConjuntoDatosTransicionDefProcedimiento cd = this.grafico.getTransicionesDelProcInvolucradas();
            if (cd == null || cd.getListaDatos().size() == 0) {
                JOptionPane.showMessageDialog(null, "No existen transiciones definidas en el procedimiento", "Atenci\u00f3n", 2);
                return;
            }
            ConjuntoDatosTransicion cdTemp = new ConjuntoDatosTransicion();
            for (int j = 0; j < cd.getListaDatos().size(); ++j) {
                TrTransicionDefProcedimiento tTemp = (TrTransicionDefProcedimiento)cd.getListaDatos().get(j);
                if (tTemp == null || tTemp.getTransicion() == null) continue;
                cdTemp.add(tTemp.getTransicion());
            }
            mmttTransicion.inicializarListaElementos(cdTemp);
        }
        mmttTransicion.setLocationRelativeTo(null);
        mmttTransicion.setVisible(true);
        boolean encontrado = false;
        Object[] elemento = mmttTransicion.obtenerElementosSeleccionados();
        if (elemento == null || elemento.length == 0) {
            return;
        }
        for (int h = 0; h < elemento.length; ++h) {
            TrTransicion elementoTransIni = (TrTransicion)elemento[h];
            Vector vectorAux = this.tablaTransicionesIni.toVector();
            for (int l = 0; l < vectorAux.size(); ++l) {
                TrTransicion elementoAux = (TrTransicion)this.tablaTransicionesIni.getValueAt(l, 0);
                if (elementoAux.getID() != elementoTransIni.getID()) continue;
                encontrado = true;
            }
            if (encontrado) continue;
            this.tablaTransicionesIni.introducirElementos(elementoTransIni);
            encontrado = false;
            this.tablaTransicionesIniLabel.setForeground(ModelaUI.colorFuenteEtiquetaModificandose);
        }
    }

    public void selSimpleTablaIniButton_actionPerformed(ActionEvent e) {
        MantenimientoTransicionJDialog mmttTransicion = new MantenimientoTransicionJDialog(true);
        mmttTransicion.setDesdeUtilidadGrf(true);
        if (this.grafico != null) {
            mmttTransicion.setGrafico(this.grafico);
            ConjuntoDatosTransicionDefProcedimiento cd = this.grafico.getTransicionesDelProcInvolucradas();
            if (cd == null || cd.getListaDatos().size() == 0) {
                JOptionPane.showMessageDialog(null, "No existen transiciones definidas en el procedimiento", "Atenci\u00f3n", 2);
                return;
            }
            ConjuntoDatosTransicion cdTemp = new ConjuntoDatosTransicion();
            for (int j = 0; j < cd.getListaDatos().size(); ++j) {
                TrTransicionDefProcedimiento tTemp = (TrTransicionDefProcedimiento)cd.getListaDatos().get(j);
                if (tTemp == null || tTemp.getTransicion() == null) continue;
                cdTemp.add(tTemp.getTransicion());
            }
            mmttTransicion.inicializarListaElementos(cdTemp);
        }
        mmttTransicion.setLocationRelativeTo(null);
        mmttTransicion.setVisible(true);
        TrTransicion elemento = (TrTransicion)mmttTransicion.obtenerElementoSeleccionado();
        if (elemento == null) {
            return;
        }
        this.tablaTransicionesIni.removeAllRows();
        this.tablaTransicionesIni.introducirElementos(elemento);
    }

    public String getAbreviaturaTemp() {
        return this.abrevTextField.getText();
    }

    public Vector getTransicionesTablaIni() {
        Vector<TrTransicion> vectorTrans = null;
        vectorTrans = new Vector<TrTransicion>();
        for (int i = 0; i < this.tablaTransicionesIni.getRowCount(); ++i) {
            TrTransicion trTransi = (TrTransicion)this.tablaTransicionesIni.getValueAt(i, 0);
            vectorTrans.add(trTransi);
        }
        return vectorTrans;
    }

    public void limpiarTablaTransicionesIni() {
        this.tablaTransicionesIni.removeAllRows();
    }

    public void inicializarFoco() {
        this.abrevTextField.requestFocus();
    }

    public void conservarColoresDeFondo() {
        this.colorFondoAbreviatura = this.abrevTextField.getBackground();
        this.colorFondoDescripcion = this.descTextField.getBackground();
        this.colorFondoTipo = this.tipoCombo.getBackground();
        this.colorFondoUnidades = this.unidadesTextField.getBackground();
        this.colorFondoUnidad = this.unidadCombo.getBackground();
        this.colorFondoVigente = this.isVigenteCheck.getForeground();
        this.colorFuenteTransiIni = this.tablaTransicionesIniLabel.getForeground();
        this.colorFuenteTransiFin = this.tablaTransicionesFinLabel.getForeground();
    }

    public void restaurarColoresDeFondo() {
        if (this.colorFondoAbreviatura != null) {
            this.abrevTextField.setBackground(this.colorFondoAbreviatura);
            this.colorFondoAbreviatura = null;
        }
        if (this.colorFondoDescripcion != null) {
            this.descTextField.setBackground(this.colorFondoDescripcion);
            this.colorFondoDescripcion = null;
        }
        if (this.colorFondoTipo != null) {
            this.tipoCombo.setBackground(this.colorFondoTipo);
            this.colorFondoTipo = null;
        }
        if (this.colorFondoUnidades != null) {
            this.unidadesTextField.setBackground(this.colorFondoUnidades);
            this.colorFondoUnidades = null;
        }
        if (this.colorFondoUnidad != null) {
            this.unidadCombo.setBackground(this.colorFondoUnidad);
            this.colorFondoUnidad = null;
        }
        if (this.colorFondoVigente != null) {
            this.isVigenteCheck.setForeground(this.colorFondoVigente);
            this.colorFondoVigente = null;
        }
        if (this.colorFuenteTransiIni != null) {
            this.tablaTransicionesIniLabel.setForeground(this.colorFuenteTransiIni);
            this.colorFuenteTransiIni = null;
        }
        if (this.colorFuenteTransiFin != null) {
            this.tablaTransicionesFinLabel.setForeground(this.colorFuenteTransiFin);
            this.colorFuenteTransiFin = null;
        }
    }
}

