/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import gdtel.ui.swing.excontrols.CreadorButton;
import gdtel.ui.swing.excontrols.JCheckBoxEx;
import gdtel.ui.swing.excontrols.JComboBoxEx;
import gdtel.ui.swing.excontrols.JFiltroTextArea;
import gdtel.ui.swing.excontrols.JFiltroTextField;
import gdtel.ui.swing.excontrols.JListAsignable;
import gdtel.ui.swing.excontrols.JPanelAtributable;
import gdtel.ui.swing.excontrols.JTextFieldAsignable;
import gdtel.util.CopiadorArchivos;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import modela.bd.obj.TrPlantilla;
import modela.bd.obj.TrTipoDocumento;
import modela.bd.obj.TrTipoImplementacion;
import modela.bd.obj.TrVariable;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.MimeTypeUtil;
import modela.ui.ModelaUI;
import modela.ui.swing.MantenimientoPlantillaJDialog;
import modela.ui.swing.MantenimientoVariablesJDialog;
import modela.ui.swing.PropParrafosTipoDocumentoJPanel;
import modela.util.TrOpenDocumentService;
import modela.util.UtilidadesVarias;

public class PropTipoDocumentoJPanel
extends JPanelAtributable {
    private static final long serialVersionUID = 170116252487421490L;
    private DDPGrafico grafico = null;
    private final String sistemaOperativo = "Wind";
    ImageIcon seleccionarIconN = new ImageIcon(PropTipoDocumentoJPanel.class.getResource(ModelaUI.IMG_SMALL_SELECCION));
    ImageIcon seleccionarIconS = new ImageIcon(PropTipoDocumentoJPanel.class.getResource(ModelaUI.IMG_SMALL_SELECCION_SOBRE));
    ImageIcon seleccionarIconD = new ImageIcon(PropTipoDocumentoJPanel.class.getResource(ModelaUI.IMG_SMALL_SELECCION_NO_ENABLED));
    ImageIcon quitarIconN = new ImageIcon(PropTipoDocumentoJPanel.class.getResource(ModelaUI.IMG_SMALL_QUITAR));
    ImageIcon quitarIconS = new ImageIcon(PropTipoDocumentoJPanel.class.getResource(ModelaUI.IMG_SMALL_QUITAR_SOBRE));
    ImageIcon quitarIconD = new ImageIcon(PropTipoDocumentoJPanel.class.getResource(ModelaUI.IMG_SMALL_QUITAR_NO_ENABLED));
    ImageIcon refreshIconN = new ImageIcon(PropTipoDocumentoJPanel.class.getResource(ModelaUI.IMG_REFRESCAR_VARIABLES));
    ImageIcon refreshIconS = new ImageIcon(PropTipoDocumentoJPanel.class.getResource(ModelaUI.IMG_REFRESCAR_VARIABLES_SOBRE));
    ImageIcon refreshIconD = new ImageIcon(PropTipoDocumentoJPanel.class.getResource(ModelaUI.IMG_REFRESCAR_VARIABLES_NO_ENABLED));
    ImageIcon eliminarIconN = new ImageIcon(PropTipoDocumentoJPanel.class.getResource(ModelaUI.IMG_SMALL_ELIMINAR));
    ImageIcon eliminarIconS = new ImageIcon(PropTipoDocumentoJPanel.class.getResource(ModelaUI.IMG_SMALL_ELIMINAR_SOBRE));
    ImageIcon eliminarIconD = new ImageIcon(PropTipoDocumentoJPanel.class.getResource(ModelaUI.IMG_SMALL_ELIMINAR_NO_ENABLED));
    ImageIcon previewIconN = new ImageIcon(PropTipoDocumentoJPanel.class.getResource(ModelaUI.IMG_PREVIEW_FILE));
    ImageIcon previewIconS = new ImageIcon(PropTipoDocumentoJPanel.class.getResource(ModelaUI.IMG_PREVIEW_FILE_SOBRE));
    ImageIcon previewIconD = new ImageIcon(PropTipoDocumentoJPanel.class.getResource(ModelaUI.IMG_PREVIEW_FILE_NO_ENABLED));
    ImageIcon agregarIconN = new ImageIcon(PropTipoDocumentoJPanel.class.getResource(ModelaUI.IMG_SMALL_AGREGAR));
    ImageIcon agregarIconS = new ImageIcon(PropTipoDocumentoJPanel.class.getResource(ModelaUI.IMG_SMALL_AGREGAR_SOBRE));
    ImageIcon agregarIconD = new ImageIcon(PropTipoDocumentoJPanel.class.getResource(ModelaUI.IMG_SMALL_AGREGAR_NO_ENABLED));
    private final XYLayout xYLayout = new XYLayout();
    private final JLabel tituloPanelLabel = new JLabel();
    private final JTabbedPane tabbedAtributos = new JTabbedPane();
    private final JPanel atributosBasicosPanel = new JPanel();
    private final JPanel datosAdicionalesPanel = new JPanel();
    private final PropParrafosTipoDocumentoJPanel panelParrafos = new PropParrafosTipoDocumentoJPanel();
    private final JPanel variablesPanel = new JPanel();
    private final JLabel etiquetaLabel = new JLabel();
    private final JFiltroTextField etiquetaTextField = new JFiltroTextField();
    private final JLabel nombreLabel = new JLabel();
    private final JFiltroTextField nombreTextField = new JFiltroTextField();
    private final JLabel decripAreaLabel = new JLabel();
    private final JFiltroTextArea descripTextArea = new JFiltroTextArea();
    private final JLabel claseDocLabel = new JLabel();
    JComboBoxEx claseCombo = new JComboBoxEx();
    private final JLabel entSalLabel = new JLabel();
    JComboBoxEx entSalCombo = new JComboBoxEx();
    private final JLabel incGenLabel = new JLabel();
    private final JComboBoxEx incGenCombo = new JComboBoxEx();
    private final JLabel textoAuxiliarLabel = new JLabel();
    private final JFiltroTextField textoAuxiliarField = new JFiltroTextField();
    JLabel plantillaLabel = new JLabel();
    private final JTextFieldAsignable plantillaTextField = new JTextFieldAsignable();
    private final JButton selPlantillaButton = (JButton)CreadorButton.crearBoton(1, false, this.seleccionarIconN, this.seleccionarIconD, this.seleccionarIconS, this.seleccionarIconS);
    protected JButton eliminarPlantillaBtn = (JButton)CreadorButton.crearBoton(1, false, this.quitarIconN, this.quitarIconD, this.quitarIconS, this.quitarIconS);
    private final JCheckBoxEx isMultipleCheck = new JCheckBoxEx();
    private final JCheckBoxEx isFechaFirmaCheck = new JCheckBoxEx();
    private final JLabel modgenLabel = new JLabel();
    private final JComboBoxEx cmbModGen = new JComboBoxEx();
    private final JCheckBoxEx isInformarCheck = new JCheckBoxEx();
    private final JCheckBoxEx isArchivableCheck = new JCheckBoxEx();
    private final JCheckBoxEx isVersionableCheck = new JCheckBoxEx();
    private final JCheckBoxEx isRegistrableCheck = new JCheckBoxEx();
    private final JCheckBoxEx isNotificableCheck = new JCheckBoxEx();
    private final JCheckBoxEx isReutilizableCheck = new JCheckBoxEx();
    private final JCheckBoxEx isFusionar_VarCheck = new JCheckBoxEx();
    private final JCheckBoxEx isFirma_DigiCheck = new JCheckBoxEx();
    private final JLabel tipo_firmaLabel = new JLabel();
    private final JComboBoxEx cmbTipo_Firma = new JComboBoxEx();
    private final JCheckBoxEx isObsoletoCheck = new JCheckBoxEx();
    private final JLabel plantillaBinariaVariableLabel = new JLabel();
    private final JFiltroTextField plantillaBinariaVariableText = new JFiltroTextField();
    private final JButton selPlantillaBinButton = (JButton)CreadorButton.crearBoton(1, false, this.seleccionarIconN, this.seleccionarIconD, this.seleccionarIconS, this.seleccionarIconS);
    JButton quitarPlantillaBinariaButton = (JButton)CreadorButton.crearBoton(1, false, this.quitarIconN, this.quitarIconD, this.quitarIconS, this.quitarIconS);
    private final JLabel listaVariablesLabel = new JLabel();
    private final JListAsignable listaVariables = new JListAsignable();
    private final JButton btnAgregarVariable = (JButton)CreadorButton.crearBoton(1, false, this.agregarIconN, this.agregarIconD, this.agregarIconS, this.agregarIconS);
    private final JButton btnEliminarVariable = (JButton)CreadorButton.crearBoton(1, false, this.eliminarIconN, this.eliminarIconD, this.eliminarIconS, this.eliminarIconS);
    private final JButton btnRefrescarVariables = (JButton)CreadorButton.crearBoton(1, false, this.refreshIconN, this.refreshIconD, this.refreshIconS, this.refreshIconS);
    private String sMimeVariableBinaria = null;
    private String sFicheroVariableBinaria = null;
    private String rutaVariableBinaria = null;
    private Color colorFondoEtiqueta = null;
    private Color colorFondoNombre = null;
    private Color colorFondoDescripcion = null;
    private Color colorFondoTextoAux = null;
    private Color colorFondoMultiple = null;
    private Color colorFondoFechaFirma = null;
    private Color colorFondoComboEntradaSalida = null;
    private Color colorFondoComboGenerarIncorporar = null;
    private Color colorFondoComboClase = null;
    private Color colorFuenteLabelPlantilla = null;
    private Color colorFondoComboModoGeneracion = null;
    private Color colorFondoInformar = null;
    private Color colorFondoArchivable = null;
    private Color colorFondoVersionable = null;
    private Color colorFondoRegistrable = null;
    private Color colorFondoFirma = null;
    private Color colorFondoNotificable = null;
    private Color colorFondoReutilizable = null;
    private Color colorFondoFusionar = null;
    private Color colorFondoComboTipoFirma = null;
    private Color colorFuenteLabelPlantillaBin = null;
    private Color colorFondoListaVariables = null;
    public static String PREFIJO_VAR_REUTILIZABLE = "VAR_EXPBODY_";

    public PropTipoDocumentoJPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void jbInit() {
        this.setSize(476, 520);
        this.setLayout(this.xYLayout);
        this.tituloPanelLabel.setText("Propiedades\n del tipo de documento");
        this.tituloPanelLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.tituloPanelLabel.setForeground(ModelaUI.colorSeleccion);
        this.etiquetaLabel.setText("Etiqueta:");
        this.etiquetaLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.etiquetaTextField.setNumItems(11);
        this.etiquetaTextField.setTipoFiltro(1);
        this.nombreLabel.setText("Nombre:");
        this.nombreLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.nombreTextField.setNumItems(50);
        this.nombreTextField.establecerTipografia(1);
        this.nombreTextField.setTipoFiltro(1);
        this.decripAreaLabel.setText("Descripci\u00f3n:");
        this.decripAreaLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.descripTextArea.setNumItems(250);
        this.descripTextArea.establecerTipografia(1);
        this.descripTextArea.setTipoFiltro(1);
        this.claseDocLabel.setText("Clase de documento:");
        this.claseDocLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.entSalLabel.setText("Entrada/Salida:");
        this.entSalLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.incGenLabel.setText("Generar/\nIncorporar:");
        this.incGenLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.cargarCmbClaseDoc();
        this.cargarCmbEntSal();
        this.cargarCmbIncGen();
        this.textoAuxiliarLabel.setText("Texto auxiliar:");
        this.textoAuxiliarLabel.setFont(ModelaUI.fuentePrincipal);
        this.textoAuxiliarField.setNumItems(50);
        this.textoAuxiliarField.establecerTipografia(1);
        this.textoAuxiliarField.setTipoFiltro(1);
        this.plantillaLabel.setText("Plantilla:");
        this.plantillaLabel.setFont(ModelaUI.fuentePrincipal);
        this.plantillaTextField.establecerTipografia(1);
        this.selPlantillaButton.setFocusPainted(false);
        this.eliminarPlantillaBtn.setEnabled(false);
        this.isMultipleCheck.setText("M\u00faltiple");
        this.isMultipleCheck.setEnabled(false);
        this.isFechaFirmaCheck.setText("Fecha de la firma");
        this.isFechaFirmaCheck.setEnabled(false);
        this.modgenLabel.setText("Modo de generaci\u00f3n:");
        this.cmbModGen.setEditable(false);
        this.cargarModGen();
        this.isInformarCheck.setText("Informar");
        this.isInformarCheck.setEnabled(false);
        this.isArchivableCheck.setText("Archivable");
        this.isArchivableCheck.setEnabled(false);
        this.isVersionableCheck.setText("Versionable");
        this.isVersionableCheck.setEnabled(false);
        this.isRegistrableCheck.setText("Registrable");
        this.isRegistrableCheck.setEnabled(false);
        this.isNotificableCheck.setText("Notificable");
        this.isNotificableCheck.setEnabled(false);
        this.isReutilizableCheck.setText("Reutilizable");
        this.isReutilizableCheck.setEnabled(false);
        this.isObsoletoCheck.setText("Obsoleto");
        this.isObsoletoCheck.setEnabled(false);
        this.isFusionar_VarCheck.setText("Fusionar variables");
        this.isFusionar_VarCheck.setEnabled(false);
        this.isFirma_DigiCheck.setText("Firma digital");
        this.isFirma_DigiCheck.setEnabled(false);
        this.tipo_firmaLabel.setText("Tipo de firma ");
        this.cmbTipo_Firma.setEditable(false);
        this.cargarTipoFirmar();
        this.panelParrafos.inicializarCampos(7);
        this.plantillaBinariaVariableLabel.setText("Plantilla binaria Open Office");
        this.plantillaBinariaVariableText.setToolTipText("Doble clic para abrir");
        this.plantillaBinariaVariableText.setNumItems(64);
        this.plantillaBinariaVariableText.establecerTipografia(2);
        this.plantillaBinariaVariableText.setTipoFiltro(1);
        this.plantillaBinariaVariableText.setEditable(false);
        this.selPlantillaBinButton.setFocusPainted(false);
        this.quitarPlantillaBinariaButton.setFocusPainted(false);
        this.btnAgregarVariable.setBorderPainted(false);
        this.btnAgregarVariable.setFocusPainted(false);
        this.btnEliminarVariable.setBorderPainted(false);
        this.btnEliminarVariable.setFocusPainted(false);
        this.btnRefrescarVariables.setBorderPainted(false);
        this.btnRefrescarVariables.setFocusPainted(false);
        this.btnRefrescarVariables.setToolTipText("Cargar lista analizando la plantilla OpenOffice");
        this.listaVariablesLabel.setText("Lista de variables");
        this.addListeners();
        this.add((Component)this.tituloPanelLabel, new XYConstraints(0, 5, 280, 15));
        this.atributosBasicosPanel.setLayout(new XYLayout());
        this.atributosBasicosPanel.add((Component)this.etiquetaLabel, new XYConstraints(10, 10, 75, 20));
        this.atributosBasicosPanel.add((Component)this.etiquetaTextField, new XYConstraints(75, 10, 100, 25));
        this.atributosBasicosPanel.add((Component)this.nombreLabel, new XYConstraints(190, 10, 75, 20));
        this.atributosBasicosPanel.add((Component)this.nombreTextField, new XYConstraints(250, 10, 285, 25));
        this.atributosBasicosPanel.add((Component)this.decripAreaLabel, new XYConstraints(10, 40, 100, 20));
        this.atributosBasicosPanel.add((Component)this.descripTextArea.getScrollableArea(), new XYConstraints(10, 60, 525, 40));
        this.atributosBasicosPanel.add((Component)this.claseDocLabel, new XYConstraints(10, 110, 150, 20));
        this.atributosBasicosPanel.add((Component)this.claseCombo, new XYConstraints(155, 110, 379, 25));
        this.atributosBasicosPanel.add((Component)this.textoAuxiliarLabel, new XYConstraints(10, 150, 100, 20));
        this.atributosBasicosPanel.add((Component)this.textoAuxiliarField, new XYConstraints(105, 150, 429, 25));
        this.atributosBasicosPanel.add((Component)this.entSalLabel, new XYConstraints(10, 190, 110, 20));
        this.atributosBasicosPanel.add((Component)this.entSalCombo, new XYConstraints(120, 190, 135, 25));
        this.atributosBasicosPanel.add((Component)this.incGenLabel, new XYConstraints(270, 190, 135, 20));
        this.atributosBasicosPanel.add((Component)this.incGenCombo, new XYConstraints(414, 190, 120, 25));
        this.atributosBasicosPanel.add((Component)this.modgenLabel, new XYConstraints(10, 230, 180, 20));
        this.atributosBasicosPanel.add((Component)this.cmbModGen, new XYConstraints(140, 230, 185, 25));
        this.atributosBasicosPanel.add((Component)this.plantillaLabel, new XYConstraints(10, 260, 50, 25));
        this.atributosBasicosPanel.add((Component)this.plantillaTextField, new XYConstraints(10, 283, 190, 25));
        this.atributosBasicosPanel.add((Component)this.selPlantillaButton, new XYConstraints(205, 283, 85, 25));
        this.atributosBasicosPanel.add((Component)this.eliminarPlantillaBtn, new XYConstraints(295, 285, 30, 21));
        this.atributosBasicosPanel.add((Component)this.isMultipleCheck, new XYConstraints(375, 240, 75, 20));
        this.atributosBasicosPanel.add((Component)this.isFechaFirmaCheck, new XYConstraints(375, 270, 130, 20));
        this.datosAdicionalesPanel.setLayout(this.xYLayout);
        this.datosAdicionalesPanel.add((Component)this.isArchivableCheck, new XYConstraints(30, 70, 90, 20));
        this.datosAdicionalesPanel.add((Component)this.isFirma_DigiCheck, new XYConstraints(200, 70, 100, 20));
        this.datosAdicionalesPanel.add((Component)this.isFusionar_VarCheck, new XYConstraints(380, 70, 140, 20));
        this.datosAdicionalesPanel.add((Component)this.isInformarCheck, new XYConstraints(30, 130, 80, 20));
        this.datosAdicionalesPanel.add((Component)this.isNotificableCheck, new XYConstraints(200, 130, 90, 20));
        this.datosAdicionalesPanel.add((Component)this.isRegistrableCheck, new XYConstraints(380, 130, 90, 20));
        this.datosAdicionalesPanel.add((Component)this.isReutilizableCheck, new XYConstraints(30, 190, 100, 20));
        this.datosAdicionalesPanel.add((Component)this.isVersionableCheck, new XYConstraints(200, 190, 100, 20));
        this.datosAdicionalesPanel.add((Component)this.tipo_firmaLabel, new XYConstraints(380, 190, 100, 20));
        this.datosAdicionalesPanel.add((Component)this.cmbTipo_Firma, new XYConstraints(380, 210, 130, 25));
        this.variablesPanel.setLayout(this.xYLayout);
        this.variablesPanel.add((Component)this.plantillaBinariaVariableLabel, new XYConstraints(10, 10, 200, 25));
        this.variablesPanel.add((Component)this.plantillaBinariaVariableText, new XYConstraints(10, 35, 400, 25));
        this.variablesPanel.add((Component)this.selPlantillaBinButton, new XYConstraints(415, 35, 80, 25));
        this.variablesPanel.add((Component)this.quitarPlantillaBinariaButton, new XYConstraints(500, 37, 30, 21));
        this.variablesPanel.add((Component)this.listaVariablesLabel, new XYConstraints(10, 70, 140, 25));
        this.variablesPanel.add((Component)this.listaVariables.getScrollableArea(), new XYConstraints(10, 95, 400, 200));
        this.variablesPanel.add((Component)this.btnAgregarVariable, new XYConstraints(415, 100, 80, 25));
        this.variablesPanel.add((Component)this.btnRefrescarVariables, new XYConstraints(500, 102, 30, 21));
        this.variablesPanel.add((Component)this.btnEliminarVariable, new XYConstraints(415, 130, 80, 25));
        this.tabbedAtributos.addTab("Propiedades", this.atributosBasicosPanel);
        this.tabbedAtributos.addTab("Datos adicionales", this.datosAdicionalesPanel);
        this.tabbedAtributos.addTab("P\u00e1rrafos", this.panelParrafos);
        this.tabbedAtributos.addTab("Variables", this.variablesPanel);
        this.add((Component)this.tabbedAtributos, new XYConstraints(0, 25, 546, 340));
    }

    private void addListeners() {
        this.plantillaBinariaVariableText.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                if (e.getSource() != null && e.getClickCount() == 2) {
                    PropTipoDocumentoJPanel.this.abrirArchivoPlantilla(null);
                    return;
                }
            }
        });
        this.selPlantillaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropTipoDocumentoJPanel.this.selPlantillaButton_actionPerformed(e);
            }
        });
        this.selPlantillaBinButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropTipoDocumentoJPanel.this.selPlantillaBinButton_actionPerformed(e);
            }
        });
        this.quitarPlantillaBinariaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropTipoDocumentoJPanel.this.eliminarButton_actionPerformed(e);
            }
        });
        this.btnAgregarVariable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropTipoDocumentoJPanel.this.btnAgregarVariableButton_actionPerformed(e);
            }
        });
        this.btnRefrescarVariables.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropTipoDocumentoJPanel.this.btnRefrescarVariables_actionPerformed(e);
            }
        });
        this.listaVariables.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\u007f') {
                    PropTipoDocumentoJPanel.this.eliminarVariable_actionPerformed();
                }
            }
        });
        this.btnEliminarVariable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropTipoDocumentoJPanel.this.eliminarVariable_actionPerformed();
            }
        });
        this.eliminarPlantillaBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropTipoDocumentoJPanel.this.eliminarPlantilla();
                PropTipoDocumentoJPanel.this.plantillaLabel.setForeground(ModelaUI.colorFuenteEtiquetaModificandose);
            }
        });
        this.descripTextArea.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                if (evt.getKeyChar() == '\t') {
                    PropTipoDocumentoJPanel.this.entSalCombo.requestFocus();
                }
            }
        });
    }

    public void limpiarCampos() {
        this.etiquetaTextField.setText("");
        this.nombreTextField.setText("");
        this.descripTextArea.setText("");
        this.entSalCombo.setSelectedIndex(1);
        this.incGenCombo.setSelectedIndex(1);
        this.claseCombo.setSelectedIndex(0);
        this.isMultipleCheck.setSelected(false);
        this.isFechaFirmaCheck.setSelected(false);
        this.textoAuxiliarField.setText("");
        this.plantillaTextField.removeAll();
        this.plantillaTextField.setText("");
        this.plantillaTextField.setFocusable(false);
        this.eliminarPlantilla();
        this.cmbModGen.setSelectedIndex(0);
        this.cmbTipo_Firma.setSelectedIndex(0);
        this.isInformarCheck.setSelected(false);
        this.isArchivableCheck.setSelected(false);
        this.isVersionableCheck.setSelected(false);
        this.isRegistrableCheck.setSelected(false);
        this.isNotificableCheck.setSelected(false);
        this.isReutilizableCheck.setSelected(false);
        this.isObsoletoCheck.setSelected(false);
        this.isFusionar_VarCheck.setSelected(false);
        this.isFirma_DigiCheck.setSelected(false);
        if (this.panelParrafos != null) {
            this.panelParrafos.limpiarCampos();
            if (this.panelParrafos.listaParrafos != null) {
                this.panelParrafos.listaParrafos.removeAllItems();
            }
        }
        this.plantillaBinariaVariableText.setText("");
        this.listaVariables.removeAllItems();
    }

    public IAsignable getValoresAsignables() {
        return this.iDatoAsignable;
    }

    public void setValoresAsignables(IAsignable datosAsignables) {
        if (datosAsignables != null && datosAsignables instanceof TrTipoDocumento) {
            this.limpiarCampos();
            this.iDatoAsignable = datosAsignables;
            TrTipoDocumento tipoDocumento = (TrTipoDocumento)datosAsignables;
            this.etiquetaTextField.setText(tipoDocumento.getEtiqueta());
            this.nombreTextField.setText(tipoDocumento.getNombre());
            this.descripTextArea.setText(tipoDocumento.getDescripcion());
            if (tipoDocumento.getEntSal() != null && !tipoDocumento.getEntSal().equals("")) {
                if (tipoDocumento.getEntSal().equals("E")) {
                    this.entSalCombo.setSelectedItem("ENTRADA");
                }
                if (tipoDocumento.getEntSal().equals("S")) {
                    this.entSalCombo.setSelectedItem("SALIDA");
                }
                if (tipoDocumento.getEntSal().equals("ES")) {
                    this.entSalCombo.setSelectedItem("ENTRADA/SALIDA");
                }
            }
            if (tipoDocumento.getIncGen() != null && !tipoDocumento.getIncGen().equals("")) {
                if (tipoDocumento.getIncGen().equals("G")) {
                    this.incGenCombo.setSelectedItem("GENERADO");
                }
                if (tipoDocumento.getIncGen().equals("I")) {
                    this.incGenCombo.setSelectedItem("INCORPORADO");
                }
            }
            if (tipoDocumento.getDescClaseDoc() != null) {
                this.claseCombo.setSelectedItem(tipoDocumento.getDescClaseDoc());
            }
            this.textoAuxiliarField.setText(tipoDocumento.getAuxiliar());
            if (tipoDocumento.getPlantilla() != null) {
                this.plantillaTextField.setObjetoAsignable(tipoDocumento.getPlantilla());
            } else {
                this.plantillaTextField.setText("");
            }
            this.isMultipleCheck.setSelected(tipoDocumento.isMultiple());
            this.isFechaFirmaCheck.setSelected(tipoDocumento.isFechaFirma());
            if (tipoDocumento.getModoGen() != null && !tipoDocumento.getModoGen().equals("")) {
                if (tipoDocumento.getModoGen().equals("R")) {
                    this.cmbModGen.setSelectedItem("REPORT SERVER ORACLE");
                }
                if (tipoDocumento.getModoGen().equals("P")) {
                    this.cmbModGen.setSelectedItem("GENERACI\u00d3N PDF");
                }
                if (tipoDocumento.getModoGen().equals("O")) {
                    this.cmbModGen.setSelectedItem("OFFICE BEAN");
                }
            }
            this.isInformarCheck.setSelected(tipoDocumento.isInformar());
            this.isArchivableCheck.setSelected(tipoDocumento.isArchivable());
            this.isVersionableCheck.setSelected(tipoDocumento.isVersionable());
            this.isRegistrableCheck.setSelected(tipoDocumento.isRegistrable());
            this.isNotificableCheck.setSelected(tipoDocumento.isNotificable());
            this.isReutilizableCheck.setSelected(tipoDocumento.isReutilizable());
            this.isObsoletoCheck.setSelected(tipoDocumento.isObsoleto());
            this.isFusionar_VarCheck.setSelected(tipoDocumento.isFusionar_Var());
            this.isFirma_DigiCheck.setSelected(tipoDocumento.isFirma_Digi());
            if (tipoDocumento.getTipo_Firma() != null && !tipoDocumento.getTipo_Firma().equals("")) {
                if (tipoDocumento.getTipo_Firma().equals("C")) {
                    this.cmbTipo_Firma.setSelectedItem("CASCADA");
                }
                if (tipoDocumento.getTipo_Firma().equals("P")) {
                    this.cmbTipo_Firma.setSelectedItem("PARALELO");
                }
                if (tipoDocumento.getTipo_Firma().equals("-")) {
                    this.cmbTipo_Firma.setSelectedItem("SIN FIRMA");
                }
            }
            this.panelParrafos.setListaParrafosTipoDoc(tipoDocumento.getParrafoTipoDoc());
            if (tipoDocumento.getT_Nom_Fichero() != null && !tipoDocumento.getT_Nom_Fichero().equals("")) {
                this.plantillaBinariaVariableText.setText(tipoDocumento.getT_Nom_Fichero());
            } else {
                this.plantillaBinariaVariableText.setText("");
            }
            this.sFicheroVariableBinaria = this.plantillaBinariaVariableText.getText();
            this.sMimeVariableBinaria = tipoDocumento.getT_Formato();
            this.rutaVariableBinaria = tipoDocumento.getRuta();
            this.listaVariables.removeAllItems();
            ArrayList arrayVariables = tipoDocumento.getVariables();
            Collections.sort(arrayVariables);
            for (int i = 0; i < arrayVariables.size(); ++i) {
                if (arrayVariables.get(i) == null) continue;
                TrVariable variable = (TrVariable)arrayVariables.get(i);
                this.listaVariables.addItem(variable);
            }
        }
    }

    public String getTitulo(int n) {
        return "Mantenimiento de tipo de documentos";
    }

    public boolean obtenerValoresCampos() {
        boolean ok = true;
        TrTipoDocumento tipoDocumento = new TrTipoDocumento();
        tipoDocumento = (TrTipoDocumento)this.iDatoAsignable;
        if (tipoDocumento == null || this.etiquetaTextField.getText() == null || this.etiquetaTextField.getText().equals("") || this.nombreTextField.getText() == null || this.nombreTextField.getText().equals("") || this.descripTextArea.getText() == null || this.descripTextArea.getText().equals("") || this.entSalCombo.getSelectedIndex() < 0 || this.incGenCombo.getSelectedIndex() < 0 || this.cmbModGen.getSelectedIndex() < 0 || this.cmbTipo_Firma.getSelectedIndex() < 0 || this.claseCombo.getSelectedIndex() < 0) {
            ok = false;
        }
        if (!ok) {
            JOptionPane.showMessageDialog(null, MantenimientoJDialog.TEXTO_FALTAN_ATRIBUTOS_OBLIGATORIOS, MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
        } else if (tipoDocumento != null) {
            tipoDocumento.setEtiqueta(this.etiquetaTextField.getText());
            tipoDocumento.setNombre(this.nombreTextField.getText());
            tipoDocumento.setDescripcion(this.descripTextArea.getText());
            tipoDocumento.setAuxiliar(this.textoAuxiliarField.getText());
            tipoDocumento.setPlantilla((TrPlantilla)this.plantillaTextField.getObjetoAsignable());
            tipoDocumento.setMultiple(this.isMultipleCheck.isSelected());
            tipoDocumento.setFechaFirma(this.isFechaFirmaCheck.isSelected());
            int nSelectedItem = this.entSalCombo.getSelectedIndex();
            if (this.entSalCombo.getItemAt(nSelectedItem).toString().equals("ENTRADA")) {
                tipoDocumento.setEntSal("E");
            }
            if (this.entSalCombo.getItemAt(nSelectedItem).toString().equals("SALIDA")) {
                tipoDocumento.setEntSal("S");
            }
            if (this.entSalCombo.getItemAt(nSelectedItem).toString().equals("ENTRADA/SALIDA")) {
                tipoDocumento.setEntSal("ES");
            }
            if (this.incGenCombo.getItemAt(nSelectedItem = this.incGenCombo.getSelectedIndex()).toString().equals("GENERADO")) {
                tipoDocumento.setIncGen("G");
            }
            if (this.incGenCombo.getItemAt(nSelectedItem).toString().equals("INCORPORADO")) {
                tipoDocumento.setIncGen("I");
            }
            nSelectedItem = this.claseCombo.getSelectedIndex();
            tipoDocumento.setClaseDocEnBaseADesc(this.claseCombo.getItemAt(nSelectedItem).toString());
            nSelectedItem = this.cmbModGen.getSelectedIndex();
            if (this.cmbModGen.getItemAt(nSelectedItem).toString().equals("REPORT SERVER ORACLE")) {
                tipoDocumento.setModoGen("R");
            }
            if (this.cmbModGen.getItemAt(nSelectedItem).toString().equals("GENERACI\u00d3N PDF")) {
                tipoDocumento.setModoGen("P");
            }
            if (this.cmbModGen.getItemAt(nSelectedItem).toString().equals("OFFICE BEAN")) {
                tipoDocumento.setModoGen("O");
            }
            tipoDocumento.setInformar(this.isInformarCheck.isSelected());
            tipoDocumento.setArchivable(this.isArchivableCheck.isSelected());
            tipoDocumento.setVersionable(this.isVersionableCheck.isSelected());
            tipoDocumento.setRegistrable(this.isRegistrableCheck.isSelected());
            tipoDocumento.setNotificable(this.isNotificableCheck.isSelected());
            tipoDocumento.setReutilizable(this.isReutilizableCheck.isSelected());
            tipoDocumento.setObsoleto(this.isObsoletoCheck.isSelected());
            tipoDocumento.setFusionar_Var(this.isFusionar_VarCheck.isSelected());
            tipoDocumento.setFirma_Digi(this.isFirma_DigiCheck.isSelected());
            nSelectedItem = this.cmbTipo_Firma.getSelectedIndex();
            if (this.cmbTipo_Firma.getItemAt(nSelectedItem).toString().equals("CASCADA")) {
                tipoDocumento.setTipo_Firma("C");
            }
            if (this.cmbTipo_Firma.getItemAt(nSelectedItem).toString().equals("PARALELO")) {
                tipoDocumento.setTipo_Firma("P");
            }
            if (this.cmbTipo_Firma.getItemAt(nSelectedItem).toString().equals("SIN FIRMA")) {
                tipoDocumento.setTipo_Firma("-");
            }
            tipoDocumento.setParrafoTipoDoc(this.panelParrafos.getListaParrafosTipoDoc());
            tipoDocumento.setNom_Fichero(this.sFicheroVariableBinaria);
            tipoDocumento.setTFormato(this.sMimeVariableBinaria);
            tipoDocumento.setRuta(this.rutaVariableBinaria);
            tipoDocumento.limpiarListaVariables();
            for (int i = 0; i < this.listaVariables.getNumItems(); ++i) {
                if (this.listaVariables.getElementAt(i) == null || tipoDocumento == null) continue;
                tipoDocumento.addVariable((TrVariable)this.listaVariables.getElementAt(i));
            }
        }
        return ok;
    }

    public void inicializarCampos(int nTipo) {
        this.nModoActualDeTrabajo = nTipo;
        boolean activo = false;
        boolean bReiniciarColoresLabel = true;
        switch (nTipo) {
            case 4: {
                this.conservarColoresDeFondo();
                bReiniciarColoresLabel = false;
                break;
            }
            case 2: {
                this.eliminarPlantillaBtn.setEnabled(false);
                activo = false;
                bReiniciarColoresLabel = false;
                break;
            }
            case 3: {
                if (this.plantillaTextField.getObjetoAsignable() != null && this.plantillaTextField.getObjetoAsignable().getNombre() != null) {
                    this.eliminarPlantillaBtn.setEnabled(true);
                } else {
                    this.eliminarPlantillaBtn.setEnabled(false);
                }
                activo = true;
                break;
            }
            case 1: {
                this.iDatoAsignable = new TrTipoDocumento();
                this.limpiarCampos();
                activo = true;
                this.eliminarPlantillaBtn.setEnabled(false);
            }
        }
        this.etiquetaTextField.setEditable(activo);
        this.nombreTextField.setEditable(activo);
        this.descripTextArea.setEditable(activo);
        this.entSalCombo.setEnabled(activo);
        this.incGenCombo.setEnabled(activo);
        this.claseCombo.setEnabled(activo);
        this.isMultipleCheck.setEnabled(activo);
        this.isFechaFirmaCheck.setEnabled(activo);
        this.textoAuxiliarField.setEditable(activo);
        this.cmbModGen.setEnabled(activo);
        this.isInformarCheck.setEnabled(activo);
        this.isArchivableCheck.setEnabled(activo);
        this.isVersionableCheck.setEnabled(activo);
        this.isRegistrableCheck.setEnabled(activo);
        this.isNotificableCheck.setEnabled(activo);
        this.isReutilizableCheck.setEnabled(activo);
        this.isObsoletoCheck.setEnabled(activo);
        this.isFusionar_VarCheck.setEnabled(activo);
        this.isFirma_DigiCheck.setEnabled(activo);
        this.cmbTipo_Firma.setEnabled(activo);
        this.panelParrafos.inicializarCampos(nTipo);
        this.panelParrafos.setEditable(activo);
        this.plantillaBinariaVariableText.setEnabled(false);
        this.plantillaTextField.setEnabled(activo);
        this.selPlantillaButton.setEnabled(activo);
        this.selPlantillaBinButton.setEnabled(activo);
        this.quitarPlantillaBinariaButton.setEnabled(activo);
        this.btnAgregarVariable.setEnabled(activo);
        this.btnEliminarVariable.setEnabled(activo);
        this.listaVariables.setEnabled(activo);
        this.btnRefrescarVariables.setEnabled(activo);
        if (this.plantillaBinariaVariableText.getText() == null || this.plantillaBinariaVariableText.getText().equals("")) {
            this.quitarPlantillaBinariaButton.setEnabled(false);
            this.btnRefrescarVariables.setEnabled(false);
        }
        if (bReiniciarColoresLabel) {
            this.plantillaLabel.setForeground(Color.BLACK);
            this.plantillaBinariaVariableLabel.setForeground(Color.BLACK);
        }
    }

    public void cargarCmbEntSal() {
        this.entSalCombo.removeAllItems();
        this.entSalCombo.addItem("ENTRADA");
        this.entSalCombo.addItem("SALIDA");
        this.entSalCombo.addItem("ENTRADA/SALIDA");
        this.entSalCombo.setSelectedIndex(1);
    }

    public void cargarCmbIncGen() {
        this.incGenCombo.removeAllItems();
        this.incGenCombo.addItem("INCORPORADO");
        this.incGenCombo.addItem("GENERADO");
        this.incGenCombo.setSelectedIndex(1);
    }

    public void cargarCmbClaseDoc() {
        this.claseCombo.removeAllItems();
        this.claseCombo.addItem("GENERAL");
        this.claseCombo.addItem("SCSP CON NECESIDAD DE AUTORIZACI\u00d3N");
        this.claseCombo.addItem("SCSP AUTORIZADO POR LEY");
        this.claseCombo.setSelectedIndex(0);
    }

    public void selPlantillaButton_actionPerformed(ActionEvent e) {
        MantenimientoPlantillaJDialog mttoPlantilla = new MantenimientoPlantillaJDialog();
        mttoPlantilla.setGrafico(this.grafico);
        if (this.grafico != null) {
            if (this.nModoActualDeTrabajo != 1) {
                mttoPlantilla.inicializarListaElementos(this.grafico.getPlantillasInvolucradas(), this.plantillaTextField.getObjetoAsignable());
            } else {
                mttoPlantilla.inicializarListaElementos(this.grafico.getPlantillasInvolucradas());
            }
        }
        mttoPlantilla.setLocationRelativeTo(null);
        mttoPlantilla.activarSeleccion(true);
        mttoPlantilla.setVisible(true);
        if (mttoPlantilla.obtenerElementoSeleccionado() != null) {
            TrPlantilla plantilla = (TrPlantilla)mttoPlantilla.obtenerElementoSeleccionado();
            this.plantillaTextField.setObjetoAsignable(plantilla);
            this.eliminarPlantillaBtn.setEnabled(true);
            this.plantillaLabel.setForeground(ModelaUI.colorFuenteEtiquetaModificandose);
        }
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        this.grafico = nuevoGrafico;
        this.panelParrafos.setGrafico(this.grafico);
    }

    public void cargarModGen() {
        this.cmbModGen.removeAllItems();
        this.cmbModGen.addItem("REPORT SERVER ORACLE");
        this.cmbModGen.addItem("GENERACI\u00d3N PDF");
        this.cmbModGen.addItem("OFFICE BEAN");
        this.cmbModGen.setSelectedIndex(0);
    }

    public void cargarTipoFirmar() {
        this.cmbTipo_Firma.removeAllItems();
        this.cmbTipo_Firma.addItem("SIN FIRMA");
        this.cmbTipo_Firma.addItem("CASCADA");
        this.cmbTipo_Firma.addItem("PARALELO");
        this.cmbTipo_Firma.setSelectedIndex(0);
    }

    public String getNombreTmp() {
        return this.nombreTextField.getText();
    }

    public void selPlantillaBinButton_actionPerformed(ActionEvent e) {
        String strRuta = ModelaConf.getRutaArchivo();
        JFileChooser fileDlg = strRuta != null ? new JFileChooser(strRuta) : new JFileChooser();
        fileDlg.setFileSelectionMode(0);
        int nRet = fileDlg.showOpenDialog(this);
        if (nRet == 0) {
            File fich = fileDlg.getSelectedFile();
            this.sFicheroVariableBinaria = fich.getName();
            File fileDestino = fich;
            if (this.sFicheroVariableBinaria != null && this.sFicheroVariableBinaria.length() > 64) {
                Object[] opciones = new Object[]{"S\u00ed", "No, renombrar\u00e9 manualmente"};
                int n = JOptionPane.showOptionDialog(null, "Nombre del fichero demasiado largo:\nLa longitud m\u00e1xima permitida es de 64 caracteres (extensi\u00f3n incluida).\n\n\u00bfQuiere renombrarlo autom\u00e1ticamente a ... \n" + UtilidadesVarias.adjustNameFileMaxLen(fich.getName(), 64) + " ?", "Atenci\u00f3n", 0, 2, null, opciones, opciones[1]);
                if (n != 0) {
                    return;
                }
                fileDestino = new File(fich.getParent() + File.separator + UtilidadesVarias.adjustNameFileMaxLen(fich.getName(), 64));
                if (fich.renameTo(fileDestino)) {
                    this.sFicheroVariableBinaria = fileDestino.getName();
                } else {
                    return;
                }
            }
            this.plantillaBinariaVariableText.setText(this.sFicheroVariableBinaria);
            MimeTypeUtil mime = MimeTypeUtil.getInstance();
            this.sMimeVariableBinaria = mime.mimeTypeOf(fich.getPath());
            this.rutaVariableBinaria = fich.getPath();
            this.plantillaBinariaVariableLabel.setForeground(ModelaUI.colorFuenteEtiquetaModificandose);
            this.agregarVariablesAutomaticamente(fileDestino);
        }
    }

    public void eliminarButton_actionPerformed(ActionEvent ev) {
        if (!this.plantillaBinariaVariableText.getText().equals("")) {
            this.plantillaBinariaVariableLabel.setForeground(ModelaUI.colorFuenteEtiquetaModificandose);
        }
        this.plantillaBinariaVariableText.setText("");
        this.sMimeVariableBinaria = "";
        this.sFicheroVariableBinaria = "";
    }

    void btnAgregarVariableButton_actionPerformed(ActionEvent e) {
        MantenimientoVariablesJDialog mttoVariables = new MantenimientoVariablesJDialog();
        mttoVariables.setGrafico(this.grafico);
        mttoVariables.inicializarListaElementos(this.grafico.getVariablesInvolucradas());
        mttoVariables.setLocationRelativeTo(null);
        mttoVariables.activarSeleccion(true);
        mttoVariables.setVisible(true);
        Object[] variablesSeleccionadas = mttoVariables.obtenerElementosSeleccionados();
        if (variablesSeleccionadas != null) {
            for (int i = 0; i < variablesSeleccionadas.length; ++i) {
                boolean bInsertar = true;
                TrVariable variable = (TrVariable)variablesSeleccionadas[i];
                for (int t = 0; t < this.listaVariables.getNumItems(); ++t) {
                    TrVariable variableAux = (TrVariable)this.listaVariables.getElementAt(t);
                    if (!variableAux.equals(variable)) continue;
                    bInsertar = false;
                }
                if (bInsertar) {
                    this.listaVariables.addItem(variable);
                    this.listaVariables.setBackground(ModelaUI.colorFondoTextoModificandose);
                    continue;
                }
                JOptionPane.showMessageDialog(this, "La variable " + variable.toString() + " ya est\u00e1 incluida en la lista.", "Atenci\u00f3n", 2);
            }
        } else if (mttoVariables.obtenerElementoSeleccionado() != null) {
            TrVariable variable = (TrVariable)mttoVariables.obtenerElementoSeleccionado();
            boolean bInsertar = true;
            for (int v = 0; v < this.listaVariables.getNumItems(); ++v) {
                TrVariable variableAux = (TrVariable)this.listaVariables.getElementAt(v);
                if (!variableAux.equals(variable)) continue;
                bInsertar = false;
            }
            if (bInsertar) {
                this.listaVariables.addItem(variable);
                this.listaVariables.setBackground(ModelaUI.colorFondoTextoModificandose);
            } else {
                JOptionPane.showMessageDialog(this, "La variable " + variable.toString() + " ya est\u00e1 incluida en la lista.", "Atenci\u00f3n", 2);
            }
        }
    }

    void btnRefrescarVariables_actionPerformed(ActionEvent e) {
        if (this.rutaVariableBinaria == null || this.rutaVariableBinaria.equals("") || this.plantillaBinariaVariableText.getText() == null || this.plantillaBinariaVariableText.getText().equals("")) {
            return;
        }
        String strRutaPlantillaOpenOffice = null;
        if (CopiadorArchivos.existeArchivo(this.rutaVariableBinaria)) {
            strRutaPlantillaOpenOffice = this.rutaVariableBinaria;
        } else if (CopiadorArchivos.existeArchivo(ModelaConf.getRutaArchivo() + System.getProperty("file.separator") + this.sFicheroVariableBinaria)) {
            strRutaPlantillaOpenOffice = ModelaConf.getRutaArchivo() + System.getProperty("file.separator") + this.sFicheroVariableBinaria;
        } else {
            JOptionPane.showMessageDialog(null, "No se ha podido analizar la plantilla:\nNo se ha encontrado el fichero asociado", "Atenci\u00f3n", 0);
            return;
        }
        File fileAux = new File(strRutaPlantillaOpenOffice);
        if (!fileAux.exists()) {
            return;
        }
        this.agregarVariablesAutomaticamente(fileAux);
    }

    public void agregarVariablesAutomaticamente(File ficheroPlantilla) {
        System.out.println("- [ Info ] Analizando documento en busca de variables: ");
        if (ficheroPlantilla == null || !ficheroPlantilla.exists()) {
            System.out.println("[ Error ] El fichero recibido es nulo o no existe.");
            return;
        }
        System.out.println("- Fichero: " + ficheroPlantilla.getAbsolutePath());
        List arrVariablesObtenidas = new ArrayList();
        try {
            TrOpenDocumentService utilODS = new TrOpenDocumentService();
            arrVariablesObtenidas = utilODS.getVariables(new FileInputStream(ficheroPlantilla), ModelaConf.getMarcaVariables());
            Collections.sort(arrVariablesObtenidas);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Errores analizando la plantlla:\nPruebe a salvar la plantilla con una versi\u00f3n actual de OpenOffice.", "Atenci\u00f3n", 0);
            System.out.println("[ Error ] Analizando el documento: ");
            e.printStackTrace();
            return;
        }
        if (ModelaConf.getLimpiarListaVariables()) {
            this.listaVariables.removeAllItems();
        }
        ArrayList<TrVariable> arrVariablesNoValidas = new ArrayList<TrVariable>();
        for (int i = 0; i < arrVariablesObtenidas.size(); ++i) {
            boolean bInsertar = true;
            TrVariable variableToAdd = new TrVariable();
            variableToAdd.setNOMBRE((String)arrVariablesObtenidas.get(i));
            variableToAdd.setDESCRIPCION((String)arrVariablesObtenidas.get(i));
            variableToAdd.setTipoImplementacion(TrTipoImplementacion.JAVA);
            if (!variableToAdd.getNombre().startsWith(PREFIJO_VAR_REUTILIZABLE)) {
                if (variableToAdd.getNombre().length() < 26) {
                    if (this.grafico != null && this.grafico.getVariablesInvolucradas() != null && this.grafico.getVariablesInvolucradas().existeElemento(variableToAdd, false) != null) {
                        variableToAdd = (TrVariable)this.grafico.getVariablesInvolucradas().existeElemento(variableToAdd, false);
                    } else {
                        this.grafico.getVariablesInvolucradas().add(variableToAdd);
                    }
                    for (int t = 0; t < this.listaVariables.getNumItems(); ++t) {
                        TrVariable variableAux = (TrVariable)this.listaVariables.getElementAt(t);
                        if (!variableAux.equals(variableToAdd)) continue;
                        bInsertar = false;
                    }
                    if (bInsertar) {
                        this.listaVariables.addItem(variableToAdd);
                        this.listaVariables.setBackground(ModelaUI.colorFondoTextoModificandose);
                        System.out.println("- Variable detectada: " + variableToAdd);
                        continue;
                    }
                    System.out.println("- Variable detectada pero ya asociada: " + variableToAdd);
                    continue;
                }
                arrVariablesNoValidas.add(variableToAdd);
                continue;
            }
            System.out.println("- Variable reutilizable ignorada: " + variableToAdd);
        }
        if (arrVariablesNoValidas.size() > 0) {
            String strNombreNoValidas = new String();
            for (int i = 0; i < arrVariablesNoValidas.size(); ++i) {
                strNombreNoValidas = strNombreNoValidas + "\n - " + arrVariablesNoValidas.get(i);
            }
            JOptionPane.showMessageDialog(null, "Se detectaron variables cuya longitud supera a la permitida (25 caracteres):" + strNombreNoValidas + "\nEstas variables no ser\u00e1n asociadas al documento.", "Atenci\u00f3n", 2);
        }
    }

    public void eliminarVariable_actionPerformed() {
        if (!this.listaVariables.hasAnyObject()) {
            this.inicializarCampos(3);
            return;
        }
        if (this.listaVariables.getSelectedValue() != null) {
            Object[] options;
            int n;
            int[] index = this.listaVariables.getSelectedIndices();
            String msgDel = "\u00bfConfirma eliminar el elemento seleccionado?";
            if (index.length > 1) {
                msgDel = "\u00bfConfirma eliminar los elementos seleccionados?";
            }
            if ((n = JOptionPane.showOptionDialog(this, msgDel, "Eliminar", 0, 3, null, options = new Object[]{"Aceptar", "Cancelar"}, options[1])) == 1 || n == -1) {
                return;
            }
            for (int d = index.length - 1; d >= 0; --d) {
                this.listaVariables.removeItem(index[d]);
            }
            this.listaVariables.setBackground(ModelaUI.colorFondoTextoModificandose);
            if (!this.listaVariables.hasAnyObject()) {
                this.listaVariables.setToolTipText(null);
            }
        }
    }

    void eliminarPlantilla() {
        if (this.plantillaTextField.getObjetoAsignable() != null) {
            this.plantillaTextField.setObjetoAsignable(null);
            this.eliminarPlantillaBtn.setEnabled(false);
        }
    }

    public void inicializarFoco() {
        this.etiquetaTextField.requestFocus();
    }

    public void conservarColoresDeFondo() {
        this.colorFondoEtiqueta = this.etiquetaTextField.getBackground();
        this.colorFondoNombre = this.nombreTextField.getBackground();
        this.colorFondoDescripcion = this.descripTextArea.getBackground();
        this.colorFondoTextoAux = this.textoAuxiliarField.getBackground();
        this.colorFondoMultiple = this.isMultipleCheck.getForeground();
        this.colorFondoFechaFirma = this.isFechaFirmaCheck.getForeground();
        this.colorFondoComboEntradaSalida = this.entSalCombo.getBackground();
        this.colorFondoComboGenerarIncorporar = this.incGenCombo.getBackground();
        this.colorFondoComboClase = this.claseCombo.getBackground();
        this.colorFuenteLabelPlantilla = this.plantillaLabel.getForeground();
        this.colorFondoComboModoGeneracion = this.cmbModGen.getBackground();
        this.colorFondoInformar = this.isInformarCheck.getForeground();
        this.colorFondoArchivable = this.isArchivableCheck.getForeground();
        this.colorFondoVersionable = this.isVersionableCheck.getForeground();
        this.colorFondoRegistrable = this.isRegistrableCheck.getForeground();
        this.colorFondoNotificable = this.isNotificableCheck.getForeground();
        this.colorFondoFirma = this.isFirma_DigiCheck.getForeground();
        this.colorFondoReutilizable = this.isReutilizableCheck.getForeground();
        this.colorFondoFusionar = this.isFusionar_VarCheck.getForeground();
        this.colorFondoComboTipoFirma = this.cmbTipo_Firma.getBackground();
        this.colorFuenteLabelPlantillaBin = this.plantillaBinariaVariableLabel.getForeground();
        this.colorFondoListaVariables = this.listaVariables.getBackground();
        this.panelParrafos.conservarColoresDeFondo();
    }

    public void restaurarColoresDeFondo() {
        if (this.colorFondoEtiqueta != null) {
            this.etiquetaTextField.setBackground(this.colorFondoEtiqueta);
            this.colorFondoEtiqueta = null;
        }
        if (this.colorFondoNombre != null) {
            this.nombreTextField.setBackground(this.colorFondoNombre);
            this.colorFondoNombre = null;
        }
        if (this.colorFondoDescripcion != null) {
            this.descripTextArea.setBackground(this.colorFondoDescripcion);
            this.colorFondoDescripcion = null;
        }
        if (this.colorFondoTextoAux != null) {
            this.textoAuxiliarField.setBackground(this.colorFondoTextoAux);
            this.colorFondoTextoAux = null;
        }
        if (this.colorFondoMultiple != null) {
            this.isMultipleCheck.setForeground(this.colorFondoMultiple);
            this.colorFondoMultiple = null;
        }
        if (this.colorFondoFechaFirma != null) {
            this.isFechaFirmaCheck.setForeground(this.colorFondoFechaFirma);
            this.colorFondoFechaFirma = null;
        }
        if (this.colorFondoComboEntradaSalida != null) {
            this.entSalCombo.setBackground(this.colorFondoComboEntradaSalida);
            this.colorFondoComboEntradaSalida = null;
        }
        if (this.colorFondoComboGenerarIncorporar != null) {
            this.incGenCombo.setBackground(this.colorFondoComboGenerarIncorporar);
            this.colorFondoComboGenerarIncorporar = null;
        }
        if (this.colorFondoComboClase != null) {
            this.claseCombo.setBackground(this.colorFondoComboClase);
            this.colorFondoComboClase = null;
        }
        if (this.colorFuenteLabelPlantilla != null) {
            this.plantillaLabel.setForeground(this.colorFuenteLabelPlantilla);
            this.colorFuenteLabelPlantilla = null;
        }
        if (this.colorFondoComboModoGeneracion != null) {
            this.cmbModGen.setBackground(this.colorFondoComboModoGeneracion);
            this.colorFondoComboModoGeneracion = null;
        }
        if (this.colorFondoInformar != null) {
            this.isInformarCheck.setForeground(this.colorFondoInformar);
            this.colorFondoInformar = null;
        }
        if (this.colorFondoArchivable != null) {
            this.isArchivableCheck.setForeground(this.colorFondoArchivable);
            this.colorFondoArchivable = null;
        }
        if (this.colorFondoVersionable != null) {
            this.isVersionableCheck.setForeground(this.colorFondoVersionable);
            this.colorFondoVersionable = null;
        }
        if (this.colorFondoRegistrable != null) {
            this.isRegistrableCheck.setForeground(this.colorFondoRegistrable);
            this.colorFondoRegistrable = null;
        }
        if (this.colorFondoNotificable != null) {
            this.isNotificableCheck.setForeground(this.colorFondoNotificable);
            this.colorFondoNotificable = null;
        }
        if (this.colorFondoReutilizable != null) {
            this.isReutilizableCheck.setForeground(this.colorFondoReutilizable);
            this.colorFondoReutilizable = null;
        }
        if (this.colorFondoFusionar != null) {
            this.isFusionar_VarCheck.setForeground(this.colorFondoFusionar);
            this.colorFondoFusionar = null;
        }
        if (this.colorFondoFirma != null) {
            this.isFirma_DigiCheck.setForeground(this.colorFondoFirma);
            this.colorFondoFirma = null;
        }
        if (this.colorFondoComboTipoFirma != null) {
            this.cmbTipo_Firma.setBackground(this.colorFondoComboTipoFirma);
            this.colorFondoComboTipoFirma = null;
        }
        if (this.colorFuenteLabelPlantillaBin != null) {
            this.plantillaBinariaVariableLabel.setForeground(this.colorFuenteLabelPlantillaBin);
            this.colorFuenteLabelPlantillaBin = null;
        }
        if (this.colorFondoListaVariables != null) {
            this.listaVariables.setBackground(this.colorFondoListaVariables);
            this.colorFondoListaVariables = null;
        }
        this.panelParrafos.restaurarColoresDeFondo();
    }

    public void abrirArchivoPlantilla(ActionEvent e) {
        Runtime r = Runtime.getRuntime();
        if (this.plantillaBinariaVariableText.getText().equals("")) {
            return;
        }
        try {
            String strRutaValidaExe = null;
            if (CopiadorArchivos.existeArchivo(this.rutaVariableBinaria)) {
                strRutaValidaExe = this.rutaVariableBinaria;
            } else if (CopiadorArchivos.existeArchivo(ModelaConf.getRutaArchivo() + System.getProperty("file.separator") + this.sFicheroVariableBinaria)) {
                strRutaValidaExe = ModelaConf.getRutaArchivo() + System.getProperty("file.separator") + this.sFicheroVariableBinaria;
            } else {
                JOptionPane.showMessageDialog(null, "No se ha podido localizar el fichero asociado.", "Atenci\u00f3n", 0);
            }
            if (strRutaValidaExe != null) {
                String tmp = System.getProperty("os.name");
                if (tmp.startsWith(this.sistemaOperativo)) {
                    r.exec("rundll32 SHELL32.DLL,ShellExec_RunDLL " + strRutaValidaExe);
                } else {
                    String[] comando = new String[]{"xdg-open", strRutaValidaExe};
                    r.exec(comando);
                }
            }
        }
        catch (Exception ex) {
            Object[] opciones = new Object[]{"Aceptar", "Cancelar"};
            int n = JOptionPane.showOptionDialog(null, "Archivo no encontrado.", "Atencion", 0, 3, null, opciones, opciones[1]);
            if (n == -1) {
                n = 1;
            }
            if (n == 1) {
                return;
            }
            ActionEvent acEven = null;
            this.selPlantillaBinButton_actionPerformed(acEven);
            return;
        }
    }
}

