/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.ui.IAsignable;
import gdtel.ui.swing.FileFilterEx;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import gdtel.ui.swing.excontrols.CreadorButton;
import gdtel.ui.swing.excontrols.JCheckBoxEx;
import gdtel.ui.swing.excontrols.JComboBoxEx;
import gdtel.ui.swing.excontrols.JFiltroTextArea;
import gdtel.ui.swing.excontrols.JFiltroTextField;
import gdtel.ui.swing.excontrols.JPanelAtributable;
import gdtel.util.CopiadorArchivos;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import modela.bd.obj.TrTipoParrafo;
import modela.conf.ModelaConf;
import modela.ui.MimeTypeUtil;
import modela.ui.ModelaUI;
import modela.ui.TipoMime;
import modela.ui.swing.PropBloqueJPanel;
import modela.ui.swing.PropFaseJPanel;
import modela.util.UtilidadesVarias;

public class PropTipoParrafoJPanel
extends JPanelAtributable {
    private static final long serialVersionUID = 8540223725547386498L;
    private final JFiltroTextField nombreTextField = new JFiltroTextField();
    private final JLabel abreviaturaLabel = new JLabel();
    private final JLabel imagenLabel = new JLabel();
    private final JFiltroTextField nombreImagenTextField = new JFiltroTextField();
    private String sMime = null;
    private String sRutaCompleta = null;
    private final JLabel decripAreaLabel = new JLabel();
    private final JFiltroTextArea decripTextArea = new JFiltroTextArea();
    private final JLabel tituloPanelLabel = new JLabel();
    private final XYLayout xYLayout = new XYLayout();
    private final JCheckBoxEx isEditableCheck = new JCheckBoxEx();
    private final JLabel ubicacionLabel = new JLabel();
    private final JComboBoxEx comboUbicacion = new JComboBoxEx();
    private final JLabel etiquetaLabel = new JLabel();
    JFiltroTextField etiquetaTextField = new JFiltroTextField();
    private final JLabel contenidoLabel = new JLabel();
    JFiltroTextArea contenidoTextArea = new JFiltroTextArea();
    private final JToggleButton negritaButton = new JToggleButton();
    private final JToggleButton cursivaButton = new JToggleButton();
    private final JToggleButton subrayadoButton = new JToggleButton();
    public JToggleButton negritaEtiqButton = new JToggleButton();
    private final JToggleButton cursivaEtiqButton = new JToggleButton();
    private final JToggleButton subrayadoEtiqButton = new JToggleButton();
    private final JToggleButton izqButton = new JToggleButton();
    private final JToggleButton derButton = new JToggleButton();
    private final JToggleButton centrarButton = new JToggleButton();
    private final JToggleButton justificarButton = new JToggleButton();
    private final String sistemaOperativo = "Wind";
    ImageIcon seleccionarIconN = new ImageIcon(PropFaseJPanel.class.getResource(ModelaUI.IMG_SMALL_SELECCION));
    ImageIcon seleccionarIconS = new ImageIcon(PropFaseJPanel.class.getResource(ModelaUI.IMG_SMALL_SELECCION_SOBRE));
    ImageIcon seleccionarIconD = new ImageIcon(PropFaseJPanel.class.getResource(ModelaUI.IMG_SMALL_SELECCION_NO_ENABLED));
    JButton seleccionarImagenButton = (JButton)CreadorButton.crearBoton(1, false, this.seleccionarIconN, this.seleccionarIconD, this.seleccionarIconS, this.seleccionarIconS);
    ImageIcon quitarIconN = new ImageIcon(PropBloqueJPanel.class.getResource(ModelaUI.IMG_SMALL_QUITAR));
    ImageIcon quitarIconS = new ImageIcon(PropBloqueJPanel.class.getResource(ModelaUI.IMG_SMALL_QUITAR_SOBRE));
    ImageIcon quitarIconD = new ImageIcon(PropBloqueJPanel.class.getResource(ModelaUI.IMG_SMALL_QUITAR_NO_ENABLED));
    JButton eliminarImagenButton = (JButton)CreadorButton.crearBoton(1, false, this.quitarIconN, this.quitarIconD, this.quitarIconS, this.quitarIconS);
    ImageIcon previewIconN = new ImageIcon(PropFaseJPanel.class.getResource(ModelaUI.IMG_PREVIEW_FILE));
    ImageIcon previewIconS = new ImageIcon(PropFaseJPanel.class.getResource(ModelaUI.IMG_PREVIEW_FILE_SOBRE));
    ImageIcon previewIconD = new ImageIcon(PropFaseJPanel.class.getResource(ModelaUI.IMG_PREVIEW_FILE_NO_ENABLED));
    JButton vistaArchivoButton = (JButton)CreadorButton.crearBoton(1, false, this.seleccionarIconN, this.seleccionarIconD, this.seleccionarIconS, this.seleccionarIconS);
    private Color colorFondoAbreviatura = null;
    private Color colorFondoDescripcion = null;
    private Color colorFondoEditable = null;
    private Color colorFondoUbicacion = null;
    private Color colorFuenteImagen = null;
    private Color colorFondoEtiqueta = null;
    private Color colorFondoContenido = null;

    public PropTipoParrafoJPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void jbInit() {
        this.setLayout(this.xYLayout);
        this.abreviaturaLabel.setText("Abreviatura:");
        this.abreviaturaLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.imagenLabel.setText("Imagen:");
        this.imagenLabel.setFont(ModelaUI.fuentePrincipal);
        this.decripAreaLabel.setText("Descripci\u00f3n:");
        this.decripAreaLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.tituloPanelLabel.setText("Propiedades del tipo de p\u00e1rrafo");
        this.tituloPanelLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.tituloPanelLabel.setForeground(ModelaUI.colorSeleccion);
        this.ubicacionLabel.setText("Ubicaci\u00f3n:");
        this.ubicacionLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.etiquetaLabel.setText("Etiqueta:");
        this.contenidoLabel.setText("Contenido:");
        this.nombreTextField.setNumItems(15);
        this.nombreTextField.establecerTipografia(1);
        this.nombreTextField.setTipoFiltro(1);
        this.nombreTextField.setEnabled(true);
        this.nombreTextField.setEditable(false);
        this.nombreImagenTextField.setToolTipText("Doble clic para abrir");
        this.nombreImagenTextField.setNumItems(64);
        this.nombreImagenTextField.establecerTipografia(2);
        this.nombreImagenTextField.setTipoFiltro(1);
        this.nombreImagenTextField.setEnabled(true);
        this.nombreImagenTextField.setEditable(false);
        this.nombreImagenTextField.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                if (e.getSource() != null && e.getClickCount() == 2) {
                    PropTipoParrafoJPanel.this.abrirArchivoPlantilla(null);
                    return;
                }
            }
        });
        this.decripTextArea.setNumItems(250);
        this.decripTextArea.establecerTipografia(1);
        this.decripTextArea.setTipoFiltro(1);
        this.decripTextArea.setEnabled(true);
        this.decripTextArea.setEditable(false);
        this.contenidoTextArea.setNumItems(4000);
        this.contenidoTextArea.setTipoFiltro(1);
        this.isEditableCheck.setText("Editable");
        this.isEditableCheck.setEnabled(false);
        this.isEditableCheck.setFont(ModelaUI.fuentePrincipalNegrita);
        this.etiquetaTextField.setNumItems(15);
        this.etiquetaTextField.setTipoFiltro(1);
        this.negritaButton.setText("N");
        this.negritaButton.setFont(new Font("Tahoma", 1, 8));
        this.negritaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropTipoParrafoJPanel.this.negritaButton_actionPerformed(e);
                PropTipoParrafoJPanel.this.contenidoTextArea.setBackground(ModelaUI.colorFondoTextoModificandose);
            }
        });
        this.cursivaButton.setText("K");
        this.cursivaButton.setFont(new Font("Tahoma", 2, 9));
        this.cursivaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropTipoParrafoJPanel.this.cursivaButton_actionPerformed(e);
                PropTipoParrafoJPanel.this.contenidoTextArea.setBackground(ModelaUI.colorFondoTextoModificandose);
            }
        });
        this.subrayadoButton.setText("S");
        this.subrayadoButton.setFont(new Font("Tahoma", 0, 10));
        this.subrayadoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropTipoParrafoJPanel.this.subrayadoButton_actionPerformed(e);
                PropTipoParrafoJPanel.this.contenidoTextArea.setBackground(ModelaUI.colorFondoTextoModificandose);
            }
        });
        this.negritaEtiqButton.setText("N");
        this.negritaEtiqButton.setFont(new Font("Tahoma", 1, 8));
        this.negritaEtiqButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropTipoParrafoJPanel.this.negritaEtiqButton_actionPerformed(e);
                PropTipoParrafoJPanel.this.etiquetaTextField.setBackground(ModelaUI.colorFondoTextoModificandose);
            }
        });
        this.cursivaEtiqButton.setText("K");
        this.cursivaEtiqButton.setFont(new Font("Tahoma", 2, 9));
        this.cursivaEtiqButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropTipoParrafoJPanel.this.cursivaEtiqButton_actionPerformed(e);
                PropTipoParrafoJPanel.this.etiquetaTextField.setBackground(ModelaUI.colorFondoTextoModificandose);
            }
        });
        this.subrayadoEtiqButton.setText("S");
        this.subrayadoEtiqButton.setFont(new Font("Tahoma", 0, 8));
        this.subrayadoEtiqButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropTipoParrafoJPanel.this.subrayadoEtiqButton_actionPerformed(e);
                PropTipoParrafoJPanel.this.etiquetaTextField.setBackground(ModelaUI.colorFondoTextoModificandose);
            }
        });
        this.izqButton.setText("|-");
        this.izqButton.setFont(new Font("Tahoma", 0, 8));
        this.izqButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropTipoParrafoJPanel.this.izqButton_actionPerformed(e);
                PropTipoParrafoJPanel.this.contenidoTextArea.setBackground(ModelaUI.colorFondoTextoModificandose);
            }
        });
        this.derButton.setText("-|");
        this.derButton.setFont(new Font("Tahoma", 0, 8));
        this.derButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropTipoParrafoJPanel.this.derButton_actionPerformed(e);
                PropTipoParrafoJPanel.this.contenidoTextArea.setBackground(ModelaUI.colorFondoTextoModificandose);
            }
        });
        this.centrarButton.setText("-");
        this.centrarButton.setFont(new Font("Tahoma", 0, 8));
        this.centrarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropTipoParrafoJPanel.this.centrarButton_actionPerformed(e);
                PropTipoParrafoJPanel.this.contenidoTextArea.setBackground(ModelaUI.colorFondoTextoModificandose);
            }
        });
        this.justificarButton.setText("--");
        this.justificarButton.setFont(new Font("Tahoma", 0, 7));
        this.justificarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropTipoParrafoJPanel.this.justificarButton_actionPerformed(e);
                PropTipoParrafoJPanel.this.contenidoTextArea.setBackground(ModelaUI.colorFondoTextoModificandose);
            }
        });
        this.seleccionarImagenButton.setBorderPainted(false);
        this.seleccionarImagenButton.setFocusPainted(false);
        this.seleccionarImagenButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropTipoParrafoJPanel.this.seleccionarImagen_actionPerformed(e);
            }
        });
        this.eliminarImagenButton.setBorderPainted(false);
        this.eliminarImagenButton.setFocusPainted(false);
        this.eliminarImagenButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropTipoParrafoJPanel.this.eliminarImagen_actionPerformed(e);
            }
        });
        this.add((Component)this.tituloPanelLabel, new XYConstraints(0, 0, 250, 15));
        this.add((Component)this.abreviaturaLabel, new XYConstraints(0, 50, 100, 15));
        this.add((Component)this.nombreTextField, new XYConstraints(0, 65, 150, 25));
        this.add((Component)this.ubicacionLabel, new XYConstraints(170, 50, 80, 15));
        this.add((Component)this.comboUbicacion, new XYConstraints(170, 65, 120, 25));
        this.add((Component)this.isEditableCheck, new XYConstraints(310, 70, 85, 20));
        this.add((Component)this.decripAreaLabel, new XYConstraints(0, 100, 100, 15));
        this.add((Component)this.decripTextArea.getScrollableArea(), new XYConstraints(0, 115, 555, 45));
        this.add((Component)this.imagenLabel, new XYConstraints(0, 181, 100, 20));
        this.add((Component)this.nombreImagenTextField, new XYConstraints(55, 180, 370, 25));
        this.add((Component)this.seleccionarImagenButton, new XYConstraints(435, 180, 85, 25));
        this.add((Component)this.eliminarImagenButton, new XYConstraints(520, 182, 30, 21));
        this.add((Component)this.etiquetaLabel, new XYConstraints(0, 220, 60, 15));
        this.add((Component)this.etiquetaTextField, new XYConstraints(0, 240, 180, 25));
        this.add((Component)this.contenidoLabel, new XYConstraints(195, 220, 70, 15));
        this.add((Component)this.contenidoTextArea.getScrollableArea(), new XYConstraints(195, 240, 360, 115));
        this.add((Component)this.negritaButton, new XYConstraints(265, 215, 40, 20));
        this.add((Component)this.cursivaButton, new XYConstraints(305, 215, 40, 20));
        this.add((Component)this.subrayadoButton, new XYConstraints(345, 215, 40, 20));
        this.add((Component)this.izqButton, new XYConstraints(395, 215, 40, 20));
        this.add((Component)this.centrarButton, new XYConstraints(435, 215, 40, 20));
        this.add((Component)this.derButton, new XYConstraints(475, 215, 40, 20));
        this.add((Component)this.justificarButton, new XYConstraints(515, 215, 40, 20));
        this.add((Component)this.negritaEtiqButton, new XYConstraints(60, 215, 40, 20));
        this.add((Component)this.cursivaEtiqButton, new XYConstraints(100, 215, 40, 20));
        this.add((Component)this.subrayadoEtiqButton, new XYConstraints(140, 215, 40, 20));
        this.vistaArchivoButton.setBorderPainted(false);
        this.vistaArchivoButton.setFocusPainted(false);
        this.vistaArchivoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropTipoParrafoJPanel.this.abrirArchivoPlantilla(e);
            }
        });
        this.decripTextArea.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                if (evt.getKeyChar() == '\t') {
                    PropTipoParrafoJPanel.this.negritaEtiqButton.requestFocus();
                }
            }
        });
        this.comboUbicacion.setEditable(false);
        this.cargarCmbUbicacion();
    }

    public void limpiarCampos() {
        this.nombreTextField.setText("");
        this.nombreImagenTextField.setText("");
        this.sMime = "";
        this.sRutaCompleta = "";
        this.decripTextArea.setText("");
        this.isEditableCheck.setSelected(false);
        this.etiquetaTextField.setText("");
        this.contenidoTextArea.setText("");
        this.comboUbicacion.setSelectedIndex(0);
        this.centrarButton.setSelected(false);
        this.izqButton.setSelected(true);
        this.derButton.setSelected(false);
        this.justificarButton.setSelected(false);
        this.negritaButton.setSelected(false);
        this.cursivaButton.setSelected(false);
        this.subrayadoButton.setSelected(false);
        this.negritaEtiqButton.setSelected(false);
        this.cursivaEtiqButton.setSelected(false);
        this.subrayadoEtiqButton.setSelected(false);
        this.etiquetaTextField.setFont(new Font("Tahoma", 0, 13));
        this.contenidoTextArea.setFont(new Font("Tahoma", 0, 13));
        this.aplicarAlineacionContenido(this.getAlineacionContenido());
        this.eliminarImagen_actionPerformed(null);
    }

    public void inicializarCampos(int nTipo) {
        boolean activo = false;
        boolean bReiniciarColoresLabel = true;
        switch (nTipo) {
            case 4: {
                this.conservarColoresDeFondo();
                bReiniciarColoresLabel = false;
                break;
            }
            case 2: {
                activo = false;
                bReiniciarColoresLabel = false;
                break;
            }
            case 3: {
                activo = true;
                break;
            }
            case 1: {
                this.iDatoAsignable = new TrTipoParrafo();
                this.limpiarCampos();
                activo = true;
            }
        }
        this.nombreTextField.setEditable(activo);
        this.nombreImagenTextField.setEditable(false);
        this.decripTextArea.setEditable(activo);
        this.isEditableCheck.setEnabled(activo);
        this.etiquetaTextField.setEditable(activo);
        this.contenidoTextArea.setEditable(activo);
        this.negritaButton.setEnabled(activo);
        this.cursivaButton.setEnabled(activo);
        this.subrayadoButton.setEnabled(activo);
        this.negritaEtiqButton.setEnabled(activo);
        this.cursivaEtiqButton.setEnabled(activo);
        this.subrayadoEtiqButton.setEnabled(activo);
        this.izqButton.setEnabled(activo);
        this.derButton.setEnabled(activo);
        this.centrarButton.setEnabled(activo);
        this.justificarButton.setEnabled(activo);
        this.comboUbicacion.setEnabled(activo);
        this.seleccionarImagenButton.setEnabled(activo);
        this.eliminarImagenButton.setEnabled(activo);
        this.vistaArchivoButton.setEnabled(activo);
        if (bReiniciarColoresLabel) {
            this.imagenLabel.setForeground(Color.BLACK);
        }
    }

    public IAsignable getValoresAsignables() {
        return this.iDatoAsignable;
    }

    public void setValoresAsignables(IAsignable datosAsignables) {
        if (datosAsignables != null && datosAsignables instanceof TrTipoParrafo) {
            this.iDatoAsignable = datosAsignables;
            TrTipoParrafo tipoParrafo = (TrTipoParrafo)datosAsignables;
            this.nombreTextField.setText(tipoParrafo.getAbreviatura());
            this.nombreImagenTextField.setText(tipoParrafo.getNombreFichero());
            this.sMime = tipoParrafo.getFormato();
            this.sRutaCompleta = tipoParrafo.getRutaCompleta();
            this.decripTextArea.setText(tipoParrafo.getDescripcion());
            this.isEditableCheck.setSelected(tipoParrafo.isEditable());
            this.etiquetaTextField.setText(tipoParrafo.getEtiqueta());
            this.contenidoTextArea.setText(tipoParrafo.getContenido());
            if (tipoParrafo.getUbicacion() != null && !tipoParrafo.getUbicacion().equals("")) {
                if (tipoParrafo.getUbicacion().equals("A")) {
                    this.comboUbicacion.setSelectedItem("CABECERA");
                }
                if (tipoParrafo.getUbicacion().equals("C")) {
                    this.comboUbicacion.setSelectedItem("CUERPO");
                }
                if (tipoParrafo.getUbicacion().equals("P")) {
                    this.comboUbicacion.setSelectedItem("PIE");
                }
                if (tipoParrafo.getUbicacion().equals("O")) {
                    this.comboUbicacion.setSelectedItem("OTRO");
                }
            }
            this.setEstiloEtiqueta(tipoParrafo.getEstiloEtiq());
            this.setEstiloContenido(tipoParrafo.getEstilo());
            this.SetAlineacionContenido(tipoParrafo.getAlineacion());
        }
    }

    public String getTitulo(int n) {
        return "Mantenimiento de tipo de par\u00e1metros";
    }

    public boolean obtenerValoresCampos() {
        TrTipoParrafo tipoParrafo = null;
        boolean ok = true;
        tipoParrafo = new TrTipoParrafo();
        tipoParrafo = (TrTipoParrafo)this.iDatoAsignable;
        if (tipoParrafo == null) {
            ok = false;
        } else if (this.nombreTextField.getText() == null || this.decripTextArea.getText() == null) {
            ok = false;
        } else if (this.nombreTextField.getText().equals("") || this.decripTextArea.getText().equals("")) {
            ok = false;
        }
        if (this.comboUbicacion.getSelectedIndex() < 0) {
            ok = false;
        }
        if (!ok) {
            JOptionPane.showMessageDialog(null, MantenimientoJDialog.TEXTO_FALTAN_ATRIBUTOS_OBLIGATORIOS, MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
        } else {
            int nSelectedItem;
            if (tipoParrafo != null) {
                tipoParrafo.setAbreviatura(this.nombreTextField.getText());
                tipoParrafo.setNombreFichero(this.nombreImagenTextField.getText());
                tipoParrafo.setFormato(this.sMime);
                tipoParrafo.setRutaCompleta(this.sRutaCompleta);
                tipoParrafo.setDescripcion(this.decripTextArea.getText());
                tipoParrafo.setEditable(this.isEditableCheck.isSelected());
            }
            if ((nSelectedItem = this.comboUbicacion.getSelectedIndex()) >= 0) {
                if (this.comboUbicacion.getItemAt(nSelectedItem).toString().equals("CABECERA") && tipoParrafo != null) {
                    tipoParrafo.setUbicacion("A");
                }
                if (this.comboUbicacion.getItemAt(nSelectedItem).toString().equals("CUERPO") && tipoParrafo != null) {
                    tipoParrafo.setUbicacion("C");
                }
                if (this.comboUbicacion.getItemAt(nSelectedItem).toString().equals("PIE") && tipoParrafo != null) {
                    tipoParrafo.setUbicacion("P");
                }
                if (this.comboUbicacion.getItemAt(nSelectedItem).toString().equals("OTRO") && tipoParrafo != null) {
                    tipoParrafo.setUbicacion("O");
                }
            }
            if (tipoParrafo != null) {
                tipoParrafo.setEtiqueta(this.etiquetaTextField.getText());
                tipoParrafo.setContenido(this.contenidoTextArea.getText());
                tipoParrafo.setEstiloEtiq(this.getEstiloEtiqueta());
                tipoParrafo.setEstilo(this.getEstiloContenido());
                tipoParrafo.setAlineacion(this.getAlineacionContenido());
            }
        }
        return ok;
    }

    public void negritaEtiqButton_actionPerformed(ActionEvent e) {
        this.negritaEtiqButton.setSelected(this.negritaEtiqButton.isSelected());
        this.aplicarEstiloEtiqueta(this.getEstiloEtiqueta());
    }

    public void cursivaEtiqButton_actionPerformed(ActionEvent e) {
        this.cursivaEtiqButton.setSelected(this.cursivaEtiqButton.isSelected());
        this.aplicarEstiloEtiqueta(this.getEstiloEtiqueta());
    }

    public void subrayadoEtiqButton_actionPerformed(ActionEvent e) {
        this.subrayadoEtiqButton.setSelected(this.subrayadoEtiqButton.isSelected());
        this.aplicarEstiloEtiqueta(this.getEstiloEtiqueta());
    }

    void seleccionarImagen_actionPerformed(ActionEvent e) {
        String strRuta = ModelaConf.getRutaArchivo();
        JFileChooser fileDlg = strRuta != null ? new JFileChooser(strRuta) : new JFileChooser();
        fileDlg.setFileSelectionMode(0);
        String[] ext = new String[]{"bmp", "gif", "jpg"};
        FileFilterEx filter = new FileFilterEx(ext, "Im\u00e1genes");
        fileDlg.addChoosableFileFilter(filter);
        int nRet = fileDlg.showOpenDialog(this);
        if (nRet == 0) {
            File fich = fileDlg.getSelectedFile();
            String sFichero = fich.getName();
            if (sFichero != null && sFichero.length() > 64) {
                Object[] opciones = new Object[]{"S\u00ed", "No, renombrar\u00e9 manualmente"};
                int n = JOptionPane.showOptionDialog(null, "Nombre del fichero demasiado largo:\nLa longitud m\u00e1xima permitida es de 64 caracteres (extensi\u00f3n incluida).\n\n\u00bfQuiere renombrarlo autom\u00e1ticamente a ... \n" + UtilidadesVarias.adjustNameFileMaxLen(fich.getName(), 64) + " ?", "Atenci\u00f3n", 0, 2, null, opciones, opciones[1]);
                if (n != 0) {
                    return;
                }
                File fileDestino = new File(fich.getParent() + File.separator + UtilidadesVarias.adjustNameFileMaxLen(fich.getName(), 64));
                if (fich.renameTo(fileDestino)) {
                    sFichero = fileDestino.getName();
                } else {
                    return;
                }
            }
            this.nombreImagenTextField.setText(sFichero);
            this.sMime = TipoMime.obtenerTipoMime(fich);
            MimeTypeUtil mime = MimeTypeUtil.getInstance();
            this.sMime = mime.mimeTypeOf(fich.getPath());
            this.sRutaCompleta = fich.getPath();
            this.imagenLabel.setForeground(ModelaUI.colorFuenteEtiquetaModificandose);
        }
    }

    void eliminarImagen_actionPerformed(ActionEvent e) {
        if (!this.nombreImagenTextField.getText().equals("")) {
            this.imagenLabel.setForeground(ModelaUI.colorFuenteEtiquetaModificandose);
        }
        this.nombreImagenTextField.setText("");
        this.sMime = "";
        this.sRutaCompleta = "";
    }

    private void cargarCmbUbicacion() {
        this.comboUbicacion.removeAllItems();
        this.comboUbicacion.addItem("CABECERA");
        this.comboUbicacion.addItem("CUERPO");
        this.comboUbicacion.addItem("PIE");
        this.comboUbicacion.addItem("OTRO");
        this.comboUbicacion.setSelectedIndex(0);
    }

    private String getEstiloEtiqueta() {
        if (!(this.negritaEtiqButton.isSelected() || this.cursivaEtiqButton.isSelected() || this.subrayadoEtiqButton.isSelected())) {
            return "NORMAL";
        }
        if (this.negritaEtiqButton.isSelected() && !this.cursivaEtiqButton.isSelected() && !this.subrayadoEtiqButton.isSelected()) {
            return "NEGRIT";
        }
        if (!this.negritaEtiqButton.isSelected() && this.cursivaEtiqButton.isSelected() && !this.subrayadoEtiqButton.isSelected()) {
            return "CURSIV";
        }
        if (!this.negritaEtiqButton.isSelected() && !this.cursivaEtiqButton.isSelected() && this.subrayadoEtiqButton.isSelected()) {
            return "SUBRAY";
        }
        if (this.negritaEtiqButton.isSelected() && this.cursivaEtiqButton.isSelected() && !this.subrayadoEtiqButton.isSelected()) {
            return "NE-CU";
        }
        if (this.negritaEtiqButton.isSelected() && !this.cursivaEtiqButton.isSelected() && this.subrayadoEtiqButton.isSelected()) {
            return "NE-SU";
        }
        if (!this.negritaEtiqButton.isSelected() && this.cursivaEtiqButton.isSelected() && this.subrayadoEtiqButton.isSelected()) {
            return "CU-SU";
        }
        if (this.negritaEtiqButton.isSelected() && this.cursivaEtiqButton.isSelected() && this.subrayadoEtiqButton.isSelected()) {
            return "NE-CU-SU";
        }
        return "NORMAL";
    }

    private void aplicarEstiloEtiqueta(String strEstiloEtiq) {
        if (strEstiloEtiq.equals("NORMAL")) {
            this.etiquetaTextField.setFont(new Font("Tahoma", 0, 13));
        }
        if (strEstiloEtiq.equals("NEGRIT")) {
            this.etiquetaTextField.setFont(new Font("Tahoma", 1, 13));
        }
        if (strEstiloEtiq.equals("CURSIV")) {
            this.etiquetaTextField.setFont(new Font("Tahoma", 2, 13));
        }
        if (strEstiloEtiq.equals("SUBRAY")) {
            this.etiquetaTextField.setFont(new Font("Tahoma", 0, 13));
        }
        if (strEstiloEtiq.equals("NE-CU")) {
            this.etiquetaTextField.setFont(new Font("Tahoma", 3, 13));
        }
        if (strEstiloEtiq.equals("NE-SU")) {
            this.etiquetaTextField.setFont(new Font("Tahoma", 1, 13));
        }
        if (strEstiloEtiq.equals("CU-SU")) {
            this.etiquetaTextField.setFont(new Font("Tahoma", 2, 13));
        }
        if (strEstiloEtiq.equals("NE-CU-SU")) {
            this.etiquetaTextField.setFont(new Font("Tahoma", 3, 13));
        }
    }

    public void negritaButton_actionPerformed(ActionEvent e) {
        this.negritaButton.setSelected(this.negritaButton.isSelected());
        this.aplicarEstiloContenido(this.getEstiloContenido());
    }

    public void cursivaButton_actionPerformed(ActionEvent e) {
        this.cursivaButton.setSelected(this.cursivaButton.isSelected());
        this.aplicarEstiloContenido(this.getEstiloContenido());
    }

    public void subrayadoButton_actionPerformed(ActionEvent e) {
        this.subrayadoButton.setSelected(this.subrayadoButton.isSelected());
        this.aplicarEstiloContenido(this.getEstiloContenido());
    }

    private void aplicarEstiloContenido(String strEstiloContenido) {
        if (strEstiloContenido.equals("NORMAL")) {
            this.contenidoTextArea.setFont(new Font("Tahoma", 0, 13));
        }
        if (strEstiloContenido.equals("NEGRIT")) {
            this.contenidoTextArea.setFont(new Font("Tahoma", 1, 13));
        }
        if (strEstiloContenido.equals("CURSIV")) {
            this.contenidoTextArea.setFont(new Font("Tahoma", 2, 13));
        }
        if (strEstiloContenido.equals("SUBRAY")) {
            this.contenidoTextArea.setFont(new Font("Tahoma", 0, 13));
        }
        if (strEstiloContenido.equals("NE-CU")) {
            this.contenidoTextArea.setFont(new Font("Tahoma", 3, 13));
        }
        if (strEstiloContenido.equals("NE-SU")) {
            this.contenidoTextArea.setFont(new Font("Tahoma", 1, 13));
        }
        if (strEstiloContenido.equals("CU-SU")) {
            this.contenidoTextArea.setFont(new Font("Tahoma", 2, 13));
        }
        if (strEstiloContenido.equals("NE-CU-SU")) {
            this.contenidoTextArea.setFont(new Font("Tahoma", 3, 13));
        }
    }

    private String getEstiloContenido() {
        if (!(this.negritaButton.isSelected() || this.cursivaButton.isSelected() || this.subrayadoButton.isSelected())) {
            return "NORMAL";
        }
        if (this.negritaButton.isSelected() && !this.cursivaButton.isSelected() && !this.subrayadoButton.isSelected()) {
            return "NEGRIT";
        }
        if (!this.negritaButton.isSelected() && this.cursivaButton.isSelected() && !this.subrayadoButton.isSelected()) {
            return "CURSIV";
        }
        if (!this.negritaButton.isSelected() && !this.cursivaButton.isSelected() && this.subrayadoButton.isSelected()) {
            return "SUBRAY";
        }
        if (this.negritaButton.isSelected() && this.cursivaButton.isSelected() && !this.subrayadoButton.isSelected()) {
            return "NE-CU";
        }
        if (this.negritaButton.isSelected() && !this.cursivaButton.isSelected() && this.subrayadoButton.isSelected()) {
            return "NE-SU";
        }
        if (!this.negritaButton.isSelected() && this.cursivaButton.isSelected() && this.subrayadoButton.isSelected()) {
            return "CU-SU";
        }
        if (this.negritaButton.isSelected() && this.cursivaButton.isSelected() && this.subrayadoButton.isSelected()) {
            return "NE-CU-SU";
        }
        return "NORMAL";
    }

    public void izqButton_actionPerformed(ActionEvent e) {
        this.izqButton.setSelected(true);
        this.derButton.setSelected(false);
        this.centrarButton.setSelected(false);
        this.justificarButton.setSelected(false);
        this.aplicarAlineacionContenido(this.getAlineacionContenido());
    }

    public void derButton_actionPerformed(ActionEvent e) {
        this.derButton.setSelected(true);
        this.izqButton.setSelected(false);
        this.centrarButton.setSelected(false);
        this.justificarButton.setSelected(false);
        this.aplicarAlineacionContenido(this.getAlineacionContenido());
    }

    public void centrarButton_actionPerformed(ActionEvent e) {
        this.centrarButton.setSelected(true);
        this.izqButton.setSelected(false);
        this.derButton.setSelected(false);
        this.justificarButton.setSelected(false);
        this.aplicarAlineacionContenido(this.getAlineacionContenido());
    }

    public void justificarButton_actionPerformed(ActionEvent e) {
        this.centrarButton.setSelected(false);
        this.izqButton.setSelected(false);
        this.derButton.setSelected(false);
        this.justificarButton.setSelected(true);
        this.aplicarAlineacionContenido(this.getAlineacionContenido());
    }

    private String getAlineacionContenido() {
        if (this.izqButton.isSelected()) {
            return "I";
        }
        if (this.derButton.isSelected()) {
            return "D";
        }
        if (this.centrarButton.isSelected()) {
            return "C";
        }
        if (this.justificarButton.isSelected()) {
            return "J";
        }
        return "";
    }

    private void aplicarAlineacionContenido(String strAlineacion) {
        if (strAlineacion.equals("I")) {
            this.contenidoTextArea.setAlignmentX(0.0f);
        }
        if (strAlineacion.equals("D")) {
            this.contenidoTextArea.setAlignmentX(1.0f);
        }
        if (strAlineacion.equals("C")) {
            this.contenidoTextArea.setAlignmentX(0.5f);
        }
        if (strAlineacion.equals("J")) {
            this.contenidoTextArea.setAlignmentX(0.0f);
        }
    }

    private void setEstiloEtiqueta(String strEstiloEtiqueta) {
        if (strEstiloEtiqueta.equals("NORMAL")) {
            this.negritaEtiqButton.setSelected(false);
            this.cursivaEtiqButton.setSelected(false);
            this.subrayadoEtiqButton.setSelected(false);
        }
        if (strEstiloEtiqueta.equals("NEGRIT")) {
            this.negritaEtiqButton.setSelected(true);
            this.cursivaEtiqButton.setSelected(false);
            this.subrayadoEtiqButton.setSelected(false);
        }
        if (strEstiloEtiqueta.equals("CURSIV")) {
            this.negritaEtiqButton.setSelected(false);
            this.cursivaEtiqButton.setSelected(true);
            this.subrayadoEtiqButton.setSelected(false);
        }
        if (strEstiloEtiqueta.equals("SUBRAY")) {
            this.negritaEtiqButton.setSelected(false);
            this.cursivaEtiqButton.setSelected(false);
            this.subrayadoEtiqButton.setSelected(true);
        }
        if (strEstiloEtiqueta.equals("NE-CU")) {
            this.negritaEtiqButton.setSelected(true);
            this.cursivaEtiqButton.setSelected(true);
            this.subrayadoEtiqButton.setSelected(false);
        }
        if (strEstiloEtiqueta.equals("NE-SU")) {
            this.negritaEtiqButton.setSelected(true);
            this.cursivaEtiqButton.setSelected(false);
            this.subrayadoEtiqButton.setSelected(true);
        }
        if (strEstiloEtiqueta.equals("CU-SU")) {
            this.negritaEtiqButton.setSelected(false);
            this.cursivaEtiqButton.setSelected(true);
            this.subrayadoEtiqButton.setSelected(true);
        }
        if (strEstiloEtiqueta.equals("NE-CU-SU")) {
            this.negritaEtiqButton.setSelected(true);
            this.cursivaEtiqButton.setSelected(true);
            this.subrayadoEtiqButton.setSelected(true);
        }
        this.aplicarEstiloEtiqueta(strEstiloEtiqueta);
    }

    private void setEstiloContenido(String strEstiloContenido) {
        if (strEstiloContenido.equals("NORMAL")) {
            this.negritaButton.setSelected(false);
            this.cursivaButton.setSelected(false);
            this.subrayadoButton.setSelected(false);
        }
        if (strEstiloContenido.equals("NEGRIT")) {
            this.negritaButton.setSelected(true);
            this.cursivaButton.setSelected(false);
            this.subrayadoButton.setSelected(false);
        }
        if (strEstiloContenido.equals("CURSIV")) {
            this.negritaButton.setSelected(false);
            this.cursivaButton.setSelected(true);
            this.subrayadoButton.setSelected(false);
        }
        if (strEstiloContenido.equals("SUBRAY")) {
            this.negritaButton.setSelected(false);
            this.cursivaButton.setSelected(false);
            this.subrayadoButton.setSelected(true);
        }
        if (strEstiloContenido.equals("NE-CU")) {
            this.negritaButton.setSelected(true);
            this.cursivaButton.setSelected(true);
            this.subrayadoButton.setSelected(false);
        }
        if (strEstiloContenido.equals("NE-SU")) {
            this.negritaButton.setSelected(true);
            this.cursivaButton.setSelected(false);
            this.subrayadoButton.setSelected(true);
        }
        if (strEstiloContenido.equals("CU-SU")) {
            this.negritaButton.setSelected(false);
            this.cursivaButton.setSelected(true);
            this.subrayadoButton.setSelected(true);
        }
        if (strEstiloContenido.equals("NE-CU-SU")) {
            this.negritaButton.setSelected(true);
            this.cursivaButton.setSelected(true);
            this.subrayadoButton.setSelected(true);
        }
        this.aplicarEstiloContenido(strEstiloContenido);
    }

    private void SetAlineacionContenido(String strAlineacion) {
        if (strAlineacion.equals("I")) {
            this.izqButton.setSelected(true);
            this.derButton.setSelected(false);
            this.centrarButton.setSelected(false);
            this.justificarButton.setSelected(false);
        }
        if (strAlineacion.equals("D")) {
            this.izqButton.setSelected(false);
            this.derButton.setSelected(true);
            this.centrarButton.setSelected(false);
            this.justificarButton.setSelected(false);
        }
        if (strAlineacion.equals("C")) {
            this.izqButton.setSelected(false);
            this.derButton.setSelected(false);
            this.centrarButton.setSelected(true);
            this.justificarButton.setSelected(false);
        }
        if (strAlineacion.equals("J")) {
            this.izqButton.setSelected(false);
            this.derButton.setSelected(false);
            this.centrarButton.setSelected(false);
            this.justificarButton.setSelected(true);
        }
        this.aplicarAlineacionContenido(this.getAlineacionContenido());
    }

    public String getAbreviaturaTmp() {
        return this.nombreTextField.getText();
    }

    public void inicializarFoco() {
        this.nombreTextField.requestFocus();
    }

    public void conservarColoresDeFondo() {
        this.colorFondoAbreviatura = this.nombreTextField.getBackground();
        this.colorFondoDescripcion = this.decripTextArea.getBackground();
        this.colorFondoEditable = this.isEditableCheck.getForeground();
        this.colorFondoUbicacion = this.comboUbicacion.getBackground();
        this.colorFuenteImagen = this.imagenLabel.getForeground();
        this.colorFondoEtiqueta = this.etiquetaTextField.getBackground();
        this.colorFondoContenido = this.contenidoTextArea.getBackground();
    }

    public void restaurarColoresDeFondo() {
        if (this.colorFondoAbreviatura != null) {
            this.nombreTextField.setBackground(this.colorFondoAbreviatura);
            this.colorFondoAbreviatura = null;
        }
        if (this.colorFondoDescripcion != null) {
            this.decripTextArea.setBackground(this.colorFondoDescripcion);
            this.colorFondoDescripcion = null;
        }
        if (this.colorFondoEditable != null) {
            this.isEditableCheck.setForeground(this.colorFondoEditable);
            this.colorFondoEditable = null;
        }
        if (this.colorFondoUbicacion != null) {
            this.comboUbicacion.setBackground(this.colorFondoUbicacion);
            this.colorFondoUbicacion = null;
        }
        if (this.colorFuenteImagen != null) {
            this.imagenLabel.setForeground(this.colorFuenteImagen);
            this.colorFuenteImagen = null;
        }
        if (this.colorFondoEtiqueta != null) {
            this.etiquetaTextField.setBackground(this.colorFondoEtiqueta);
            this.colorFondoEtiqueta = null;
        }
        if (this.colorFondoContenido != null) {
            this.contenidoTextArea.setBackground(this.colorFondoContenido);
            this.colorFondoContenido = null;
        }
    }

    public void abrirArchivoPlantilla(ActionEvent e) {
        if (this.nombreImagenTextField.getText().equals("")) {
            return;
        }
        Runtime r = Runtime.getRuntime();
        try {
            String strRutaValidaExe = null;
            if (CopiadorArchivos.existeArchivo(this.sRutaCompleta)) {
                strRutaValidaExe = this.sRutaCompleta;
            } else if (CopiadorArchivos.existeArchivo(ModelaConf.getRutaArchivo() + System.getProperty("file.separator") + this.nombreImagenTextField.getText())) {
                strRutaValidaExe = ModelaConf.getRutaArchivo() + System.getProperty("file.separator") + this.nombreImagenTextField.getText();
            } else {
                JOptionPane.showMessageDialog(null, "No se ha podido localizar el fichero asociado.", "Atenci\u00f3n", 0);
            }
            if (strRutaValidaExe != null) {
                String tmp = System.getProperty("os.name");
                if (tmp.startsWith(this.sistemaOperativo)) {
                    r.exec("rundll32 SHELL32.DLL,ShellExec_RunDLL " + strRutaValidaExe);
                } else {
                    String[] comando = new String[]{"xdg-open", strRutaValidaExe};
                    r.exec(comando);
                }
            }
        }
        catch (Exception ex) {
            Object[] opciones = new Object[]{"Aceptar", "Cancelar"};
            int n = JOptionPane.showOptionDialog(null, "Archivo no encontrado.", "Atencion", 0, 3, null, opciones, opciones[1]);
            if (n == -1) {
                n = 1;
            }
            if (n == 1) {
                return;
            }
            ActionEvent acEven = null;
            this.seleccionarImagen_actionPerformed(acEven);
            return;
        }
    }
}

