/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing.excontrols;

import gdtel.ui.swing.excontrols.JTableAsignable;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import modela.ui.ModelaUI;
import modela.ui.event.InfoResultado;

public class JTableResultados
extends JTableAsignable {
    private static final long serialVersionUID = -3187640007479222386L;
    String toolTipMostrar = new String();
    public static final int INDICE_COLUMNA_ESTADO = 0;
    public static final int INDICE_COLUMNA_ENTIDAD = 1;
    public static final int INDICE_COLUMNA_TIPO_ENTIDAD = 2;
    public static final int INDICE_COLUMNA_INFORMACION = 3;
    public static final int INDICE_COLUMNA_RECOMENDACION = 4;
    public static final int FILTRO_TODOS = 1;
    public static final int FILTRO_WARNING = 2;
    public static final int FILTRO_ERRORES = 3;
    protected DefaultTableModel modeloFiltroWarning;
    protected DefaultTableModel modeloFiltroErrores;

    public JTableResultados() {
        try {
            this.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getToolTipText() {
        int nRow = this.getFilaSeleccionada();
        if (nRow == -1) {
            return "";
        }
        InfoResultado tr = (InfoResultado)this.getModel().getValueAt(nRow, 0);
        if (tr != null) {
            this.toolTipMostrar = tr.getInfo();
            if (tr.getRecomendacion() != null && !tr.getRecomendacion().equals("")) {
                this.toolTipMostrar = this.toolTipMostrar + ": " + tr.getRecomendacion();
            }
            return this.toolTipMostrar;
        }
        return "";
    }

    public void init() {
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setAutoscrolls(true);
        Vector<String> columnaPrimera = new Vector<String>();
        columnaPrimera.add("Estado");
        columnaPrimera.add("Entidad");
        columnaPrimera.add("Tipo entidad");
        columnaPrimera.add("Informaci\u00f3n");
        columnaPrimera.add("Recomendaci\u00f3n");
        this.setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setFont(ModelaUI.fuenteMenu);
        this.modelo = new DefaultTableModel(columnaPrimera, 0);
        this.modeloFiltroWarning = new DefaultTableModel(columnaPrimera, 0);
        this.modeloFiltroErrores = new DefaultTableModel(columnaPrimera, 0);
        this.setModel(this.modelo);
        this.setRowHeight(30);
        TableColumn column = null;
        column = this.getColumnModel().getColumn(0);
        column.setPreferredWidth(50);
        column = this.getColumnModel().getColumn(1);
        column.setPreferredWidth(100);
        column = this.getColumnModel().getColumn(2);
        column.setPreferredWidth(180);
        column = this.getColumnModel().getColumn(3);
        column.setPreferredWidth(300);
        column = this.getColumnModel().getColumn(4);
        column.setPreferredWidth(300);
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isCellEditable(i, j);
            }
        }
    }

    public void addFila(InfoResultado info) {
        if (info == null) {
            return;
        }
        Vector<Object> nuevaFila = new Vector<Object>();
        nuevaFila.add(info);
        nuevaFila.add(info.getTipoEntidad());
        nuevaFila.add(info.getEntidad());
        nuevaFila.add(info.getInfo());
        nuevaFila.add(info.getRecomendacion());
        this.modelo.addRow(nuevaFila);
        if (info.getTipo().equals(InfoResultado.TIPO_AVISO)) {
            this.modeloFiltroWarning.addRow(nuevaFila);
        } else if (info.getTipo().equals(InfoResultado.TIPO_ERROR)) {
            this.modeloFiltroErrores.addRow(nuevaFila);
        }
        this.updateUI();
    }

    public void aplicarFiltro(int nTipoFiltro) {
        int nCol1 = this.getColumnModel().getColumn(0).getPreferredWidth();
        int nCol2 = this.getColumnModel().getColumn(1).getPreferredWidth();
        int nCol3 = this.getColumnModel().getColumn(2).getPreferredWidth();
        int nCol4 = this.getColumnModel().getColumn(3).getPreferredWidth();
        int nCol5 = this.getColumnModel().getColumn(4).getPreferredWidth();
        switch (nTipoFiltro) {
            case 2: {
                this.setModel(this.modeloFiltroWarning);
                break;
            }
            case 3: {
                this.setModel(this.modeloFiltroErrores);
                break;
            }
            case 1: {
                this.setModel(this.modelo);
                break;
            }
            default: {
                this.setModel(this.modelo);
            }
        }
        this.getColumnModel().getColumn(0).setPreferredWidth(nCol1);
        this.getColumnModel().getColumn(1).setPreferredWidth(nCol2);
        this.getColumnModel().getColumn(2).setPreferredWidth(nCol3);
        this.getColumnModel().getColumn(3).setPreferredWidth(nCol4);
        this.getColumnModel().getColumn(4).setPreferredWidth(nCol5);
        this.updateUI();
    }

    public void removeAllRows() {
        this.modelo.getDataVector().clear();
        this.modeloFiltroWarning.getDataVector().clear();
        this.modeloFiltroErrores.getDataVector().clear();
        this.updateUI();
    }
}

