/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing.graficas;

import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.excontrols.CreadorButton;
import gdtel.ui.swing.excontrols.JCheckBoxEx;
import gdtel.ui.swing.excontrols.JComboBoxEx;
import gdtel.ui.swing.excontrols.JFiltroTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import modela.conf.ModelaConf;
import modela.graf.CalculaEstadisticas;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.TextAnchor;
import org.jfree.util.TableOrder;

public class JPanelGrafica
extends JPanel {
    private static final long serialVersionUID = 1L;
    JPanel panelOpcionesGraficas = new JPanel();
    JPanel panelOpcionesGraficasAux1 = new JPanel();
    JLabel labelTipo = new JLabel();
    JComboBoxEx comboTipo = new JComboBoxEx();
    JCheckBoxEx checkLimitarAmbito = new JCheckBoxEx();
    JPanel panelOpcionesGraficasAux2 = new JPanel();
    ImageIcon imgPagPrimera = new ImageIcon(JPanelGrafica.class.getResource(ModelaUI.IMG_PAGINA_PRIMERA));
    ImageIcon imgPagPrimeraDes = new ImageIcon(JPanelGrafica.class.getResource(ModelaUI.IMG_PAGINA_PRIMERA_DESA));
    ImageIcon imgPagPrimeraSob = new ImageIcon(JPanelGrafica.class.getResource(ModelaUI.IMG_PAGINA_PRIMERA_SOBRE));
    ImageIcon imgPagAnterior = new ImageIcon(JPanelGrafica.class.getResource(ModelaUI.IMG_PAGINA_ANTERIOR));
    ImageIcon imgPagAnteriorDes = new ImageIcon(JPanelGrafica.class.getResource(ModelaUI.IMG_PAGINA_ANTERIOR_DESA));
    ImageIcon imgPagAnteriorSob = new ImageIcon(JPanelGrafica.class.getResource(ModelaUI.IMG_PAGINA_ANTERIOR_SOBRE));
    ImageIcon imgPagSiguiente = new ImageIcon(JPanelGrafica.class.getResource(ModelaUI.IMG_PAGINA_SIGUIENTE));
    ImageIcon imgPagSiguienteDes = new ImageIcon(JPanelGrafica.class.getResource(ModelaUI.IMG_PAGINA_SIGUIENTE_DESA));
    ImageIcon imgPagSiguienteSob = new ImageIcon(JPanelGrafica.class.getResource(ModelaUI.IMG_PAGINA_SIGUIENTE_SOBRE));
    ImageIcon imgPagUltima = new ImageIcon(JPanelGrafica.class.getResource(ModelaUI.IMG_PAGINA_ULTIMA));
    ImageIcon imgPagUltimaDes = new ImageIcon(JPanelGrafica.class.getResource(ModelaUI.IMG_PAGINA_ULTIMA_DESA));
    ImageIcon imgPagUltimaSob = new ImageIcon(JPanelGrafica.class.getResource(ModelaUI.IMG_PAGINA_ULTIMA_SOBRE));
    JButton botonPagPrimera = (JButton)CreadorButton.crearBoton(1, false, this.imgPagPrimera, this.imgPagPrimeraDes, this.imgPagPrimeraSob, this.imgPagPrimeraSob);
    JButton botonPagAnterior = (JButton)CreadorButton.crearBoton(1, false, this.imgPagAnterior, this.imgPagAnteriorDes, this.imgPagAnteriorSob, this.imgPagAnteriorSob);
    JButton botonPagSiguiente = (JButton)CreadorButton.crearBoton(1, false, this.imgPagSiguiente, this.imgPagSiguienteDes, this.imgPagSiguienteSob, this.imgPagSiguienteSob);
    JButton botonPagUltima = (JButton)CreadorButton.crearBoton(1, false, this.imgPagUltima, this.imgPagUltimaDes, this.imgPagUltimaSob, this.imgPagUltimaSob);
    JFiltroTextField txtPagActual = new JFiltroTextField();
    JLabel labelPagTotales = new JLabel();
    JCheckBoxEx checkTodosLosItem = new JCheckBoxEx();
    protected String tituloPanel;
    protected CalculaEstadisticas calculaEstadisticas;
    protected DDPGrafico diagramaAsociado;
    protected JFreeChart freeChart;
    protected ArrayList arrDataSets;
    protected int nElementosVista = 2;
    protected int nPaginaActual = 0;
    protected static final int TIPO_GRAFICA_TARTA = 0;
    protected static final int TIPO_GRAFICA_TARTA_3D = 1;
    protected static final int TIPO_GRAFICA_BARRAS = 2;
    protected static final int TIPO_GRAFICA_BARRAS_3D = 3;
    protected static final int TIPO_GRAFICA_BARRAS_APILADAS = 4;
    protected static final int TIPO_GRAFICA_BARRAS_APILADAS_3D = 5;
    protected static final int TIPO_GRAFICA_TARTAS_MULTIPLES = 6;
    protected static final int TIPO_GRAFICA_TARTAS_MULTIPLES_3D = 7;
    protected static final String TIPO_GRAFICA_TARTA_DESC = "Tarta";
    protected static final String TIPO_GRAFICA_TARTA_3D_DESC = "Tarta 3D";
    protected static final String TIPO_GRAFICA_BARRAS_DESC = "Barras";
    protected static final String TIPO_GRAFICA_BARRAS_3D_DESC = "Barras 3D";
    protected static final String TIPO_GRAFICA_BARRAS_APILADAS_DESC = "Barras apiladas";
    protected static final String TIPO_GRAFICA_BARRAS_APILADAS_3D_DESC = "Barras apiladas 3D";
    protected static final String TIPO_GRAFICA_TARTAS_MULTIPLES_DESC = "Tartas m\u00faltiples";
    protected static final String TIPO_GRAFICA_TARTAS_MULTIPLES_3D_DESC = "Tartas m\u00faltiples 3D";
    protected int nTipoGrafica = 5;

    public JPanelGrafica() {
        this.jbInit();
    }

    private void jbInit() {
        this.tituloPanel = "Gr\u00e1fica";
        this.setLayout(new BorderLayout());
        this.checkLimitarAmbito.setCambiarColorAlModificar(false);
        this.checkLimitarAmbito.setText("Limitar el \u00e1mbito al procedimiento (pesta\u00f1a) actualmente activo");
        this.checkLimitarAmbito.setFocusPainted(true);
        this.checkLimitarAmbito.setSelected(true);
        this.labelTipo.setText("Tipo de gr\u00e1fica: ");
        this.comboTipo.setCambiarColorAlModificar(false);
        this.comboTipo.removeAllItems();
        this.txtPagActual.setCambiarColorAlModificar(false);
        this.txtPagActual.setEditable(true);
        this.txtPagActual.establecerTipografia(1);
        this.txtPagActual.setTipoFiltro(2);
        this.txtPagActual.setNumItems(3);
        this.txtPagActual.setText(String.valueOf(this.nPaginaActual + 1));
        this.checkTodosLosItem.setCambiarColorAlModificar(false);
        this.checkTodosLosItem.setText("Ver todos los elementos");
        this.checkTodosLosItem.setFocusPainted(true);
        this.checkTodosLosItem.setSelected(false);
        this.panelOpcionesGraficasAux1.setLayout(new XYLayout());
        this.panelOpcionesGraficasAux1.add((Component)this.labelTipo, new XYConstraints(5, 5, 100, 20));
        this.panelOpcionesGraficasAux1.add((Component)this.comboTipo, new XYConstraints(100, 5, 150, 20));
        this.panelOpcionesGraficasAux1.add((Component)this.checkLimitarAmbito, new XYConstraints(260, 5, 450, 20));
        this.panelOpcionesGraficasAux1.setBorder(BorderFactory.createEtchedBorder());
        this.panelOpcionesGraficasAux2.setLayout(new XYLayout());
        this.panelOpcionesGraficasAux2.add((Component)this.botonPagPrimera, new XYConstraints(5, 5, 25, 22));
        this.panelOpcionesGraficasAux2.add((Component)this.botonPagAnterior, new XYConstraints(35, 5, 25, 22));
        this.panelOpcionesGraficasAux2.add((Component)this.txtPagActual, new XYConstraints(65, 5, 30, 22));
        this.panelOpcionesGraficasAux2.add((Component)this.labelPagTotales, new XYConstraints(100, 5, 30, 22));
        this.panelOpcionesGraficasAux2.add((Component)this.botonPagSiguiente, new XYConstraints(135, 5, 25, 22));
        this.panelOpcionesGraficasAux2.add((Component)this.botonPagUltima, new XYConstraints(165, 5, 25, 22));
        this.panelOpcionesGraficasAux2.add((Component)this.checkTodosLosItem, new XYConstraints(5, 30, 200, 22));
        this.panelOpcionesGraficasAux2.setBorder(BorderFactory.createEtchedBorder());
        this.panelOpcionesGraficas.setLayout(new BorderLayout());
        this.panelOpcionesGraficas.add((Component)this.panelOpcionesGraficasAux1, "Center");
        this.panelOpcionesGraficas.add((Component)this.panelOpcionesGraficasAux2, "East");
        this.addListeners();
    }

    private void addListeners() {
        this.comboTipo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPanelGrafica.this.actualizarGrafica();
            }
        });
        this.checkLimitarAmbito.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPanelGrafica.this.actualizarGrafica();
            }
        });
        this.botonPagPrimera.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPanelGrafica.this.nPaginaActual = 0;
                JPanelGrafica.this.actualizarGrafica();
                JPanelGrafica.this.txtPagActual.setText(String.valueOf(JPanelGrafica.this.nPaginaActual + 1));
            }
        });
        this.botonPagAnterior.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                --JPanelGrafica.this.nPaginaActual;
                if (JPanelGrafica.this.nPaginaActual < 0) {
                    JPanelGrafica.this.nPaginaActual = 0;
                }
                JPanelGrafica.this.actualizarGrafica();
                JPanelGrafica.this.txtPagActual.setText(String.valueOf(JPanelGrafica.this.nPaginaActual + 1));
            }
        });
        this.botonPagSiguiente.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ++JPanelGrafica.this.nPaginaActual;
                if (JPanelGrafica.this.nPaginaActual >= JPanelGrafica.this.arrDataSets.size()) {
                    JPanelGrafica.this.nPaginaActual = JPanelGrafica.this.arrDataSets.size() - 1;
                }
                JPanelGrafica.this.actualizarGrafica();
                JPanelGrafica.this.txtPagActual.setText(String.valueOf(JPanelGrafica.this.nPaginaActual + 1));
            }
        });
        this.botonPagUltima.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPanelGrafica.this.nPaginaActual = JPanelGrafica.this.arrDataSets.size() - 1;
                JPanelGrafica.this.actualizarGrafica();
                JPanelGrafica.this.txtPagActual.setText(String.valueOf(JPanelGrafica.this.nPaginaActual + 1));
            }
        });
        this.txtPagActual.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent anEvent) {
                if (anEvent.getKeyChar() == '\n') {
                    if (JPanelGrafica.this.txtPagActual.getText() == null) {
                        JPanelGrafica.this.txtPagActual.setText("1");
                    }
                    JPanelGrafica.this.nPaginaActual = Integer.parseInt(JPanelGrafica.this.txtPagActual.getText()) - 1;
                    if (JPanelGrafica.this.nPaginaActual < 0) {
                        JPanelGrafica.this.nPaginaActual = 0;
                    } else if (JPanelGrafica.this.nPaginaActual >= JPanelGrafica.this.arrDataSets.size()) {
                        JPanelGrafica.this.nPaginaActual = JPanelGrafica.this.arrDataSets.size() - 1;
                    }
                    JPanelGrafica.this.txtPagActual.setText(String.valueOf(JPanelGrafica.this.nPaginaActual + 1));
                    JPanelGrafica.this.actualizarGrafica();
                }
            }
        });
        this.checkTodosLosItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPanelGrafica.this.nElementosVista = JPanelGrafica.this.checkTodosLosItem.isSelected() ? 0 : ModelaConf.getItemsPorPagina();
                JPanelGrafica.this.txtPagActual.setText("1");
                JPanelGrafica.this.nPaginaActual = 0;
                JPanelGrafica.this.actualizarGrafica();
            }
        });
    }

    private void inicializarDataSet() {
        this.arrDataSets = null;
        this.arrDataSets = new ArrayList();
        switch (this.nTipoGrafica) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.arrDataSets.add(new DefaultCategoryDataset());
                break;
            }
            case 0: 
            case 1: {
                this.arrDataSets.add(new DefaultPieDataset());
                break;
            }
            default: {
                this.arrDataSets.clear();
            }
        }
    }

    public void addValor(String elemento, Double valor) {
        if (this.arrDataSets.size() < 1) {
            return;
        }
        switch (this.nTipoGrafica) {
            case 2: 
            case 3: {
                if (this.nElementosVista != 0 && ((DefaultCategoryDataset)this.arrDataSets.get(this.arrDataSets.size() - 1)).getColumnKeys().size() >= this.nElementosVista) {
                    this.arrDataSets.add(new DefaultCategoryDataset());
                }
                ((DefaultCategoryDataset)this.arrDataSets.get(this.arrDataSets.size() - 1)).setValue((Number)valor, (Comparable)((Object)""), (Comparable)((Object)elemento));
                break;
            }
            case 0: 
            case 1: {
                if (this.nElementosVista != 0 && ((DefaultPieDataset)this.arrDataSets.get(this.arrDataSets.size() - 1)).getItemCount() >= this.nElementosVista) {
                    this.arrDataSets.add(new DefaultPieDataset());
                }
                ((DefaultPieDataset)this.arrDataSets.get(this.arrDataSets.size() - 1)).setValue((Comparable)((Object)elemento), (Number)valor);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                int nColumnas = ((DefaultCategoryDataset)this.arrDataSets.get(this.arrDataSets.size() - 1)).getColumnKeys().size();
                if (((DefaultCategoryDataset)this.arrDataSets.get(this.arrDataSets.size() - 1)).getColumnKeys().contains(elemento)) {
                    ((DefaultCategoryDataset)this.arrDataSets.get(this.arrDataSets.size() - 1)).setValue((Number)valor, (Comparable)((Object)""), (Comparable)((Object)elemento));
                    break;
                }
                if (this.nElementosVista != 0 && nColumnas >= this.nElementosVista) {
                    this.arrDataSets.add(new DefaultCategoryDataset());
                }
                ((DefaultCategoryDataset)this.arrDataSets.get(this.arrDataSets.size() - 1)).setValue((Number)valor, (Comparable)((Object)""), (Comparable)((Object)elemento));
            }
        }
    }

    public void addValor(String elemento, String categoria, Double valor) {
        switch (this.nTipoGrafica) {
            case 2: 
            case 3: {
                if (this.nElementosVista != 0 && ((DefaultCategoryDataset)this.arrDataSets.get(this.arrDataSets.size() - 1)).getColumnKeys().size() >= this.nElementosVista) {
                    this.arrDataSets.add(new DefaultCategoryDataset());
                }
                ((DefaultCategoryDataset)this.arrDataSets.get(this.arrDataSets.size() - 1)).setValue((Number)valor, (Comparable)((Object)categoria), (Comparable)((Object)elemento));
                break;
            }
            case 0: 
            case 1: {
                if (this.nElementosVista != 0 && ((DefaultPieDataset)this.arrDataSets.get(this.arrDataSets.size() - 1)).getItemCount() >= this.nElementosVista) {
                    this.arrDataSets.add(new DefaultCategoryDataset());
                }
                ((DefaultPieDataset)this.arrDataSets.get(this.arrDataSets.size() - 1)).setValue((Comparable)((Object)elemento), (Number)valor);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                int nColumnas = ((DefaultCategoryDataset)this.arrDataSets.get(this.arrDataSets.size() - 1)).getColumnKeys().size();
                if (((DefaultCategoryDataset)this.arrDataSets.get(this.arrDataSets.size() - 1)).getColumnKeys().contains(elemento)) {
                    ((DefaultCategoryDataset)this.arrDataSets.get(this.arrDataSets.size() - 1)).setValue((Number)valor, (Comparable)((Object)categoria), (Comparable)((Object)elemento));
                    break;
                }
                if (this.nElementosVista != 0 && nColumnas >= this.nElementosVista) {
                    this.arrDataSets.add(new DefaultCategoryDataset());
                }
                ((DefaultCategoryDataset)this.arrDataSets.get(this.arrDataSets.size() - 1)).setValue((Number)valor, (Comparable)((Object)categoria), (Comparable)((Object)elemento));
            }
        }
    }

    public void createChart(String strTituloGrafica) {
        if (this.arrDataSets.size() < 1) {
            return;
        }
        if (this.nPaginaActual >= this.arrDataSets.size()) {
            this.txtPagActual.setText(String.valueOf(this.arrDataSets.size()));
            this.nPaginaActual = this.arrDataSets.size() - 1;
        }
        switch (this.nTipoGrafica) {
            case 2: {
                this.freeChart = ChartFactory.createBarChart((String)strTituloGrafica, (String)"", (String)"", (CategoryDataset)((DefaultCategoryDataset)this.arrDataSets.get(this.nPaginaActual)), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
                break;
            }
            case 3: {
                this.freeChart = ChartFactory.createBarChart3D((String)strTituloGrafica, (String)"", (String)"", (CategoryDataset)((DefaultCategoryDataset)this.arrDataSets.get(this.nPaginaActual)), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
                break;
            }
            case 4: {
                this.freeChart = ChartFactory.createStackedBarChart((String)strTituloGrafica, (String)"", (String)"", (CategoryDataset)((DefaultCategoryDataset)this.arrDataSets.get(this.nPaginaActual)), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
                break;
            }
            case 5: {
                this.freeChart = ChartFactory.createStackedBarChart3D((String)strTituloGrafica, (String)"", (String)"", (CategoryDataset)((DefaultCategoryDataset)this.arrDataSets.get(this.nPaginaActual)), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
                break;
            }
            case 6: {
                this.freeChart = ChartFactory.createMultiplePieChart((String)strTituloGrafica, (CategoryDataset)((DefaultCategoryDataset)this.arrDataSets.get(this.nPaginaActual)), (TableOrder)TableOrder.BY_ROW, (boolean)true, (boolean)true, (boolean)false);
                break;
            }
            case 7: {
                this.freeChart = ChartFactory.createMultiplePieChart3D((String)strTituloGrafica, (CategoryDataset)((DefaultCategoryDataset)this.arrDataSets.get(this.nPaginaActual)), (TableOrder)TableOrder.BY_ROW, (boolean)true, (boolean)true, (boolean)false);
                break;
            }
            case 0: {
                this.freeChart = ChartFactory.createPieChart((String)strTituloGrafica, (PieDataset)((DefaultPieDataset)this.arrDataSets.get(this.nPaginaActual)), (boolean)true, (boolean)true, (boolean)false);
                break;
            }
            case 1: {
                this.freeChart = ChartFactory.createPieChart3D((String)strTituloGrafica, (PieDataset)((DefaultPieDataset)this.arrDataSets.get(this.nPaginaActual)), (boolean)true, (boolean)true, (boolean)false);
            }
        }
        if (this.arrDataSets != null) {
            this.labelPagTotales.setText("/" + String.valueOf(this.arrDataSets.size()));
        } else {
            this.labelPagTotales.setText("/0");
        }
        this.aplicarEstilo();
    }

    public JPanel createPanel() {
        ChartPanel panelContenedorGrafica = new ChartPanel(this.freeChart);
        return panelContenedorGrafica;
    }

    public void aplicarEstilo() {
        if (this.freeChart == null) {
            return;
        }
        CategoryPlot categoryPlot = null;
        PiePlot piePlot = null;
        BarRenderer barRenderer = null;
        NumberAxis numberaxis = null;
        this.freeChart.setBackgroundPaint((Paint)ModelaUI.colorFondoPanelGraficas);
        this.freeChart.getTitle().setFont(ModelaUI.fuenteGraficasTitulo);
        switch (this.nTipoGrafica) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                categoryPlot = (CategoryPlot)this.freeChart.getPlot();
                categoryPlot.setBackgroundPaint((Paint)ModelaUI.colorFondoGraficas);
                categoryPlot.setRangeGridlinePaint((Paint)ModelaUI.colorLineasFondoGraficas);
                barRenderer = (BarRenderer)categoryPlot.getRenderer();
                barRenderer.setDrawBarOutline(true);
                barRenderer.setOutlinePaint((Paint)ModelaUI.colorLineasBordeBarras);
                barRenderer.setSeriesPaint(0, (Paint)ModelaUI.colorSerie0);
                barRenderer.setSeriesPaint(1, (Paint)ModelaUI.colorSerie1);
                barRenderer.setSeriesPaint(2, (Paint)ModelaUI.colorSerie2);
                barRenderer.setSeriesPaint(3, (Paint)ModelaUI.colorSerie3);
                barRenderer.setSeriesPaint(4, (Paint)ModelaUI.colorSerie4);
                barRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
                barRenderer.setBaseItemLabelsVisible(true);
                barRenderer.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
                barRenderer.setBaseNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
                barRenderer.setBaseItemLabelFont(ModelaUI.fuentePrincipalNegrita);
                numberaxis = (NumberAxis)categoryPlot.getRangeAxis();
                numberaxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                break;
            }
            case 0: {
                piePlot = (PiePlot)this.freeChart.getPlot();
                piePlot.setBackgroundPaint((Paint)ModelaUI.colorFondoGraficas);
                piePlot.setIgnoreNullValues(true);
                piePlot.setIgnoreZeroValues(true);
                piePlot.setSectionPaint(0, (Paint)ModelaUI.colorSerie0);
                piePlot.setSectionPaint(1, (Paint)ModelaUI.colorSerie1);
                piePlot.setSectionPaint(2, (Paint)ModelaUI.colorSerie2);
                piePlot.setSectionPaint(3, (Paint)ModelaUI.colorSerie3);
                piePlot.setSectionPaint(4, (Paint)ModelaUI.colorSerie4);
                break;
            }
            case 1: {
                PiePlot3D piePlot3D = (PiePlot3D)this.freeChart.getPlot();
                piePlot3D.setBackgroundPaint((Paint)ModelaUI.colorFondoGraficas);
                piePlot3D.setIgnoreNullValues(true);
                piePlot3D.setIgnoreZeroValues(true);
                piePlot3D.setDepthFactor(0.1);
                piePlot3D.setSectionPaint(0, (Paint)ModelaUI.colorSerie0);
                piePlot3D.setSectionPaint(1, (Paint)ModelaUI.colorSerie1);
                piePlot3D.setSectionPaint(2, (Paint)ModelaUI.colorSerie2);
                piePlot3D.setSectionPaint(3, (Paint)ModelaUI.colorSerie3);
                piePlot3D.setSectionPaint(4, (Paint)ModelaUI.colorSerie4);
                break;
            }
            case 6: 
            case 7: {
                MultiplePiePlot mPiePlot = (MultiplePiePlot)this.freeChart.getPlot();
                mPiePlot.setBackgroundPaint((Paint)ModelaUI.colorFondoGraficas);
                piePlot = (PiePlot)mPiePlot.getPieChart().getPlot();
                piePlot.setBackgroundPaint((Paint)ModelaUI.colorFondoGraficas);
                piePlot.setIgnoreNullValues(true);
                piePlot.setIgnoreZeroValues(true);
                piePlot.setOutlinePaint((Paint)ModelaUI.colorLineasBordeBarras);
                NumberFormat percentFormat = NumberFormat.getPercentInstance();
                percentFormat.setMinimumFractionDigits(0);
                percentFormat.setMaximumFractionDigits(2);
                piePlot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0} ({2})", NumberFormat.getNumberInstance(), percentFormat));
                piePlot.setSectionPaint(0, (Paint)ModelaUI.colorSerie0);
                piePlot.setSectionPaint(1, (Paint)ModelaUI.colorSerie1);
                piePlot.setSectionPaint(2, (Paint)ModelaUI.colorSerie2);
                piePlot.setSectionPaint(3, (Paint)ModelaUI.colorSerie3);
                piePlot.setSectionPaint(4, (Paint)ModelaUI.colorSerie4);
            }
        }
    }

    public void actualizarGrafica() {
        this.arrDataSets = null;
        this.arrDataSets = new ArrayList();
        if (((String)this.comboTipo.getSelectedItem()).equals(TIPO_GRAFICA_BARRAS_DESC)) {
            this.loadGrafica(2, this.checkLimitarAmbito.isSelected());
        } else if (((String)this.comboTipo.getSelectedItem()).equals(TIPO_GRAFICA_BARRAS_3D_DESC)) {
            this.loadGrafica(3, this.checkLimitarAmbito.isSelected());
        } else if (((String)this.comboTipo.getSelectedItem()).equals(TIPO_GRAFICA_TARTA_DESC)) {
            this.loadGrafica(0, this.checkLimitarAmbito.isSelected());
        } else if (((String)this.comboTipo.getSelectedItem()).equals(TIPO_GRAFICA_TARTA_3D_DESC)) {
            this.loadGrafica(1, this.checkLimitarAmbito.isSelected());
        } else if (((String)this.comboTipo.getSelectedItem()).equals(TIPO_GRAFICA_BARRAS_APILADAS_DESC)) {
            this.loadGrafica(4, this.checkLimitarAmbito.isSelected());
        } else if (((String)this.comboTipo.getSelectedItem()).equals(TIPO_GRAFICA_BARRAS_APILADAS_3D_DESC)) {
            this.loadGrafica(5, this.checkLimitarAmbito.isSelected());
        } else if (((String)this.comboTipo.getSelectedItem()).equals(TIPO_GRAFICA_TARTAS_MULTIPLES_DESC)) {
            this.loadGrafica(6, this.checkLimitarAmbito.isSelected());
        } else if (((String)this.comboTipo.getSelectedItem()).equals(TIPO_GRAFICA_TARTAS_MULTIPLES_3D_DESC)) {
            this.loadGrafica(7, this.checkLimitarAmbito.isSelected());
        }
    }

    public boolean loadGrafica(int nTipoGraf, boolean bLimitarAmbito) {
        return false;
    }

    public CalculaEstadisticas getCalculaEstadisticas() {
        return this.calculaEstadisticas;
    }

    public void setCalculaEstadisticas(CalculaEstadisticas pCalcula) {
        this.calculaEstadisticas = pCalcula;
    }

    public DDPGrafico getDiagrama() {
        return this.diagramaAsociado;
    }

    public void setDiagrama(DDPGrafico paramDiagrama) {
        this.diagramaAsociado = paramDiagrama;
        this.calculaEstadisticas = new CalculaEstadisticas(this.diagramaAsociado);
    }

    public String getTituloPanel() {
        return this.tituloPanel;
    }

    public void setTituloPanel(String pTituloPanel) {
        this.tituloPanel = pTituloPanel;
    }

    public JFreeChart getFreeChart() {
        return this.freeChart;
    }

    public void setFreeChart(JFreeChart pFreeChart) {
        this.freeChart = pFreeChart;
    }

    public int getTipoGrafica() {
        return this.nTipoGrafica;
    }

    public void setTipoGrafica(int pTipo) {
        this.nTipoGrafica = pTipo;
        this.inicializarDataSet();
    }

    public int getNElementosVista() {
        return this.nElementosVista;
    }

    public void setNElementosVista(int elementosVista) {
        this.nElementosVista = elementosVista;
    }

    public String toString() {
        return this.tituloPanel;
    }
}

