/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing.graficas;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import modela.bd.obj.TrPerfilTareaFase;
import modela.bd.obj.TrPerfilTransEvol;
import modela.bd.obj.TrPerfilUsuario;
import modela.bd.obj.TrTareaEnFaseDefProcedimiento;
import modela.bd.obj.TrTransicionDefProcedimiento;
import modela.conf.ModelaConf;
import modela.ui.swing.graficas.JPanelGrafica;
import org.jfree.chart.ChartPanel;

public class JPanelGraficaCargaPerfiles
extends JPanelGrafica {
    private static final long serialVersionUID = -8101647481868835386L;

    public JPanelGraficaCargaPerfiles() {
        this.jbInit();
    }

    private void jbInit() {
        this.setTituloPanel("Carga de trabajo X Perfiles:");
        this.comboTipo.addItem("Barras apiladas");
        this.comboTipo.addItem("Barras apiladas 3D");
        this.comboTipo.addItem("Tartas m\u00faltiples");
        this.comboTipo.addItem("Tartas m\u00faltiples 3D");
        this.add((Component)this.panelOpcionesGraficas, "South");
        this.setNElementosVista(ModelaConf.getItemsPorPagina());
    }

    public boolean loadGrafica(int nTipoGraf, boolean bLimitarAmbito) {
        this.setTipoGrafica(nTipoGraf);
        if (this.diagramaAsociado == null || this.diagramaAsociado.getDDP() == null) {
            return false;
        }
        try {
            ArrayList arrTransicionesDefProc;
            ArrayList arrTareasDefProc;
            String tituloGrafica;
            ArrayList arrPerfiles = new ArrayList();
            if (!bLimitarAmbito) {
                arrPerfiles = this.diagramaAsociado.getPerfilesUsuarioInvolucrados().getListaDatos();
                tituloGrafica = "Todo el procedimiento (Reutilizables inclusive)";
            } else {
                arrPerfiles = this.diagramaAsociado.getPerfilesUsuarioInvolucradosGr().getListaDatos();
                tituloGrafica = this.diagramaAsociado.getDDP().getTITULO();
                if (tituloGrafica == null) {
                    tituloGrafica = this.diagramaAsociado.getDDP().getNOMBRE();
                }
            }
            Collections.sort(arrPerfiles);
            int nTareas = 0;
            int nTransiciones = 0;
            if (!bLimitarAmbito) {
                arrTareasDefProc = this.calculaEstadisticas.getArrTotalTrTareaEnFaseDefProc();
                arrTransicionesDefProc = this.calculaEstadisticas.getArrTotalTrTransicionesDefProc();
            } else {
                arrTareasDefProc = this.diagramaAsociado.getTareaFaseDefProcInvolucradas().getListaDatos();
                arrTransicionesDefProc = this.diagramaAsociado.getTransicionesDelProcInvolucradas().getListaDatos();
            }
            for (int n = 0; arrPerfiles != null && n < arrPerfiles.size(); ++n) {
                TrPerfilUsuario perfilAux = (TrPerfilUsuario)arrPerfiles.get(n);
                nTareas = 0;
                nTransiciones = 0;
                for (int t = 0; arrTareasDefProc != null && t < arrTareasDefProc.size(); ++t) {
                    TrTareaEnFaseDefProcedimiento tareaFaseProcAux = (TrTareaEnFaseDefProcedimiento)arrTareasDefProc.get(t);
                    ArrayList arrPerfilesTarea = tareaFaseProcAux.getConjuntoPerfilesTareaFase().getListaDatos();
                    for (int pT = 0; arrPerfilesTarea != null && pT < arrPerfilesTarea.size(); ++pT) {
                        TrPerfilTareaFase perfilTareaAux = (TrPerfilTareaFase)arrPerfilesTarea.get(pT);
                        if (!perfilTareaAux.getPERFIL().equals(perfilAux)) continue;
                        ++nTareas;
                    }
                }
                for (int t = 0; arrTransicionesDefProc != null && t < arrTransicionesDefProc.size(); ++t) {
                    TrTransicionDefProcedimiento transiDefProcAux = (TrTransicionDefProcedimiento)arrTransicionesDefProc.get(t);
                    ArrayList arrPerfilesTransi = transiDefProcAux.getConjuntoPerfilTransEvol().getListaDatos();
                    for (int pT = 0; arrPerfilesTransi != null && pT < arrPerfilesTransi.size(); ++pT) {
                        TrPerfilTransEvol perfilTransAux = (TrPerfilTransEvol)arrPerfilesTransi.get(pT);
                        if (!perfilTransAux.getPERFIL().equals(perfilAux)) continue;
                        ++nTransiciones;
                    }
                }
                super.addValor(perfilAux.getNombre(), "Tareas", new Double(nTareas));
                super.addValor(perfilAux.getNombre(), "Transiciones", new Double(nTransiciones));
            }
            super.createChart(tituloGrafica);
            if (this.getComponentCount() > 1 && this.getComponent(1) instanceof ChartPanel) {
                this.remove(1);
            }
            this.add((Component)super.createPanel(), "Center");
            this.validate();
            this.repaint();
            return true;
        }
        catch (Exception e) {
            System.out.println("\u00b7 [ Error ] No se pudo cargar la gr\u00e1fica de Carga X Perfiles.");
            e.printStackTrace();
            return false;
        }
    }
}

