/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing.graficas;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import modela.bd.obj.TrTransicion;
import modela.bd.obj.TrTransicionDefProcedimiento;
import modela.ui.swing.graficas.JPanelGrafica;
import org.jfree.chart.ChartPanel;

public class JPanelGraficaTiposTransi
extends JPanelGrafica {
    private static final long serialVersionUID = -1532130166894687252L;

    public JPanelGraficaTiposTransi() {
        this.jbInit();
    }

    private void jbInit() {
        this.setTituloPanel("Tipos de Transici\u00f3n:");
        this.comboTipo.addItem("Barras");
        this.comboTipo.addItem("Barras 3D");
        this.comboTipo.addItem("Tarta");
        this.comboTipo.addItem("Tarta 3D");
        this.add((Component)this.panelOpcionesGraficas, "South");
        this.setNElementosVista(0);
        this.panelOpcionesGraficasAux2.setVisible(false);
    }

    public boolean loadGrafica(int nTipoGraf, boolean bLimitarAmbito) {
        this.setTipoGrafica(nTipoGraf);
        if (this.diagramaAsociado == null || this.diagramaAsociado.getDDP() == null) {
            return false;
        }
        try {
            String tituloGrafica;
            ArrayList arrTransiciones = new ArrayList();
            if (!bLimitarAmbito) {
                arrTransiciones = this.diagramaAsociado.getTransicionesInvolucradas().getListaDatos();
                tituloGrafica = "Todo el procedimiento (Reutilizables inclusive)";
            } else {
                ArrayList arrAux = this.diagramaAsociado.getTransicionesDelProcInvolucradas().getListaDatos();
                for (int n = 0; arrAux != null && n < arrAux.size(); ++n) {
                    TrTransicionDefProcedimiento trTranAux = (TrTransicionDefProcedimiento)arrAux.get(n);
                    if (trTranAux.getTransicion() == null) continue;
                    arrTransiciones.add(trTranAux.getTransicion());
                }
                tituloGrafica = this.diagramaAsociado.getDDP().getTITULO();
                if (tituloGrafica == null) {
                    tituloGrafica = this.diagramaAsociado.getDDP().getNOMBRE();
                }
            }
            Collections.sort(arrTransiciones);
            int nTipoInicio = 0;
            int nTipoNormal = 0;
            int nTipoUnion = 0;
            int nTipoDivision = 0;
            int nTipoEventoSalir = 0;
            int nTipoEventoNoSalir = 0;
            int nTipoFin = 0;
            for (int n = 0; arrTransiciones != null && n < arrTransiciones.size(); ++n) {
                TrTransicion transiAux = (TrTransicion)arrTransiciones.get(n);
                if (transiAux.getTIPO().equals("I")) {
                    ++nTipoInicio;
                    continue;
                }
                if (transiAux.getTIPO().equals("N")) {
                    ++nTipoNormal;
                    continue;
                }
                if (transiAux.getTIPO().equals("U")) {
                    ++nTipoUnion;
                    continue;
                }
                if (transiAux.getTIPO().equals("D")) {
                    ++nTipoDivision;
                    continue;
                }
                if (transiAux.getTIPO().equals("ES")) {
                    ++nTipoEventoSalir;
                    continue;
                }
                if (transiAux.getTIPO().equals("EN")) {
                    ++nTipoEventoNoSalir;
                    continue;
                }
                if (!transiAux.getTIPO().equals("F")) continue;
                ++nTipoFin;
            }
            super.addValor("Inicio", new Double(nTipoInicio));
            super.addValor("Normal", new Double(nTipoNormal));
            super.addValor("Uni\u00f3n", new Double(nTipoUnion));
            super.addValor("Divisi\u00f3n", new Double(nTipoDivision));
            super.addValor("Evento Salir", new Double(nTipoEventoSalir));
            super.addValor("Evento No Salir", new Double(nTipoEventoNoSalir));
            super.addValor("Final", new Double(nTipoFin));
            super.createChart(tituloGrafica);
            if (this.getComponentCount() > 1 && this.getComponent(1) instanceof ChartPanel) {
                this.remove(1);
            }
            this.add((Component)super.createPanel(), "Center");
            this.validate();
            this.repaint();
            return true;
        }
        catch (Exception e) {
            System.out.println("\u00b7 [ Error ] No se pudo cargar la gr\u00e1fica de Tipos de Transici\u00f3n");
            e.printStackTrace();
            return false;
        }
    }
}

