/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing.renderers;

import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import modela.bd.obj.TrMetafase;
import modela.ui.ModelaUI;

public class ColorMetafaseListRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 3074932031506175549L;
    private TrMetafase trMeta;
    private Color colorFondo;

    public ColorMetafaseListRenderer() {
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        this.trMeta = (TrMetafase)value;
        if (index == -1) {
            int selected = list.getSelectedIndex();
            if (selected == -1) {
                return this;
            }
            index = selected;
        }
        this.colorFondo = this.trMeta.getPropiedadesGraficas().getColorFondo();
        BufferedImage bIm = new BufferedImage(10, 10, 1);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                bIm.setRGB(i, j, this.colorFondo.getRGB());
            }
        }
        ImageIcon i = new ImageIcon(bIm);
        label.setIcon(i);
        if (this.trMeta != null && this.trMeta.isDefaultMetafase()) {
            this.setFont(ModelaUI.fuentePrincipalNegrita);
        }
        return label;
    }
}

