/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing.renderers;

import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import modela.ui.ModelaUI;
import modela.ui.event.InfoResultado;

public class ResultadosTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private static final long serialVersionUID = 1286177790455989280L;
    ImageIcon imagen;

    public ResultadosTableCellRenderer() {
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.setFont(ModelaUI.fuentePrincipal);
    }

    public Component getTableCellRendererComponent(JTable table, Object objeto, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean setIcono = false;
        if (isSelected) {
            this.setBackground(ModelaUI.colorSeleccion);
        } else {
            this.setBackground(Color.white);
        }
        if (column == 0) {
            InfoResultado info = (InfoResultado)objeto;
            if (info != null) {
                if (info.getDescripcionTipo().equals("Inicio")) {
                    this.imagen = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_INFORESULTADOS_INICIO));
                } else if (info.getDescripcionTipo().equals("Aviso")) {
                    this.imagen = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_INFORESULTADOS_AVISO));
                } else if (info.getDescripcionTipo().equals("Fin")) {
                    this.imagen = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_INFORESULTADOS_FIN));
                } else if (info.getDescripcionTipo().equals("Error")) {
                    this.imagen = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_INFORESULTADOS_ERROR));
                } else if (info.getDescripcionTipo().equals("Correcto")) {
                    this.imagen = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_INFORESULTADOS_CORRECTO));
                }
            }
            if (objeto != null) {
                this.setText(objeto.toString());
            }
            setIcono = true;
        } else {
            setIcono = false;
        }
        if (setIcono) {
            this.setIcon(this.imagen);
            this.setText("");
            this.setHorizontalAlignment(0);
            return this;
        }
        if (!setIcono) {
            this.setIcon(null);
            this.setHorizontalAlignment(2);
            if (objeto != null) {
                this.setText(objeto.toString());
            }
            return this;
        }
        return null;
    }
}

