/*
 * Decompiled with CFR 0.152.
 */
package modela.util;

import gdtel.ui.swing.FileFilterEx;
import java.awt.Font;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import modela.conf.ModelaConf;

public class UtilidadesVarias {
    public static boolean esNumerico(String cadena) {
        try {
            Integer.parseInt(cadena);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static String seleccionarRutaFichero(String rutaInicial, String extensionFile, String descripcionFile, String propertieActualizar) {
        if (rutaInicial == null || rutaInicial.equals("")) {
            rutaInicial = "C:/";
        }
        String strRuta = null;
        JFileChooser fileDlg = new JFileChooser(rutaInicial);
        fileDlg.setFileSelectionMode(0);
        FileFilterEx filter = new FileFilterEx(extensionFile);
        filter.setDescription(descripcionFile);
        fileDlg.addChoosableFileFilter(filter);
        int nRet = fileDlg.showSaveDialog(null);
        if (nRet == 0) {
            String strNombreFichero;
            File fich = fileDlg.getSelectedFile();
            strRuta = fich.getPath();
            if (!strRuta.endsWith("." + extensionFile)) {
                strRuta = strRuta + "." + extensionFile;
            }
            if (!(strNombreFichero = fich.getName()).endsWith("." + extensionFile)) {
                strNombreFichero = strNombreFichero + "." + extensionFile;
            }
            if (propertieActualizar != null && !propertieActualizar.equals("") && propertieActualizar.equals(ModelaConf.PROP_LOGO_INFORMES)) {
                String strFileTmp = fileDlg.getCurrentDirectory().getPath() + System.getProperty("file.separator") + fich.getName();
                strFileTmp = strFileTmp.replace(System.getProperty("file.separator").toCharArray()[0], '/');
                ModelaConf.setLogoInformes(strFileTmp);
            }
        }
        return strRuta;
    }

    public static String seleccionarRutaDirectorio(String rutaInicial, String propertieActualizar) {
        if (rutaInicial == null || rutaInicial.equals("")) {
            rutaInicial = "C:/";
        }
        String strRuta = null;
        JFileChooser fileDlg = new JFileChooser(rutaInicial);
        fileDlg.setFileSelectionMode(1);
        int nRet = fileDlg.showSaveDialog(null);
        if (nRet == 0) {
            File fich = fileDlg.getSelectedFile();
            strRuta = fich.getPath();
            if (propertieActualizar == null || !propertieActualizar.equals("")) {
                // empty if block
            }
        }
        return strRuta;
    }

    public static byte[] InputStreamToByte(InputStream in) {
        byte[] resultado = null;
        if (in == null) {
            return resultado;
        }
        try {
            int leidos;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            while ((leidos = in.read(buffer)) > 0) {
                bos.write(buffer, 0, leidos);
            }
            resultado = bos.toByteArray();
            bos.close();
            in.close();
        }
        catch (Exception ex) {
            System.out.println("\u00b7 [ Error ] Al convertir el InputStream a byte[]");
        }
        return resultado;
    }

    public static String interpretaBoolean2String(boolean valorInterpretable, String strTrue, String strFalse) {
        if (valorInterpretable) {
            return strTrue;
        }
        return strFalse;
    }

    public static boolean interpretaString2Boolean(String valorInterpretable, String strTrue, String strFalse, boolean valorDefecto) {
        if (valorInterpretable == null) {
            return valorDefecto;
        }
        if (valorInterpretable.equals(strTrue)) {
            return true;
        }
        if (valorInterpretable.equals(strFalse)) {
            return false;
        }
        return valorDefecto;
    }

    public static String escribirFuente(Font fuente) {
        String fuenteStr = "";
        if (fuente != null) {
            fuenteStr = fuente.getFontName() + ";" + fuente.getStyle() + ";" + fuente.getSize();
        }
        return fuenteStr;
    }

    public static Font obtenerFuente(String strFuente, Font fuentePorDefecto) {
        Font fuente = fuentePorDefecto;
        if (strFuente == null) {
            return fuente;
        }
        StringTokenizer sToken = new StringTokenizer(strFuente, ";");
        if (sToken.countTokens() == 3) {
            ArrayList<String> arrElementosFuente = new ArrayList<String>();
            while (sToken.hasMoreElements()) {
                arrElementosFuente.add(sToken.nextToken());
            }
            fuente = new Font((String)arrElementosFuente.get(0), Integer.parseInt((String)arrElementosFuente.get(1)), Integer.parseInt((String)arrElementosFuente.get(2)));
        }
        return fuente;
    }

    public static String adjustNameFileMaxLen(String nombreFile, int maxLen) {
        try {
            if (nombreFile != null && !nombreFile.equals("") && nombreFile.length() > maxLen) {
                int nLongitudSufijo = 0;
                if (nombreFile.lastIndexOf(".") == nombreFile.length() - 4) {
                    nLongitudSufijo = 4;
                }
                String strSufijo = nombreFile.substring(nombreFile.length() - nLongitudSufijo, nombreFile.length());
                nombreFile = nombreFile.substring(0, maxLen - nLongitudSufijo) + strSufijo;
            }
            return nombreFile;
        }
        catch (Exception e) {
            return nombreFile;
        }
    }

    public static void esperarDurante(long nMilisegundos) {
        try {
            Thread.sleep(nMilisegundos);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

